/*****************************************************************************\
 * $Id: gettimeo.c 2.0 1994/03/14 03:22:38 dj Exp $
 * $Log: gettimeo.c $
 * Revision 2.0  1994/03/14  03:22:38  dj
 * initial version
 *
\*****************************************************************************/

/* Copyright (C) 1993 by Charles Sandmann (sandmann@clio.rice.edu)
 *
 * This software comes with ABSOLUTELY NO WARRANTY, and may be used and
 * copied freely as long as the copyright is left intact.
 */

#include <stdlib.h>
#include <dos.h>
#include <sys/time.h>
#include <sys/timeb.h>

int gettimeofday(struct timeval *tv, struct timezone *tz)
{
  union REGS r;
  struct tm tmblk;
  struct timeval tv_tmp;

  if (!tv)
    tv = &tv_tmp;

  memset(&tmblk, 0, sizeof(tmblk));

  r.h.ah = 0x2c;
  int86(0x21, &r, &r);
		
  tv->tv_usec = r.h.dl * 10000;
  tmblk.tm_sec = r.h.dh;
  tmblk.tm_min = r.h.cl;
  tmblk.tm_hour = r.h.ch;

  r.h.ah = 0x2a;
  int86(0x21, &r, &r);
  tmblk.tm_mday = r.h.dl;
  tmblk.tm_mon = r.h.dh - 1;
  tmblk.tm_year = (r.x.cx & 0x7ff) - 1900;

  tmblk.tm_wday = tmblk.tm_yday = tmblk.tm_isdst = tmblk.tm_gmtoff = 0;
  tmblk.tm_zone = NULL;
  tmblk.tm_isdst = -1;

  tv->tv_sec = mktime(&tmblk);

  if(tz)
  {
    struct tm *tmloc = localtime(&(tv->tv_sec));
    tz->tz_minuteswest = - tmloc->tm_gmtoff / 60;
    tz->tz_dsttime = tmloc->tm_isdst;
  }
  return 0;
}
