#include <stdlib.h>

typedef void (*func)();

extern func __go32_first_ctor[];
extern func __go32_last_ctor[];
extern func __go32_first_dtor[];
extern func __go32_last_dtor[];

static void do_ctors()
{
  func *ctor;
  for (ctor=__go32_last_ctor-1; ctor >= __go32_first_ctor; ctor--)
    (*ctor)();
}

static void do_dtors()
{
  func *dtor;
  for (dtor = __go32_first_dtor; dtor < __go32_last_dtor; dtor++)
    (*dtor)();
}

void __main()
{
  static int main_called = 0;
  if (main_called)
    return;
  main_called = 1;

  do_ctors();
  atexit(do_dtors);
}
