/*===========================================================================*/
/*                                                                           */
/* File    : WINTERNL.H                                                      */
/*                                                                           */
/* Purpose : Information which is used by MEWEL internally.                  */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1989-1993 Marc Adler/Magma Systems     All Rights Reserved  */
/*===========================================================================*/

/*
  HUGE definition
*/
#if defined(DOS) && !defined(WC386) && !defined(__TSC__)
#define HUGE  huge
#else
#define HUGE  FAR
#endif


/*
  Definitions of helper typedefs and functions for DOS extenders
*/

/*
  Pharlap 286
*/
#if defined(DOS286X)
#define APIENTRY PASCAL _far
typedef USHORT SEL;
typedef USHORT _far *PSEL;
typedef ULONG  REALPTR;

typedef struct
{
  USHORT es;
  USHORT ds;
  USHORT di;
  USHORT si;
  USHORT bp;
  USHORT sp;
  USHORT bx;
  USHORT dx;
  USHORT cx;
  USHORT ax;
  USHORT ip;
  USHORT cs;
  USHORT flags;
} REGS16;
typedef REGS16 _far *PREGS;

extern  USHORT APIENTRY DosAllocSeg(USHORT, PSEL, USHORT);
extern  USHORT APIENTRY DosFreeSeg(SEL);
extern  USHORT APIENTRY DosGetBIOSSeg(PSEL);
extern  USHORT APIENTRY DosMapRealSeg(USHORT, ULONG, PSEL);
extern  USHORT APIENTRY DosReallocSeg(USHORT, SEL);
extern  USHORT _far _cdecl DosRealIntr(USHORT, PREGS, REALPTR, SHORT, ...);

#define MAKEP(sel, off)   ((PVOID)((((ULONG)(sel)) << 16) + (off)))
/* #define SELECTOROF(fp)    ((SEL)(((ULONG)(fp)) >> 16)) */
#endif /* DOS286X */


/*
  Rational DOS 16/M
*/
#if defined(DOS16M)
#define RSIAPI cdecl _loadds far
extern VOID FAR *RSIAPI D16MemAlloc(UINT);
extern INT RSIAPI D16MemFree(VOID FAR *);
#endif


/*
  The Zortech and High-C compilers need to have a 48-bit "far" pointer
  for some data accesses to real memory.
*/
#if defined(DOS386)
#define TRUEFAR  far
#elif defined(__HIGHC__)
#define TRUEFAR  _Dfar
#else
#define TRUEFAR  FAR
#endif

#if defined(DOS386) || defined(__HIGHC__)
typedef BYTE TRUEFAR *FARADDR;
#else
typedef LPSTR FARADDR;
#endif

extern FARADDR PASCAL GetBIOSAddress(WORD);


/*
  Definitions of a screen cell - very important for compatibility between
  16 and 32 bit mode
*/
typedef unsigned short  CELL;
typedef CELL           *PCELL;
typedef CELL FAR       *LPCELL;

/*
  Rectangle stuff
*/
extern RECT RectEmpty;  /* An empty rect which you can use for compares */
#define RECTGEN(r, row1, col1, row2, col2) \
        {\
          (r).top    = row1;\
          (r).left   = col1;\
          (r).bottom = row2;\
          (r).right  = col2;\
        }


/*
  Generic linked list
*/
typedef struct list
{
  struct list *next;
  LPSTR  data;
} LIST, *PLIST;


/*
  This structure contains some important MEWEL global variables.
*/
typedef struct tagWinSysParams
{
  HWND hWndActive;         /* Currently active window */
  HWND hWndSysModal;       /* System-modal window */
  HWND hWndCaret;          /* Window which has the caret */
  HWND hWndCapture;        /* Window which has the mouse captured */
  HWND hWndFocus;          /* Window which has the input focus */
  BOOL bVGAFontsDone;      /* Special VGA fonts used? */
  PSTR pszMEWELcopyright;  /* Copyright notice     */
  HCURSOR hCursor;         /* Current mouse cursor */
  BOOL bInMsgBox;          /* for the WM_CTLCOLOR message */
  INT  fOldBrkFlag;        /* Were control-breaks originally enabled? */

  WINDOW *WindowList;      /* linked list of all existing windows */
  WINDOW *wDesktop;        /* pointer to desktop window */

# define MAXHOOKS  (WH_LAST + 1)
  FARPROC lpfnHookProc[MAXHOOKS];  /* table of window hook pointers */
} WINSYSPARAMS;
extern WINSYSPARAMS InternalSysParams;

#define _SetActiveWindow(hWnd)   (InternalSysParams.hWndActive = (hWnd))


/*===========================================================================*/
/*                                                                           */
/*                       VIDEO INFORMATION                                   */
/*                                                                           */
/*===========================================================================*/
extern struct videoinfo
{
  INT  length,
       width;
  WORD segment;
  WORD starting_mode;
  WORD flags;
/*
  Adapter Types
  (odd numbers signify a mono adapter)
*/
#define CGA       0
#define MDA       1
#define EGACOLOR  2
#define EGAMONO   3
#define VGACOLOR  4
#define VGAMONO   5
#define MCGACOLOR 6
#define MCGAMONO  7
#define VIDEO_NOSNOW    ((VideoInfo.flags & 0x07) != CGA)
#define USEVIDEOBIOS      0x0100
#define IN_GRAPHICS_MODE  0x0200
#define IN_MONO_MODE      0x0400
  int  yFontHeight;
  int  xFontWidth;
} VideoInfo;

#define VID_USE_BIOS()             (VideoInfo.flags & USEVIDEOBIOS)
#define VID_USE_GRAPHICS_BIOS()    (VideoInfo.flags & USEVIDEOBIOS)
#define VID_IN_GRAPHICS_MODE()     (VideoInfo.flags & IN_GRAPHICS_MODE)
#define VID_IN_MONO_MODE()         (VideoInfo.flags & IN_MONO_MODE)

/*
  Various variables used by the low-level video routines
*/
#define MAXSCREENWIDTH    170
extern BYTE  HilitePrefix;
#define HILITE_PREFIX   '~'       /* default prefix for highliting */
extern COLOR HilitePrefixAttr;

extern WORD  Scr_Base;
extern BYTE  bUseMonoMap;
extern BOOL  bDrawingBorder;
extern BOOL  bVirtScreenEnabled;
extern BOOL  bUseVirtualScreen;  /* set to FALSE if you don't want the VS */
extern BOOL  bRestoreDirectory;


/*
  Window-list related
*/
#if !defined(MAC)
extern WINDOW *WindowList;
#endif
extern WINDOW *_wDesktop;
extern WINDOW **HwndArray;
#define MAXWINDOWS    128
extern WINDOW *FAR PASCAL WID_TO_WIN(HWND);
#define _WinGetLowestClass(i)  (ClassIDToClassStruct(i)->idLowestClass)

/*
  Internal GDI stuff
*/
extern HBRUSH SysBrush[];  /* brushes for the COLOR_xxx objects */
extern HPEN   SysPen[];    /* pens for the COLOR_xxx objects */
#define SYSPEN_BTNHIGHLIGHT  0
#define SYSPEN_BTNSHADOW     1
#define SYSPEN_WINDOWFRAME   2

/*
  Control classes ids put out by the resource compiler
*/
#define CT_MASK       0x80
#define CT_BUTTON     0x80
#define CT_EDIT       0x81
#define CT_STATIC     0x82
#define CT_LISTBOX    0x83
#define CT_SCROLLBAR  0x84
#define CT_COMBOBOX   0x85


/*
  Definition of the window restoration information used when a window
  is maximized or minimized. This is stored in the last 2 or 4 bytes
  of the window's szClassExtra[] array.
*/
#ifdef MEWEL_GUI
#define USE_ICON_TITLE
#endif

typedef struct tagRestoreInfo
{
  RECT  rect;         /* Original window rect  */
  DWORD ulOldFlags;   /* Original window flags */
  HWND  hIconTitle;   /* Handle to icon title window */
} RESTOREINFO, *PRESTOREINFO, FAR *LPRESTOREINFO;


/*
  Virtual Screen stuff
*/
typedef struct virtScreen
{
  LPSTR pVirtScreen;
  WORD  segVirtScreen;
#if defined(DOS)
  WORD  segPhysScreen;
#elif defined(OS2)
  LPSTR segPhysScreen;
#endif
  WORD  nRows, nCols;
  WORD  nScreenSize;
  INT   minBadCol, maxBadCol;
  BOOL  *pbRowBad;
  WORD  fRedrawFlags;
#define VS_DRAWALL   0x0001
} VIRTUALSCREEN;
extern VIRTUALSCREEN VirtualScreen;


/*
  This structure records some information about the system events.
*/
typedef WORD (FAR PASCAL *EVENTCHECKPROC)(LPMSG);

typedef struct tagSysEventInfo
{
  WORD chLastKey;       /* VK code of last key pressed  */
  WORD chLastShift;     /* last shift state recorded    */
  WORD chLastScan;      /* last scan  state recorded    */
  WORD lastMessage;     /* last message recorded        */
  INT  nAltKeyPresses;  /* Has the ALT key been tapped? */
  EVENTCHECKPROC pfExternalEventChecker;  /* event checking function */
  WORD DblClickPendingMsg;  /* pending double click message? */
} SYSEVENTINFO, *LPSYSEVENTINFO;
extern SYSEVENTINFO SysEventInfo;


/*
  MEWEL Printer interface structures and typedefs. Used by SysGDIInfo.

   Definitions for the printer hooks used to avoid pulling in the 
   printer routines in programs not using printing.
*/  
#include "wprndev.h"
#ifdef MSC
typedef HDC (FAR PASCAL *CREATPRDCPROC)(LPSTR,LPSTR,LPSTR,LPSTR,BOOL);
typedef LPPRDEVICE (FAR PASCAL *PRDCXLATPROC)(HDC);
typedef BOOL (FAR PASCAL *DELPRDCPROC)(HDC);
#else
typedef HDC FAR PASCAL (*CREATPRDCPROC)(LPSTR,LPSTR,LPSTR,LPSTR,BOOL);
typedef LPPRDEVICE FAR PASCAL (*PRDCXLATPROC)(HDC);
typedef BOOL FAR PASCAL (*DELPRDCPROC)(HDC);
#endif



/*
  This structure contains information which is needed by the entire GDI.
*/
typedef struct tagGDIInfo
{
  BOOL   bGraphicsSystemInitialized;  /* Graphics system initialized? */
  BOOL   bWasBlinkingEnabled; /* TRUE if blinking was originally on */
  INT    iVideoMode;          /* Current video mode      */
  INT    cxScreen, cyScreen;  /* Screen dimensions       */
  INT    nColors;             /* Number of colors        */
  INT    nBitsPerPixel;       /* Bits per pixel          */
  INT    tmHeight;            /* Height of system font   */
  INT    tmExternalLeading;   /* Leading of system font  */
  INT    tmHeightAndSpace;    /* The above two combined  */
  INT    tmAveCharWidth;      /* Avg char width of font  */
  INT    iSavedVideoMode;     /* Original video mode     */
  INT    StartingVideoMode;   /* same as above, but used in text mode */
  INT    StartingVideoLength; /* original video length   */
  HFONT  hFontDefault;        /* Handle of default font  */
  HBITMAP hDefMonoBitmap;     /* default 1x1 mono bitmap */
  RECT   rectLastClipping;    /* set by GraphSetViewport */

  /*
    These 3 function pointers are used by the printing module.
  */
  CREATPRDCPROC lpfnCreatPrDCHook;
  DELPRDCPROC   lpfnDelPrDCHook;
  PRDCXLATPROC  lpfnPrDCXlatHook;
  HPALETTE      hSysPalette;
  INT           CurrFontID;

  DWORD         fFlags;
  /* 
    Special printing mode for BGI and Ryle,Fleming,etc. When this is on,
    all BGI functions are routed to the printer driver. So, don't
    do things like draw window bitmaps.
  */
#define GDISTATE_BGI_PRINTING      0x00000001L
  /*
    By default, the MSC graphics.lib version uses the "best match"
    indicator for _setfont(). If this is set, then MEWEL will not
    use the best match. This can be set in the MEWEL.INI file
    in the [boot] section using the 'NoBestMatch' variable.
  */
#define GDISTATE_MSC_NOBESTMATCH   0x00000002L
  /*
    This flag is turned ON when the GX virtual screen is on. It is
    used to compensate for a protection violation in the GX lib.
    (grSetVirtual(FALSE) reads from location 0:0 if there was never
     a virtual screen set).
  */
#define GDISTATE_GX_VIRTUALON      0x00000004L

  /*
    These two variabled maintain a cache of widths for the characters
    in the current font. Used to speed up GetCharWidth().
  */
  LPINT         lpFontWidthCache;
  HFONT         hFontCached;

} GDIINFO;
extern GDIINFO SysGDIInfo;
extern BOOL bGraphicsSystemInitialized;

#if defined(WAGNER_GRAPHICS)
#define FONT_WIDTH     (vidmode.char_width)
#else
#define FONT_WIDTH     8
#endif


/*
  Device context
*/
typedef struct dc
{
  HWND   hWnd;       /* the window that this DC is associated with */
  WORD   fFlags;
#define DC_ISWINDOWDC       0x0001
#define DC_ISMEMDC          0x0002
#define DC_BITMAPSELECTED   0x0004
#define DC_ISPRTDC          0x4000
#define DC_ISUSED           0x8000
#define DC_SYSPALNOSTATIC   0x0010
#define DC_RESETING_OWNDC   0x0008
#define IS_WINDOWDC(lphDC)      ((lphDC)->fFlags & DC_ISWINDOWDC)
#define IS_MEMDC(lphDC)         ((lphDC)->fFlags & DC_ISMEMDC)
#define IS_PRTDC(lphDC)         ((lphDC)->fFlags & DC_ISPRTDC)
#define IS_BMPSELECTED(lphDC)   ((lphDC)->fFlags & DC_BITMAPSELECTED)
#define IS_RESETING_OWNDC(lphDC) ((lphDC)->fFlags & DC_RESETING_OWNDC)
#define IS_DCUSED(lphDC)        ((lphDC)->fFlags & DC_ISUSED)
#define IS_DCFREE(lphDC)        (!((lphDC)->fFlags & DC_ISUSED))

  HANDLE hCanvas;    /* ptr to the current drawing surface - NULL is screen */

  RECT   rClipping;       /* the window clipping region */

  HRGN   hRgnVis;         /* Visibility region - calc'ed by MEWEL */
  HRGN   hRgnClip;        /* Clipping region - set by app */

  COLOR  attr;            /* the window colors */
  COLORREF clrBackground, /* background & foreground rgb values  */
           clrText;       /* default is white back and black fg  */
  HPEN   hPen;            /* pen to draw lines with */
  HBRUSH hBrush;          /* brush to draw with */
  HFONT  hFont;           /* current font   */
  HBITMAP hBitmap;        /* current bitmap */
  POINT  ptOrg;           /* DC origin */
  POINT  ptPen;           /* current pen coordinates */
  POINT  ptViewOrg;       /* viewport origin & extent */
  SIZE   extView;
  POINT  ptWindowOrg;     /* window origin & extent */
  SIZE   extWindow;
  POINT  ptBrushOrg;      /* brush origin - (0,0) is default     */
  INT    wDrawingMode;    /* drawing mode - R2_COPY is default   */
  INT    wMappingMode;    /* mapping mode - MM_TEXT is default   */
  INT    wBackgroundMode; /* background mode - OPAQUE is default */
  INT    wAlignment;      /* text alignment - TA_LEFT is default */
  INT    wStretchMode;    /* blt stretching mode                 */
  INT    wPolyFillMode;   /* polygon filling mode                */
  INT    wTextCharExtra;  /* text extra value - default is 0     */
  HPALETTE hPalette;      /* color palette                       */

  HANDLE hPrDevice;  /* if we have a printer DC, this pts to a PrDevice */

  LIST   *listSavedDCs;   /* for Save/RestoreDC */

  /*
    These are pointer to functions within the "device driver" which
    handle the GDI functions. One can theoretically write a new
    "driver" (ie - printer, graphics, KANJI) by setting hooks to all
    of these functions.
  */
  INT (FAR PASCAL *lpfnDevCapsProc)(HDC, INT);
  INT (FAR PASCAL *lpfnEscapeProc)(HDC, INT, INT, LPSTR, LPSTR);
  INT (FAR PASCAL *lpfnTextOutProc)(HDC, INT, INT, LPSTR, WORD);

  /*
    This is a pointer to extra data associated with this DC. This can
    be a link to an underlying graphics engine structure, such as a
    PORT in MetaWindows or a gxHeader in Genus' GX Graphics.
  */
  LPVOID lpDCExtra;

#ifdef WAGNER_GRAPHICS
   vidcontext context;
#endif
#if defined(MOTIF) || defined(DECWINDOWS)
   Widget      widget;
   GC          gc;
   XFontStruct *pXFontStruct;
#endif

} DC, *PDC, *LPHDC;

extern LPHDC FAR PASCAL _GetDC(HDC);

/*
  This constant is passed as the window handle to the various DC routines
  when the device context is associated with a non-display device, such
  as a printer, plotter, etc.
*/
#define HWND_NONDISPLAY   0xFFFF

/*
  Macro to determine if the DC is a valid DC for a display rather than a prt
*/
#define IS_DISPLAY_DC(hDC)  ((hDC) > 0 && !_GetDC(hDC)->hPrDevice)



/*
  Hardware cursor information
*/
typedef struct tagCursorInfo
{
  int  row, col;
  int  startscan, endscan;
  int  nWidth;
  int  fState;
#define CURSOR_VISIBLE   0x0001
#define MAXCURSORWIDTH   32
#define MAXCURSORHEIGHT  32
  BYTE achSavedBits[MAXCURSORHEIGHT][MAXCURSORWIDTH];
} CURSORINFO;

extern CURSORINFO CursorInfo;
#define ISCURSORON()  (CursorInfo.startscan < CursorInfo.endscan)


#ifdef INCLUDE_CURSORS
/*
  A cursor handle with SYSCURSOR_MAGIC or'ed into it tells MEWEL
  that a system cursor is involved.
*/
#define SYSCURSOR_MAGIC  0x0800

/*
  The cursor signature distinguishes a cursor created by CreateCursor()
  from one created by LoadCursor().
*/
#define CURSOR_SIGNATURE MAKEINTRESOURCE(0x1128)

typedef struct tagSysCursorInfo
{
  LPSTR  dwID;
  INT    xHotSpot, yHotSpot;
  BYTE   achMask[(16/8) * 16 * 2];   /* DOS cursors are 16x16 */
  /*
    The first mask is the screen mask (AND).
    The second mask is the cursor mask (XOR).
  */
} SYSCURSORINFO, FAR *LPSYSCURSORINFO;

#endif /* INCLUDE_CURSORS */


extern INT MewelCurrOpenResourceFile;  /* file descriptor */

/*
  Keyboard related stuff
  Mostly found in WINKBD.C
*/
typedef WORD   VKEYCODE;

extern VOID     FAR PASCAL KBDInit(void);
extern VOID     FAR PASCAL KBDTerminate(void);
extern VKEYCODE FAR PASCAL KBDRead(void);
extern INT      FAR PASCAL KBDGetShift(void);
extern VOID         PASCAL InitKeyboard(void);  /* for UNIX */

/*
  Char pushback functions found in WKBSTACK.C
*/
extern VOID     FAR PASCAL nungetc(VKEYCODE);
extern VKEYCODE FAR PASCAL ngetc(void);

typedef struct checkboxinfo
{
  int  state;
  int  checkchar;
  BOOL bHasFocus;
} CHECKBOXINFO;


#ifdef INCLUDE_COMBOBOX
/*
  Combobox structure
*/
typedef struct combobox
{
  HWND  hEdit,              /* Handle to the edit/static component */
        hListBox;           /* Handle to the listbox component */
  INT   yOrigBottom;        /* The original bottom y coordinate */
  INT   yAdjustedBottom;    /* The adjusted bottom y coordinate */
  BYTE  chComboBoxIcon;     /* The char used for the icon */
} COMBOBOX;

/*
  See comments in wincombo.c
*/
#define CBN_INTERNALSELCHANGE  99

#ifdef MEWEL_GUI
#define SM_CXCOMBOICON   16
#define SM_CYCOMBOICON   16
#else
#define SM_CXCOMBOICON   1
#define SM_CYCOMBOICON   1
#endif
#endif /* INCLUDE_COMBOBOX */


#if defined(INCLUDE_LISTBOX)
typedef struct listbox
{
  int  nStrings;    /* number of strings in the listbox */
  int  iTopLine;    /* index of string currently at the top of the box */
  int  iCurrSel;    /* index of currently selected item */
  WINDOW *wListBox;
  LIST *strList;    /* linked list of strings */
  HWND hListBox;    /* back reference to listbox window handle */
  int  nColumns;
  int  iLeftCol;
  int  iColWidth;
  int  nVisibleStrings;  /* # of strings which can be shown in the listbox */
  LPWORD pTabStops; 
  INT  tmHeight;          /* font height */
  INT  tmHeightAndSpace;  /* height plus leading */
  INT  tmWidth;           /* font width  */
  INT  wHorizExtent;      /* horizontal extent for scrolling */
} LISTBOX;

extern INT FAR PASCAL ListBoxDir(LISTBOX *,LPSTR,unsigned);


/*
  Undefine this if you don't want owner-drawn stuff in MEWEL.
*/
#define OWNERDRAWN

/*
  Routines used by wlistbox and wincombo to control owner-drawn listboxes.
*/
#ifdef OWNERDRAWN
HDC  FAR PASCAL _ListBoxSetupDIS(WINDOW *, DRAWITEMSTRUCT *, HDC, LPHDC *);
VOID FAR PASCAL _ListBoxDrawOwnerDrawnItem(WINDOW *, int, int, COLOR,
                          BOOL, BOOL, BOOL, LIST *, PDRAWITEMSTRUCT, INT, BOOL);
VOID FAR PASCAL _ListBoxDeleteOwnerDrawnItem(WINDOW *, int, LIST *);

#define IS_OWNERDRAWN(fl) ((fl) & (LBS_OWNERDRAWFIXED | LBS_OWNERDRAWVARIABLE))
#define IS_OWNERDRAWN_WITHOUT_STRINGS(fl) \
                      (IS_OWNERDRAWN(fl) && !((fl) & LBS_HASSTRINGS))
#endif

#endif


#if defined(INCLUDE_SCROLLBAR)
typedef struct scrollbar
{
  int    minpos, maxpos, currpos;
  int    thumbpos;   /* offset of thumb position from window top-left */
  DWORD  sb_flags;
#define SB_HASFOCUS    0x0040  /* to give a slider (a lonely scrollbar) focus */
#define SB_FORCEREDRAW 0x0020
#define SB_NOREDRAWARROWS 0x0080  /* don't redraw arrows */
  RECT   rectThumb;  /* client-relative coordinates of thumb */
} SCROLLBARINFO;

#endif


#ifdef INCLUDE_MENU
/*
  The data structure associated with a menu...
*/
typedef struct menu
{
  HWND     hWnd;                 /* back reference to the menu's handle */
  INT      id;                   /* id associated with the menu */
  LIST     *itemList;            /* linked list of menu items */
  INT      nItems;               /* number of items in the list */
  INT      iCurrSel;             /* 0-based index of the current selection */
  DWORD    flags;                /* attribute flags */
#define M_NOBORDER     0x0000
#define M_HASBORDER    0x0001       /* Has a border */
#define M_MENUBAR      0x0002       /* Is a menubar, not a pulldown */
#define M_POPUP        0x0004       /* Is a pulldown,not a menubar  */
#define M_SYSMENU      0x0008       /* Is a system menu             */
#define M_AUTOACCEPT   0x0010       /* Accept when the user types the letter */
#define M_NOSHOWPOPUPS 0x0020       /* Don't show the underlying popup */
  HWND     hOldFocus;            /* Handle of the window which had the    */
  INT      iLevel;               /*   focus before the menu was invoked   */
} MENU, *LPMENU;                 

#define IS_MENUBAR(m)   ((m)->flags & M_MENUBAR)
#define IS_POPUP(m)     ((m)->flags & M_POPUP)
#define IS_SYSMENU(m)   ((m)->flags & M_SYSMENU)
#define DONT_SHOW_POPUPS(m)  ((m)->flags & M_NOSHOWPOPUPS)


/*
  Data structure for each menu item
*/
typedef struct menu_item
{
  LPSTR text;                /* NULL-terminated string or bitmap handle */
  INT  letter;               /* HotKey which activates this item */
  INT  id;                   /* The id which the WM_COMMAND passes back */
  WORD flags;                /* Any status info... */
  INT  iRightJustPos;        /* index of part of string which is right-just */
  INT  cyItem;               /* Pixel height of menu item */
  RECT rectItem;             /* Rectangle enclosing the menu item */
  INT  xTab;                 /* Tab position */
  INT  wTextExtent;          /* length of string */
  INT  xULStart;             /* coordinate relative to left of item of underline */
  INT  xULLength;            /* Length of underline */
#if defined(MOTIF) || defined(DECWINDOWS)
  Widget widget;             /* Pointer to Motif widget for the item */
#endif
} MENUITEM, FAR *LPMENUITEM;

typedef struct tagMenuInvertInfo
{
  BOOL  bInverting;
  INT   iOldSel;
  HMENU hMenu;
} MENUINVERTINFO;
extern MENUINVERTINFO MenuInvertInfo;


extern MENU *FAR PASCAL _MenuHwndToStruct(HWND);
extern VOID  FAR PASCAL MenuAdjustPopupSize(MENU *);
extern LPMENUITEM FAR PASCAL MenuGetItem(MENU *, INT, WORD);

/*
  Menu-related system variables
*/
#define SM_CXBETWEENMENUITEMS     (2*SysGDIInfo.tmAveCharWidth)
#define SM_CXBEFOREFIRSTMENUITEM  (2*SysGDIInfo.tmAveCharWidth)
#define SM_RESTOREICONWIDTH       (2*SysGDIInfo.tmAveCharWidth)

#endif /* INCLUDE_MENU */




#ifdef INCLUDE_REGIONS
/* 
  This is the array of rectangles which comprised the visibility list.
  In theory, there should be a vislist attached to every window, but
  we don't want to use up too much memory!
*/
typedef struct tagRegion
{
  HRGN hRgn;          /* Reference to the handle */
  INT  nRects;        /* # of rects in the rectangle list */
  INT  maxRects;      /* # of rects which space is allocated for */
  RECT rectBounding;  /* union of all rects in the list */
  RECT rects[1];      /* list starts here and grows downwards */
} REGION, *PREGION, FAR *LPREGION;

extern HRGN FAR PASCAL WinCalcVisRgn(HWND, HDC);
#endif


#if defined(INCLUDE_PALETTE_MGR)
/*
  The main difference between a "public" palette-entry object and an
  internal one is the addition of the 'peSysIndex' entry. This is
  the index of the logical color into the system hardware palette.
*/
typedef struct tagInternalPALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
  UINT peSysIndex;
} INTPALETTEENTRY, FAR *LPINTPALETTEENTRY;
 
typedef struct tagInternalLOGPALETTE
{
  WORD palVersion;
  WORD palNumEntries;
  INTPALETTEENTRY  palPalEntry[1];
} INTLOGPALETTE, *PINTLOGPALETTE, *NPINTLOGPALETTE, FAR *LPINTLOGPALETTE;
 
BOOL FAR PASCAL InitPaletteManager(void);
INT  FAR PASCAL MapPaletteIndex(HDC, INT);
#endif


#ifdef INCLUDE_MEMMGR
/*
  Memory block info. Used in WMEMGLOB.C and WMEMLOCL.C
*/
typedef struct tagMemHandle
{
  union                /* real memory address */
  {
    LPSTR lpMem;
    PSTR  pMem;
  } uMem;
  DWORD dwBytes;
  DWORD dwLRUCount;
  WORD  wFlags;
  INT   iLockCount;
  /* The above fields takes up 16 bytes */

  /* The following fields are for the internal management of the memory. */
  /* They take up another 6 bytes */
  WORD  fMemFlags;
#define BLOCK_IN_CONV  0x0001
#define BLOCK_IN_EMS   0x0002
#define BLOCK_IN_XMS   0x0004
#define BLOCK_ON_DISK  0x0008
#define HALLOC_BLOCK   0x0100
#define GLOBAL_BLOCK   0x1000
#define LOCAL_BLOCK    0x2000
#define NOTIFY_BLOCK   0x4000  /* cause GMEM_DISCARDED == GMEM_NOTIFY */
  union
  {
    DWORD ulXMSMem;   /* Handle/offset to location in XMS */
    DWORD ulEMSMem;   /* page number (0-3) and offset within page */
    DWORD ulDiskSeekPos;  /* seek position on disk */
  } uOutMem;
} MEMHANDLEINFO, *PMEMHANDLEINFO, FAR *LPMEMHANDLEINFO;

typedef BOOL FAR PASCAL NOTIFYPROC(HANDLE);

extern HANDLE FAR PASCAL FindFreeHandle(void);
extern LPMEMHANDLEINFO FAR PASCAL DerefHandle(HANDLE);


typedef struct tagMemoryMgr
{
  LPMEMHANDLEINFO HandleTable;
  DWORD           ulLRUCount;
  NOTIFYPROC      *lpfnNotify;
  WORD            nHandlesAlloced;
  WORD            fFlags;
#define MEM_USE_XMSLIB       0x0001
#define MEM_USE_MSCVM        0x0002
#define MEM_USE_DISK         0x0004
#define MEMMGR_DISCARDING    0x0100

  int             fdTemp;            /* handle to temp file for disk VM */
  LPSTR           lpszTempFile;      /* name of temp file */
} MEMMGRINFO;
extern MEMMGRINFO MewelMemoryMgr;

/*
  Define USE_HALLOC if we want to try using halloc() instead of
  _falloc for Microsoft C. The USE_HALLOC define is referenced in
  wemalloc.c and wmemglob.c.
*/
#if defined(MSC)
#if 0
#define USE_HALLOC
#endif
#endif

#endif /* INCLUDE_MEMMGR */



/*
  Clipboard stuff used in WCLIPBRD.C
*/
#define MAXFORMATS  16

typedef struct tagClipboard
{
  GLOBALHANDLE hData;  /* pointer to the clipboard data */
  WORD fmtData;        /* the format which the data is in */
  HWND hWndOpen;       /* who opened the clipboard      */
  HWND hWndOwner;      /* the clipboard owner           */
  HWND hWndViewer;     /* the first clipboard viewer    */
  WORD fFlags;         /* status bits                   */
#define CLIP_OPEN   0x0001
  WORD nFormats;       /* # of formats currently defined */
  struct
  {
    WORD  idFormat;
    LPSTR pszFormat;
    int   iRefCount;
  } fmtInfo[MAXFORMATS];
} CLIPBOARD;
extern CLIPBOARD _Clipboard;

/*
  Vismap stuff
*/
extern WORD FAR *WinVisMap;
VOID FAR PASCAL WinInitVisMap(void);
VOID FAR PASCAL WinUpdateVisMap(void);
VOID FAR PASCAL _WinUpdateVisMap(WINDOW *);
HWND FAR PASCAL VisMapPointToHwnd(int, int);
HRGN FAR PASCAL WinCalcVisRgn(HWND, HDC);
BOOL FAR PASCAL IsVisRegionEmpty(HDC, LPRECT);
VOID     PASCAL DumpWindowTreeRegions(void);

/*
  Constants used for determining the position of iconic windows.
*/
#ifdef MEWEL_GUI
#define ICONHEIGHT        GetSystemMetrics(SM_CYICON)
#define ICONWIDTH         GetSystemMetrics(SM_CXICON)
#define CY_BETWEEN_ICONS  8
#define CX_BETWEEN_ICONS  8
#else
#define ICONHEIGHT        3
#define ICONWIDTH         15
#define CY_BETWEEN_ICONS  1
#define CX_BETWEEN_ICONS  1
#endif




/*===========================================================================*/
/*                                                                           */
/*                       MOUSE INFORMATION                                   */
/*                                                                           */
/*===========================================================================*/
#ifdef INCLUDE_MOUSE

#define ERROR_MOUSE_NO_DEVICE	385

#define MOVE_WITH_NO_BUTTONS    0x01
#define MOVE_WITH_BUTTON1       0x02
#define BUTTON1_DOWN            0x04
#define MOVE_WITH_BUTTON2       0x08
#define BUTTON2_DOWN            0x10
#define MOVE_WITH_BUTTON3       0x20
#define BUTTON3_DOWN            0x40

#ifndef MOU_NOWAIT
#define MOU_NOWAIT              0
#define MOU_WAIT                1
#endif


#ifdef DOS
typedef struct _MOUEVENTINFO
{
  WORD   fs;      /* State of mouse at the time the event was reported*/
  DWORD  time;    /* time since boot in milliseconds      */
  WORD   row;     /* absolute/relative row position       */
  WORD   col;     /* absolute/relative column position    */
} MOUEVENTINFO;
typedef MOUEVENTINFO *PMOUEVENTINFO;
#endif

struct EventInfo
{
  WORD Mask;
  DWORD Time;
  WORD Row;
  WORD Col;
};


#ifdef DOS
typedef struct _PTRLOC
{
  WORD row;     /* pointer row coordinate screen position*/
  WORD col;     /* pointer column coordinate screen position*/
} PTRLOC;
typedef PTRLOC *PPTRLOC;
#endif

struct PtrLoc
{
  WORD RowPos;
  WORD ColPos;
};

#ifdef DOS
typedef struct _MOUQUEINFO
{
  WORD cEvents;    /* current number of event queue elements*/
  WORD cmaxEvents; /* MaxNumQueElements value           */
} MOUQUEINFO;
typedef MOUQUEINFO *PMOUQUEINFO;
#endif

struct QueInfo
{
  WORD Events;
  WORD QSize;
};

typedef struct mouseparams
{
  int m1,m2,m3,m4;
} MOUSEPARAMS;

#ifndef OS2
extern WORD FAR PASCAL MouOpen(LPSTR,unsigned FAR *);
extern WORD FAR PASCAL MouReadEventQue(struct _MOUEVENTINFO *,LPWORD,unsigned);
extern WORD FAR PASCAL MouSetDevStatus(unsigned FAR *,unsigned);
extern WORD FAR PASCAL MouGetNumQueEl(struct _MOUQUEINFO *,unsigned);
extern WORD FAR PASCAL MouSetPtrPos(struct _PTRLOC *,unsigned);
extern INT      FAR PASCAL MouseWaitForClick(struct _MOUEVENTINFO *,unsigned,int);
#endif /* OS2 */

#ifdef DOS
/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINMOUSE.c */
extern VOID FAR PASCAL MOUSECALL(struct mouseparams *);
extern INT  FAR PASCAL MOUSE_Init(void);
extern VOID FAR PASCAL MOUSE_GetPress(int,int *,int *,int *,int *);
extern VOID FAR PASCAL MOUSE_GetStatus(int *,COORD *,COORD *);
extern VOID FAR PASCAL MOUSE_SetPos(int,int);
extern VOID FAR PASCAL MOUSE_LightPen(int);
extern VOID FAR PASCAL MOUSE_SetSpeed(int,int);
extern INT  FAR PASCAL MOUSE_HideCursor(void);
extern VOID FAR PASCAL MOUSE_GetRelease(int,int *,int *,int *,int *);
extern VOID FAR PASCAL MOUSE_GetMotion(int *,int *);
extern VOID FAR PASCAL MOUSE_SetThreshold(int);
extern VOID FAR PASCAL MOUSE_SetSubroutine(int,void (FAR *)());
extern VOID FAR PASCAL MOUSE_SetGraphicsCursor(int,int,void FAR *);
extern INT  FAR PASCAL MOUSE_SetCursorMode(int,int,int);
extern VOID FAR PASCAL MOUSE_ConditionalOff(int,int,int,int);
extern INT  FAR PASCAL MOUSE_ShowCursor(void);
extern VOID FAR PASCAL MOUSE_SetHBounds(int,int);
extern VOID FAR PASCAL MOUSE_SetVBounds(int,int);
#endif
#endif /* INCLUDE_MOUSE */


/*
  System-dependent chars which map into GDI stuff
*/
extern BYTE SysPenDrawingChars[][6];
extern BYTE SysBrushDrawingChars[];
extern BYTE SysHatchDrawingChars[];
extern BYTE SysBoxDrawingChars[][8];

/*
  For Windows Hooks
*/
#if defined(__TURBOC__) && !defined(__BORLANDC__)
typedef int      PASCAL MYHOOKPROC(int, WORD, DWORD);
typedef LRESULT  PASCAL WNDPROCHOOKPROC(int, WORD, DWORD);
typedef UINT     PASCAL COMMDLGHOOKPROC(HWND, UINT, WPARAM, LPARAM);
#else
typedef int  FAR PASCAL MYHOOKPROC(int, WORD, DWORD);
typedef LRESULT FAR PASCAL WNDPROCHOOKPROC(int, WORD, DWORD);
typedef UINT FAR PASCAL COMMDLGHOOKPROC(HWND, UINT, WPARAM, LPARAM);
#endif
extern FARPROC _lpfnHookProc[];
extern VOID FAR PASCAL _WinProcessWndProcHook(HWND*, WORD*, WORD*, LONG*);

/****************************************************************************/
/*                                                                          */
/*     Private, internal declarations                                       */
/*                                                                          */
/****************************************************************************/

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WACTIVE.c */
extern VOID FAR PASCAL _WinActivateFirstWindow(void);
extern HWND FAR PASCAL _WinGetRootWindow(HWND);

extern UINT FAR PASCAL MEWELArrangeIconicWindows(HWND, BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WCHECKBX.c */
extern HWND FAR PASCAL CheckBoxCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern HWND FAR PASCAL RadioButtonCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern LONG FAR PASCAL ButtonWinProc(HWND,WORD,WORD,LONG);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WCREATE.c */
extern HWND FAR PASCAL WinCreate(HWND,int,int,int,int,LPSTR, COLOR,DWORD,WORD,int);

BOOL  FAR PASCAL LPtoSP(HDC, LPPOINT, int);
BOOL  FAR PASCAL SPtoLP(HDC, LPPOINT, int);

/*
  WEMALLOC.C
*/
BOOL FAR PASCAL GmemRealloc(LPSTR FAR *, WORD *, INT, INT);

/*
  WGUI.C
*/
BOOL FAR PASCAL WinTrackSysIcon(HWND, INT);


/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINALT.c */
extern VOID Int9Init(void);
extern VOID Int9Terminate(void);
#if defined(MSC) && defined(DOS) && !defined(ZORTECH) && !defined(__TSC__) && !defined(WC386)
extern  VOID FAR _interrupt CDECL NewInt9(unsigned int es,unsigned int ds,unsigned int di,unsigned int si,unsigned int bp,unsigned int sp,unsigned int bx,unsigned int dx,unsigned int cx,unsigned int ax,unsigned int ip,unsigned int cs,
                                          unsigned int flags);
#endif
#if defined(__TURBOC__) || defined(__TSC__)
extern  VOID interrupt NewInt9(unsigned int bp,unsigned int di,unsigned int si,
               unsigned int ds,unsigned int es,unsigned int dx,unsigned int cx,
               unsigned int bx,unsigned int ax,unsigned int ip,unsigned int cs,
               unsigned int flags);
#endif

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINBREAK.c */
extern INT  FAR PASCAL getbrk(void);
extern VOID FAR PASCAL rstbrk(void);
extern VOID FAR PASCAL setbrk(void);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINCLICK.c */
extern WORD FAR PASCAL DetermineClickOwner(int,int, int*);
extern INT  FAR PASCAL DoNCHitTest(HWND, POINT);
extern LPRECT FAR PASCAL WinCalcWindowRects(HWND);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINCOMBO.c */
extern LONG FAR PASCAL ComboBoxWndProc(HWND,WORD,WORD,LONG);
extern LONG FAR PASCAL ComboListBoxWndProc(HWND,WORD,WORD,LONG);
extern LONG FAR PASCAL ComboEditWndProc(HWND,WORD,WORD,LONG);
extern WORD FAR PASCAL ComboBoxCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINDLG.c */
extern BOOL FAR PASCAL IsStaticClass(HWND);
extern LONG FAR PASCAL DlgGetSetWindowLong(HWND, int, LONG, BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINDRAW.c */
extern int  FAR PASCAL _WinPuts(HWND, HDC, int, int, LPSTR, COLOR, int, BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINDSTRY.c */
extern VOID FAR PASCAL _WinDestroy(HWND);
extern VOID FAR PASCAL WinDelete(HWND);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINEDIT.c */
extern WORD FAR PASCAL EditCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern LONG FAR PASCAL EditWinProc(HWND,WORD,WORD,LONG);
extern VOID FAR PASCAL bytedel(LPSTR,WORD,WORD);
extern VOID FAR PASCAL byteinsert(LPSTR,WORD);


/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINEVENT.c */
extern WORD FAR PASCAL GetEvent(LPMSG);
extern EVENTCHECKPROC FAR PASCAL EventSetHandler(EVENTCHECKPROC);
#if !defined(MAC)
extern INT  FAR PASCAL PostEvent(HWND,WORD,WORD,LONG,DWORD);
#endif

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WININIT.c */
extern VOID FAR PASCAL _WinInit(void);
extern VOID FAR PASCAL _WinSaveDirectory(void);
#ifdef UNIX
extern VOID     CDECL _WinRestoreDirectory(void);
#else
extern VOID     CDECL _WinRestoreDirectory(void);
#endif
extern WORD FAR PASCAL WinCreateDesktopWindow(void);
extern LONG FAR PASCAL _DesktopWndProc(HWND,WORD,WORD,LONG);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WININT24.c */
extern VOID FAR PASCAL Int24Install(void);
extern VOID FAR CDECL  Int24Restore(void);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINLBDIR.c */
extern DWORD FAR PASCAL _DOSEnumDisks(void);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINQUEUE.c */
extern VOID FAR PASCAL InitEventQueue(void);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINSHOW.c */
extern VOID FAR PASCAL _WinShowWindow(PWINDOW,BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINTIMER.c */
extern VOID  FAR PASCAL KillWindowTimers(HWND);
extern INT   FAR PASCAL TimerCheck(LPMSG, BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINVID.c */
extern INT   FAR PASCAL ToggleEGA(void);
extern INT   FAR PASCAL VidBlankRect(int,int,int,int,COLOR);
extern VOID  FAR PASCAL VidClearAllMonitors(COLOR);
extern INT   FAR PASCAL VidClearLine(int,int,int,COLOR,int,int);
extern VOID  FAR PASCAL VidClearScreen(COLOR);
extern INT   FAR PASCAL VidFillFrame(int,int,int,int,COLOR,COLOR);
extern INT   FAR PASCAL VidFrame(int,int,int,int,COLOR,int);
extern VOID  FAR PASCAL VidScroll(int,int,int,int,int,COLOR);
extern INT   FAR PASCAL MonitorSetRoutine(void (*)(int));
extern INT   FAR PASCAL MonitorSwitch(int,int);
extern VOID  FAR PASCAL VidSetPos(int,int);
extern VOID  FAR PASCAL VidGetPos(int *,int *);
extern INT   FAR PASCAL VidHideCursor(void);
extern INT   FAR PASCAL VidSetCursorScanLines(int,int,int);
extern INT   FAR PASCAL VidSetCursorMode(int,int);
extern INT   FAR PASCAL VidShowCursor(void);
extern LPSTR FAR PASCAL PointToScrAddress(int,int);
extern INT   FAR PASCAL VidGetMode(void);
extern INT   FAR PASCAL VidGetCurrVideoMode(void);
extern VOID  FAR PASCAL VidSetVideoMode(int);
extern VOID  FAR PASCAL _VidInitNewVideoMode(void);
extern INT   FAR PASCAL VidQueryAdapterType(void);
extern INT   FAR PASCAL VidQueryFontHeight(int);
extern VOID  FAR PASCAL VidTerminate(void);
#ifdef DOS
extern BOOL  FAR PASCAL VidSetBlinking(BOOL);
extern WORD  FAR PASCAL VioReadCellStr(LPWORD, int *, int, int, int);
extern VOID  FAR PASCAL VioWrtNCell(WORD, int, int, int, int);
extern VOID  FAR PASCAL VioWrtCellStr(LPWORD, int, int, int, int);
extern VOID  FAR PASCAL VGAVioWrtCellStr(LPWORD,int,int,int,int);
extern VOID  FAR PASCAL _VGAVioWrtCellStr(LPWORD,WORD,WORD,WORD,WORD);
#endif

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WINVIRT.c */
extern VOID FAR PASCAL VirtualScreenInit(void);
extern VOID FAR PASCAL VirtualScreenFillBackground(COLOR);
extern VOID FAR PASCAL VirtualScreenBad(void);
extern VOID FAR PASCAL VirtualScreenRowBad(int);
extern VOID FAR PASCAL VirtualScreenSetBadCols(int,int);
extern BOOL FAR PASCAL VirtualScreenEnable(void);
extern VOID FAR PASCAL VirtualScreenFlush(void);

/*
  WINZOOM.C
*/
extern VOID FAR PASCAL _GetIconXY(INT, HWND, INT *, INT *, INT *, INT *);
extern VOID FAR PASCAL WinDestroyIconTitle(WINDOW *);


/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WLISTBOX.c */
extern LONG FAR PASCAL ListBoxWinProc(HWND,WORD,WORD,LONG);
extern WORD FAR PASCAL ListBoxCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern INT  FAR PASCAL ListBoxSetRedraw(HWND,BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WLNKLIST.c */
extern VOID FAR PASCAL ListInsert(LIST **,LIST *,LIST *);
extern INT  FAR PASCAL ListGetLength(LIST *);
extern VOID FAR PASCAL ListAdd(LIST **,LIST *);
extern LIST *FAR PASCAL ListGetNth(LIST *,int);
extern LIST *FAR PASCAL ListFindData(LIST *,LPSTR);
extern VOID FAR PASCAL ListDelete(LIST **,LIST *);
extern INT  FAR PASCAL ListFree(LIST **,int);
extern LIST *FAR PASCAL ListCreate(LPSTR);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WMEM.c */
extern VOID FAR PASCAL MemoryInit(void);
 

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WMOUAPI.c */
extern BOOL FAR PASCAL MouseHideIfInRange (int, int);
extern INT  FAR PASCAL MouseInit(void);
extern VOID FAR PASCAL MouseTerminate(void);
extern INT  FAR PASCAL MouseShow(void);
extern INT  FAR PASCAL MouseHide(void);
extern VOID FAR PASCAL WinUpdateCaret(void);
extern BOOL FAR PASCAL CaretPush(int, int);
extern VOID FAR PASCAL CaretPop(void);
extern VOID FAR PASCAL MouseSetCursorChar(INT);
extern BOOL FAR PASCAL IsMouseLeftButtonDown(void);
extern INT  FAR PASCAL GetMouseMessage(LPMSG);
extern VOID     PASCAL MouseGetStatus(int *, COORD *, COORD *);

/* WNOTIFY.C */
extern VOID FAR PASCAL WinParentNotify(HWND, WORD, DWORD);

/* WOBJECT.C */
extern HBRUSH FAR PASCAL SysCreateSolidBrush(DWORD);
extern VOID   FAR PASCAL InitSysBrushes(void);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WPUSHBUT.c */
extern HWND FAR PASCAL PushButtonCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern VOID FAR PASCAL PushButtonDraw(HWND);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WREFRESH.c */
extern VOID PASCAL RefreshInvalidWindows(HWND);
extern VOID PASCAL WinGenInvalidRects(HWND, LPRECT);
extern VOID FAR PASCAL InvalidateWindow(HWND, BOOL);
extern VOID FAR PASCAL InvalidateNCArea(HWND);
extern VOID FAR PASCAL _InvalidateRect(HWND, CONST RECT FAR *, BOOL);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WRUBBER.c */
extern INT  FAR PASCAL WinRubberband(HWND,WORD,int,int,int);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WSETRECT.C */
extern VOID FAR PASCAL _WinAdjustRectForShadow(WINDOW *, LPRECT);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WSTATIC.c */
extern WORD FAR PASCAL StaticCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,WORD);
extern LONG FAR PASCAL StaticWinProc(HWND,WORD,WORD,LONG);
extern BOOL FAR PASCAL IsFrameClass(WINDOW *);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WSETWPOS.c */
extern BOOL FAR PASCAL ShouldWeUpdateVismap(WINDOW *);
extern INT  FAR PASCAL MEWELSend_WMMOVE(WINDOW *);
extern INT  FAR PASCAL MEWELSend_WMSIZE(WINDOW *);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WSTDPROC.c */
extern LONG FAR PASCAL StdWindowWinProc(HWND,WORD,WORD,LONG);

/* cl /AL /c /J /DMSC /DDOS /DLANSYS /Oait /Gs /Zg WSTFOCUS.c */
extern INT  FAR PASCAL WinSetFocus(HWND);
extern VOID FAR PASCAL WinRefreshActiveTitleBar(HWND);
extern HWND FAR PASCAL _WinActivate(HWND, BOOL);

/* WSYSMENU.c */
extern BOOL FAR PASCAL _WinFindandInvokeSysMenu(HWND);
extern WORD FAR PASCAL WinCreateSysMenu(HWND);
extern BOOL FAR PASCAL WinActivateSysMenu(HWND);
extern VOID FAR PASCAL WinGetIntlMenuStrings(void);

/* WZORDER.C */
extern VOID FAR PASCAL _WinUnlinkChildFromParent(PWINDOW);
extern VOID FAR PASCAL _WinAddChild(HWND, HWND);


#if defined(UNIX) || defined(VAXC)
extern WORD FAR PASCAL VioReadCellStr(LPSTR, int *, int, int, int);
extern VOID FAR PASCAL VioWrtCell(CELL, int, int, int);
extern VOID FAR PASCAL VioWrtNCell(CELL, int, int, int, int);
extern VOID FAR PASCAL VioWrtCellStr(LPCELL, int, int, int, int);
extern VOID FAR PASCAL VIDmvaddstr(int, int, LPSTR);
#endif

#if defined(MOTIF) || defined(DECWINDOWS)
extern void WindowDestroyCallback(Widget, caddr_t, caddr_t);
extern BOOL FAR PASCAL _XCreateNormalWindow(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, HMENU, LPSTR);
extern BOOL FAR PASCAL _XCreatePushButton(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateRadioButton(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateCheckBox(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateEdit(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateText(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateScrollbar(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern BOOL FAR PASCAL _XCreateListBox(HWND,int,LPCSTR,DWORD, int,int,int,int,
                                        HWND, WORD, LPSTR);
extern HWND FAR PASCAL _WidgetToHwnd(Widget);
extern VOID FAR PASCAL _XWinMove(HWND, int, int);
extern VOID FAR PASCAL _XWinResize(HWND, int, int);
extern VOID FAR PASCAL _XBringWindowToTop(HWND);
extern VOID FAR PASCAL _XScrollWindow(HWND, int, int, LPRECT, LPRECT);
extern VOID FAR PASCAL _XSetFocus(HWND);
extern VOID FAR PASCAL _XSetCapture(HWND);
extern VOID FAR PASCAL _XReleaseCapture(void);
extern VOID FAR PASCAL _XSetCursor(int);
extern VOID FAR PASCAL _XGetRealCoords(WINDOW *);
extern HWND FAR PASCAL XSetMenu(HWND, LPCSTR);
extern VOID FAR PASCAL _XAddSysMenuItem(LPSTR, WORD);
extern int  FAR PASCAL _XDialogBox(HANDLE, LPSTR, HWND, FARPROC);
extern HWND FAR PASCAL _XCreateDialog(HANDLE, LPSTR, HWND, FARPROC);
extern INT  FAR PASCAL _XMessageBox(HWND, LPSTR, LPSTR, WORD);
extern BOOL     PASCAL _XGetTextMetrics(HDC, LPTEXTMETRIC);
extern BOOL     PASCAL XTextOut(HDC, INT, INT, PSZ, WORD);
extern BOOL     PASCAL _Arc(HDC, int, int, int, int, int, int, int, int, int);
extern BOOL FAR PASCAL GUIInitialize(void);
#ifndef _WPRIVATE_H
#define DialogBox     _XDialogBox
#define CreateDialog  _XCreateDialog
#endif
extern int FAR PASCAL _XSetScrollPos(HWND, int);
extern int FAR PASCAL _XSetScrollRange(HWND, int, int);
extern LPSTR _XGetWindowName(Widget);
extern BOOL  _XSetWindowName(Widget, LPSTR);
#else
#define GUIInitialize()
#endif


extern VOID  FAR CDECL int23ini(LPSTR);
extern VOID  FAR CDECL int23res(void);
extern VOID  FAR CDECL int23rtn(void);
extern VOID  FAR CDECL int1brtn(void);
extern INT   FAR CDECL dosioctl(WORD, WORD, WORD, WORD, WORD, LPWORD, LPWORD);

extern LPSTR FAR PASCAL lcgacpy(LPSTR,LPSTR,WORD);

#if defined(OS2)
int CDECL InitEventThreads(void);
int CDECL SuspendEventThreads(VOID);
int CDECL ResumeEventThreads(VOID);
int CDECL TerminateKeyboard(VOID);
int CDECL MouseThreadInit(VOID);
int CDECL StartTimerThread(VOID);
int CDECL InitEventThreads(VOID);
#endif

VOID FAR PASCAL _TranslatePrefix(LPSTR szWindow);

extern VOID  FAR PASCAL lwmemset(LPCELL, CELL, WORD);
#if defined(OS2)
#define limemset   lwmemset
#else
extern VOID  FAR PASCAL limemset(LPWORD, WORD, WORD);
#endif

extern VOID PASCAL MEWELWriteDebugString(PSTR);

extern VOID FAR PASCAL GUIGetDCHook(HDC);
extern INT  FAR PASCAL GUIReleaseDCHook(HDC);


/*
  Starting with MSC 7, several DOS-specific functions have been un-ANSIfied.
*/
#if 0
#if defined(_MSC_VER) && (_MSC_VER >= 700)
#define INT86   _int86
#define INT86X  _int86x
#else
#define INT86   int86
#define INT86X  int86x
#endif
#endif

#define INT86   int86
#define INT86X  int86x
