/*===========================================================================*/
/*                                                                           */
/* File    : WINDECLS.H                                                      */
/*                                                                           */
/* Purpose : Function prototypes for MEWEL.                                  */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1989-1991 Marc Adler/Magma Systems     All Rights Reserved  */
/*===========================================================================*/


#if defined(DOS) || defined(OS2) || defined(XENIX) || defined(VAXC)
#define PROTOTYPES 1
#endif

#if defined(DOS) && !defined(WC386) && !defined(__TSC__)
#define HUGEDATA  huge
#else
#define HUGEDATA  FAR
#endif


/* WARRICON.C */
extern UINT FAR PASCAL ArrangeIconicWindows(HWND);

/* WCLIPBRD.c */
extern BOOL FAR PASCAL CloseClipboard(void);
extern BOOL FAR PASCAL EmptyClipboard(void);
extern WORD FAR PASCAL EnumClipboardFormats(WORD);
#ifdef MEM_MACROS
extern GLOBALHANDLE FAR PASCAL GetClipboardData(WORD);
extern GLOBALHANDLE FAR PASCAL SetClipboardData(WORD, GLOBALHANDLE);
#else
extern HANDLE FAR PASCAL GetClipboardData(WORD);
extern HANDLE FAR PASCAL SetClipboardData(WORD, HANDLE);
#endif
extern INT  FAR PASCAL GetClipboardFormatName(WORD, LPSTR, INT);
extern HWND FAR PASCAL GetClipboardOwner(void);
extern HWND FAR PASCAL GetClipboardViewer(void);
extern BOOL FAR PASCAL IsClipboardFormatAvailable(WORD);
extern BOOL FAR PASCAL OpenClipboard(HWND);
extern HWND FAR PASCAL SetClipboardViewer(HWND);
extern WORD FAR PASCAL RegisterClipboardFormat(LPCSTR);
extern BOOL FAR PASCAL ChangeClipboardChain(HWND, HWND);
extern INT  FAR PASCAL CountClipboardFormats(void);
extern INT  FAR PASCAL GetPriorityClipboardFormat(LPWORD, INT);
#if (WINVER >= 0x030a)
extern HWND WINAPI GetOpenClipboardWindow(void);
#endif  /* WINVER >= 0x030a */


extern BOOL FAR PASCAL IsWindow(HWND);
extern BOOL FAR PASCAL IsMenu(HMENU);

/* WDLGDIR.c */
extern BOOL FAR PASCAL DlgDirListComboBox(HWND,LPSTR, int, int, UINT);
extern BOOL FAR PASCAL DlgDirList(HWND,LPSTR, int, int, UINT);
extern BOOL FAR PASCAL DlgDirSelectComboBox(HWND,LPSTR, int);
extern BOOL FAR PASCAL DlgDirSelect(HWND,LPSTR, int);
extern INT  FAR PASCAL SpecHasWildcards(LPSTR);
extern INT  FAR PASCAL CheckCriticalError(INT);

/* WDLGOPEN.c */
extern INT FAR PASCAL DlgOpenFile(HWND,LPSTR,LPSTR);

/* WDRVTYPE.c */
extern WORD  FAR PASCAL GetDriveType(int);
/* GetDriveType return values */
#define DRIVE_REMOVABLE 2
#define DRIVE_FIXED     3
#define DRIVE_REMOTE    4

/* WEMALLOC.c */
extern PSTR  FAR PASCAL emalloc(WORD);
extern VOID  FAR PASCAL MyFree(void *);
extern LPSTR FAR PASCAL emalloc_far(DWORD);
extern LPSTR FAR PASCAL emalloc_far_noquit(DWORD);
extern LPSTR FAR PASCAL realloc_far(void FAR *, DWORD);
extern VOID  FAR PASCAL MyFree_far(void FAR *);
#if defined(__TURBOC__)
extern DWORD FAR PASCAL MyFarCoreLeft(void);
#endif
extern PSTR  FAR PASCAL strsave(PSTR);
extern LPSTR FAR PASCAL lstrsave(LPSTR);

/* WGETNEXT.c */
extern HWND FAR PASCAL GetWindow(HWND,UINT);
extern HWND FAR PASCAL GetTopWindow(HWND);
extern HWND FAR PASCAL GetNextWindow(HWND,UINT);
#if !defined(MAC)
extern HWND FAR PASCAL FindWindow(LPCSTR, LPCSTR);
#endif

/* WINACCEL.c */
extern WORD FAR PASCAL AcceleratorCreate(void);
extern INT  FAR PASCAL AcceleratorDestroy(HACCEL);
extern INT  FAR PASCAL AcceleratorSetKey(HACCEL,int,WORD);
extern BOOL FAR PASCAL TranslateMessage(LPMSG);
extern BOOL FAR PASCAL TranslateAccelerator(HWND, HACCEL, LPMSG);
extern INT  FAR PASCAL AltKeytoLetter(int);
extern INT  FAR PASCAL LetterToAltKey(int);

/* WINBLIT.c */
extern INT FAR PASCAL WinBltRect(HWND,HDC,LPRECT,LPRECT);
extern INT FAR PASCAL WinFillRect(HWND,HDC,LPRECT,INT,COLOR);
extern INT FAR PASCAL WinInvertRect(HWND,HDC,LPRECT);
extern INT FAR PASCAL WinRestoreRect(HWND,LPRECT,HANDLE);
extern HANDLE FAR PASCAL _WinSaveRect(HWND,LPRECT);
extern INT  FAR PASCAL WinSaveRect(HWND,LPRECT,LPSTR);
extern INT  FAR PASCAL WinColorRect(HWND,HDC,LPRECT,INT,COLOR);

/* WINBORDR.c */
extern VOID FAR PASCAL WinDrawBorder(HWND,int);
extern INT  FAR PASCAL WinDrawFrame(HWND,COLOR,int);

/* WINCLASS.c */
extern INT  FAR PASCAL RegisterClass(WNDCLASS *);
extern INT  FAR PASCAL ExtRegisterClass(EXTWNDCLASS *);
extern INT  FAR PASCAL ClassNameToClassID(LPCSTR);
extern INT  FAR PASCAL WinGetClass(HWND);
extern LPCSTR FAR PASCAL WinGetClassName(HWND);
extern DWORD FAR PASCAL GetClassStyle(HWND);
extern INT  FAR PASCAL GetClassName(HWND,LPCSTR,int);
extern LPCSTR FAR PASCAL ClassIDToClassName(WORD);

#if 0
extern LONG (FAR PASCAL *FAR PASCAL ClassToWinProc(int idClass))();
extern LONG (FAR PASCAL *FAR PASCAL ClassIDToDefProc(WORD id))();
extern LONG (FAR PASCAL *FAR PASCAL ClassIDToWndProc(WORD id))();
#else
extern WINPROC *FAR PASCAL ClassToWinProc(int);
extern WINPROC *FAR PASCAL ClassIDToDefProc(WORD);
extern WINPROC *FAR PASCAL ClassIDToWndProc(WORD);
#endif

extern EXTWNDCLASS *FAR PASCAL ClassIDToClassStruct(WORD);
extern INT  FAR PASCAL ClassNameToBaseClass(LPCSTR);
extern BOOL FAR PASCAL GetClassInfo(HINSTANCE, LPCSTR, WNDCLASS FAR *);
extern BOOL FAR PASCAL ExtGetClassInfo(HANDLE, LPCSTR, LPEXTWNDCLASS);
extern VOID FAR PASCAL _RegisterPredefinedClasses(void);
extern BOOL FAR PASCAL UnregisterClass(LPCSTR, HANDLE);

/* WINCOLOR.c */
extern VOID  FAR PASCAL WinUseSysColors(HWND,BOOL);
extern COLOR FAR PASCAL WinQuerySysColor(HWND,WORD);
extern COLOR FAR PASCAL WinSetSysColor(HWND,WORD,COLOR);
extern COLOR FAR PASCAL WinGetClassBrush(HWND);
extern DWORD FAR PASCAL GetSysColor(int);
extern VOID  FAR PASCAL SetSysColors(int, LPINT, DWORD FAR *);

/* WINCREAT.c */
extern WORD FAR PASCAL _CreateWindow(LPCSTR,LPCSTR,DWORD,int,int,int,int,COLOR,WORD,HWND,HWND,HANDLE,void FAR*);
extern HWND FAR PASCAL CreateWindow(LPCSTR,LPCSTR,DWORD,int,int,int,int,HWND,HMENU,HANDLE,void FAR*);
extern HWND FAR PASCAL CreateWindowEx(DWORD,LPCSTR,LPCSTR,DWORD,int,int,int,int,HWND,HMENU,HANDLE,void FAR*);

/* WINDLG.c */
extern HWND FAR PASCAL _DlgGetParent(HDLG);
extern HWND FAR PASCAL DialogCreate(HWND,int,int,int,int,LPSTR,COLOR,DWORD,FARPROC,WORD,LPSTR,HANDLE);

extern HWND FAR PASCAL CreateDialog(HANDLE, LPCSTR , HWND, FARPROC);
extern HWND FAR PASCAL CreateDialogParam(HANDLE, LPCSTR , HWND, FARPROC, LONG);
extern HWND FAR PASCAL CreateDialogIndirectParam(HANDLE, CONST VOID FAR *, HWND, FARPROC, LONG);
extern INT  FAR PASCAL DialogBoxParam(HANDLE, LPCSTR, HWND, FARPROC, LONG);
extern INT  FAR PASCAL DialogBox(HANDLE, LPCSTR , HWND, FARPROC);
extern INT  FAR PASCAL DialogBoxIndirect(HANDLE, GLOBALHANDLE , HWND, FARPROC);
extern INT  FAR PASCAL DialogBoxIndirectParam(HANDLE, GLOBALHANDLE , HWND, FARPROC, LONG);
extern INT  FAR PASCAL _DialogBox(HWND);
extern INT  FAR PASCAL _DialogBoxParam(HWND, LONG);

extern LONG FAR PASCAL DlgBoxWinProc(HWND,WORD,WORD,LONG);
extern LONG FAR PASCAL DefDlgProc(HWND,WORD,WORD,LONG);
extern BOOL FAR PASCAL DlgSetFocus(HWND);
extern BOOL FAR PASCAL _DlgSetFocus(HWND,BOOL);
extern BOOL FAR PASCAL IsDialogMessage(HWND,LPMSG);
extern INT  FAR PASCAL EndDialog(HWND,int);
extern WORD FAR PASCAL DlgGetFirstTabItem(HWND);
extern INT  FAR PASCAL DialogTab(HWND,int,int);
extern HWND FAR PASCAL GetNextDlgTabItem(HWND,HWND,BOOL);
extern HWND FAR PASCAL GetNextDlgGroupItem(HWND,HWND,UINT);
extern INT  FAR PASCAL CheckDlgButton(HWND,int,int);
extern INT  FAR PASCAL CheckRadioButton(HWND,int,int,int);
extern WORD FAR PASCAL GetDlgItemInt(HWND, int, BOOL FAR *, BOOL);
extern WORD FAR PASCAL GetDlgItem(HWND,int);
extern INT  FAR PASCAL GetDlgItemText(HWND,int,LPSTR,int);
extern BOOL FAR PASCAL IsDlgButtonChecked(HWND,int);
extern LRESULT FAR PASCAL SendDlgItemMessage(HWND, int, UINT, WPARAM, LPARAM);
extern BOOL FAR PASCAL SetDlgItemText(HWND,int,LPCSTR);
extern VOID FAR PASCAL SetDlgItemInt(HWND,int,UINT,BOOL);
extern BOOL FAR PASCAL SetDlgItemStyle(HWND,int,DWORD);
extern WORD FAR PASCAL DlgGetDefButton(HWND,int *);
extern VOID FAR PASCAL MapDialogRect(HWND, LPRECT);

/* WINDC.c */
extern HDC   FAR PASCAL GetDC(HWND);
extern HDC   FAR PASCAL GetWindowDC(HWND);
extern INT   FAR PASCAL ReleaseDC(HWND,HDC);
extern DWORD FAR PASCAL GetDCOrg(HDC);
extern HDC   FAR PASCAL BeginPaint(HWND,LPPAINTSTRUCT);
extern VOID  FAR PASCAL EndPaint(HWND,LPPAINTSTRUCT);
extern DWORD FAR PASCAL SetBkColor(HDC,DWORD);
extern DWORD FAR PASCAL GetBkColor(HDC);
extern DWORD FAR PASCAL SetTextColor(HDC,DWORD);
extern DWORD FAR PASCAL GetTextColor(HDC);
extern DWORD FAR PASCAL GetNearestColor(HDC, COLORREF);
extern WORD  FAR PASCAL RGBtoAttr(HDC, DWORD);
extern BOOL  FAR PASCAL _PrepareWMCtlColor(HWND, WORD);
extern VOID  FAR PASCAL UpdateWindow(HWND);
extern VOID  FAR PASCAL InvalidateRect(HWND,CONST RECT FAR *,BOOL);
extern VOID  FAR PASCAL ValidateRect(HWND, CONST RECT FAR *);
extern INT   FAR PASCAL GetUpdateRect(HWND,LPRECT,BOOL);
extern VOID  FAR PASCAL SetUpdateRect(HWND,LPRECT);
extern BOOL  FAR PASCAL TextOut(HDC,int,int,LPCSTR,int);
extern BOOL  FAR PASCAL ExtTextOut(HDC,INT,INT,UINT,CONST RECT FAR *,LPCSTR,UINT, LPINT);
extern DWORD FAR PASCAL GetTextExtent(HDC,LPCSTR,int);
extern BOOL  FAR PASCAL GetTextExtentPoint(HDC,LPCSTR,int,SIZE FAR *);
extern BOOL  FAR PASCAL GetCharWidth(HDC, UINT, UINT, LPINT);
#if !defined(MAC)
extern INT   FAR PASCAL FillRect(HDC,CONST RECT FAR *,HBRUSH);
extern INT   FAR PASCAL FrameRect(HDC,CONST RECT FAR *,HBRUSH);
extern VOID  FAR PASCAL InvertRect(HDC, CONST RECT FAR *);
#endif
extern BOOL  FAR PASCAL Rectangle(HDC,INT,INT,INT,INT);
#ifdef MEWEL_GUI
extern VOID  FAR PASCAL DrawFocusRect(HDC, CONST RECT FAR *);
#endif
extern VOID  FAR PASCAL AdjustWindowRect(LPRECT,DWORD,BOOL);
#if (WINVER >= 0x030a)
extern INT   FAR PASCAL SetWindowPos(HWND,HWND,INT,INT,INT,INT,UINT);
#else
extern VOID  FAR PASCAL SetWindowPos(HWND,HWND,INT,INT,INT,INT,UINT);
#endif
extern LONG  FAR PASCAL _WindowizeMouse(HWND, LONG);
extern LONG  FAR PASCAL _UnWindowizeMouse(HWND, LONG);

extern BOOL FAR PASCAL GrayString(HDC,HBRUSH,FARPROC,DWORD,int,int,int,int,int);


/* WINDRAW.c */
extern VOID FAR PASCAL WinDrawAllWindows(void);
extern VOID FAR PASCAL WinDraw(HWND);
extern INT  FAR PASCAL WinClear(HWND);
extern INT  FAR PASCAL WinEraseEOP(HWND,int,int,COLOR);
extern INT  FAR PASCAL WinEraseEOL(HWND,int,int,COLOR);
extern INT  FAR PASCAL WinEraseRect(HWND,LPRECT,COLOR);
extern INT  FAR PASCAL WinPutsCenter(HWND,int,LPSTR,COLOR);
extern INT  FAR PASCAL WinPutsRight(HWND,int,LPSTR,COLOR);
extern INT  FAR PASCAL WinPuts(HWND,int,int,LPSTR,COLOR);
extern INT  FAR PASCAL WinPutc(HWND,int,int,int,COLOR);
extern INT  FAR PASCAL WinGenAncestorClippingRect(HWND,HDC,LPRECT);
extern BOOL FAR PASCAL IsWindowVisible(HWND);
extern BOOL FAR PASCAL WinIsPointVisible(HWND,int,int);
#ifdef MODSOFT
extern BOOL FAR PASCAL WinIsRectUnobscured(HWND, LPRECT);
#endif
extern WORD FAR PASCAL WindowFromPoint(POINT);
extern WORD FAR PASCAL ChildWindowFromPoint(HWND,POINT);

/* WINDSTRY.c */
extern INT FAR PASCAL DestroyWindow(HWND);

/* WINENABL.c */
extern BOOL FAR PASCAL IsWindowEnabled(HWND);
extern INT  FAR PASCAL EnableWindow(HWND,BOOL);

/* WINENUM.c */
extern BOOL FAR PASCAL EnumTaskWindows(HANDLE, FARPROC, LONG);
extern BOOL FAR PASCAL EnumWindows(FARPROC,LONG);
extern BOOL FAR PASCAL EnumChildWindows(HWND,FARPROC,LONG);

/* WINEXEC.c */
#ifdef MODSOFT
extern INT  FAR PASCAL WinExecVars(char *, char *, char *);
extern INT  FAR PASCAL WinExecOpt(char *, char *, BOOL , BOOL);
#endif
extern INT  FAR PASCAL WinExec(char *, WORD);
#define EXEC_SWAP   0x00FF
#define EXEC_PAUSE  0x0100
#define EXEC_80X25  0x0200

/* WINEXTRA.c */
extern BOOL FAR PASCAL SetWindowExtra(HWND,int);
extern PSTR FAR PASCAL GetWindowExtra(HWND);
extern WORD FAR PASCAL GetWindowByte(HWND,int );
extern WORD FAR PASCAL GetWindowWord(HWND,int );
extern LONG FAR PASCAL GetWindowLong(HWND,int );
extern PSTR FAR PASCAL GetWindowPtr(HWND,int );
extern WORD FAR PASCAL SetWindowByte(HWND,int ,WORD );
extern INT  FAR PASCAL SetWindowWord(HWND,int ,WORD );
extern LONG FAR PASCAL SetWindowLong(HWND,int ,long );
extern PSTR FAR PASCAL SetWindowPtr(HWND,int ,PSTR);
extern PSTR FAR PASCAL GetWindowExtraAddr(HWND,int ,int);

/* WINICON.c */
extern HICON WINAPI LoadIcon(HINSTANCE, LPCSTR);
extern HICON WINAPI CreateIcon(HANDLE,int,int,BYTE,BYTE,CONST VOID FAR*,CONST VOID FAR*);
extern BOOL  FAR PASCAL DestroyIcon(HICON);
extern BOOL  FAR PASCAL DrawIcon(HDC,int,int,HICON);
extern BOOL  FAR PASCAL IsIconic(HWND);
extern BOOL  FAR PASCAL OpenIcon(HWND);

/* WININIT.C */
extern INT  FAR PASCAL WinInit(void);
extern INT  FAR PASCAL GetModuleFileName(HANDLE, LPSTR, int);
extern WORD FAR PASCAL GetSystemDirectory(LPSTR, INT);
extern INT  FAR PASCAL GetKeyState(int);

extern BOOL FAR PASCAL SetErrorMode(WORD);
/* SetErrorMode() constants */
#define SEM_FAILCRITICALERRORS  0x0001
#define SEM_NOGPFAULTERRORBOX   0x0002
#define SEM_NOOPENFILEERRORBOX  0x8000

/* WINMENU.c */
extern HMENU FAR PASCAL CreateMenu(void);
extern LONG  FAR PASCAL MenuWndProc(HWND,WORD,WORD,LONG);
extern BOOL  FAR PASCAL ChangeMenu(HWND,WORD,LPCSTR,WORD,WORD);
extern BOOL  FAR PASCAL CheckMenuItem(HWND,UINT,UINT);
extern INT   FAR PASCAL DestroyMenu(HWND);
#if !defined(MAC)
extern INT   FAR PASCAL DrawMenuBar(HWND);
extern WORD  FAR PASCAL GetMenu(HWND);
#endif
extern BOOL  FAR PASCAL EnableMenuItem(HWND,UINT,UINT);
extern INT   FAR PASCAL GetMenuItemCount(HWND);
extern UINT  FAR PASCAL GetMenuItemID(HMENU,int);
extern UINT  FAR PASCAL GetMenuState(HWND,UINT,UINT);
extern INT   FAR PASCAL GetMenuString(HWND,UINT,LPSTR,int,UINT);
extern WORD  FAR PASCAL GetSubMenu(HWND,int);
extern INT   FAR PASCAL IsMenuBarAccel(HWND,WORD, int *, int *);
extern INT   FAR PASCAL MenuBarShowPopup(HWND,int);
extern INT   FAR PASCAL MenuChar(PWINDOW,WORD);
extern INT   FAR PASCAL MenuRefresh(WINDOW *);
extern INT   FAR PASCAL MenuSaveScreen(HWND,BOOL);
extern INT   FAR PASCAL SetMenu(HWND,HWND);
extern WORD  FAR PASCAL WinGetMenuRoot(HWND);
extern VOID  FAR PASCAL _MenuFixPopups(PWINDOW,HWND);
extern WORD  FAR PASCAL CreatePopupMenu(void);
extern WORD  FAR PASCAL LoadPopupMenu(HWND,LPCSTR);
extern BOOL  FAR PASCAL TrackPopupMenu(HMENU,WORD,int,int,int,HWND,CONST RECT *);

#if !defined(MAC)
extern BOOL  WINAPI InsertMenu(HMENU, UINT, UINT, UINT, LPCSTR);
extern BOOL  WINAPI AppendMenu(HMENU, UINT, UINT, LPCSTR);
extern BOOL  WINAPI DeleteMenu(HMENU, UINT, UINT);
#endif
extern BOOL  WINAPI ModifyMenu(HMENU, UINT, UINT, UINT, LPCSTR);
extern BOOL  WINAPI RemoveMenu(HMENU, UINT, UINT);

/* WINMONO.c */
extern COLOR FAR PASCAL WinMapAttr(COLOR);
extern VOID FAR PASCAL WinSetMonoMapColor(int,int,COLOR);
extern VOID FAR PASCAL WinUseMonoMap(int);

/* WINMOVE.c */
extern INT  FAR PASCAL WinMove(HWND,int,int);
#if !defined(MAC)
#if (WINVER >= 0x030a)
extern BOOL FAR PASCAL MoveWindow(HWND, int, int, int, int, BOOL);
#else
extern VOID FAR PASCAL MoveWindow(HWND, int, int, int, int, BOOL);
#endif
#endif /* MAC */

/* WINPROP.c */
extern WORD FAR PASCAL GetProp(HWND, LPSTR);
extern WORD FAR PASCAL SetProp(HWND, LPSTR, WORD);
extern HANDLE FAR PASCAL RemoveProp(HWND, LPSTR);
extern INT  FAR PASCAL EnumProps(HWND, FARPROC);


/* WINRECT.c */
extern RECT FAR PASCAL RectIntersect(RECT,RECT);
extern INT  FAR PASCAL DoesRectIntersect(LPRECT,LPRECT);
extern INT  FAR PASCAL RectContainsPoint(RECT,int,int);
extern INT  FAR PASCAL RectIsEmpty(RECT);
extern INT  FAR PASCAL RectSize(LPRECT);
extern VOID FAR PASCAL RectSort(LPRECT);
extern VOID FAR PASCAL RectTile(RECT,RECT,RECT[]);
extern RECT FAR PASCAL RectUnion(RECT,RECT);
extern VOID FAR PASCAL CopyRect(LPRECT,CONST RECT FAR *);
#if !defined(MAC)
extern BOOL FAR PASCAL EqualRect(CONST RECT FAR *,CONST RECT FAR *);
extern VOID FAR PASCAL OffsetRect(LPRECT,int,int);
extern BOOL FAR PASCAL PtInRect(CONST RECT FAR *,POINT);
extern VOID FAR PASCAL SetRect(LPRECT,int,int,int,int);
extern BOOL WINAPI UnionRect(RECT FAR*, CONST RECT FAR*, CONST RECT FAR*);
#endif /* MAC */
extern VOID FAR PASCAL InflateRect(LPRECT,int,int);
extern INT  FAR PASCAL IntersectRect(RECT FAR *,CONST RECT FAR *,CONST RECT FAR *);
extern BOOL FAR PASCAL IsRectEmpty(CONST RECT FAR *);
extern VOID FAR PASCAL SetRectEmpty(LPRECT);
extern VOID FAR PASCAL ClientToScreen(HWND,LPPOINT);
extern VOID FAR PASCAL ScreenToClient(HWND,LPPOINT);
extern VOID FAR PASCAL WinClientRectToScreen(HWND,LPRECT);
extern VOID FAR PASCAL WinScreenRectToClient(HWND,LPRECT);
extern VOID FAR PASCAL GetClientRect(HWND, LPRECT);
#ifdef __cplusplus
inline BOOL WINAPI SubtractRect(RECT FAR* lpDest, CONST RECT FAR* lpRect1, 
                                CONST RECT FAR* lpRect2)
{
  *(lpDest) = *(lpRect1);   return TRUE;
}
#else
#define SubtractRect(lpDest, lpRect1, lpRect2)  (*(lpDest) = *(lpRect1), TRUE)
#endif

/* WINRES.c */
#if !defined(MAC)
extern LPSTR FAR PASCAL GetResource(HWND,LPSTR,LPSTR);
#endif
extern WORD  FAR PASCAL OpenResourceFile(PSTR);
extern VOID  FAR PASCAL CloseResourceFile(WORD);

extern WORD FAR PASCAL LoadAccelerators(HINSTANCE,LPCSTR);
extern WORD FAR PASCAL LoadMenu(HINSTANCE,LPCSTR);
extern HMENU FAR PASCAL LoadMenuIndirect(CONST VOID FAR *);
extern WORD FAR PASCAL LoadDialog(HINSTANCE,LPCSTR,HWND,FARPROC);
extern HWND FAR PASCAL CreateDialogIndirect(HANDLE, CONST VOID FAR*, HWND, FARPROC);
extern HWND FAR PASCAL _CreateDialogIndirect(HANDLE, CONST VOID FAR*, HWND, FARPROC);

extern PSTR FAR PASCAL _DosSearchPath(PSTR,PSTR,PSTR);
extern INT FAR PASCAL LoadString(HANDLE,int,LPSTR,WORD);

/* WINSCROL.c */
extern INT  FAR PASCAL WinScrollWindow(HWND,int,int,CONST RECT FAR*);
extern VOID WINAPI ScrollWindow(HWND, int, int, CONST RECT FAR*, CONST RECT FAR*);

/* WINSET.c */
extern DWORD FAR PASCAL WinSetFlags(HWND,DWORD);
extern DWORD FAR PASCAL WinSetStyle(HWND,DWORD);
extern DWORD FAR PASCAL WinGetFlags(HWND);
extern DWORD FAR PASCAL WinGetStyle(HWND);
extern COLOR FAR PASCAL WinSetAttr(HWND,COLOR,BOOL);
extern COLOR FAR PASCAL WinGetAttr(HWND);
extern INT   FAR PASCAL SetCapture(HWND);
extern HWND  FAR PASCAL GetCapture(void);
extern INT   FAR PASCAL ReleaseCapture(void);
extern VOID  FAR PASCAL WinSetCursor(HWND,int,int);
#if defined(UNIX) && !defined(XENIX)
extern LONG (*WinSetWinProc(HWND,long (*)()))();
#else
#if 0
extern LONG (FAR PASCAL *FAR PASCAL WinSetWinProc(HWND,long (FAR PASCAL *)()))();
#else
extern WINPROC *FAR PASCAL WinSetWinProc(HWND,WINPROC *);
#endif
#endif
extern INT  FAR PASCAL SetWindowText(HWND,LPCSTR);
extern INT  FAR PASCAL GetWindowText(HWND,LPSTR,int);
extern INT  FAR PASCAL GetWindowTextLength(HWND);
#if !defined(MAC)
extern HCURSOR FAR PASCAL SetCursor(HCURSOR);
#endif


/* WINSHOW.c */
#if !defined(MAC)
extern BOOL FAR PASCAL ShowWindow(HWND,int);
extern VOID FAR PASCAL CloseWindow(HWND);
#endif

/* WINSIZE.c */
extern INT  FAR PASCAL WinSetSize(HWND,int,int);

/* WINSOUND.c */
extern VOID FAR PASCAL MessageBeep(int);
extern VOID FAR PASCAL SoundNote(int,int,unsigned);
extern VOID FAR PASCAL SoundTone(unsigned,unsigned,unsigned);
extern VOID FAR PASCAL SoundClick(void);


/* WINTERM.c */
#ifdef XENIX
extern VOID     CDECL WinTerminate(void);
#else
extern VOID     CDECL WinTerminate(void);
#endif

/* WINTIME.c */
extern INT   FAR PASCAL DosGetTime(int *,int *,int *);
extern DWORD FAR PASCAL BIOSGetTime(void);
extern DWORD FAR PASCAL BIOSSetTime(int);
extern DWORD FAR PASCAL GetCurrentTime(void);

/* WINTIMER.c */
extern UINT  FAR PASCAL SetTimer(HWND,UINT,UINT,TIMERPROC);
extern BOOL  FAR PASCAL KillTimer(HWND,UINT);

/* WINTOTOP.c */
extern INT   FAR PASCAL BringWindowToTop(HWND);
extern INT   FAR PASCAL WinToTop(HWND);

/* WINZOOM.c */
extern BOOL FAR PASCAL WinZoom(HWND);
extern BOOL FAR PASCAL IsZoomed(HWND);
extern BOOL FAR PASCAL WinMinimize(HWND);

#ifndef VAXC
/* WLINETO.c */
#if !defined(MAC)
extern DWORD FAR PASCAL MoveTo(HDC, INT, INT);
extern BOOL  FAR PASCAL LineTo(HDC, INT, INT);
#endif
extern BOOL  FAR PASCAL MoveToEx(HDC, INT, INT, POINT FAR *);
extern DWORD FAR PASCAL GetCurrentPosition(HDC);
extern BOOL  FAR PASCAL GetCurrentPositionEx(HDC, POINT FAR *);
#endif

/* WLOADBMP.c */
extern HBITMAP FAR PASCAL LoadBitmap(HINSTANCE, LPCSTR);


#if defined(MSC) || defined(__TURBOC__) || defined(__ZTC__)
#ifndef memcpy
#include <string.h>
#endif
#endif
#if !defined(__TURBOC__) && !defined(__HIGHC__) && defined(MSC) && (_MSC_VER < 700)
#pragma intrinsic(memcpy)
#pragma intrinsic(memset)
#pragma intrinsic(memcmp)
#pragma intrinsic(strlen)
#if !defined(MSC)
#pragma intrinsic(strchr)
#endif
#endif

#if (defined(DOS) && !defined(M_I86LM) && !defined(M_I86HM) && !defined(__LARGE__) && !defined(DOS386) && !defined(WC386))
extern LPSTR FAR PASCAL lmemcpy(LPSTR,LPSTR,WORD);
extern LPSTR FAR PASCAL lmemset(LPSTR,int,WORD);
extern WORD  FAR PASCAL lstrlen(LPSTR);
extern INT   FAR PASCAL lstrnicmp(LPSTR,LPSTR,WORD);
extern LPSTR FAR PASCAL lstrcpy(LPSTR,LPSTR);
extern LPSTR FAR PASCAL lstrchr(LPSTR, int);
extern LPSTR FAR PASCAL lstrncpy(LPSTR,LPSTR,WORD);
extern LPSTR FAR PASCAL lstrcat(LPSTR,LPSTR);
extern INT   FAR PASCAL lstrcmp(LPSTR,LPSTR);
extern INT   FAR PASCAL lstricmp(LPSTR,LPSTR);
extern LPSTR FAR PASCAL lmemchr(LPSTR, int, WORD);
#else
/*
  Use built-in functions for non-DOS systems, DOS-large, or DOS prot-mode
*/
#define lstrnicmp(s, t, n) strnicmp(s, t, n)
#define lstrcpy(s,t)       strcpy(s,t)
#define lstrchr(s, c)      strchr(s, c)
#define lstrncpy(s,t,n)    strncpy(s,t,n)
#define lstrcpyn(s,t,n)    strncpy(s,t,n)
#define lstrcat(s,t)       strcat(s,t)
#define lstrcmp(s,t)       strcmp(s,t)
#define lstricmp(s,t)      stricmp(s,t)
#define lstrlen(s)         ((int) strlen(s))
#define lmemchr(s, c, n)   memchr(s, c, n)  
#define lmemcpy(s, t, n)   memcpy(s, t, n)  
#define lmemset(s, c, n)   memset(s, c, n)  
#endif

extern LPSTR FAR PASCAL lstrupr(LPSTR);
extern INT  FAR PASCAL lmemscan(LPSTR, int, WORD);
extern PSTR FAR PASCAL strcpy_until(PSTR,PSTR,int);
extern PSTR FAR PASCAL next_int_token(PSTR,int *);
extern PSTR FAR PASCAL next_token(PSTR);
extern PSTR FAR PASCAL span_blanks(PSTR);
extern PSTR FAR PASCAL span_chars(PSTR);
extern PSTR FAR PASCAL rtrim(PSTR);

/* WFILEIO.c */
extern INT  FAR PASCAL _lread(int, void FAR *, unsigned int);
extern INT  FAR PASCAL _lwrite(int, void FAR *, unsigned int);
extern INT  FAR PASCAL _lcreat(LPSTR, int);
extern INT  FAR PASCAL _lopen(LPSTR, int);

/* WMESSAGE.c */
extern WORD  FAR PASCAL _PeekMessage(LPMSG);
extern WORD  FAR PASCAL _WinGetMessage(LPMSG);
extern BOOL  WINAPI PostMessage(HWND, UINT, WPARAM, LPARAM);
extern LRESULT WINAPI SendMessage(HWND, UINT, WPARAM, LPARAM);
extern BOOL  FAR PASCAL InSendMessage(void);
#ifdef STRICT
extern LRESULT WINAPI CallWindowProc(WNDPROC, HWND, UINT, WPARAM, LPARAM);
#else
extern LRESULT WINAPI CallWindowProc(FARPROC, HWND, UINT, WPARAM, LPARAM);
#endif
extern INT   FAR PASCAL DispatchMessage(LPMSG);
extern BOOL  FAR PASCAL GetMessage(LPMSG,HWND,WORD,WORD);
extern LONG  FAR PASCAL GetMessageTime(void);
extern DWORD FAR PASCAL GetMessagePos(void);
extern BOOL  FAR PASCAL PeekMessage(LPMSG,HWND,WORD,WORD,WORD);
extern VOID  FAR PASCAL WaitMessage(void);
extern INT   FAR PASCAL PostQuitMessage(int);
extern LONG  FAR PASCAL DefWindowProc(HWND,WORD,WORD,LONG);

extern BOOL  FAR PASCAL UnhookWindowsHook(int, HOOKPROC);
#ifdef STRICT
HHOOK   WINAPI SetWindowsHook(int, HOOKPROC);
LRESULT WINAPI DefHookProc(int, WPARAM, LPARAM, HHOOK FAR*);
#else
HOOKPROC WINAPI SetWindowsHook(int, HOOKPROC);
LRESULT WINAPI DefHookProc(int, WPARAM, LPARAM, HOOKPROC FAR*);
#endif
#if (WINVER >= 0x030a)
HHOOK   WINAPI SetWindowsHookEx(int, HOOKPROC, HINSTANCE, HTASK);
BOOL    WINAPI UnhookWindowsHookEx(HHOOK);
LRESULT WINAPI CallNextHookEx(HHOOK, int, WPARAM, LPARAM);
#endif  /* WINVER >= 0x030a */


/* WMOUAPI.c */
extern BOOL FAR PASCAL IsMouseInstalled(void);
#if !defined(MAC)
extern INT  FAR PASCAL ShowCursor(BOOL);
#endif
extern INT  FAR PASCAL MouseShow(void);
extern VOID FAR PASCAL GetCursorPos(LPPOINT);
extern VOID FAR PASCAL GetPixelCursorPos(LPPOINT);
extern VOID FAR PASCAL SetCursorPos(int, int);
extern INT  FAR PASCAL SetDoubleClickTime(int);
extern INT  FAR PASCAL GetDoubleClickTime(void);
extern VOID FAR PASCAL ClipCursor(LPRECT);
extern BOOL FAR PASCAL SwapMouseButton(BOOL);
#ifndef OS2
extern VOID     FAR PASCAL WinUseGraphicsMouse(void);
#endif /* OS2 */


/* WMSGBOX.c */
extern INT  FAR PASCAL MessageBox(HWND, LPCSTR, LPCSTR, UINT);

/* WPROFILE.c */
extern INT  FAR PASCAL WriteProfileString(LPCSTR,LPCSTR,LPCSTR);
extern INT  FAR PASCAL WritePrivateProfileString(LPCSTR,LPCSTR,LPCSTR,LPCSTR);
extern INT  FAR PASCAL GetProfileString(LPCSTR,LPCSTR,LPCSTR,LPSTR,int);
extern INT  FAR PASCAL GetPrivateProfileString(LPCSTR,LPCSTR,LPCSTR,LPSTR,int,LPCSTR);
extern UINT FAR PASCAL GetProfileInt(LPCSTR,LPCSTR,int);
extern UINT FAR PASCAL GetPrivateProfileInt(LPCSTR,LPCSTR,int,LPCSTR);
extern LPSTR FAR PASCAL env_parse(LPSTR, LPSTR);
extern VOID FAR PASCAL CloseProfile(void);

/* WREADINI.C */
extern VOID FAR PASCAL WinReadINI(void);

/* WSCRLBAR.c */
extern LONG FAR PASCAL ScrollBarWinProc(HWND,WORD,WORD,LONG);
extern WORD FAR PASCAL ScrollBarCreate(HWND,int,int,int,int,COLOR,DWORD,WORD);
extern VOID FAR PASCAL ShowScrollBar(HWND,int,BOOL);
extern INT  FAR PASCAL GetScrollPos(HWND,int);
extern INT  FAR PASCAL SetScrollPos(HWND,int,int,BOOL);
extern INT  FAR PASCAL GetScrollRange(HWND,int,int *,int *);
extern INT  FAR PASCAL SetScrollRange(HWND,int,int,int,BOOL);
extern VOID FAR PASCAL WinGetScrollbars(HWND,WORD *,WORD *);

/* WSETPRNT.c */
extern WORD FAR PASCAL SetParent(HWND,HWND);
extern WORD FAR PASCAL GetParent(HWND);
extern BOOL FAR PASCAL IsChild(HWND,HWND);

/* WSETRECT.c */
extern VOID FAR PASCAL WinSetRect(HWND,RECT);
extern INT  FAR PASCAL _WinSetClientRect(HWND);
extern VOID FAR PASCAL WinSetClientRect(HWND, LPRECT);
extern VOID FAR PASCAL GetWindowRect(HWND, LPRECT);
extern RECT FAR PASCAL WinGetClient(HWND);

/* WSHADOW.c */
extern INT  FAR PASCAL WinDrawShadow(HWND);

extern HWND FAR PASCAL GetFocus(void);
extern WORD FAR PASCAL SetFocus(HWND);

/* WSTRDISP.c */
extern VOID FAR PASCAL VidBlastToScreen(HDC,int,int,int,COLOR,LPSTR);

/* WSYSMENU.c */
extern WORD FAR PASCAL GetSystemMenu(HWND, BOOL);

/* WVGAMAP.c */
extern VOID FAR PASCAL VioMapCharBitmap(WORD, WORD, LPSTR);
#if defined(MEWEL_TEXT) && !defined(EXTENDED_DOS)
extern BOOL FAR PASCAL VidInitVGAFonts(void);
#else
#define VidInitVGAFonts()   (FALSE)
#endif
extern VOID CDECL  VidRestoreVGAFonts(void);

 /*
  * UNIX gprof(1) shows that window creation/destruction is extremely time
  * consuming. In fact, most of that time is spent within lwmemset(), in
  * calls from the WinUpdateVismap() routine. The following is an attempt to
  * speed up window creation/destruction by inlining the lwmemset statements,
  * so that the optimizer can produce more efficient code.
  */
#if 0
#if !defined(VAXC)
#ifdef PARANOID /* allow checks by the malloc library support routines */
#define lwmemset(d, c, l) { \
			    register LPWORD dest = d;	\
			    register WORD cell = c;	\
			    register WORD len = l;	\
				memset(dest, 0, len * sizeof(WORD));	\
				while (len-- > 0)	\
				    *dest++ = cell;	\
			    }
#else
#define lwmemset(d, c, l) { \
			    register LPWORD dest = d;	\
			    register WORD cell = c;	\
			    register WORD len = l;	\
				while (len-- > 0)	\
				    *dest++ = cell;	\
			    }
#endif
#endif /* VAXC */
#endif


extern LPSTR FAR PASCAL lmemmove(LPSTR, LPSTR, WORD);
#if defined(DOS) || defined(OS2)
extern VOID  FAR PASCAL lmemshr(LPSTR, LPSTR, WORD);
#else
#define lmemshr lmemmove
#endif

#ifndef OS2
extern VOID  FAR CDECL DosSleep(int);
#endif
extern INT   FAR CDECL keyready(WORD);

#define lang_upper(c)   (int)(long)AnsiUpper((LPSTR)(long)(c))


#if 0
#if defined(XENIX) && !defined(PCTEST)
#include <prototypes.h>
extern char *strlwr();
extern INT  stricmp();
extern INT  strnicmp();
#endif
#endif
#if (defined(UNIX) || defined(XENIX)) && !defined(PCTEST)
extern char *strlwr();
#endif

extern WORD FAR PASCAL GetClassWord(HWND, INT);
extern WORD FAR PASCAL SetClassWord(HWND, INT, WORD);
extern LONG FAR PASCAL GetClassLong(HWND, INT);
extern LONG FAR PASCAL SetClassLong(HWND, INT, LONG);

extern HANDLE FAR PASCAL GlobalAlloc(WORD, DWORD);
extern DWORD  FAR PASCAL GlobalCompact(DWORD);
extern HANDLE FAR PASCAL GlobalDiscard(HANDLE);
extern WORD   FAR PASCAL GlobalFlags(HANDLE);
extern HANDLE FAR PASCAL GlobalFree(HANDLE);
extern DWORD  FAR PASCAL GlobalHandle(WORD);
extern LPSTR  FAR PASCAL GlobalLock(HANDLE);
extern HANDLE FAR PASCAL GlobalLRUNewest(HANDLE);
extern HANDLE FAR PASCAL GlobalLRUOldest(HANDLE);
extern VOID   FAR PASCAL GlobalNotify(FARPROC);
extern HANDLE FAR PASCAL GlobalReAlloc(HANDLE, DWORD, WORD);
extern DWORD  FAR PASCAL GlobalSize(HANDLE);
extern BOOL   FAR PASCAL GlobalUnlock(HANDLE);
extern BOOL   FAR PASCAL GlobalUnWire(HANDLE);
extern LPSTR  FAR PASCAL GlobalWire(HANDLE);
extern HANDLE FAR PASCAL LocalAlloc(WORD, WORD);
extern WORD   FAR PASCAL LocalCompact(WORD);
extern HANDLE FAR PASCAL LocalDiscard(HANDLE);
extern WORD   FAR PASCAL LocalFlags(HANDLE);
extern HANDLE FAR PASCAL LocalFree(HANDLE);
extern HANDLE FAR PASCAL LocalHandle(WORD);
extern PSTR   FAR PASCAL LocalLock(HANDLE);
extern HANDLE FAR PASCAL LocalReAlloc(HANDLE, WORD, WORD);
extern WORD   FAR PASCAL LocalSize(HANDLE);
extern BOOL   FAR PASCAL LocalUnlock(HANDLE);
extern DWORD  FAR PASCAL GetFreeSpace(UINT);

/*
  WACTIVE.C
*/
extern HWND   FAR PASCAL GetActiveWindow(void);
extern HWND   FAR PASCAL SetActiveWindow(HWND);

/*
  WADJUST.C
*/
extern VOID   FAR PASCAL AdjustWindowRect(LPRECT, DWORD, BOOL);
extern VOID   FAR PASCAL AdjustWindowRectEx(LPRECT, DWORD, BOOL, DWORD);

/*
  WINANSI.C
*/
VOID    WINAPI AnsiToOem(CONST char HUGEDATA *, char HUGEDATA *);
VOID    WINAPI OemToAnsi(CONST char HUGEDATA *, char HUGEDATA *);

VOID    WINAPI AnsiToOemBuff(LPCSTR, LPSTR, UINT);
VOID    WINAPI OemToAnsiBuff(LPCSTR, LPSTR, UINT);
LPSTR   WINAPI AnsiNext(LPCSTR);
LPSTR   WINAPI AnsiPrev(LPCSTR, LPCSTR);
LPSTR   WINAPI AnsiUpper(LPSTR);
LPSTR   WINAPI AnsiLower(LPSTR);
UINT    WINAPI AnsiUpperBuff(LPSTR, UINT);
UINT    WINAPI AnsiLowerBuff(LPSTR, UINT);

/*
  WANYPOP.C
*/
extern BOOL   FAR PASCAL AnyPopup(void);
extern HWND   FAR PASCAL GetLastActivePopup(HWND);

/*
  WINCATCH.C
*/
#if !defined(AFX)
extern INT    FAR PASCAL Catch(LPCATCHBUF);
extern VOID   FAR PASCAL Throw(LPCATCHBUF, INT);
#endif

/*
  WENUMOBJ.C
*/
#ifdef STRICT
typedef (CALLBACK* GOBJENUMPROC)(void FAR*, LPARAM);
int     WINAPI EnumObjects(HDC, int, GOBJENUMPROC, LPARAM);
#else
typedef FARPROC GOBJENUMPROC;
int     WINAPI EnumObjects(HDC, int, GOBJENUMPROC, LPSTR);
#endif

/*
  WISCHAR.C
*/
extern BOOL   FAR PASCAL IsCharAlpha(WORD);
extern BOOL   FAR PASCAL IsCharAlphaNumeric(WORD);
extern BOOL   FAR PASCAL IsCharLower(WORD);
extern BOOL   FAR PASCAL IsCharUpper(WORD);

/*
  WINCARET.C
*/
extern VOID   FAR PASCAL CreateCaret(HWND, HBITMAP, INT, INT);
extern VOID   FAR PASCAL DestroyCaret(void);
extern VOID   FAR PASCAL HideCaret(HWND);
extern VOID   FAR PASCAL ShowCaret(HWND);
extern VOID   FAR PASCAL GetCaretPos(LPPOINT);
extern VOID   FAR PASCAL SetCaretPos(INT, INT);
extern WORD   FAR PASCAL GetCaretBlinkTime(void);
extern VOID   FAR PASCAL SetCaretBlinkTime(WORD);

/*
  WGDICLIP.C
*/
extern INT    FAR PASCAL ExcludeClipRect(HDC, INT, INT, INT, INT);
extern INT    FAR PASCAL IntersectClipRect(HDC, INT, INT, INT, INT);
extern INT    FAR PASCAL OffsetClipRect(HDC, INT, INT);
extern INT    FAR PASCAL OffsetClipRgn(HDC, INT, INT);
extern BOOL   FAR PASCAL PtVisible(HDC, INT, INT);
extern BOOL   FAR PASCAL RectVisible(HDC, CONST RECT FAR *);

/*
  WINDOS.C
*/
extern LPSTR  FAR PASCAL GetDOSEnvironment(void);
extern DWORD  FAR PASCAL GlobalDosAlloc(DWORD);
extern WORD   FAR PASCAL GlobalDosFree(WORD);

/*
  WINKBD.C
*/
extern BOOL FAR PASCAL EnableHardwareInput(BOOL);

/*
  WINVID.C
*/
extern INT   FAR PASCAL ToggleEGA(void);
extern INT   FAR PASCAL IsEGA(void);
extern INT   FAR PASCAL IsVGA(void);
extern INT   FAR PASCAL VidGetMode(void);
extern INT   FAR PASCAL VidGetCurrVideoMode(void);
extern VOID  FAR PASCAL VidSetVideoMode(int);
extern BOOL  FAR PASCAL VidSetBlinking(BOOL);

/*
  WINEVENT.C
*/
extern BOOL  FAR PASCAL GetInputState(void);

/*
  WINFLASH.C
*/
extern BOOL FAR PASCAL FlashWindow(HWND, BOOL);

/*
  WEXITWIN.C
*/
extern BOOL FAR PASCAL ExitWindows(DWORD, WORD);

/*
  WMENUHI.C
*/
extern BOOL FAR PASCAL HiliteMenuItem(HWND, HMENU, UINT, UINT);

/*
  WSCROLDC.C
*/
extern BOOL   FAR PASCAL ScrollDC(HDC,INT,INT,CONST RECT FAR *,CONST RECT FAR *,HRGN,RECT FAR *);

/*
  WINDEFER.C
*/
DECLARE_HANDLE(HDWP);
HDWP    WINAPI BeginDeferWindowPos(int);
HDWP    WINAPI DeferWindowPos(HDWP, HWND, HWND, int, int, int, int, UINT);
BOOL    WINAPI EndDeferWindowPos(HDWP);

/*
  WINDEBUG.C
*/
extern VOID FAR PASCAL OutputDebugString(LPCSTR);

/*
  WSAVEDC.C
*/
extern BOOL   FAR PASCAL RestoreDC(HDC, INT);
extern INT    FAR PASCAL SaveDC(HDC);

/*
  WSPRINTF.C
  Note : These defs differ from the Windows defs, but we do not have
    anything like a _farsprintf function in the C run-time libraries.
*/
#if (MODEL_NAME == MODEL_LARGE)
int FAR CDECL wsprintf(LPSTR lpszOut, LPCSTR lpszFmt, ...);
#else
int FAR CDECL wsprintf(PSTR, PCSTR, ...);
#endif
#if (MODEL_NAME == MODEL_MEDIUM)
#define wvsprintf  vsprintf
#else
int WINAPI wvsprintf(LPSTR lpszOut, LPCSTR lpszFmt, CONST void FAR* lpParams);
#endif

/****************************************************************************/
/*                                                                          */
/* The following Windows functions are not implemented in MEWEL and         */
/* most are dummied out.                                                    */
/*                                                                          */
/****************************************************************************/
extern HWND   _HwndDesktop;

#ifdef __cplusplus
#if defined(MEWEL_GUI)
int   FAR PASCAL AddFontResource(LPCSTR lpFileName);
#else
inline int FAR PASCAL AddFontResource(LPCSTR lpFileName)
  { return 1; }
#endif

inline HMETAFILE WINAPI CloseMetaFile(HDC hDC)
  { return NULL;  }
inline HBRUSH FAR PASCAL CreateDIBPatternBrush(HANDLE hbm,UINT iClr)
  { (void) iClr;   return CreatePatternBrush(hbm); }
inline HBITMAP FAR PASCAL CreateDiscardableBitmap(HDC hDC, int cx, int cy)
  { return CreateCompatibleBitmap(hDC, cx, cy); }
inline HDC       WINAPI CreateMetaFile(LPCSTR lpFileName)
  { return NULL;  }
inline BOOL      WINAPI PlayMetaFile(HDC hDC, HMETAFILE hMF)
  { return FALSE; }

#ifndef MEWEL_GUI
inline BOOL FAR PASCAL DestroyIcon(HICON hIcon)
  {  return TRUE; }
#endif
#ifndef MEWEL_GUI
inline VOID FAR PASCAL DrawFocusRect(HDC hDC, LPRECT lpRect)
  { } 
#endif
inline VOID FAR PASCAL FatalAppExit(INT nCode, LPSTR s)
{
  extern VOID CDECL exit(int);
  MessageBox(HWND_DESKTOP, s, NULL, 0x30);
  exit(nCode);
}
inline VOID FAR PASCAL FreeProcInstance(FARPROC lpfn)
  { } 
inline DWORD FAR PASCAL GetAspectRatioFilter(HDC hDC)
  { (void) hDC;  return MAKELONG(1,1); }
inline int  FAR PASCAL GetAsyncKeyState(int nKey)
  { return 0; }
inline DWORD FAR PASCAL GetBitmapDimension(HBITMAP hbm)
  { return 0L; }
inline DWORD FAR PASCAL GetBrushOrg(HDC hDC)
  { return 0L; }
inline HANDLE FAR PASCAL GetCurrentTask(void)
  { return 0; }
inline HWND FAR PASCAL GetDesktopHwnd(void)
  { return _HwndDesktop; }
inline HWND FAR PASCAL GetDesktopWindow(void)
  { return _HwndDesktop; }
inline LONG FAR PASCAL GetDialogBaseUnits(void)
#ifdef MEWEL_GUI
  { return MAKELONG(8, 16); }
#else
  { return MAKELONG(4, 8); }
#endif
inline INT  FAR PASCAL GetDlgCtrlID(HWND hWnd) 
  { return (int) GetWindowWord(hWnd, GWW_ID); }
inline VOID FAR PASCAL GetInstanceData(HINSTANCE hInst, LPSTR pV, int len)
  { lmemset(pV, 0, len); }

inline LONG FAR PASCAL GetMenuCheckMarkDimensions(void)
#ifdef MEWEL_GUI
  { return MAKELONG(8, 8); }
#else
  { return MAKELONG(1, 1); }
#endif

inline HANDLE FAR PASCAL GetModuleHandle(LPCSTR lpModule)
  { (void) lpModule;  return 0; }
inline int FAR PASCAL GetModuleUsage(HANDLE h)
  { return 0; }
inline WORD FAR PASCAL GetNumTasks(VOID)
  { return 1; }
inline DWORD FAR PASCAL GetTickCount(void)
  { return BIOSGetTime(); }
inline WORD FAR PASCAL GetVersion(void)
  { return MEWEL_VERSION; }
inline DWORD FAR PASCAL GetWinFlags(void)
  { return 0L; }
inline WORD FAR PASCAL GetWindowsDirectory(LPSTR buf, int n)
  { return GetSystemDirectory(buf, n); }

#ifndef DDE_SHMEM
inline ATOM FAR PASCAL GlobalAddAtom(LPCSTR s)
  { return AddAtom(s); }
inline ATOM FAR PASCAL GlobalDeleteAtom(ATOM a)
  { return DeleteAtom(a); }
inline ATOM FAR PASCAL GlobalFindAtom(LPSTR s)
  { return FindAtom(s); }
inline WORD FAR PASCAL GlobalGetAtomName(ATOM a, LPSTR s, int n)
  { return GetAtomName(a, s, n); }
#endif /* DDE_SHMEM */

#ifdef MEWEL_TEXT
inline HCURSOR  FAR PASCAL LoadCursor(HANDLE h, LPCSTR lpsz)
  { return 0; } 
#endif
inline HANDLE  FAR PASCAL LoadModule(LPSTR lpsz, LPVOID lpv)
  { return 0; }
inline BOOL FAR PASCAL LocalInit(UINT uSegment, UINT uStartAddr, UINT uEndAddr)
  { return 0; }
inline HGLOBAL FAR PASCAL LockData(UINT seg)
  { return (HGLOBAL) seg; }
inline FARPROC FAR PASCAL MakeProcInstance(FARPROC pfn, HANDLE hInst)
  { return (FARPROC) pfn; }
inline INT  FAR PASCAL MulDiv(int nNum, int nNumer, int nDenom)
  { return (nDenom == 0) ? 0xFFFF : (int) (((long) nNum * nNumer) / nDenom); }
inline BOOL FAR PASCAL PostAppMessage(HANDLE hTask,WORD wMsg,WORD wParam,WORD lParam)
  { return PostMessage(_HwndDesktop, wMsg, wParam, lParam); }
#if defined(MEWEL_GUI)
extern BOOL FAR PASCAL RemoveFontResource(LPCSTR);
#else
inline BOOL FAR PASCAL RemoveFontResource(LPCSTR lpszFont)
  { return TRUE; }
#endif
inline VOID FAR PASCAL ReplyMessage(LONG lRet)
  { }
inline DWORD FAR PASCAL SetBitmapDimension(HBITMAP hbm, int cx, int cy)
  { return 0L; }
inline DWORD FAR PASCAL SetBrushOrg(HDC hBrush, int x, int y)
  { return 0L; }
inline BOOL  FAR PASCAL SetMenuItemBitmaps(HMENU hMenu, UINT idItem, UINT wFlags, HBITMAP hbmUnchecked, HBITMAP hbmChecked)
  { return 0L; }
inline BOOL  FAR PASCAL SetMessageQueue(int n)
  { return TRUE; }
inline VOID FAR PASCAL ShowOwnedPopups(HWND hWnd, BOOL bShow)
  { }
inline VOID FAR PASCAL UnlockData(UINT seg)
  { }
inline VOID FAR PASCAL Yield(void)
  { }

#else

#define CloseMetaFile(hDC)           (0)
#define CreateDIBPatternBrush(hbm,iClr)     CreatePatternBrush(hbm)
#define CreateDiscardableBitmap(hDC,cx,cy)  CreateCompatibleBitmap(hDC,cx,cy)
#define CreateMetaFile(lpFileName)   (0)
#ifndef MEWEL_GUI
#define DestroyIcon(hIcon)           (TRUE)
#define DrawFocusRect(hDC,lpRect)
#endif
#define FatalAppExit(nCode, s)       MessageBox(HWND_DESKTOP, s, NULL, MB_OK|MB_ICONEXCLAMATION), exit(nCode)
#define FreeProcInstance(lpfn)
#define GetAspectRatioFilter(hDC)    MAKELONG(1,1)
#define GetAsyncKeyState(nKey)       (0)
#define GetBitmapDimension(hbm)      (0L)
#define GetBrushOrg(hDC)             (0L)
#define _GetClientRect(hWnd,r)       (*(r) = WinGetClient(hWnd))
#define GetCurrentTask()             (0)
#define GetDesktopHwnd()             (_HwndDesktop)
#define GetDesktopWindow()           (_HwndDesktop)
#ifdef MEWEL_GUI
#define GetDialogBaseUnits()         (MAKELONG(8, 16))
#else
#define GetDialogBaseUnits()         (MAKELONG(4, 8))
#endif
#define GetDlgCtrlID(hWnd)           ((int) GetWindowWord(hWnd, GWW_ID))
#define GetInstanceData(hInst,pV,len) (lmemset((LPSTR) (pV), 0, (len)))
#ifdef MEWEL_GUI
#define GetMenuCheckMarkDimensions() (MAKELONG(8, 8))
#else
#define GetMenuCheckMarkDimensions() (MAKELONG(1, 1))
#endif
#define GetModuleHandle(lpModule)    (0)
#define GetNumTasks()                (1)
#define GetTickCount                 GetCurrentTime
#define GetVersion()                 (MEWEL_VERSION)
#define GetWinFlags()                (0L)
#define GetWindowsDirectory(buf,n)   GetSystemDirectory(buf,n)
#ifndef DDE_SHMEM
#define GlobalAddAtom                AddAtom
#define GlobalDeleteAtom             DeleteAtom
#define GlobalFindAtom               FindAtom
#define GlobalGetAtomName            GetAtomName
#endif
#ifdef MEWEL_TEXT
#define LoadCursor(hCursor, psz)     (0)
#endif
#define LocalInit(seg, start, end)   (0)
#define LockData(seg)                (seg)
#define MakeProcInstance(pfn, hInst) (FARPROC)(pfn)
#define MulDiv(nNum,nNumer,nDenom) \
  (((nDenom) == 0) ? 0xFFFF : (int) (((long) (nNum) * (nNumer)) / (nDenom)))
#define PlayMetaFile(hDC, hMF)       (0)
#define PostAppMessage(hT,msg,w,l)   PostMessage(_HwndDesktop,msg,w,l)
#define ReplyMessage(lRet)           (lRet)
#define SetBitmapDimension(hbm,cx,cy) (0L)
#define SetBrushOrg(hDC,x,y)         (0L)
#define SetMenuItemBitmaps(hMenu,idItem,wFlags,hbmUnchecked,hbmChecked)  (0)
#define SetMessageQueue(n)           (TRUE)
#define ShowOwnedPopups(hWnd, bShow) 
#define UnlockData(seg)              (TRUE)
#define Yield()                      

#define CloseSound()
#define OpenSound()                  (TRUE)
#define SetVoiceSound(nVoice, n1, n2)  SoundTone(32000/LOWORD(n1), n2, 5)
#define SetVoiceNote(nVoice, n1, n2, n3)        (TRUE)
#define SetVoiceAccent(nVoice, n1, n2, n3, n4)  (TRUE)
#define StartSound()
#define WaitSoundState(n)            (TRUE)
#endif

#ifdef MEWEL_GUI
int     FAR PASCAL AddFontResource(LPCSTR);
HCURSOR FAR PASCAL LoadCursor(HINSTANCE, LPCSTR);
int     FAR PASCAL RemoveFontResource(LPCSTR);
HCURSOR FAR PASCAL CreateCursor(HINSTANCE, INT, INT, INT, INT, CONST VOID FAR *, CONST VOID FAR *);
BOOL    FAR PASCAL DestroyCursor(HCURSOR);
#else
#define AddFontResource(lpFileName)  (TRUE)
#define RemoveFontResource(lpszFont) (TRUE)
#define CreateCursor(hInst, xHot, yHot, nWidth, nHeight, lpAND, lpXOR)  (0)
#define DestroyCursor(hCursor)       (TRUE)
#endif


/*
  Palette Management stuff
*/
#if !defined(MEWEL_GUI) || !defined(USE_PALETTES)
#ifdef __cplusplus
inline VOID FAR PASCAL AnimatePalette(HPALETTE hPal, UINT i1, UINT i2, LPPALETTEENTRY lpPE)
  {           }
inline HPALETTE FAR PASCAL CreatePalette(LPLOGPALETTE lp)
  { return 0; }
inline UINT FAR PASCAL GetNearestPaletteIndex(HPALETTE hPal, DWORD rgb)
  { return 0; }
inline UINT FAR PASCAL GetPaletteEntries(HPALETTE hPal,UINT i1,UINT i2,LPPALETTEENTRY lppe)
  { return 0; } 
inline UINT FAR PASCAL GetSystemPaletteEntries(HDC hDC, UINT i1, UINT i2, LPPALETTEENTRY lpPE)
  { return 0; }
inline UINT FAR PASCAL GetSystemPaletteUse(HDC hDC)
  { return 0; }
inline UINT FAR PASCAL RealizePalette(HDC hDC)
  { return TRUE; }
inline BOOL FAR PASCAL ResizePalette(HPALETTE hPal, UINT uSize)
  { return 0; }
inline HPALETTE FAR PASCAL SelectPalette(HDC hDC, HPALETTE hP, BOOL bErase)
  { return 0; } 
inline UINT FAR PASCAL SetPaletteEntries(HPALETTE hPal,UINT i1,UINT i2,LPPALETTEENTRY lppe)
  { return 0; } 
inline UINT FAR PASCAL SetSystemPaletteUse(HDC hDC, WORD f)
  { return 0; }
inline int FAR PASCAL UpdateColors(HDC hDC)
  { return TRUE; }
#else
#define AnimatePalette(hPal, i1, i2, lpPal)
#define CreatePalette(lp)                       (0)
#define GetNearestPaletteIndex(hPal, rgb)       (0)
#define GetPaletteEntries(hPal, i1, i2, lpPal)  (0)
#define GetSystemPaletteEntries(hDC,i1,i2,lppe) (0)
#define GetSystemPaletteUse(hDC)                (0)
#define RealizePalette(hDC)                     (1)
#define ResizePalette(hPal, size)               (0)
#define SelectPalette(hDC,hP,bErase)            (0)
#define SetPaletteEntries(hPal, i1, i2, lpPal)  (0)
#define SetSystemPaletteUse(hDC, f)             (0)
#define UpdateColors(hDC)                       (1)
#endif

#else
VOID     FAR PASCAL AnimatePalette(HPALETTE, UINT, UINT, LPPALETTEENTRY);
HPALETTE FAR PASCAL CreatePalette(LPLOGPALETTE);
UINT     FAR PASCAL GetNearestPaletteIndex(HPALETTE, DWORD);
UINT     FAR PASCAL GetPaletteEntries(HPALETTE,UINT,UINT,LPPALETTEENTRY);
UINT     FAR PASCAL GetSystemPaletteEntries(HDC,UINT,UINT,LPPALETTEENTRY);
WORD     FAR PASCAL GetSystemPaletteUse(HDC);
WORD     FAR PASCAL RealizePalette(HDC);
BOOL     FAR PASCAL ResizePalette(HPALETTE, WORD);
HPALETTE FAR PASCAL SelectPalette(HDC, HPALETTE, BOOL);
UINT     FAR PASCAL SetPaletteEntries(HPALETTE,UINT,UINT,LPPALETTEENTRY);
WORD     FAR PASCAL SetSystemPaletteUse(HDC, WORD);
INT      FAR PASCAL UpdateColors(HDC);
#endif

int   FAR PASCAL GetStretchBltMode(HDC);

DWORD FAR PASCAL ScaleViewportExt(HDC, int, int, int, int);
DWORD FAR PASCAL ScaleWindowExt(HDC, int, int, int, int);

HWND  FAR PASCAL GetSysModalWindow(void);
HWND  FAR PASCAL SetSysModalWindow(HWND);

int   FAR PASCAL SetTextJustification(HDC, int, int);
DWORD FAR PASCAL GetTabbedTextExtent(HDC, LPCSTR, int, int, LPINT);
int   FAR PASCAL SetTextCharacterExtra(HDC, int);
int   FAR PASCAL GetTextCharacterExtra(HDC);
LONG  FAR PASCAL TabbedTextOut(HDC, int, int, LPCSTR, int, int, LPINT, int);
BOOL  FAR PASCAL FloodFill( HDC, int, int, COLORREF);
BOOL  FAR PASCAL ExtFloodFill(HDC, int, int, COLORREF, UINT);
BOOL  FAR PASCAL PolyPolygon(HDC, CONST POINT FAR *, LPINT, int);


#if (defined(MOTIF) || defined(DECWINDOWS)) && !defined(_WPRIVATE_H)
#define DialogBox     _XDialogBox
#define CreateDialog  _XCreateDialog
#endif

#if defined(WZV) && (defined(UNIX) || defined(VAXC))
#define	lmemcpy		memcpy
#define	lmemset		memset
#define	lmemmove	memcpy
#define	lstrchr		strchr
#define	lstrcpy		strcpy
#define	lstrncpy	strncpy
#define	lstrcat		strcat
#define	lstrlen		strlen
#define	lstrcmp		strcmp
#define	lstricmp	stricmp
#define	stricmp		strcasecmp
#define	strnicmp	strncasecmp
#define	_lread		read
#define	_lwrite		write
#endif

/*
  WGUIPCX.C
*/
extern INT FAR PASCAL DrawPCXFile(HDC, char *, INT, INT);

/*
  For printer support
*/
void FAR PASCAL InstallPrinterSupport(void);
