;Video Interface Controller an Adresse D000

;Freie Register beim Lesen: AX,BX,DI
;           beim Schreiben: AX,DI

include pc64.inc

;Variablen und Funktionen aus anderen Modulen
data?
extrn c wAlgorithm:word
extrn c wLineDelay:word
extrn c wSpriteDelay:word
extrn Clock:word
extrn abCharBuf:byte
extrn abColorBuf:byte
extrn awVICEvents:word
extrn bScreenOn:byte
extrn Events:byte
extrn c fLocalBus:word
extrn c fWindowsNT:word
extrn c wRefresh:word                  ;Durchlufe
extrn c dClocksPerRefresh:dword
extrn c dTicksPerRefresh:dword
extrn c dRealTicksPerRefresh:dword
extrn c wLinesPerFrame:word
extrn c adPCTicks:dword
extrn c adC64Ticks:dword
extrn c wNewLine:word
extrn c awUpdate:word
extrn c abColor:byte                   ;Color Ram an Adresse D800
extrn VICBasePara:word                 ;Basis aus CIA1 in Paragraphen
extrn Frame32:dword
extrn Back32:dword
extrn Top_Bottom:dword
extrn VisibleTop:word
extrn VisibleBottom:word
extrn wYBlock:word
extrn wYOffset:word
extrn ScrollX:word
extrn IRQLine:word
extrn awSpriteX:word
extrn awSpriteYCount:word
extrn awSpriteYAdd:word
extrn VIC:byte
extrn RasterLine:word
extrn awError:word
extrn abSpritePtr:byte
code
IMP WriteIOTable,word                  ;Funktionen zum Schreiben in Register
IMP UpdateSID,near                     ;Nchster Baustein in der Kette
IMP Stop,near                          ;Schwerer Fehler aufgetreten
extrn c halloc:far                     ;Speicher reservieren
extrn c hfree:far                      ;Speicher freigeben
RAM segment para public use16 'BSS'
RAM ends
CHAR segment para public use16 'BSS'
CHAR ends

ifdef DEBUG

const
extrn SpriteXTab:word
extrn c VGAColors:byte
data
extrn c wRunDebug:word
extrn fnContinue:word
extrn wParam:word
data?
extrn wSpriteSub:word
extrn wSave25SI:word
extrn wSave25BP:word
extrn bHasDelayed:byte
extrn adDelay:dword
extrn adLast:dword
extrn CachePtr:dword
extrn Line:byte
extrn Collision:word
extrn Color:byte
extrn CacheSeg:word
extrn TextSeg:word
extrn GraphicSeg:word
extrn CharSeg:word
extrn BuildLine:word
extrn afnSprite:word
extrn wLineCompare:word
extrn bFrameColor:byte
extrn wRefreshCounter:word
code
extrn DumpText:far

else

;Lokale Variablen
data? 4
adDelay dd ?,?                          ;Echtzeit parallel zum PC-Timer
  public adDelay
adLast dd ?,?                           ;PC-Zeit des letzten Refreshs
  public adLast
CachePtr dd ?                           ;Verdoppelt Ausfhrungsgeschwindigkeit
  public CachePtr
Line db 432 dup (?)                     ;Puffer zum Zeilenaufbau
  public Line
Collision dw 432 dup (?)                ;Gesetzte Pixel fr Spritekollision
  public Collision
Color db 4 dup (?)                      ;4 mgliche Farben einer Pixelgruppe
  public Color
CacheSeg dw ?                           ;Adresse des Bildschirm-Caches
  public CacheSeg
TextSeg dw ?                            ;Adresse des Textbildschirms
  public TextSeg
GraphicSeg dw ?                         ;Adresse des Grafikbildschirms
  public GraphicSeg
CharSeg dw ?                            ;Adresse des Zeichensatzes
  public CharSeg
wSpriteSub dw ?                         ;3 Zyklen falls ein Sprite an ist
  public wSpriteSub
BuildLine dw ?                          ;Funktion zum Aufbau der Rasterzeile
  public BuildLine
afnSprite dw 8 dup (?)                  ;Eine von 8 Darstellungsfunktionen
  public afnSprite
wLineCompare dw ?                       ;Vergleichswert fr Register 12h
  public wLineCompare
wRefreshCounter dw ?                    ;Zhler Leerdurchlufe (0..wRefresh-1)
  public wRefreshCounter
wSave25SI dw ?                          ;Erkennung VIC[25] lesen und schreiben
  public wSave25SI
wSave25BP dw ?
  public wSave25BP
bFrameColor db ?                        ;Randfarbe letzter Bilddurchlauf
  public bFrameColor
bHasDelayed db ?                        ;In diesem Zyklus verzgert?
  public bHasDelayed

;X-Positionen und Funktionsadressen fr die Sprites
const 2
SpriteXTab label word
  public SpriteXTab
  i=0
  rept 24+320+8
    dw 56-24+i
    i=i+1
  endm
  dw 120 dup (-1)
  i=0
  rept 8+24
    dw i
    i=i+1
  endm
  dw 8 dup (-1)

;Farben im VGA-Format als RGB-Werte von 0 bis 63
const 1
VGAColors label byte
  public c VGAColors
if 0
  ;PC64
  db 00h,00h,00h ;Black
  db 3Fh,3Fh,3Fh ;White
  db 2Eh,00h,05h ;Red
  db 00h,30h,2Bh ;Cyan
  db 25h,00h,26h ;Purple
  db 09h,33h,00h ;Green
  db 01h,04h,2Ch ;Blue
  db 3Fh,3Fh,00h ;Yellow
  db 26h,15h,00h ;Orange
  db 14h,08h,05h ;Brown
  db 3Fh,14h,1Eh ;Lt.Red
  db 12h,12h,12h ;Dk.Grey
  db 1Ch,1Ch,1Ch ;Grey
  db 17h,3Fh,15h ;Lt.Green
  db 15h,1Ch,3Ah ;Lt.Blue
  db 2Bh,2Bh,2Bh ;Lt.Grey
else
  ;C64S
  db 08h,08h,08h ;Black
  db 3Fh,3Fh,3Fh ;White
  db 2Dh,08h,08h ;Red
  db 1Ch,3Fh,3Fh ;Cyan
  db 2Dh,08h,2Dh ;Purple
  db 08h,2Dh,08h ;Green
  db 08h,08h,2Dh ;Blue
  db 3Fh,3Fh,08h ;Yellow
  db 2Dh,1Ch,08h ;Orange
  db 24h,11h,08h ;Brown
  db 3Fh,1Ch,1Ch ;Lt.Red
  db 1Ch,1Ch,1Ch ;Dk.Grey
  db 24h,24h,24h ;Grey
  db 1Ch,3Fh,1Ch ;Lt.Green
  db 1Ch,1Ch,3Fh ;Lt.Blue
  db 2Dh,2Dh,2Dh ;Lt.Grey
endif

;------------------------------------------------------------------------------

;Videocontroller zurcksetzen
code 1
ResetVIC proc near
  public ResetVIC
  xor BP,BP
@@Next:
  mov CX,offset @@Continue              ;Rcksprungadresse
  xor AL,AL                             ;Register auf 0 setzen
  jmp WriteIOTable[0000h+EBP*2]
@@Continue:
  inc BP
  cmp BP,47
  jb @@Next
  mov DI,8*2-2
@@ResetSprites:
  mov awSpriteYCount[DI],21*2           ;Keine Sprites werden angezeigt
  mov awSpriteYAdd[DI],2                ;Einfache Hhe
  sub DI,2
  jns @@ResetSprites
  ret
ResetVIC endp

endif

;------------------------------------------------------------------------------

;Funktionsadressen fr den Zeilenaufbau
const 2
afnBuildLine label word
  dw SingleText,SingleGraphic,ExtendedText,BlackScreen
  dw MultiText,MultiGraphic,BlackScreen,BlackScreen

;Funktionsadressen fr die Sprite-Darstellung
const 2
SpriteFuncTab label word
  dw SpriteMF2,SpriteMF1,SpriteSF2,SpriteSF1
  dw SpriteMH2,SpriteMH1,SpriteSH2,SpriteSH1

;------------------------------------------------------------------------------

;Emulator einschalten
code 1
EXP StartVIC,near
StartVIC proc near
  cmp fLocalBus,0
  jne @@LocalBus
  push 1                                ;Puffer fr Bildschirmcache holen
  pushd 64016
  call halloc
  add SP,6
  mov word ptr CachePtr[0],AX
  mov word ptr CachePtr[2],DX
  add AX,15
  shr AX,4
  add AX,DX
  mov CacheSeg,AX
  je @@NoMemory
  mov ES,AX                             ;Cache mit schwarzer Farbe fllen
  xor DI,DI
  mov CX,64000/4
  xor EAX,EAX
  rep stosd
@@LocalBus:
  mov AX,1012h                          ;Emulierte Farben setzen
  xor BX,BX
  mov CX,16
  mov DX,offset DGROUP:VGAColors
  push DS
  pop ES
  int 10h
  mov bFrameColor,0                     ;Cache fr Rahmenfarbe berichtigen
  mov wRefreshCounter,-1                ;Zhler fr Leerdurchlufe auf Dummy
  mov AX,awUpdate[0]                    ;Vergleichswert fr VIC Register 12h
  mul wNewLine
  mov BX,100
  div BX
  mov wLineCompare,AX
  mov wSave25SI,0
  mov wSave25BP,0
  mov CX,offset @@Cont1                 ;Basisadressen setzen
  jmp BaseChanged
@@Cont1:
  mov CX,offset @@Cont2                 ;Funktion BuildLine setzen
  jmp ModeChanged
@@Cont2:
  pop CX
  jmp SetSpriteFunc                     ;Funktion afnSprite setzen
@@NoMemory:
  if GERMAN
    ERROR "Es ist nicht genug freier DOS-Speicher vorhanden!"
  else
    ERROR "There is not enough DOS memory available!"
  endif
StartVIC endp

;Emulator auschalten
code 1
EXP StopVIC,near
StopVIC proc near
  cmp fLocalBus,0
  jne @@LocalBus
  push CachePtr                         ;Speicher fr Cache freigeben
  call hfree
  add SP,4
@@LocalBus:
  ret
StopVIC endp

;------------------------------------------------------------------------------

;Aktuelle Basisadressen von Bildschirm und Zeichensatz bzw. Grafik anzeigen
ifdef DEBUG
code 1
ShowVICConfig proc near
  public ShowVICConfig
  push AX
  TBEG VIC
    mov DI,TextSeg
    sub DI,RAM
    shl DI,4
    mov AL,VIC[17]
    mov AH,VIC[22]
    and AX,0001000001100000b
    je @@SingleText
    cmp AX,0001000000000000b
    je @@MultiText
    cmp AX,0000000001000000b
    je @@ExtendedText
    mov CX,GraphicSeg
    sub CX,RAM
    shl CX,4
    cmp AX,0000000000100000b
    je @@SingleGraphic
    cmp AX,0001000000100000b
    je @@MultiGraphic
    if GERMAN
      INFO2 "Bildschirm ist dunkelgeschaltet"
    else
      INFO2 "The screen has been switched black"
    endif
    ret
  @@SingleText:
    if GERMAN
      INFO2 "Standard Textmodus mit Bildschirm an Adresse %04X",<DI>
    else
      INFO2 "Standard text mode with character memory at %04X",<DI>
    endif
    jmp @@ShowChar
  @@MultiText:
    if GERMAN
      INFO2 "Multicolor Textmodus mit Bildschirm an Adresse %04X",<DI>
    else
      INFO2 "Multicolor text mode with character memory at %04X",<DI>
    endif
    jmp @@ShowChar
  @@ExtendedText:
    if GERMAN
      INFO2 "Erweiterter Textmodus mit Bildschirm an Adresse %04X",<DI>
    else
      INFO2 "Enhanced color text mode with character memory at %04X",<DI>
    endif
  @@ShowChar:
    mov DI,CharSeg
    cmp DI,CHAR
    je @@ROMUpper
    cmp DI,CHAR+2048/16
    je @@ROMLower
    sub DI,RAM
    shl DI,4
    if GERMAN
      INFO2 "Benutzerdefinierter Zeichensatz an Adresse %04X",<DI>
    else
      INFO2 "User defined character set at %04X",<DI>
    endif
    ret
  @@ROMUpper:
    if GERMAN
      INFO2 "Zeichensatz im ROM (Groschreibung)"
    else
      INFO2 "ROM character set (upper case letters)"
    endif
    ret
  @@ROMLower:
    if GERMAN
      INFO2 "Zeichensatz im ROM (Kleinschreibung)"
    else
      INFO2 "ROM character set (lower case letters)"
    endif
    ret
  @@SingleGraphic:
    if GERMAN
      INFO2 "Standard Grafik bei %04X, Farben an Adresse %04X",<CX,DI>
    else
      INFO2 "Standard graphics screen at %04X, color memory at %04X",<CX,DI>
    endif
    ret
  @@MultiGraphic:
    if GERMAN
      INFO2 "Multicolor Grafik bei %04X, Farben 1 und 2 an Adresse %04X",<CX,DI>
    else
      INFO2 "Multicolor graphics screen at %04X, colors 1 and 2 at %04X",<CX,DI>
    endif
  TEND
  pop AX
  ret
ShowVICConfig endp
endif

;------------------------------------------------------------------------------

;VIC Register 0
;  xxxxxxxx = X-Koordinate Sprite 0

code 4
EXP ReadVIC0,near
ReadVIC0 proc near
  mov AL,VIC[0]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 0 lesen (%04X)",<AX>
      else
        INFO "Read sprite 0 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC0 endp

code 4
EXP WriteVIC0,near
WriteVIC0 proc near
  mov VIC[0],AL
  mov AH,VIC[16]
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 0 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 0 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[0],AX
  jmp CX
WriteVIC0 endp

;------------------------------------------------------------------------------

;VIC Register 1
;  xxxxxxxx = Y-Koordinate Sprite 0

code 4
EXP ReadVIC1,near
ReadVIC1 proc near
  mov AL,VIC[1]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 0 lesen (%02X)",<AX>
      else
        INFO "Read sprite 0 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC1 endp

code 4
EXP WriteVIC1,near
WriteVIC1 proc near
  mov VIC[1],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 0 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 0 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC1 endp

;------------------------------------------------------------------------------

;VIC Register 2
;  xxxxxxxx = X-Koordinate Sprite 1

code 4
EXP ReadVIC2,near
ReadVIC2 proc near
  mov AL,VIC[2]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,1
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 1 lesen (%04X)",<AX>
      else
        INFO "Read sprite 1 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC2 endp

code 4
EXP WriteVIC2,near
WriteVIC2 proc near
  mov VIC[2],AL
  mov AH,VIC[16]
  shr AH,1
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 1 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 1 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[2],AX
  jmp CX
WriteVIC2 endp

;------------------------------------------------------------------------------

;VIC Register 3
;  xxxxxxxx = Y-Koordinate Sprite 1

code 4
EXP ReadVIC3,near
ReadVIC3 proc near
  mov AL,VIC[3]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 1 lesen (%02X)",<AX>
      else
        INFO "Read sprite 1 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC3 endp

code 4
EXP WriteVIC3,near
WriteVIC3 proc near
  mov VIC[3],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 1 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 1 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC3 endp

;------------------------------------------------------------------------------

;VIC Register 4
;  xxxxxxxx = X-Koordinate Sprite 2

code 4
EXP ReadVIC4,near
ReadVIC4 proc near
  mov AL,VIC[4]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,2
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 2 lesen (%04X)",<AX>
      else
        INFO "Read sprite 2 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC4 endp

code 4
EXP WriteVIC4,near
WriteVIC4 proc near
  mov VIC[4],AL
  mov AH,VIC[16]
  shr AH,2
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 2 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 2 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[4],AX
  jmp CX
WriteVIC4 endp

;------------------------------------------------------------------------------

;VIC Register 5
;  xxxxxxxx = Y-Koordinate Sprite 2

code 4
EXP ReadVIC5,near
ReadVIC5 proc near
  mov AL,VIC[5]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 2 lesen (%02X)",<AX>
      else
        INFO "Read sprite 2 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC5 endp

code 4
EXP WriteVIC5,near
WriteVIC5 proc near
  mov VIC[5],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 2 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 2 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC5 endp

;------------------------------------------------------------------------------

;VIC Register 6
;  xxxxxxxx = X-Koordinate Sprite 3

code 4
EXP ReadVIC6,near
ReadVIC6 proc near
  mov AL,VIC[6]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,3
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 3 lesen (%04X)",<AX>
      else
        INFO "Read sprite 3 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC6 endp

code 4
EXP WriteVIC6,near
WriteVIC6 proc near
  mov VIC[6],AL
  mov AH,VIC[16]
  shr AH,3
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 3 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 3 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[6],AX
  jmp CX
WriteVIC6 endp

;------------------------------------------------------------------------------

;VIC Register 7
;  xxxxxxxx = Y-Koordinate Sprite 3

code 4
EXP ReadVIC7,near
ReadVIC7 proc near
  mov AL,VIC[7]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 3 lesen (%02X)",<AX>
      else
        INFO "Read sprite 3 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC7 endp

code 4
EXP WriteVIC7,near
WriteVIC7 proc near
  mov VIC[7],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 3 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 3 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC7 endp

;------------------------------------------------------------------------------

;VIC Register 8
;  xxxxxxxx = X-Koordinate Sprite 4

code 4
EXP ReadVIC8,near
ReadVIC8 proc near
  mov AL,VIC[8]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,4
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 4 lesen (%04X)",<AX>
      else
        INFO "Read sprite 4 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC8 endp

code 4
EXP WriteVIC8,near
WriteVIC8 proc near
  mov VIC[8],AL
  mov AH,VIC[16]
  shr AH,4
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 4 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 4 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[8],AX
  jmp CX
WriteVIC8 endp

;------------------------------------------------------------------------------

;VIC Register 9
;  xxxxxxxx = Y-Koordinate Sprite 4

code 4
EXP ReadVIC9,near
ReadVIC9 proc near
  mov AL,VIC[9]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 4 lesen (%02X)",<AX>
      else
        INFO "Read sprite 4 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC9 endp

code 4
EXP WriteVIC9,near
WriteVIC9 proc near
  mov VIC[9],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 4 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 4 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC9 endp

;------------------------------------------------------------------------------

;VIC Register 10
;  xxxxxxxx = X-Koordinate Sprite 5

code 4
EXP ReadVIC10,near
ReadVIC10 proc near
  mov AL,VIC[10]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,5
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 5 lesen (%04X)",<AX>
      else
        INFO "Read sprite 5 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC10 endp

code 4
EXP WriteVIC10,near
WriteVIC10 proc near
  mov VIC[10],AL
  mov AH,VIC[16]
  shr AH,5
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 5 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 5 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[10],AX
  jmp CX
WriteVIC10 endp

;------------------------------------------------------------------------------

;VIC Register 11
;  xxxxxxxx = Y-Koordinate Sprite 5

code 4
EXP ReadVIC11,near
ReadVIC11 proc near
  mov AL,VIC[11]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 5 lesen (%02X)",<AX>
      else
        INFO "Read sprite 5 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC11 endp

code 4
EXP WriteVIC11,near
WriteVIC11 proc near
  mov VIC[11],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 5 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 5 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC11 endp

;------------------------------------------------------------------------------

;VIC Register 12
;  xxxxxxxx = X-Koordinate Sprite 6

code 4
EXP ReadVIC12,near
ReadVIC12 proc near
  mov AL,VIC[12]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,6
      and AH,00000001b
      if GERMAN
        INFO "X-Position Sprite 6 lesen (%04X)",<AX>
      else
        INFO "Read sprite 6 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC12 endp

code 4
EXP WriteVIC12,near
WriteVIC12 proc near
  mov VIC[12],AL
  mov AH,VIC[16]
  shr AH,6
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 6 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 6 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[12],AX
  jmp CX
WriteVIC12 endp

;------------------------------------------------------------------------------

;VIC Register 13
;  xxxxxxxx = Y-Koordinate Sprite 6

code 4
EXP ReadVIC13,near
ReadVIC13 proc near
  mov AL,VIC[13]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 6 lesen (%02X)",<AX>
      else
        INFO "Read sprite 6 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC13 endp

code 4
EXP WriteVIC13,near
WriteVIC13 proc near
  mov VIC[13],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 6 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 6 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC13 endp

;------------------------------------------------------------------------------

;VIC Register 14
;  xxxxxxxx = X-Koordinate Sprite 7

code 4
EXP ReadVIC14,near
ReadVIC14 proc near
  mov AL,VIC[14]
  ifdef DEBUG
    TBEG VIC
      mov AH,VIC[16]
      shr AH,7
      if GERMAN
        INFO "X-Position Sprite 7 lesen (%04X)",<AX>
      else
        INFO "Read sprite 7 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC14 endp

code 4
EXP WriteVIC14,near
WriteVIC14 proc near
  mov VIC[14],AL
  mov AH,VIC[16]
  shr AH,7
  and EAX,0000000111111111b
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "X-Position Sprite 7 schreiben (%04X)",<AX>
      else
        INFO "Write sprite 7 X-coordinate (%04X)",<AX>
      endif
    TEND
  endif
  mov AX,SpriteXTab[EAX*2]
  mov awSpriteX[14],AX
  jmp CX
WriteVIC14 endp

;------------------------------------------------------------------------------

;VIC Register 15
;  xxxxxxxx = Y-Koordinate Sprite 7

code 4
EXP ReadVIC15,near
ReadVIC15 proc near
  mov AL,VIC[15]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 7 lesen (%02X)",<AX>
      else
        INFO "Read sprite 7 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC15 endp

code 4
EXP WriteVIC15,near
WriteVIC15 proc near
  mov VIC[15],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Y-Position Sprite 7 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 7 Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC15 endp

;------------------------------------------------------------------------------

;VIC Register 16
;  -------x = Bit 8 der X-Koordinate von Sprite 0
;  ------x- = Bit 8 der X-Koordinate von Sprite 1
;  -----x-- = Bit 8 der X-Koordinate von Sprite 2
;  ----x--- = Bit 8 der X-Koordinate von Sprite 3
;  ---x---- = Bit 8 der X-Koordinate von Sprite 4
;  --x----- = Bit 8 der X-Koordinate von Sprite 5
;  -x------ = Bit 8 der X-Koordinate von Sprite 6
;  x------- = Bit 8 der X-Koordinate von Sprite 7

code 4
EXP ReadVIC16,near
ReadVIC16 proc near
  mov AL,VIC[16]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "bertrge der X-Positionen von Sprite 0-7 lesen (%02X)",<AX>
      else
        INFO "Read high bits of sprite X-coordinates (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC16 endp

code 4
EXP WriteVIC16,near
WriteVIC16 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "bertrge der X-Positionen von Sprite 0-7 schreiben (%02X)",<AX>
      else
        INFO "Write high bits of sprite X-coordinates (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[16],AL
  i=0
  rept 8
    shrd BX,AX,8+i
    and BH,00000001b
    mov BL,VIC[i*2]
    mov BX,SpriteXTab[EBX*2]
    mov awSpriteX[i*2],BX
    i=i+1
  endm
  jmp CX
WriteVIC16 endp

;------------------------------------------------------------------------------

;VIC Register 17
;  -----xxx = Bildverschiebung nach unten, Default 011b
;  ----0--- = 24-Zeilen-Modus fr Schiebeeffekte
;  ----1--- = 25-Zeilen-Modus
;  ---1---- = Bildschirm eingeschaltet
;  -00----- = Textmodus
;  -10----- = Extended Color Text
;  -x1----- = Grafikmodus
;  x------- = Bit 8 der aktuellen Rasterzeile (lesen)
;  x------- = Bit 8 der Rasterzeile fr IRQ (schreiben)

code 4
EXP ReadVIC17,near
ReadVIC17 proc near
  mov AL,byte ptr RasterLine+1          ;Bit 8 der Rasterzeile holen
  shl AL,7
  or AL,VIC[17]                         ;Mit restlichen Bits verknpfen
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Steuerregister 1 lesen (%02X)",<AX>
      else
        INFO "Read Control Register 1 (%02X)",<AX>
      endif
      mov DI,AX
      and DI,0000000000000111b
      sub DI,3
      if GERMAN
        INFO2 "Bit 0-2: Bildverschiebung %d Punkte in Y-Richtung",<DI>
      else
        INFO2 "Bits 0-2: Smooth Scroll to Y dot-position %d",<DI>
      endif
      test AL,00001000b
      jne @@Bit3
      if GERMAN
        INFO2 "Bit 3 = 0: 24 Zeilen Modus (fr vertikales Softscrolling)"
      else
        INFO2 "Bit 3 = 0: 24 lines mode (for smooth vertical scrolling)"
      endif
      jmp @@NoBit3
    @@Bit3:
      if GERMAN
        INFO2 "Bit 3 = 1: 25 Zeilen Modus"
      else
        INFO2 "Bit 3 = 1: 25 lines mode"
      endif
    @@NoBit3:
      test AL,00010000b
      jne @@Bit4
      if GERMAN
        INFO2 "Bit 4 = 0: Bildschirm aus"
      else
        INFO2 "Bit 4 = 0: Blank the screen"
      endif
      jmp @@NoBit4
    @@Bit4:
      if GERMAN
        INFO2 "Bit 4 = 1: Bildschirm ein"
      else
        INFO2 "Bit 4 = 1: Unblank the screen"
      endif
    @@NoBit4:
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 7: bertrag Zeile fr Rasterinterrupt (%04X)",<DI>
      else
        INFO2 "Bit 7: Raster register bit 8 (%04X)",<DI>
      endif
    TEND
  endif
  jmp CX
ReadVIC17 endp

code 4
EXP WriteVIC17,near
WriteVIC17 proc near
  shrd BX,AX,15                         ;Bit 8 der Rasterzeile fr IRQ
  and BH,0000001b
  mov byte ptr IRQLine+1,BH
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Steuerregister 1 schreiben (%02X)",<AX>
      else
        INFO "Write Control Register 1 (%02X)",<AX>
      endif
      mov DI,AX
      and DI,0000000000000111b
      sub DI,3
      if GERMAN
        INFO2 "Bit 0-2: Bildverschiebung %d Punkte in Y-Richtung",<DI>
      else
        INFO2 "Bits 0-2: Smooth Scroll to Y dot-position %d",<DI>
      endif
      test AL,00001000b
      jne @@Bit3
      if GERMAN
        INFO2 "Bit 3 = 0: 24 Zeilen Modus (fr vertikales Softscrolling)"
      else
        INFO2 "Bit 3 = 0: 24 lines mode (for smooth vertical scrolling)"
      endif
      jmp @@NoBit3
    @@Bit3:
      if GERMAN
        INFO2 "Bit 3 = 1: 25 Zeilen Modus"
      else
        INFO2 "Bit 3 = 1: 25 lines mode"
      endif
    @@NoBit3:
      test AL,00010000b
      jne @@Bit4
      if GERMAN
        INFO2 "Bit 4 = 0: Bildschirm aus"
      else
        INFO2 "Bit 4 = 0: Blank the screen"
      endif
      jmp @@NoBit4
    @@Bit4:
      if GERMAN
        INFO2 "Bit 4 = 1: Bildschirm ein"
      else
        INFO2 "Bit 4 = 1: Unblank the screen"
      endif
    @@NoBit4:
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 7: bertrag Zeile fr Rasterinterrupt (%04X)",<DI>
      else
        INFO2 "Bit 7: Raster register bit 8 (%04X)",<DI>
      endif
    TEND
  endif
  and AL,01111111b                      ;Restliche Bits schreiben
  mov VIC[17],AL
  mov Top_Bottom,0+200*65536            ;Sichtbaren Bereich bestimmen
  test AL,00001000b
  jne @@AllVisible
  mov Top_Bottom,4+196*65536            ;24-Zeilen-Modus
@@AllVisible:
  ifdef DEBUG
    push CX
    mov CX,offset ShowVICConfig
  endif
ModeChanged label near
  mov DI,word ptr VIC[17]               ;Funktion zum Zeilenaufbau setzen
  shr DI,4
  and DI,0000000000000110b
  mov AL,VIC[22]
  shr AL,1
  and AX,0000000000001000b
  or DI,AX
  mov AX,afnBuildLine[DI]
  mov BuildLine,AX
  jmp CX
WriteVIC17 endp

;------------------------------------------------------------------------------

;VIC Register 18
;  xxxxxxxx = Bit 0..7 der aktuellen Rasterzeile (lesen)
;  xxxxxxxx = Bit 0..7 der Rasterzeile fr IRQ (schreiben)

code 4
EXP ReadVIC18,near
ReadVIC18 proc near
  mov AX,RasterLine                     ;Aktueller Rasterzeile holen
  cmp AX,255                            ;Konflikt mit Reg 17 Bit 7 vermeiden
  jae @@NoInc
  cmp BP,wLineCompare                   ;Eventuell um 1 erhhen
  jge @@NoInc
  inc AX
@@NoInc:
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Aktuelle Rasterzeile lesen (%04X)",<AX>
      else
        INFO "Read current raster line (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC18 endp

code 4
EXP WriteVIC18,near
WriteVIC18 proc near
  mov byte ptr IRQLine,AL
  ifdef DEBUG
    TBEG VIC
      mov AX,IRQLine
      if GERMAN
        INFO "Zeile fr Rasterinterrupt schreiben (%04X)",<AX>
      else
        INFO "Set raster line for Compare interrupt (%04X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC18 endp

;------------------------------------------------------------------------------

;VIC Register 19
;  xxxxxxxx = Lichtgriffel X-Koordinate

code 4
EXP ReadVIC19,near
ReadVIC19 proc near
  mov AL,VIC[19]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Lichtgriffel X-Koordinate lesen (%02X)",<AX>
      else
        INFO "Read light pen X-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC19 endp

code 4
EXP WriteVIC19,near
WriteVIC19 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        WARN "Lichtgriffel X-Koordinate schreiben (%02X)",<AX>
      else
        WARN "Write light pen X-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[19],AL
  jmp CX
WriteVIC19 endp

;------------------------------------------------------------------------------

;VIC Register 20
;  xxxxxxxx = Lichtgriffel Y-Koordinate

code 4
EXP ReadVIC20,near
ReadVIC20 proc near
  mov AL,VIC[20]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Lichtgriffel Y-Koordinate lesen (%02X)",<AX>
      else
        INFO "Read light pen Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC20 endp

code 4
EXP WriteVIC20,near
WriteVIC20 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        WARN "Lichtgriffel Y-Koordinate schreiben (%02X)",<AX>
      else
        WARN "Write light pen Y-coordinate (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[20],AL
  jmp CX
WriteVIC20 endp

;------------------------------------------------------------------------------

;VIC Register 21
;  -------1 = Sprite 0 eingeschaltet
;  ------1- = Sprite 1 eingeschaltet
;  -----1-- = Sprite 2 eingeschaltet
;  ----1--- = Sprite 3 eingeschaltet
;  ---1---- = Sprite 4 eingeschaltet
;  --1----- = Sprite 5 eingeschaltet
;  -1------ = Sprite 6 eingeschaltet
;  1------- = Sprite 7 eingeschaltet

code 4
EXP ReadVIC21,near
ReadVIC21 proc near
  mov AL,VIC[21]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 eingeschaltet lesen (%02X)",<AX>
      else
        INFO "Read Sprite Display Enable register (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC21 endp

code 4
EXP WriteVIC21,near
WriteVIC21 proc near
  mov VIC[21],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 eingeschaltet schreiben (%02X)",<AX>
      else
        INFO "Write Sprite Display Enable register (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
WriteVIC21 endp

;------------------------------------------------------------------------------

;VIC Register 22
;  -----xxx = Verschiebung des Bildschirms nach rechts, Default 0
;  ----0--- = 39 Zeichen pro Zeile
;  ----1--- = 40 Zeichen pro Zeile
;  ---1---- = Multi Color Modus eingeschaltet
;  --x----- = unbekannt
;  11------ = unbenutzt

code 4
EXP ReadVIC22,near
ReadVIC22 proc near
  mov AL,VIC[22]
  or AL,11000000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Steuerregister 2 lesen (%02X)",<AX>
      else
        INFO "Read Control Register 2 (%02X)",<AX>
      endif
      mov DI,AX
      and DI,0000000000000111b
      if GERMAN
        INFO2 "Bit 0-2: Bildverschiebung %d Punkte in X-Richtung",<DI>
      else
        INFO2 "Bit 0-2: Smooth scroll to X position %d",<DI>
      endif
      test AL,00001000b
      jne @@Bit3
      if GERMAN
        INFO2 "Bit 3 = 0: 38 Spalten Modus (fr horizontales Softscrolling)"
      else
        INFO2 "Bit 3 = 0: 38 columns mode (for horizontal smooth scrolling)"
      endif
      jmp @@NoBit3
    @@Bit3:
      if GERMAN
        INFO2 "Bit 3 = 1: 40 Zeilen Modus"
      else
        INFO2 "Bit 3 = 1: 40 columns mode"
      endif
    @@NoBit3:
      test AL,00010000b
      je @@NoBit4
      if GERMAN
        INFO2 "Bit 4 = 1: Multicolor Modus ist eingeschaltet"
      else
        INFO2 "Bit 4 = 1: Multicolor mode enabled"
      endif
    @@NoBit4:
      test AL,00100000b
      je @@NoBit5
      if GERMAN
        WARN2 "Bit 5 = 1: Das gerchtvolle Reset-Bit (kein Effekt)"
      else
        WARN2 "Bit 5 = 1: The rumoured 'reset' bit (no effect)"
      endif
    @@NoBit5:
    TEND
  endif
  jmp CX
ReadVIC22 endp

code 4
EXP WriteVIC22,near
WriteVIC22 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Steuerregister 2 schreiben (%02X)",<AX>
      else
        INFO "Write Control Register 2 (%02X)",<AX>
      endif
      mov DI,AX
      and DI,0000000000000111b
      if GERMAN
        INFO2 "Bit 0-2: Bildverschiebung %d Punkte in X-Richtung",<DI>
      else
        INFO2 "Bit 0-2: Smooth scroll to X position %d",<DI>
      endif
      test AL,00001000b
      jne @@Bit3
      if GERMAN
        INFO2 "Bit 3 = 0: 38 Spalten Modus (fr horizontales Softscrolling)"
      else
        INFO2 "Bit 3 = 0: 38 columns mode (for horizontal smooth scroll)"
      endif
      jmp @@NoBit3
    @@Bit3:
      if GERMAN
        INFO2 "Bit 3 = 1: 40 Zeilen Modus"
      else
        INFO2 "Bit 3 = 1: 40 columns mode"
      endif
    @@NoBit3:
      test AL,00010000b
      je @@NoBit4
      if GERMAN
        INFO2 "Bit 4 = 1: Multicolor Modus ist eingeschaltet"
      else
        INFO2 "Bit 4 = 1: Multicolor mode is enabled"
      endif
    @@NoBit4:
      test AL,00100000b
      je @@NoBit5
      if GERMAN
        WARN2 "Bit 5 = 1: Das gerchtvolle Reset-Bit (kein Effekt)"
      else
        WARN2 "Bit 5 = 1: The rumoured 'reset' bit (no effect)"
      endif
    @@NoBit5:
    TEND
  endif
  mov VIC[22],AL
  and AX,0000000000000111b
  neg AX
  mov ScrollX,AX
  ifdef DEBUG
    push CX
    mov CX,offset ShowVICConfig
  endif
  jmp ModeChanged
WriteVIC22 endp

;------------------------------------------------------------------------------

;VIC Register 23
;  -------1 = Sprite 0 doppelte Hhe
;  ------1- = Sprite 1 doppelte Hhe
;  -----1-- = Sprite 2 doppelte Hhe
;  ----1--- = Sprite 3 doppelte Hhe
;  ---1---- = Sprite 4 doppelte Hhe
;  --1----- = Sprite 5 doppelte Hhe
;  -1------ = Sprite 6 doppelte Hhe
;  1------- = Sprite 7 doppelte Hhe

code 4
EXP ReadVIC23,near
ReadVIC23 proc near
  mov AL,VIC[23]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 doppelte Hhe lesen (%02X)",<AX>
      else
        INFO "Read sprite Vertical Expand register (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC23 endp

code 4
EXP WriteVIC23,near
WriteVIC23 proc near
  mov VIC[23],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 doppelte Hhe schreiben (%02X)",<AX>
      else
        INFO "Write sprite Vertical Expand register (%02X)",<AX>
      endif
    TEND
  endif
  i=0
  rept 8
    mov DI,2
    shr AL,1
    sbb DI,0
    mov awSpriteYAdd[i*2],DI
    i=i+1
  endm
  jmp CX
WriteVIC23 endp

;------------------------------------------------------------------------------

;VIC Register 24
;  -------1 = unbenutzt
;  ----xxx- = Adrebits 11 bis 13 fr Grafik/Zeichensatz
;  xxxx---- = Adrebits 10 bis 13 fr Textbildschirm

code 4
EXP ReadVIC24,near
ReadVIC24 proc near
  mov AL,VIC[24]
  or AL,00000001b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Adreregister Videoram lesen (%02X)",<AX>
      else
        INFO "Read Memory Control Register (%02X)",<AX>
      endif
    TEND
    push CX
    jmp ShowVICConfig
  else
    jmp CX
  endif
ReadVIC24 endp

code 4
EXP WriteVIC24,near
WriteVIC24 proc near
  mov VIC[24],AL
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Adreregister Videoram schreiben (%02X)",<AX>
      else
        INFO "Write Memory Control Register (%02X)",<AX>
      endif
    TEND
    push CX
    mov CX,offset ShowVICConfig
  endif
EXP BaseChanged,near
BaseChanged label near
  mov AL,VIC[24]
  mov DI,VICBasePara                    ;Basisadresse VIC in Paragraphen
  shrd BX,AX,14                         ;Adresse des Textbildschirms
  and BX,0000001111000000b
  add BX,DI
  add BX,RAM
  mov TextSeg,BX
  shl AX,6                              ;Gemeinsame Basis Grafik und Zeichen
  and AX,0000001110000000b
  add DI,AX
  mov AX,DI                             ;Adresse des Grafikbildschirms
  and AX,0000111000000000b
  add AX,RAM
  mov GraphicSeg,AX
  mov AX,DI                             ;Auf Zeichensatz 1xxx und 9xxx prfen
  and AH,00000111b
  cmp AH,00000001b
  je @@CharRom
  add DI,RAM                            ;Adresse des Zeichensatzes
  mov CharSeg,DI
  jmp CX
align 4
@@CharRom:
  and AX,0000000010000000b              ;Zeichensatz im ROM
  add AX,CHAR
  mov CharSeg,AX
  jmp CX
WriteVIC24 endp

;------------------------------------------------------------------------------

;VIC Register 25 (nur Lesen, beim Schreiben Bits 1-3 zurcksetzen)
;  -------1 = Rasterzeile aus Register 18 wurde erreicht
;  ------1- = Sprite/Hintergrund-Kollision aufgetreten
;  -----1-- = Sprite/Sprite-Kollision aufgetreten
;  ----1--- = Lichtgriffel gab Impuls
;  -111---- = unbenutzt
;  1------- = bereinstimmung zwischen Reg 25 und 26, Interrupt ist aktiv

code 4
EXP ReadVIC25,near
ReadVIC25 proc near
  mov wSave25SI,SI
  mov wSave25BP,BP
  mov AL,Events
  shl AL,4
  or AL,01110000b
  or AL,VIC[25]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Interrupt Flag Register lesen (%02X)",<AX>
      else
        INFO "Read Interrupt Flag Register (%02X)",<AX>
      endif
      test AL,00000001b
      je @@NoBit0
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 0 = 1: Rasterzeile %04X wurde erreicht",<DI>
      else
        INFO2 "Bit 0 = 1: Raster line %04X was achieved (line %04X)",<DI>
      endif
    @@NoBit0:
      test AL,00000010b
      je @@NoBit1
      if GERMAN
        INFO2 "Bit 1 = 1: Sprite/Hintergrund-Kollision aufgetreten"
      else
        INFO2 "Bit 1 = 1: Sprite to background collision occurred"
      endif
    @@NoBit1:
      test AL,00000100b
      je @@NoBit2
      if GERMAN
        INFO2 "Bit 2 = 1: Sprite/Sprite-Kollision aufgetreten"
      else
        INFO2 "Bit 2 = 1: Sprite to sprite collision occurred"
      endif
    @@NoBit2:
      test AL,00001000b
      je @@NoBit3
      if GERMAN
        INFO2 "Bit 3 = 1: Lichtgriffel gab Impuls"
      else
        INFO2 "Bit 3 = 1: Light pen triggered"
      endif
    @@NoBit3:
      test AL,10000000b
      je @@NoBit7
      if GERMAN
        INFO2 "Bit 7 = 1: Interruptleitung ist aktiv"
      else
        INFO2 "Bit 7 = 1: Interrupt line is active"
      endif
    @@NoBit7:
    TEND
  endif
  jmp CX
ReadVIC25 endp

code 4
EXP WriteVIC25,near
WriteVIC25 proc near
  cmp wSave25SI,SI
  je @@ReadAndWrite
@@WrongBP:
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Interrupt Flag Register schreiben (%02X). Verbleibende Ereignisse:",<AX>
      else
        INFO "Write Interrupt Flag Register (%02X). Remaining events:",<AX>
      endif
    TEND
  endif
  not AL
  and AL,VIC[25]
  mov VIC[25],AL
  ifdef DEBUG
    TBEG VIC
      test AL,00000001b
      je @@NoBit0
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 0 = 1: Rasterzeile %04X wurde erreicht",<DI>
      else
        INFO2 "Bit 0 = 1: Raster line %04X was achieved",<DI>
      endif
    @@NoBit0:
      test AL,00000010b
      je @@NoBit1
      if GERMAN
        INFO2 "Bit 1 = 1: Sprite/Hintergrund-Kollision aufgetreten"
      else
        INFO2 "Bit 1 = 1: Sprite to background collision occurred"
      endif
    @@NoBit1:
      test AL,00000100b
      je @@NoBit2
      if GERMAN
        INFO2 "Bit 2 = 1: Sprite/Sprite-Kollision aufgetreten"
      else
        INFO2 "Bit 2 = 1: Sprite to sprite collision occurred"
      endif
    @@NoBit2:
      test AL,00001000b
      je @@NoBit3
      if GERMAN
        INFO2 "Bit 3 = 1: Lichtgriffel gab Impuls"
      else
        INFO2 "Bit 3 = 1: Light pen triggered"
      endif
    @@NoBit3:
    TEND
  endif
  test AL,VIC[26]
  jne @@DontClearIRQ
  ifdef DEBUG
    TBEG VIC
      test Events,evIRQVIC
      je @@NoBit7
      if GERMAN
        INFO2 "Bit 7 = 0: Interruptleitung wurde zurckgesetzt"
      else
        INFO2 "Bit 7 = 0: Interrupt line was reset"
      endif
    @@NoBit7:
    TEND
  endif
  and Events,not evIRQVIC
  ifdef DEBUG
    jmp CX
  endif
@@DontClearIRQ:
  ifdef DEBUG
    TBEG VIC
      test Events,evIRQVIC
      je @@NoBit7
      if GERMAN
        WARN2 "Bit 7 = 1: Interruptleitung bleibt weiterhin aktiv!"
      else
        WARN2 "Bit 7 = 1: Interrupt line remains active!"
      endif
    @@NoBit7:
    TEND
  endif
  jmp CX
align 4
@@ReadAndWrite:
  cmp wSave25BP,BP
  jne @@WrongBP
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Alle Interruptereignisse zurcksetzen (undokumentiertes Feature)"
      else
        INFO "Reset all interrupt events (undocumented feature)"
      endif
    TEND
  endif
  mov VIC[25],0
  and Events,not evIRQVIC
  jmp CX
WriteVIC25 endp

;------------------------------------------------------------------------------

;VIC Register 26
;  -------1 = Rasterinterrupt einschalten
;  ------1- = Sprite/Hintergrund-Kollision einschalten
;  -----1-- = Sprite/Sprite-Kollision einschalten
;  ----1--- = Lichtgriffelinterrupt einschalten
;  1111---- = unbenutzt

code 4
EXP ReadVIC26,near
ReadVIC26 proc near
  mov AL,VIC[26]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Interrupt Mask Register lesen (%02X)",<AX>
      else
        INFO "Read Interrupt Mask Register (%02X)",<AX>
      endif
      test AL,00000001b
      je @@NoBit0
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 0 = 1: Interrupt bei Rasterzeile %04X aktiviert",<DI>
      else
        INFO2 "Bit 0 = 1: Interrupt on raster line %04X activated",<DI>
      endif
    @@NoBit0:
      test AL,00000010b
      je @@NoBit1
      if GERMAN
        INFO2 "Bit 1 = 1: Interrupt bei Sprite/Hintergrund-Kollision aktiviert"
      else
        INFO2 "Bit 1 = 1: Interrupt on sprite to background collision activated"
      endif
    @@NoBit1:
      test AL,00000100b
      je @@NoBit2
      if GERMAN
        INFO2 "Bit 2 = 1: Interrupt bei Sprite/Sprite-Kollision aktiviert"
      else
        INFO2 "Bit 2 = 1: Interrupt on sprite to sprite collision activated"
      endif
    @@NoBit2:
      test AL,00001000b
      je @@NoBit3
      if GERMAN
        INFO2 "Bit 3 = 1: Interrupt durch Lichtgriffel aktiviert"
      else
        INFO2 "Bit 3 = 1: Interrupt on light pen input activated"
      endif
    @@NoBit3:
    TEND
  endif
  jmp CX
ReadVIC26 endp

code 4
EXP WriteVIC26,near
WriteVIC26 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Interrupt Mask Register schreiben (%02X)",<AX>
      else
        INFO "Write Interrupt Mask Register (%02X)",<AX>
      endif
      test AL,00000001b
      je @@NoBit0
      mov DI,IRQLine
      if GERMAN
        INFO2 "Bit 0 = 1: Interrupt bei Rasterzeile %04X aktiviert",<DI>
      else
        INFO2 "Bit 0 = 1: Interrupt on raster line %04X activated",<DI>
      endif
    @@NoBit0:
      test AL,00000010b
      je @@NoBit1
      if GERMAN
        INFO2 "Bit 1 = 1: Interrupt bei Sprite/Hintergrund-Kollision aktiviert"
      else
        INFO2 "Bit 1 = 1: Interrupt on sprite to background collision activated"
      endif
    @@NoBit1:
      test AL,00000100b
      je @@NoBit2
      if GERMAN
        INFO2 "Bit 2 = 1: Interrupt bei Sprite/Sprite-Kollision aktiviert"
      else
        INFO2 "Bit 2 = 1: Interrupt on sprite to sprite collision activated"
      endif
    @@NoBit2:
      test AL,00001000b
      je @@NoBit3
      if GERMAN
        INFO2 "Bit 3 = 1: Interrupt durch Lichtgriffel aktiviert"
      else
        INFO2 "Bit 3 = 1: Interrupt on light pen input activated"
      endif
    @@NoBit3:
    TEND
  endif
  and AL,00001111b
  mov VIC[26],AL
  test AL,VIC[25]
  je @@CheckClear
  ifdef DEBUG
    TBEG VIC
      test Events,evIRQVIC
      jne @@Quiet
      if GERMAN
        INFO2 "Bedingung fr IRQ erfllt, Interruptleitung wurde gesetzt"
      else
        INFO2 "IRQ condition occurred, interrupt line was set"
      endif
    @@Quiet:
    TEND
  endif
  or Events,evIRQVIC
  jmp CX
@@CheckClear:
  ifdef DEBUG
    TBEG VIC
      test Events,evIRQVIC
      je @@Quiet
      if GERMAN
        INFO2 "Interruptleitung wurde zurckgesetzt"
      else
        INFO2 "Interrupt line was reset"
      endif
    @@Quiet:
    TEND
  endif
  and Events,not evIRQVIC
  jmp CX
WriteVIC26 endp

;------------------------------------------------------------------------------

;VIC Register 27
;  -------1 = Sprite 0 im Hintergrund
;  ------1- = Sprite 1 im Hintergrund
;  -----1-- = Sprite 2 im Hintergrund
;  ----1--- = Sprite 3 im Hintergrund
;  ---1---- = Sprite 4 im Hintergrund
;  --1----- = Sprite 5 im Hintergrund
;  -1------ = Sprite 6 im Hintergrund
;  1------- = Sprite 7 im Hintergrund

code 4
EXP ReadVIC27,near
ReadVIC27 proc near
  mov AL,VIC[27]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 im Hintergrund lesen (%02X)",<AX>
      else
        INFO "Read sprite to background display priority (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC27 endp

code 4
EXP WriteVIC27,near
WriteVIC27 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 im Hintergrund schreiben (%02X)",<AX>
      else
        INFO "Set sprite to background display priority (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[27],AL
SetSpriteFunc label near
  mov EAX,dword ptr VIC[27]
  i=0
  rept 8
    xor BX,BX
    shr EAX,1
    rcl BX,1
    cmp AL,128
    rcl BX,1
    cmp AH,128
    rcl BX,1
    mov BX,SpriteFuncTab[EBX*2]
    mov afnSprite[i*2],BX
    i=i+1
  endm
  xor EAX,EAX
  jmp CX
WriteVIC27 endp

;------------------------------------------------------------------------------

;VIC Register 28
;  -------1 = Multicolor Sprite 0
;  ------1- = Multicolor Sprite 1
;  -----1-- = Multicolor Sprite 2
;  ----1--- = Multicolor Sprite 3
;  ---1---- = Multicolor Sprite 4
;  --1----- = Multicolor Sprite 5
;  -1------ = Multicolor Sprite 6
;  1------- = Multicolor Sprite 7

code 4
EXP ReadVIC28,near
ReadVIC28 proc near
  mov AL,VIC[28]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 Multicolormode lesen (%02X)",<AX>
      else
        INFO "Read sprite multi-color mode enable (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC28 endp

code 4
EXP WriteVIC28,near
WriteVIC28 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 Multicolormode schreiben (%02X)",<AX>
      else
        INFO "Set/reset sprite multi-color mode (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[28],AL
  jmp SetSpriteFunc
WriteVIC28 endp

;------------------------------------------------------------------------------

;VIC Register 29
;  -------1 = Sprite 0 doppelte Breite
;  ------1- = Sprite 1 doppelte Breite
;  -----1-- = Sprite 2 doppelte Breite
;  ----1--- = Sprite 3 doppelte Breite
;  ---1---- = Sprite 4 doppelte Breite
;  --1----- = Sprite 5 doppelte Breite
;  -1------ = Sprite 6 doppelte Breite
;  1------- = Sprite 7 doppelte Breite

code 4
EXP ReadVIC29,near
ReadVIC29 proc near
  mov AL,VIC[29]
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 doppelte Breite lesen (%02X)",<AX>
      else
        INFO "Read sprite double width information (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC29 endp

code 4
EXP WriteVIC29,near
WriteVIC29 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Sprite 0-7 doppelte Breite schreiben (%02X)",<AX>
      else
        INFO "Set/reset sprite double width (%02X)",<AX>
      endif
    TEND
  endif
  mov VIC[29],AL
  jmp SetSpriteFunc
WriteVIC29 endp

;------------------------------------------------------------------------------

;VIC Register 30
;  -------1 = Sprite 0 mit einem anderen Sprite zusammengestoen
;  ------1- = Sprite 1 mit einem anderen Sprite zusammengestoen
;  -----1-- = Sprite 2 mit einem anderen Sprite zusammengestoen
;  ----1--- = Sprite 3 mit einem anderen Sprite zusammengestoen
;  ---1---- = Sprite 4 mit einem anderen Sprite zusammengestoen
;  --1----- = Sprite 5 mit einem anderen Sprite zusammengestoen
;  -1------ = Sprite 6 mit einem anderen Sprite zusammengestoen
;  1------- = Sprite 7 mit einem anderen Sprite zusammengestoen

code 4
EXP ReadVIC30,near
ReadVIC30 proc near
  xor AX,AX                             ;Nach dem Lesen auf 0 setzen
  xchg AL,VIC[30]
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Sprite/Sprite-Kollision lesen (%02X) und zurcksetzen",<AX>
      else
        INFO "Read and reset sprite to sprite collision information (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC30 endp

code 4
EXP WriteVIC30,near
WriteVIC30 proc near
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Sprite/Sprite-Kollision zurcksetzen"
      else
        INFO "Reset sprite to sprite collision"
      endif
    TEND
  endif
  mov VIC[30],0
  jmp CX
WriteVIC30 endp

;------------------------------------------------------------------------------

;VIC Register 31
;  -------1 = Sprite 0 mit Zeichen zusammengestoen
;  ------1- = Sprite 1 mit Zeichen zusammengestoen
;  -----1-- = Sprite 2 mit Zeichen zusammengestoen
;  ----1--- = Sprite 3 mit Zeichen zusammengestoen
;  ---1---- = Sprite 4 mit Zeichen zusammengestoen
;  --1----- = Sprite 5 mit Zeichen zusammengestoen
;  -1------ = Sprite 6 mit Zeichen zusammengestoen
;  1------- = Sprite 7 mit Zeichen zusammengestoen

code 4
EXP ReadVIC31,near
ReadVIC31 proc near
  xor AX,AX                             ;Nach dem Lesen auf 0 setzen
  xchg AL,VIC[31]
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Sprite/Hintergrund-Kollision lesen (%02X) und zurcksetzen",<AX>
      else
        INFO "Read and reset sprite to background collision (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC31 endp

code 4
EXP WriteVIC31,near
WriteVIC31 proc near
  ifdef DEBUG
    TBEG VIC
      if GERMAN
        INFO "Sprite/Hintergrund-Kollision zurcksetzen"
      else
        INFO "Reset sprite to background collision"
      endif
    TEND
  endif
  mov VIC[31],0
  jmp CX
WriteVIC31 endp

;------------------------------------------------------------------------------

;VIC Register 32
;  ----xxxx = Rahmenfarbe
;  1111---- = unbenutzt

code 4
EXP ReadVIC32,near
ReadVIC32 proc near
  mov AL,VIC[32]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Rahmenfarbe lesen (%02X)",<AX>
      else
        INFO "Read border color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC32 endp

code 4
EXP WriteVIC32,near
WriteVIC32 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Rahmenfarbe schreiben (%02X)",<AX>
      else
        INFO "Write border color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[32],AL
  mov AH,AL                             ;Fr 32-Bit-Zugriff abspeichern
  mov word ptr Frame32[0],AX
  mov word ptr Frame32[2],AX
  jmp CX
WriteVIC32 endp

;------------------------------------------------------------------------------

;VIC Register 33
;  ----xxxx = Hintergrundfarbe
;  1111---- = unbenutzt

code 4
EXP ReadVIC33,near
ReadVIC33 proc near
  mov AL,VIC[33]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 0 lesen (%02X)",<AX>
      else
        INFO "Read background color 0 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC33 endp

code 4
EXP WriteVIC33,near
WriteVIC33 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 0 schreiben (%02X)",<AX>
      else
        INFO "Write background color 0 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[33],AL
  mov AH,AL                             ;Fr 32-Bit-Zugriff abspeichern
  mov word ptr Back32[0],AX
  mov word ptr Back32[2],AX
  jmp CX
WriteVIC33 endp

;------------------------------------------------------------------------------

;VIC Register 34
;  ----xxxx = Multi/Extended Color Farbe 1
;  1111---- = unbenutzt

code 4
EXP ReadVIC34,near
ReadVIC34 proc near
  mov AL,VIC[34]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 1 lesen (%02X)",<AX>
      else
        INFO "Read background color 1 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC34 endp

code 4
EXP WriteVIC34,near
WriteVIC34 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 1 schreiben (%02X)",<AX>
      else
        INFO "Write background color 1 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[34],AL
  jmp CX
WriteVIC34 endp

;------------------------------------------------------------------------------

;VIC Register 35
;  ----xxxx = Multi/Extended Color Farbe 2
;  1111---- = unbenutzt

code 4
EXP ReadVIC35,near
ReadVIC35 proc near
  mov AL,VIC[35]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 2 lesen (%02X)",<AX>
      else
        INFO "Read background color 2 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC35 endp

code 4
EXP WriteVIC35,near
WriteVIC35 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 2 schreiben (%02X)",<AX>
      else
        INFO "Write background color 2 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[35],AL
  jmp CX
WriteVIC35 endp

;------------------------------------------------------------------------------

;VIC Register 36
;  ----xxxx = Extended Color Farbe 3
;  1111---- = unbenutzt

code 4
EXP ReadVIC36,near
ReadVIC36 proc near
  mov AL,VIC[36]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 3 lesen (%02X)",<AX>
      else
        INFO "Read background color 3 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC36 endp

code 4
EXP WriteVIC36,near
WriteVIC36 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Hintergrundfarbe 3 schreiben (%02X)",<AX>
      else
        INFO "Write background color 3 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[36],AL
  jmp CX
WriteVIC36 endp

;------------------------------------------------------------------------------

;VIC Register 37
;  ----xxxx = Sprite Multi Color Farbe 1
;  1111---- = unbenutzt

code 4
EXP ReadVIC37,near
ReadVIC37 proc near
  mov AL,VIC[37]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Gemeinsame Multicolor Farbe 1 fr Sprites lesen (%02X)",<AX>
      else
        INFO "Read Sprite Multi-Color register 1 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC37 endp

code 4
EXP WriteVIC37,near
WriteVIC37 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Gemeinsame Multicolor Farbe 1 fr Sprites schreiben (%02X)",<AX>
      else
        INFO "Write Sprite Multi-Color register 1 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[37],AL
  jmp CX
WriteVIC37 endp

;------------------------------------------------------------------------------

;VIC Register 38
;  ----xxxx = Sprite Multi Color Farbe 2
;  1111---- = unbenutzt

code 4
EXP ReadVIC38,near
ReadVIC38 proc near
  mov AL,VIC[38]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Gemeinsame Multicolor Farbe 2 fr Sprites lesen (%02X)",<AX>
      else
        INFO "Read Sprite Multi-Color register 2 (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC38 endp

code 4
EXP WriteVIC38,near
WriteVIC38 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Gemeinsame Multicolor Farbe 2 fr Sprites schreiben (%02X)",<AX>
      else
        INFO "Write Sprite Multi-Color register 2 (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[38],AL
  jmp CX
WriteVIC38 endp

;------------------------------------------------------------------------------

;VIC Register 39
;  ----xxxx = Farbe Sprite 0
;  1111---- = unbenutzt

code 4
EXP ReadVIC39,near
ReadVIC39 proc near
  mov AL,VIC[39]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 0 lesen (%02X)",<AX>
      else
        INFO "Read sprite 0 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC39 endp

code 4
EXP WriteVIC39,near
WriteVIC39 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 0 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 0 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[39],AL
  jmp CX
WriteVIC39 endp

;------------------------------------------------------------------------------

;VIC Register 40
;  ----xxxx = Farbe Sprite 1
;  1111---- = unbenutzt

code 4
EXP ReadVIC40,near
ReadVIC40 proc near
  mov AL,VIC[40]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 1 lesen (%02X)",<AX>
      else
        INFO "Read sprite 1 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC40 endp

code 4
EXP WriteVIC40,near
WriteVIC40 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 1 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 1 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[40],AL
  jmp CX
WriteVIC40 endp

;------------------------------------------------------------------------------

;VIC Register 41
;  ----xxxx = Farbe Sprite 2
;  1111---- = unbenutzt

code 4
EXP ReadVIC41,near
ReadVIC41 proc near
  mov AL,VIC[41]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 2 lesen (%02X)",<AX>
      else
        INFO "Read sprite 2 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC41 endp

code 4
EXP WriteVIC41,near
WriteVIC41 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 2 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 2 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[41],AL
  jmp CX
WriteVIC41 endp

;------------------------------------------------------------------------------

;VIC Register 42
;  ----xxxx = Farbe Sprite 3
;  1111---- = unbenutzt

code 4
EXP ReadVIC42,near
ReadVIC42 proc near
  mov AL,VIC[42]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 3 lesen (%02X)",<AX>
      else
        INFO "Read sprite 3 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC42 endp

code 4
EXP WriteVIC42,near
WriteVIC42 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 3 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 3 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[42],AL
  jmp CX
WriteVIC42 endp

;------------------------------------------------------------------------------

;VIC Register 43
;  ----xxxx = Farbe Sprite 4
;  1111---- = unbenutzt

code 4
EXP ReadVIC43,near
ReadVIC43 proc near
  mov AL,VIC[43]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 4 lesen (%02X)",<AX>
      else
        INFO "Read sprite 4 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC43 endp

code 4
EXP WriteVIC43,near
WriteVIC43 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 4 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 4 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[43],AL
  jmp CX
WriteVIC43 endp

;------------------------------------------------------------------------------

;VIC Register 44
;  ----xxxx = Farbe Sprite 5
;  1111---- = unbenutzt

code 4
EXP ReadVIC44,near
ReadVIC44 proc near
  mov AL,VIC[44]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 5 lesen (%02X)",<AX>
      else
        INFO "Read sprite 5 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC44 endp

code 4
EXP WriteVIC44,near
WriteVIC44 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 5 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 5 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[44],AL
  jmp CX
WriteVIC44 endp

;------------------------------------------------------------------------------

;VIC Register 45
;  ----xxxx = Farbe Sprite 6
;  1111---- = unbenutzt

code 4
EXP ReadVIC45,near
ReadVIC45 proc near
  mov AL,VIC[45]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 6 lesen (%02X)",<AX>
      else
        INFO "Read sprite 6 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC45 endp

code 4
EXP WriteVIC45,near
WriteVIC45 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      ;Fuck MS
      if GERMAN
        INFO "Farbe von Sprite 6 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 6 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[45],AL
  jmp CX
WriteVIC45 endp

;------------------------------------------------------------------------------

;VIC Register 46
;  ----xxxx = Farbe Sprite 7
;  1111---- = unbenutzt

code 4
EXP ReadVIC46,near
ReadVIC46 proc near
  mov AL,VIC[46]
  or AL,11110000b
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 7 lesen (%02X)",<AX>
      else
        INFO "Read sprite 7 color (%02X)",<AX>
      endif
    TEND
  endif
  jmp CX
ReadVIC46 endp

code 4
EXP WriteVIC46,near
WriteVIC46 proc near
  ifdef DEBUG
    TBEG VIC
      xor AH,AH
      if GERMAN
        INFO "Farbe von Sprite 7 schreiben (%02X)",<AX>
      else
        INFO "Write sprite 7 color (%02X)",<AX>
      endif
    TEND
  endif
  and AL,00001111b
  mov VIC[46],AL
  jmp CX
WriteVIC46 endp

;------------------------------------------------------------------------------

;Bildschirm ausgeschaltet, Zeile in Rahmenfarbe anzeigen
code 4
ScreenOff proc near
  mov DI,RasterLine                     ;DI = Zeilenadresse
  sub DI,51
  imul DI,320
  mov CX,320/4                          ;80 Gruppen  4 Byte
  mov EAX,Frame32                       ;EAX = 4 mal Rahmenfarbe
  cmp fLocalBus,0
  jne @@LocalBus
  mov ES,CacheSeg                       ;ES = Bildschirmcache
  mov BX,0A000h                         ;FS = VGA-Bildschirm
  mov FS,BX
  jmp @@Compare
align 4
@@Changed:
  mov ES:[DI-4],EAX                     ;Rahmenfarbe in Cache
  mov FS:[DI-4],EAX                     ;und in Bildschirm schreiben
  and CX,CX
  je BorderSprites
@@Compare:
  repe scasd                            ;Cache nach zu ndernden Eintrgen
  jne @@Changed                         ;durchsuchen
  jmp BorderSprites
align 4
@@LocalBus:
  mov BX,0A000h                         ;ES = VGA-Bildschirm
  mov ES,BX
  rep stosd                             ;Zeile mit Rahmenfarbe beschreiben
  jmp BorderSprites
ScreenOff endp

;Ungltiger Modus, schwarzer Hintergrund
code 4
BlackScreen proc near
  mov AX,DS                             ;Zielsegment setzen
  mov ES,AX
  xor EAX,EAX                           ;Schwarzer Hintergrund, alles lschen
  mov DI,offset Line+56
  mov CX,320/4                          ;80 Gruppen  4 Byte
  rep stosd
  mov DI,offset Collision+56*2          ;Werte fr Sprite/Zeichenkollision
  mov CX,320*2/4
  rep stosd
  jmp AddSprites
BlackScreen endp

;Normaler Textmodus
;  Farbe 0 = VIC[33]
;  Farbe 1 = Color Ram
code 4
SingleText proc near
  mov FS,CharSeg                        ;FS = Zeichensatz
  mov DX,wYOffset                       ;DX = Rasterzeile & 7
  xor SI,SI                             ;SI = Index in Textbildschirm/Farbram
  mov DI,56                             ;DI = Index in Line/Collision
  mov AL,VIC[33]                        ;Hintergrundfarbe setzen
  mov Color[0],AL
align 4
@@NextGroup:
  mov BL,abCharBuf[SI]                  ;Zeichen holen
  xor BH,BH
  mov AH,byte ptr FS:[EBX*8+EDX]        ;Bitmuster nach AH
  mov AL,abColorBuf[SI]                 ;Vordergrundfarbe setzen
  mov Color[1],AL
  i=0
  rept 8
    shld BX,AX,1+i                      ;Nchstes Bit nach BX holen
    and BX,0000000000000001b
    mov AL,Color[BX]                    ;Bildpunkt setzen
    mov Line[DI+i],AL
    mov Collision[EDI*2+i*2],BX         ;Kollisionsmaske setzen
    i=i+1
  endm
  inc SI                                ;Nchstes Zeichen behandeln
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
SingleText endp

;Normaler Grafikmodus
;  Farbe 0 = Zeichen Bit 0..3
;  Farbe 1 = Zeichen Bit 4..7
code 4
SingleGraphic proc near
  mov FS,GraphicSeg                     ;FS = Grafikbildschirm
  mov DX,wYBlock                        ;DX = Index in Grafikbildschirm
  shl DX,3
  add DX,wYOffset
  xor SI,SI                             ;SI = Index in Textbildschirm/Farbram
  mov DI,56                             ;DI = Index in Line/Collision
align 4
@@NextGroup:
  mov AL,abCharBuf[SI]                  ;Vorder- und Hintergrundfarbe setzen
  mov AH,AL
  shr AH,4
  and AX,0000111100001111b
  mov word ptr Color,AX
  mov AH,byte ptr FS:[EDX]              ;Bitmuster nach AH holen
  i=0
  rept 8
    shld BX,AX,1+i                      ;Nchstes Bit nach BX holen
    and BX,0000000000000001b
    mov AL,Color[BX]                    ;Bildpunkt setzen
    mov Line[DI+i],AL
    mov Collision[EDI*2+i*2],BX         ;Kollisionsmaske setzen
    i=i+1
  endm
  inc SI                                ;Nchste Gruppe behandeln
  add DX,8
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
SingleGraphic endp

;Mehrfarbiger Textmodus
;  Color Ram Bit 3 = 0: zweifarbig
;    Farbe 0 = VIC[33]
;    Farbe 1 = Color Ram Bit 0..2
;  Color Ram Bit 3 = 1: vierfarbig
;    Farbe 0 = VIC[33]
;    Farbe 1 = VIC[34]
;    Farbe 2 = VIC[35]
;    Farbe 3 = Color Ram Bit 0..2
code 4
MultiText proc near
  mov FS,CharSeg                        ;FS = Zeichensatz
  mov DX,wYOffset                       ;DX = Rasterzeile & 7
  xor SI,SI                             ;SI = Index in Textbildschirm/Farbram
  mov DI,56                             ;DI = Index in Line/Collision
  mov AL,VIC[33]                        ;Hintergrundfarbe setzen
  mov Color[0],AL
  mov AL,VIC[35]                        ;Farbe 2 setzen
  mov Color[2],AL
align 4
@@NextGroup:
  mov BL,abCharBuf[SI]                  ;Zeichen holen
  xor BH,BH
  mov AH,byte ptr FS:[EBX*8+EDX]        ;Bitmuster nach AH
  mov AL,abColorBuf[SI]                 ;Dieses Zeichen im Multicolor-Modus?
  test AL,00001000b
  je @@SingleColor
  and AL,00000111b                      ;Farbe 3 setzen
  mov Color[3],AL
  mov AL,VIC[34]                        ;Farbe 1 setzen
  mov Color[1],AL
  i=0
  rept 4
    shld BX,AX,2+i*2                    ;Nchstes Bitmuster nach BX holen
    and BX,0000000000000011b
    mov AL,Color[BX]                    ;Bildpunkte setzen
    mov Line[DI+i*2+0],AL
    mov Line[DI+i*2+1],AL
    shr BX,1                            ;Muster 01 wird nicht erkannt
    mov Collision[EDI*2+i*4+0],BX       ;Kollisionsmasken setzen
    mov Collision[EDI*2+i*4+2],BX
    i=i+1
  endm
  inc SI                                ;Nchstes Zeichen behandeln
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
align 4
@@SingleColor:
  mov Color[1],AL                       ;Vordergrundfarbe setzen
  i=0
  rept 8
    shld BX,AX,1+i                      ;Nchstes Bit nach BX holen
    and BX,0000000000000001b
    mov AL,Color[BX]                    ;Bildpunkt setzen
    mov Line[DI+i],AL
    mov Collision[EDI*2+i*2],BX         ;Kollisionsmaske setzen
    i=i+1
  endm
  inc SI                                ;Nchstes Zeichen behandeln
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
MultiText endp

;Mehrfarbiger Grafikmodus
;  Farbe 0 = VIC[33]
;  Farbe 1 = Zeichen Bit 4..7
;  Farbe 2 = Zeichen Bit 0..3
;  Farbe 3 = Color Ram
code 4
MultiGraphic proc near
  mov FS,GraphicSeg                     ;FS = Grafikbildschirm
  mov DX,wYBlock                        ;DX = Index in Grafikbildschirm
  shl DX,3
  add DX,wYOffset
  xor SI,SI                             ;SI = Index in Textbildschirm/Farbram
  mov DI,56                             ;DI = Index in Line/Collision
  mov AL,VIC[33]                        ;Hintergrundfarbe setzen
  mov Color[0],AL
align 4
@@NextGroup:
  mov AL,abCharBuf[SI]                  ;Farben 1 und 2 setzen
  mov AH,AL
  shr AL,4
  and AX,0000111100001111b
  mov word ptr Color[1],AX
  mov AL,abColorBuf[SI]                 ;Farbe 3 setzen
  mov Color[3],AL
  mov AH,byte ptr FS:[EDX]              ;Bitmuster nach AH holen
  i=0
  rept 4
    shld BX,AX,2+i*2                    ;Nchstes Bitmuster nach BX holen
    and BX,0000000000000011b
    mov AL,Color[BX]                    ;Bildpunkte setzen
    mov Line[DI+i*2+0],AL
    mov Line[DI+i*2+1],AL
    shr BX,1                            ;Muster 01 wird nicht erkannt
    mov Collision[EDI*2+i*4+0],BX       ;Kollisionsmasken setzen
    mov Collision[EDI*2+i*4+2],BX
    i=i+1
  endm
  inc SI                                ;Nchste Gruppe behandeln
  add DX,8
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
MultiGraphic endp

;Erweiterter Textmodus
;  Farbe 0 = VIC[33 + Zeichen Bit 6..7]
;  Farbe 1 = Color Ram
code 4
ExtendedText proc near
  mov FS,CharSeg                        ;FS = Zeichensatz
  mov DX,wYOffset                       ;DX = Rasterzeile & 7
  xor SI,SI                             ;SI = Index in Textbildschirm/Farbram
  mov DI,56                             ;DI = Index in Line/Collision
align 4
@@NextGroup:
  mov CL,abCharBuf[SI]                  ;Zeichen holen
  shld BX,CX,10
  and CX,0000000000111111b
  mov AH,byte ptr FS:[ECX*8+EDX]        ;Bitmuster nach AH
  and BX,0000000000000011b              ;Hintergrundfarbe setzen
  mov CL,VIC[33+BX]
  mov CH,abColorBuf[SI]                 ;Vordergrundfarbe setzen
  mov word ptr Color[0],CX
  i=0
  rept 8
    shld BX,AX,1+i                      ;Nchstes Bit nach BX holen
    and BX,0000000000000001b
    mov AL,Color[BX]                    ;Bildpunkt setzen
    mov Line[DI+i],AL
    mov Collision[EDI*2+i*2],BX         ;Kollisionsmaske setzen
    i=i+1
  endm
  inc SI                                ;Nchstes Zeichen behandeln
  add DI,8
  cmp DI,56+320
  jb @@NextGroup
  jmp AddSprites
ExtendedText endp

;Normales Sprite im Vordergrund
;  Farbe 1 = VIC[39+SI]
code 4
SpriteSF1 proc near
  mov CL,VIC[39+SI]                     ;Vordergrundfarbe holen
  lea BP,[DI+24]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetPixel:
  mov Line[DI],CL                       ;Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  inc DI                                ;Einen Bildpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shl EAX,1                             ;Ist der nchste Bildpunkt gesetzt?
  jnc @@NextPixel
  mov BX,Collision[EDI*2]               ;Befindet sich ein Zeichen darunter?
  and BL,BL
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;War da bereits ein Sprite?
  je @@SetPixel
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteSF1 endp

;Multicolor Sprite im Vordergrund
;  Farbe 1 = VIC[37]
;  Farbe 2 = VIC[39+SI]
;  Farbe 3 = VIC[38]
code 4
SpriteMF1 proc near
  mov BX,word ptr VIC[37]               ;Farben bertragen
  mov Color[1],BL
  mov BL,VIC[39+SI]
  mov word ptr Color[2],BX
  lea BP,[DI+24]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetRight:
  mov Line[DI+1],CL                     ;Rechtes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,2                              ;Einen Multicolorpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shld EBX,EAX,2                        ;Ist der nchste Bildpunkt gesetzt?
  shl EAX,2
  and BX,0000000000000011b
  je @@NextPixel
  mov CL,Color[BX]                      ;Farbe holen
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@SetLeft
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@SetRight
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
align 4
@@SetLeft:
  mov Line[DI],CL                       ;Linkes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@SetRight
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteMF1 endp

;Normales Sprite im Hintergrund
;  Farbe 1 = VIC[39+SI]
SpriteSH1 proc near
  mov CL,VIC[39+SI]                     ;Vordergrundfarbe holen
  lea BP,[DI+24]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetPixel:
  and BL,BL                             ;Zeichenpunkte sind im Vordergrund
  jne @@SetCollision
  mov Line[DI],CL                       ;Spritepixel sichtbar machen
@@SetCollision:
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  inc DI                                ;Einen Bildpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shl EAX,1                             ;Ist der nchste Bildpunkt gesetzt?
  jnc @@NextPixel
  mov BX,Collision[EDI*2]               ;Befindet sich ein Zeichen darunter?
  and BL,BL
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;War da bereits ein Sprite?
  je @@SetPixel
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteSH1 endp

;Multicolor Sprite im Hintergrund
;  Farbe 1 = VIC[37]
;  Farbe 2 = VIC[39+SI]
;  Farbe 3 = VIC[38]
code 4
SpriteMH1 proc near
  mov BX,word ptr VIC[37]               ;Farben bertragen
  mov Color[1],BL
  mov BL,VIC[39+SI]
  mov word ptr Color[2],BX
  lea BP,[DI+24]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetRight:
  test EBX,00FF0000h                    ;Zeichenpunkte sind im Vordergrund
  jne @@SetCollisionRight
  mov Line[DI+1],CL                     ;Rechtes Spritepixel sichtbar machen
@@SetCollisionRight:
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,2                              ;Einen Multicolorpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shld EBX,EAX,2                        ;Ist der nchste Bildpunkt gesetzt?
  shl EAX,2
  and BX,0000000000000011b
  je @@NextPixel
  mov CL,Color[BX]                      ;Farbe holen
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@SetLeft
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@SetRight
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
align 4
@@SetLeft:
  and BL,BL                             ;Zeichenpunkte sind im Vordergrund
  jne @@SetCollisionLeft
  mov Line[DI],CL                       ;Linkes Spritepixel sichtbar machen
@@SetCollisionLeft:
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@SetRight
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteMH1 endp

;Doppelt breites Sprite im Vordergrund
;  Farbe 1 = VIC[39+SI]
code 4
SpriteSF2 proc near
  mov CL,VIC[39+SI]                     ;Vordergrundfarbe holen
  lea BP,[DI+48]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetPixel2:
  mov Line[DI+1],CL                     ;Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,2                              ;Einen Bildpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shl EAX,1                             ;Ist der nchste Bildpunkt gesetzt?
  jnc @@NextPixel
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;War da bereits ein Sprite?
  je @@SetPixel1
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  test EBX,0FF000000h
  je @@SetPixel2
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
align 4
@@SetPixel1:
  mov Line[DI],CL                       ;Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
  test EBX,0FF000000h
  je @@SetPixel2
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteSF2 endp

;Doppelt breites Multicolor Sprite im Vordergrund
;  Farbe 1 = VIC[37]
;  Farbe 2 = VIC[39+SI]
;  Farbe 3 = VIC[38]
code 4
SpriteMF2 proc near
  mov BX,word ptr VIC[37]               ;Farben bertragen
  mov Color[1],BL
  mov BL,VIC[39+SI]
  mov word ptr Color[2],BX
  lea BP,[DI+48]                        ;Endeadresse holen
  jmp @@FirstPixel
@@Set2Right:
  mov Line[DI+3],CL                     ;Rechtes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+7],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,4                              ;Einen Multicolorpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shld EBX,EAX,2                        ;Ist der nchste Bildpunkt gesetzt?
  shl EAX,2
  and BX,0000000000000011b
  je @@NextPixel
  mov CL,Color[BX]                      ;Farbe holen
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background1
  or DH,CH                              ;Kollision mit Zeichen
@@Background1:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@Set1Left
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont1Left
align 4
@@Set1Left:
  mov Line[DI],CL                       ;Linkes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont1Left:
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@Set1Right
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont1Right
align 4
@@Set1Right:
  mov Line[DI+1],CL                     ;Rechtes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont1Right:
  mov EBX,dword ptr Collision[EDI*2+4]  ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background2
  or DH,CH                              ;Kollision mit Zeichen
@@Background2:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@Set2Left
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont2Left
align 4
@@Set2Left:
  mov Line[DI+2],CL                     ;Linkes Spritepixel sichtbar machen
  mov byte ptr Collision[EDI*2+5],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont2Left:
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@Set2Right
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteMF2 endp

;Doppelt breites Sprite im Hintergrund
;  Farbe 1 = VIC[39+SI]
SpriteSH2 proc near
  mov CL,VIC[39+SI]                     ;Vordergrundfarbe holen
  lea BP,[DI+48]                        ;Endeadresse holen
  jmp @@FirstPixel
@@SetPixel2:
  test EBX,00FF0000h                    ;Zeichenpunkte sind im Vordergrund
  jne @@SetCollision2
  mov Line[DI+1],CL                     ;Spritepixel sichtbar machen
@@SetCollision2:
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,2                              ;Einen Bildpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shl EAX,1                             ;Ist der nchste Bildpunkt gesetzt?
  jnc @@NextPixel
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background
  or DH,CH                              ;Kollision mit Zeichen
@@Background:
  and BH,BH                             ;War da bereits ein Sprite?
  je @@SetPixel1
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@ContPixel1
align 4
@@SetPixel1:
  and BL,BL                             ;Zeichenpunkte sind im Vordergrund
  jne @@SetCollision1
  mov Line[DI],CL                       ;Spritepixel sichtbar machen
@@SetCollision1:
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
@@ContPixel1:
  test EBX,0FF000000h                   ;War da bereits ein Sprite?
  je @@SetPixel2
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteSH2 endp

;Doppelt breites Multicolor Sprite im Hintergrund
;  Farbe 1 = VIC[37]
;  Farbe 2 = VIC[39+SI]
;  Farbe 3 = VIC[38]
code 4
SpriteMH2 proc near
  mov BX,word ptr VIC[37]               ;Farben bertragen
  mov Color[1],BL
  mov BL,VIC[39+SI]
  mov word ptr Color[2],BX
  lea BP,[DI+48]                        ;Endeadresse holen
  jmp @@FirstPixel
@@Set2Right:
  test EBX,00FF0000h                    ;Zeichenpunkte sind im Vordergrund
  jne @@Collision2Right
  mov Line[DI+3],CL                     ;Rechtes Spritepixel sichtbar machen
@@Collision2Right:
  mov byte ptr Collision[EDI*2+7],CH    ;Nummer fr Kollisionserkennung setzen
@@NextPixel:
  add DI,4                              ;Einen Multicolorpunkt nach rechts
  cmp DI,BP                             ;Ende des Sprites erreicht?
  jae NextSprite
@@FirstPixel:
  shld EBX,EAX,2                        ;Ist der nchste Bildpunkt gesetzt?
  shl EAX,2
  and BX,0000000000000011b
  je @@NextPixel
  mov CL,Color[BX]                      ;Farbe holen
  mov EBX,dword ptr Collision[EDI*2]    ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background1
  or DH,CH                              ;Kollision mit Zeichen
@@Background1:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@Set1Left
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont1Left
align 4
@@Set1Left:
  and BL,BL                             ;Zeichenpunkte sind im Vordergrund
  jne @@Collision1Left
  mov Line[DI],CL                       ;Linkes Spritepixel sichtbar machen
@@Collision1Left:
  mov byte ptr Collision[EDI*2+1],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont1Left:
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@Set1Right
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont1Right
align 4
@@Set1Right:
  test EBX,00FF0000h                    ;Zeichenpunkte sind im Vordergrund
  jne @@Collision1Right
  mov Line[DI+1],CL                     ;Rechtes Spritepixel sichtbar machen
@@Collision1Right:
  mov byte ptr Collision[EDI*2+3],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont1Right:
  mov EBX,dword ptr Collision[EDI*2+4]  ;Befindet sich ein Zeichen darunter?
  test EBX,00FF00FFh
  je @@Background2
  or DH,CH                              ;Kollision mit Zeichen
@@Background2:
  and BH,BH                             ;Linke Pixelhlfte auf Sprite prfen
  je @@Set2Left
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@Cont2Left
align 4
@@Set2Left:
  and BL,BL                             ;Zeichenpunkte sind im Vordergrund
  jne @@Collision2Left
  mov Line[DI+2],CL                     ;Linkes Spritepixel sichtbar machen
@@Collision2Left:
  mov byte ptr Collision[EDI*2+5],CH    ;Nummer fr Kollisionserkennung setzen
@@Cont2Left:
  test EBX,0FF000000h                   ;Rechte Pixelhlfte auf Sprite prfen
  je @@Set2Right
  or DL,BH                              ;Kollision des Vorgngers
  or DL,CH                              ;mit aktuellem Sprite
  jmp @@NextPixel
SpriteMH2 endp

comment #  Aufbau des Bildes
           -----------------
Der Emulator besitzt die beiden Zhler (wYBlock) und (wYOffset). Der erste
gibt die Anfangsadresse der aktuellen Zeile im Bildschirmspeicher an, also 0,
40, 80, 120 usw. Der zweite steht fr die Pixelzeile innerhalb des Blocks von
0 bis 7.

Bei Rasterzeile 48 wird (wYBlock) auf -40 gesetzt. Jedesmal wenn ((Rasterzeile
^ VIC[17]) & 7 == 0) gilt, wird (wYOffset) auf 0 zurckgesetzt, (wYBlock) um
40 erhht und eine neue Zeichenzeile in den Puffer eingelesen. Das kostet 40
Taktzyklen. Liegt (wYBlock) im Bereich zwischen 0 und 24 * 40 und (wYOffset)
zwischen 0 und 7, so wird der Bildschirm angezeigt. Ansonsten wird das Byte an
Adresse 16383 dargestellt.
#

;Alle 64us die nchste Bildschirmzeile berechnen und ausgeben
code 4
EXP UpdateVIC,near
UpdateVIC proc near
  mov wSpriteSub,0                      ;Keine Verzgerung wegen Sprites
  mov AX,RasterLine                     ;Aktuelle Rasterzeile um 1 erhhen
  inc AX
  cmp AX,wLinesPerFrame
  jae @@Retrace
@@NoRetrace:
  mov RasterLine,AX
  ifdef DEBUG
    TBEG REM
    if GERMAN
      INFO "VIC Rasterzeile %04X wurde erreicht",<AX>
    else
      INFO "VIC raster line %04X was achieved",<AX>
    endif
    TEND
  endif
  cmp AX,IRQLine                        ;Rasterinterrupt auslsen
  je @@RasterInt
  cmp wRefreshCounter,0                 ;Anzeige berspringen?
  jne @@IdleCycle
@@NoRasterInt:
  cmp wAlgorithm,2
  je @@Algorithm2
  ja @@Algorithm3
@@Algorithm1:
  inc wYOffset
  xor AL,VIC[17]
  test AL,00000111b
  jne @@ReloadAX
  mov BX,RasterLine
  sub BX,48
  shr BX,3
  imul BX,40
  jmp @@LoadChrPtr
@@Algorithm2:
  cmp AX,48
  jne @@NoBlockReset2
  mov wYBlock,-40
@@NoBlockReset2:
  inc wYOffset
  xor AL,VIC[17]
  test AL,00000111b
  jne @@ReloadAX
  mov BX,wYBlock
  add BX,40
  jmp @@LoadChrPtr
@@Algorithm3:
  inc wYOffset
  cmp wYOffset,8
  jne @@NoBlockInc2
  add wYBlock,40
@@NoBlockInc2:
  xor AL,VIC[17]
  test AL,00000111b
  jne @@ReloadAX
  mov AX,RasterLine
  shr AX,3
  cmp AX,6
  jne @@NoBlockReset3
  mov wYBlock,0
@@NoBlockReset3:
  mov BX,wYBlock
@@LoadChrPtr:
  mov wYBlock,BX
  cmp BX,25*40
  jae @@ReloadAX
  mov wYOffset,0
  mov ES,TextSeg
  i=0
  rept 40/4
    mov EAX,ES:[BX+i*4]
    mov dword ptr abCharBuf[i*4],EAX
    i=i+1
  endm
  i=0
  rept 40/4
    mov EAX,dword ptr abColor[BX+i*4]
    mov dword ptr abColorBuf[i*4],EAX
    i=i+1
  endm
  mov DI,wLineDelay
  sub Clock,DI
@@ReloadAX:
  mov AX,RasterLine
@@EndAlgorithm:
  sub AX,51                             ;Strahl im sichtbaren Bereich?
  jb BorderSprites
  cmp AX,VisibleTop                     ;Bildschirm einschalten?
  je @@SetScreenOn
  cmp AX,VisibleBottom                  ;Bildschirm ausschalten?
  je @@SetScreenOff
  cmp AX,200                            ;Strahl im sichtbaren Bereich?
  jae BorderSprites
  cmp bScreenOn,0                       ;Bildschirm eingeschaltet?
  je ScreenOff
@@ScreenIsOn:
  mov AX,DS                             ;Spritekollision auerhalb des linken
  mov ES,AX                             ;und rechten Bildrandes lschen
  xor EAX,EAX
  mov DI,offset DGROUP:Collision
  mov CX,56*2/4
  rep stosd
  mov DI,offset DGROUP:Collision+(56+320)*2
  mov CX,56*2/4
  rep stosd
  cmp wYBlock,25*40                     ;Zeile im gltigen Bereich?
  jae @@OutOfScreenY
  cmp wYOffset,8
  jae @@OutOfScreenY
  jmp BuildLine                         ;Zeile normal aufbauen
align 4
@@SetScreenOff:
  mov bScreenOn,0                       ;Bildschirm ausschalten
  cmp AX,200                            ;Strahl im sichtbaren Bereich?
  jb ScreenOff
  jmp BorderSprites
align 4
@@SetScreenOn:
  test VIC[17],00010000b
  je ScreenOff
  mov bScreenOn,1                       ;Bildschirm einschalten
  jmp @@ScreenIsOn
align 4
@@OutOfScreenY:
  cmp BuildLine,offset BlackScreen      ;Modus ungltig?
  je BlackScreen                        ;Dann schwarzer Hintergrund
  movzx AX,VIC[33]                      ;Vorder- und Hintergrundfarbe setzen
  mov word ptr Color,AX
  mov AX,VICBasePara                    ;ES = Startadresse VIC-RAM
  add AX,RAM
  mov ES,AX
  mov DI,56                             ;DI = Index in Line/Collision
@@NextGroup:
  mov AH,ES:[16383]                     ;Bitmuster nach AH holen
@@NextPixel:
  xor BX,BX                             ;Nchstes Pixel nach BX
  shl AX,1
  rcl BX,1
  mov AL,Color[BX]                      ;Bildpunktes setzen
  mov Line[DI],AL
  mov Collision[EDI*2],BX               ;Maske fr Spritekollision setzen
  inc DI                                ;Um einen Punkt nach rechts
  test DI,7
  jne @@NextPixel
  cmp DI,56+320                         ;Auf Zeilenende prfen
  jb @@NextGroup
align 4
AddSprites label near
  mov AX,VICBasePara                    ;FS = VIC-Basisadresse
  add AX,RAM
  mov FS,AX
  xor SI,SI                             ;SI = Nummer des Sprites
  mov CH,00000001b                      ;CH = Bitmaske
  xor DX,DX                             ;DL = Spr/Spr, DH = Spr/Chr Kollision
  jmp @@FirstSprite
align 4
NextSprite label near
  shl CH,1                              ;Maske aktualisieren
  jc @@LastSprite
  inc SI                                ;Nummer aktualisieren
@@FirstSprite:
  mov AX,awSpriteYCount[ESI*2]          ;Wird das Sprite bereits angezeigt?
  cmp AX,21*2
  jb @@ShowSprite
  test VIC[21],CH                       ;Ist das Sprite eingeschaltet?
  je NextSprite
  movzx AX,VIC[1+ESI*2]                 ;Rasterstrahl eine Zeile darber?
  cmp RasterLine,AX
  jne NextSprite
  mov awSpriteYCount[ESI*2],0           ;Sprite zur Anzeige freigeben
  jmp NextSprite
align 4
@@ShowSprite:
  mov wSpriteSub,3                      ;Verzgerung 3 Clocks wegen Sprites
  mov DI,wSpriteDelay                   ;Verzgerung 2 Clocks pro Sprite
  sub Clock,DI
  mov BX,awSpriteYAdd[ESI*2]            ;Index weiterzhlen
  add BX,AX
  cmp BX,21*2                           ;Letzte Zeile erreicht?
  jae @@TestTiled
@@ShowCont:
  mov awSpriteYCount[ESI*2],BX          ;Neuen Index abspeichern
  mov DI,awSpriteX[ESI*2]               ;X-Position prfen
  and DI,DI
  js NextSprite
  add DI,ScrollX
  js NextSprite
  movzx BX,abSpritePtr[SI]              ;Adresse des Bitmusters berechnen
  shl BX,6
  shr AX,1
  add BX,AX
  add BX,AX
  add BX,AX
  mov AX,FS:[BX]                        ;Bitmuster nach EAX holen
  xchg AL,AH
  shl EAX,16
  mov AH,FS:[BX+2]
  jmp afnSprite[ESI*2]                  ;Muster in Zeilenpuffer schreiben
align 4
@@TestTiled:
  test VIC[21],CH                       ;Ist das Sprite eingeschaltet?
  je @@ShowCont
  movzx DI,VIC[1+ESI*2]                 ;Rasterstrahl eine Zeile darber?
  cmp RasterLine,DI
  jne @@ShowCont
  xor BX,BX                             ;Sprite erneut anzeigen
  jmp @@ShowCont
align 4
BorderSprites label near
  mov CH,00000001b                      ;Maske initialisieren
  xor SI,SI                             ;Index initialisieren
  mov BX,RasterLine                     ;Fr schnelleren Vergleich
  jmp @@BFirstSprite
@@BNextSprite:
  shl CH,1                              ;Maske aktualisieren
  jc @@BLastSprite
  inc SI                                ;Nummer aktualisieren
@@BFirstSprite:
  mov AX,awSpriteYCount[ESI*2]          ;Wird das Sprite bereits angezeigt?
  cmp AX,21*2
  jb @@BShowSprite
@@BTestTiled:
  test VIC[21],CH                       ;Ist das Sprite eingeschaltet?
  je @@BNextSprite
  movzx AX,VIC[1+ESI*2]                 ;Rasterstrahl eine Zeile darber?
  cmp AX,BX
  jne @@BNextSprite
  mov awSpriteYCount[ESI*2],0           ;Sprite zur Anzeige freigeben
  jmp @@BNextSprite
align 4
@@BShowSprite:
  mov wSpriteSub,3                      ;Verzgerung 3 Clocks wegen Sprites
  mov DI,wSpriteDelay                   ;Verzgerung 2 Clocks pro Sprite
  sub Clock,DI
  add AX,awSpriteYAdd[ESI*2]            ;Index weiterzhlen
  mov awSpriteYCount[ESI*2],AX
  cmp AX,21*2                           ;Letzte Zeile erreicht?
  jb @@BNextSprite
  jmp @@BTestTiled
align 4
@@BLastSprite:
  mov ES,TextSeg                        ;Adressen fr nchsten Durchlauf setzen
  mov EAX,ES:[1016+0]
  mov dword ptr abSpritePtr[0],EAX
  mov EAX,ES:[1016+4]
  mov dword ptr abSpritePtr[4],EAX
  jmp NextLine
align 4
@@LastSprite:
  mov ES,TextSeg                        ;Adressen fr nchsten Durchlauf setzen
  mov EAX,ES:[1016+0]
  mov dword ptr abSpritePtr[0],EAX
  mov EAX,ES:[1016+4]
  mov dword ptr abSpritePtr[4],EAX
  mov DI,RasterLine                     ;Kollisionen speichern fr Leerdurchlufe
  mov awVICEvents[EDI*2-51*2],DX
  movzx EBX,word ptr VIC[30]            ;Hiwords mssen 0 sein (auer EAX)
  or DX,BX
  cmp DL,BL                             ;Eine neue Sprite/Sprite-Kollision?
  je @@NoSprSpr
  mov VIC[30],DL                        ;Neue Kollision vermerken
  and BL,BL                             ;Kollision bereits gesetzt?
  jne @@NoSprSpr
  or VIC[25],00000100b                  ;Neues Ereignis vermerken
align 4
@@NoSprSpr:
  cmp DH,BH                             ;Eine neue Sprite/Hintergrund-Kollision?
  je @@NoSprChr
  mov VIC[31],DH                        ;Neue Kollision vermerken
  and BH,BH                             ;Kollision bereits gesetzt?
  jne @@NoSprChr
  or VIC[25],00000010b                  ;Neues Ereignis vermerken
align 4
@@NoSprChr:
  mov SI,offset DGROUP:Line+56          ;SI = Neuer Zeileninhalt
  add SI,ScrollX
  test VIC[22],00001000b
  jne Width40
  mov EAX,Frame32                       ;38-Zeichen-Modus
  mov dword ptr DS:[SI],EAX
  mov dword ptr DS:[SI+3],EAX
  mov DS:[SI+320-9],AL
  mov dword ptr DS:[SI+320-8],EAX
  mov dword ptr DS:[SI+320-4],EAX
  jmp Width38
Width40:
  mov EAX,Back32                        ;40-Zeichen-Modus
  mov dword ptr Line[56-8],EAX
  mov dword ptr Line[56-4],EAX
Width38:
  mov DI,RasterLine                     ;DI = offset Bildschirm
  sub DI,51
  imul DI,320
  mov CX,320/4
  cmp fLocalBus,0
  jne @@LocalBus
  mov ES,CacheSeg                       ;ES = Bildschirmcache
  mov AX,0A000h                         ;FS = VGA-Bildschirm
  mov FS,AX
  jmp @@Compare
align 4
@@Changed:
  mov EAX,DS:[SI-4]                     ;4 Pixel aus der Zeile holen,
  mov ES:[DI-4],EAX                     ;in den Cache schreiben
  mov FS:[DI-4],EAX                     ;und auf dem Bildschirm ausgeben
  jcxz NextLine
@@Compare:
  repe cmpsd                            ;Nach Unterschieden suchen
  jne @@Changed
  jmp NextLine
align 4
@@LocalBus:
  mov AX,0A000h                         ;ES = VGA-Bildschirm
  mov ES,AX
  rep movsd                             ;Zeile einfach umkopieren
NextLine label near
  cmp wSpriteDelay,0                    ;Eventuell 3 Clocks abziehen, falls
  je @@NoSpriteSub                      ;Sprites angezeigt wurden
  mov AX,wSpriteSub
  sub Clock,AX
@@NoSpriteSub:
  mov AL,VIC[25]                        ;Interruptereignisse prfen
  and AL,VIC[26]
  je UpdateSID
  ifdef DEBUG
    test Events,evIRQVIC                ;VIC-Int bereits gesetzt?
    jne UpdateSID
    TBEG INT
      test AL,00000001b
      je @@NoBit0
      mov DI,RasterLine
      if GERMAN
        INFO "VIC lst Rasterinterrupt bei Zeile %04X aus",<DI>
      else
        INFO "VIC generates a raster interrupt on line %04X",<DI>
      endif
    @@NoBit0:
      test AL,00000010b
      je @@NoBit1
      if GERMAN
        INFO "VIC lst Interrupt wegen Sprite/Hintergrund-Kollision aus"
      else
        INFO "VIC generates an interrupt because of sprite to background collision"
      endif
    @@NoBit1:
      test AL,00000100b
      je @@NoBit2
      if GERMAN
        INFO "VIC lst Interrupt wegen Sprite/Sprite-Kollision aus"
      else
        INFO "VIC generates an interrupt because of sprite to sprite collision"
      endif
    @@NoBit2:
      test AL,00001000b
      je @@Ready
      if GERMAN
        INFO "VIC lst Lichtgriffelinterrupt aus"
      else
        INFO "VIC generates a light pen interrupt"
      endif
    @@Ready:
    TEND
  endif
  or Events,evIRQVIC                    ;Interrupt auslsen
  jmp UpdateSID
@@FirstTime:
  call GetPCTicks                       ;Zeit fr Verzgerung setzen
  mov adDelay[0],EBX
  mov adDelay[4],EDX
  mov adLast[0],EBX                     ;Zeit fr Echtzeitberechnung setzen
  mov adLast[4],EDX
  mov bHasDelayed,0                     ;Keine Verzgerung aufgetreten
  xor AX,AX                             ;Nchster Durchlauf anzeigen
  jmp @@NoRefresh
@@Delay:
  mov bHasDelayed,1
  jmp @@DelayLoop
@@Retrace:
  cmp wRefreshCounter,-1                ;Erster Durchlauf nach Start?
  je @@FirstTime
  mov EAX,dClocksPerRefresh             ;C64-Clocks weiterzhlen
  add adC64Ticks[0],EAX
  adc adC64Ticks[4],0
  mov EAX,dTicksPerRefresh              ;Verzgerungszhler weiterzhlen
  add adDelay[0],EAX
  adc adDelay[4],0
@@DelayLoop:
  call GetPCTicks                       ;Aktuelle Zeit nach EDX:EBX holen
  cmp EBX,adDelay[0]                    ;Mu gewartet werden?
  mov EAX,EDX
  sbb EAX,adDelay[4]
  jb @@Delay
  mov EAX,EBX                           ;Zeit dieses Refreshs festhalten
  sub EAX,adLast[0]                     ;und Differenz zum letzten Refresh
  mov adLast[0],EBX                     ;berechnen
  mov EBX,EDX
  sbb EBX,adLast[4]
  mov adLast[4],EDX
  jne @@WrongTiming                     ;Zur Sicherheit wegen Multitasking
  movzx EDX,awUpdate[0]                 ;Clocks Echtzeit pro Update berechnen
  mul EDX
  div dRealTicksPerRefresh
  mov awUpdate[2],AX
@@WrongTiming:
  mov AX,wRefreshCounter                ;Beim nchsten Durchlauf anzeigen?
  inc AX
  cmp AX,wRefresh
  jb @@NoRefresh
  cmp bHasDelayed,0                     ;Trat eine Verzgerung auf?
  jne @@HasDelayed
  mov EAX,adLast[0]                     ;Nein, dann aktuelle Zeit umkopieren
  mov adDelay[0],EAX
  mov EAX,adLast[4]
  mov adDelay[4],EAX
@@HasDelayed:
  mov bHasDelayed,0                     ;Keine Verzgerung aufgetreten
  xor AX,AX                             ;Zhler fr Anzeige zurcksetzen
@@NoRefresh:
  mov wRefreshCounter,AX
  xor EBX,EBX
  xor EDX,EDX
  xor AX,AX
  mov BH,VIC[32]                        ;Hat sich Rahmenfarbe gendert?
  cmp BH,bFrameColor
  je @@NoRetrace
  mov bFrameColor,BH
  mov AX,1001h                          ;Neue Rahmenfarbe setzen
  int 10h
  xor AX,AX
  jmp @@NoRetrace
align 4
@@RasterInt:
  or VIC[25],00000001b
  cmp wRefreshCounter,0                 ;Anzeige berspringen?
  je @@NoRasterInt
@@IdleCycle:
  cmp AX,51                             ;Rasterstrahl innerhalb des Schirms?
  jb NextLine
  cmp AX,51+200
  jae NextLine
  mov DI,AX                             ;Ereignisse beim letzen mal holen
  mov DX,awVICEvents[EDI*2-51*2]
  mov BX,word ptr VIC[30]               ;Hiwords mssen 0 sein (auer EAX)
  or DX,BX
  cmp DL,BL                             ;Eine neue Sprite/Sprite-Kollision?
  je @@NoSprSpr1
  mov VIC[30],DL                        ;Neue Kollision vermerken
  and BL,BL                             ;Kollision bereits gesetzt?
  jne @@NoSprSpr1
  or VIC[25],00000100b                  ;Neues Ereignis vermerken
@@NoSprSpr1:
  cmp DH,BH                             ;Eine neue Sprite/Hintergrund-Kollision?
  je NextLine
  mov VIC[31],DH                        ;Neue Kollision vermerken
  and BH,BH                             ;Kollision bereits gesetzt?
  jne NextLine
  or VIC[25],00000010b                  ;Neues Ereignis vermerken
  jmp NextLine
UpdateVIC endp

comment #  Neuberechnung des Timings
           -------------------------
Eine Verzgerung bei schnellen Rechnern wird berechnet, indem vor dem Start
des Emulators die Anzahl der PC-Ticks pro Refresh nach (dTicksPerRefresh)
gebracht wird. Die Variable (adDelay) wird um diesen Betrag erhht und es wird
solange gewartet, bis diese Zeit erreicht wird. Hierzu darf nicht Int28
verwendet werden, weil OS/2 sonst ruckelt. Falls im letzten von (wRefresh)
Durchlufen nicht gewartet wurde, dann hatte der Rechner nicht gengend
Leistung, und (adDelay) wird auf die aktuelle Zeit gesetzt.

Auerdem wird bei jedem vertikalen Retrace die verbrauchte Zeit gemessen. Aus
deren Verhltnis zu (dRealTicksPerRefresh) wird (awUpdate[1]) berechnet, die
tatschlich bentigte Zeit zwischen zwei Updates (PAL 63 us, NTSC 65 us).
#

;Verstrichene Zeit seit Emulationsstart nach EDX:EBX holen
code 4
EXP GetPCTicks,near
GetPCTicks proc near
  mov AL,04h
  cli
  mov EBX,adPCTicks[0]
  mov EDX,adPCTicks[4]
  out 43h,AL
  in AL,40h
  mov AH,AL
  in AL,40h
  sti
  xchg AL,AH
  cmp adPCTicks[0],EBX
  jne @@Underflow
  sub BX,AX
  ret
@@Underflow:
  cli
  mov EBX,adPCTicks[0]
  mov EDX,adPCTicks[4]
  sti
  ret
GetPCTicks endp

ende
