// Lautstrke und Klangeinstellungen regeln

#include "pc64.h"

BOOL FAR PASCAL SoundDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  SOUND sound;
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    for (i = 0; i < 2; i++) {
      HWND hwndScrollBar = GetDlgItem(hwnd, IDSB_VOLUME + i);
      SetScrollRange(hwndScrollBar, SB_CTL, 0, 15, FALSE);
      SetScrollPos(hwndScrollBar, SB_CTL, pfw->c.sound.abVolume[i], FALSE);
      SetDlgItemInt(hwnd, IDT_VOLUME + i, pfw->c.sound.abVolume[i], FALSE);
      if (i == 0 && !wAdlib || i == 1 && !wDSPBase) {
        WinSetAttr(hwndScrollBar, 0x78, FALSE);
        WinSetAttr(GetDlgItem(hwnd, IDT_VOLUME + i), 0x78, FALSE);
      }
    }
    for (i = 0; i < 2; i++) {
      CheckDlgButton(hwnd, IDB_SOUNDON + i, pfw->c.sound.abEnable[i]);
    }
    SetDlgItemHex(hwnd, IDT_DETECTADLIB, wAdlib, 4);
    SetDlgItemHex(hwnd, IDT_DETECTDSP, wDSPBase, 4);
    wDialogHelp = IDM_OPTIONSSOUND;
    return TRUE;
  case WM_HSCROLL:
    {
      HWND hwndScrollBar = (HWND)HIWORD(lParam);
      assert(IsWindow(hwndScrollBar));
      i = GetWindowWord(hwndScrollBar, GWW_ID) - IDSB_VOLUME;
      assert(i >= 0 && i < 2);
      int iPos = GetScrollPos(hwndScrollBar, SB_CTL);
      switch (wParam) {
      case SB_LINEUP:
        iPos--;
        break;
      case SB_LINEDOWN:
        iPos++;
        break;
      case SB_PAGEUP:
        iPos -= 4;
        break;
      case SB_PAGEDOWN:
        iPos += 4;
        break;
      case SB_TOP:
        iPos = 0;
        break;
      case SB_BOTTOM:
        iPos = 15;
        break;
      case SB_THUMBPOSITION:
      case SB_THUMBTRACK:
        iPos = (int)LOWORD(lParam);
        break;
      }
      if (iPos < 0) iPos = 0;
      else if (iPos > 15) iPos = 15;
      SetScrollPos(hwndScrollBar, SB_CTL, iPos, TRUE);
      SetDlgItemInt(hwnd, IDT_VOLUME + i, iPos, FALSE);
    }
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      for (i = 0; i < 2; i++) {
        sound.abVolume[i] = (byte)GetScrollPos(GetDlgItem(hwnd, IDSB_VOLUME + i), SB_CTL);
      }
      for (i = 0; i < 2; i++) {
        sound.abEnable[i] = (byte)IsDlgButtonChecked(hwnd, IDB_SOUNDON + i);
      }
      assert(pfw);
      if (memcmp(&sound, &pfw->c.sound, sizeof SOUND)) {
        pfw->c.sound = sound;
        pfw->fModified = TRUE;
        Database(pfw, TRUE);
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFSOUND)) {
        if (memcmp(&sound, &def.c.sound, sizeof SOUND)) {
          def.c.sound = sound;
          SaveDefault();
        }
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
