ORIGIN = PWB
ORIGIN_VER = 2.1.49
PROJ = pc64
PROJFILE = pc64.mak
DEBUG = 0

CC  = cl
CFLAGS_G  = /AL /W3 /G2 /DGERMAN=$(GERMAN) /J /BATCH
CFLAGS_D  = /f /Od /Zi /D_DEBUG
CFLAGS_R  = /f- /Os /Oe /Oa /Gs /DNDEBUG /Gf /W3
CXX  = cl
CXXFLAGS_G  = /AL /W4 /G2 /DMASTER=$(MASTER) /DGERMAN=$(GERMAN) /Yupc64.h\
        /BATCH
CXXFLAGS_D  = /f /Od /Zi /D_DEBUG
CXXFLAGS_R  = /f- /Os /Oe /Oa /Gs /DNDEBUG /Gf /W3
ASM  = ml
AFLAGS_G  = /Cp /W3 /DGERMAN=$(GERMAN)
AFLAGS_R  = /nologo
MAPFILE_D  = $(PROJ).map
MAPFILE_R  = NUL
LFLAGS_G  = /NOI /STACK:8100 /BATCH /ONERROR:NOEXE /SEG:256
LFLAGS_D  = /CO /MAP /NOFA /NOPACKC /NOPACKF /DYNAMIC:1024
LFLAGS_R  = /FAR /NOPACKF /PACKC /DYNAMIC:1024
LLIBS_G  = moveinit lhelp
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
ILFLAGS  = /a /e
LLIBS_R  = win2
LLIBS_D  = win2
RC  = rcmewel
RCFLAGS1  = /w
PCHSRC_CXX  = debug.cpp
CVFLAGS  = /25 /S
PBTDEPEND  = $(PROJ).exe
PREP  = prep
PROFILE  = profile
PLIST  = plist
PROFSET  = set
PROFNMAKE  = nmake
AFLAGS_D  = /Sf /Zi /Fl /D_DEBUG
NMFLAGS  =  MASTER=0 GERMAN=1

FILES  = DEBUG.CPP pc64.CPP IEC.CPP FLOPPY.CPP LINKASM.ASM EMULAT_D.ASM\
        EMULAT_R.ASM IOTAB_D.ASM IOTAB_R.ASM CPU_D.ASM CPU_R.ASM VIC_D.ASM\
        VIC_R.ASM CIA_D.ASM CIA_R.ASM SID_D.ASM SID_R.ASM ABOUT.CPP\
        JOYSTICK.CPP KEYBOARD.CPP MSG.CPP ROMS.CPP RUN.CPP DEFAULT.CPP\
        FLOPPIES.CPP TRACE.ASM DIRTREE.CPP ARRANGE.CPP FILEOPT.CPP FILTERS.CPP\
        EVENTS.CPP DESKTOP.CPP SEARCH.CPP ADJUST.CPP WINHELP.C LINKWND.CPP\
        pc64.DEF CLONE.CPP HARDWARE.CPP INITMENU.CPP WINTERNP.C TIMER.ASM\
        LINK.CPP PROGRESS.CPP FILEWND.CPP WNDPROC.CPP TIMING.CPP SOUND.CPP\
        STEXT.CPP SADR.CPP pc64.RC FILE.CPP DEVICE.CPP DIR.CPP PRINTER.CPP\
        COMPTEST.CPP readroms.cpp printopt.cpp IMAGE.CPP IMAGEASM.ASM
DEF_FILE  = pc64.DEF
OBJS  = DEBUG.obj pc64.obj IEC.obj FLOPPY.obj LINKASM.obj EMULAT_D.obj\
        EMULAT_R.obj IOTAB_D.obj IOTAB_R.obj CPU_D.obj CPU_R.obj VIC_D.obj\
        VIC_R.obj CIA_D.obj CIA_R.obj SID_D.obj SID_R.obj ABOUT.obj\
        JOYSTICK.obj KEYBOARD.obj MSG.obj ROMS.obj RUN.obj DEFAULT.obj\
        FLOPPIES.obj TRACE.obj DIRTREE.obj ARRANGE.obj FILEOPT.obj FILTERS.obj\
        EVENTS.obj DESKTOP.obj SEARCH.obj ADJUST.obj WINHELP.obj LINKWND.obj\
        CLONE.obj HARDWARE.obj INITMENU.obj WINTERNP.obj TIMER.obj LINK.obj\
        PROGRESS.obj FILEWND.obj WNDPROC.obj TIMING.obj SOUND.obj STEXT.obj\
        SADR.obj FILE.obj DEVICE.obj DIR.obj PRINTER.obj COMPTEST.obj\
        readroms.obj printopt.obj IMAGE.obj IMAGEASM.obj
RESS  = pc64.res

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .obj .res .c .cpp .asm .rcm .rc
.SUFFIXES: .obj .res .c .cpp .asm .rc

DEBUG.obj : DEBUG.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/Ycpc64.h /c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDEBUG.obj DEBUG.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/Ycpc64.h /c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDEBUG.obj DEBUG.CPP
<<
!ENDIF

pc64.obj : pc64.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /Fopc64.obj pc64.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /Fopc64.obj pc64.CPP
<<
!ENDIF

IEC.obj : IEC.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h resource.h\
        winternl.h device.h floppy.h link.h image.h printer.h window.h\
        wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoIEC.obj IEC.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoIEC.obj IEC.CPP
<<
!ENDIF

FLOPPY.obj : FLOPPY.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFLOPPY.obj FLOPPY.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFLOPPY.obj FLOPPY.CPP
<<
!ENDIF

LINKASM.obj : LINKASM.ASM
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoLINKASM.obj LINKASM.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoLINKASM.obj LINKASM.ASM
!ENDIF

EMULAT_D.obj : EMULAT_D.ASM emulat.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoEMULAT_D.obj EMULAT_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoEMULAT_D.obj EMULAT_D.ASM
!ENDIF

EMULAT_R.obj : EMULAT_R.ASM emulat.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoEMULAT_R.obj EMULAT_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoEMULAT_R.obj EMULAT_R.ASM
!ENDIF

IOTAB_D.obj : IOTAB_D.ASM iotab.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoIOTAB_D.obj IOTAB_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoIOTAB_D.obj IOTAB_D.ASM
!ENDIF

IOTAB_R.obj : IOTAB_R.ASM iotab.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoIOTAB_R.obj IOTAB_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoIOTAB_R.obj IOTAB_R.ASM
!ENDIF

CPU_D.obj : CPU_D.ASM cpu.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoCPU_D.obj CPU_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoCPU_D.obj CPU_D.ASM
!ENDIF

CPU_R.obj : CPU_R.ASM cpu.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoCPU_R.obj CPU_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoCPU_R.obj CPU_R.ASM
!ENDIF

VIC_D.obj : VIC_D.ASM vic.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoVIC_D.obj VIC_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoVIC_D.obj VIC_D.ASM
!ENDIF

VIC_R.obj : VIC_R.ASM vic.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoVIC_R.obj VIC_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoVIC_R.obj VIC_R.ASM
!ENDIF

CIA_D.obj : CIA_D.ASM cia.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoCIA_D.obj CIA_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoCIA_D.obj CIA_D.ASM
!ENDIF

CIA_R.obj : CIA_R.ASM cia.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoCIA_R.obj CIA_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoCIA_R.obj CIA_R.ASM
!ENDIF

SID_D.obj : SID_D.ASM sid.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoSID_D.obj SID_D.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoSID_D.obj SID_D.ASM
!ENDIF

SID_R.obj : SID_R.ASM sid.asm pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoSID_R.obj SID_R.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoSID_R.obj SID_R.ASM
!ENDIF

ABOUT.obj : ABOUT.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoABOUT.obj ABOUT.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoABOUT.obj ABOUT.CPP
<<
!ENDIF

JOYSTICK.obj : JOYSTICK.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoJOYSTICK.obj JOYSTICK.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoJOYSTICK.obj JOYSTICK.CPP
<<
!ENDIF

KEYBOARD.obj : KEYBOARD.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoKEYBOARD.obj KEYBOARD.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoKEYBOARD.obj KEYBOARD.CPP
<<
!ENDIF

MSG.obj : MSG.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h resource.h\
        winternl.h device.h floppy.h link.h image.h printer.h window.h\
        wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoMSG.obj MSG.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoMSG.obj MSG.CPP
<<
!ENDIF

ROMS.obj : ROMS.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoROMS.obj ROMS.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoROMS.obj ROMS.CPP
<<
!ENDIF

RUN.obj : RUN.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h resource.h\
        winternl.h device.h floppy.h link.h image.h printer.h window.h\
        wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoRUN.obj RUN.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoRUN.obj RUN.CPP
<<
!ENDIF

DEFAULT.obj : DEFAULT.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDEFAULT.obj DEFAULT.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDEFAULT.obj DEFAULT.CPP
<<
!ENDIF

FLOPPIES.obj : FLOPPIES.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFLOPPIES.obj FLOPPIES.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFLOPPIES.obj FLOPPIES.CPP
<<
!ENDIF

TRACE.obj : TRACE.ASM pc64.inc
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoTRACE.obj TRACE.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoTRACE.obj TRACE.ASM
!ENDIF

DIRTREE.obj : DIRTREE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDIRTREE.obj DIRTREE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDIRTREE.obj DIRTREE.CPP
<<
!ENDIF

ARRANGE.obj : ARRANGE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoARRANGE.obj ARRANGE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoARRANGE.obj ARRANGE.CPP
<<
!ENDIF

FILEOPT.obj : FILEOPT.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFILEOPT.obj FILEOPT.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFILEOPT.obj FILEOPT.CPP
<<
!ENDIF

FILTERS.obj : FILTERS.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFILTERS.obj FILTERS.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFILTERS.obj FILTERS.CPP
<<
!ENDIF

EVENTS.obj : EVENTS.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoEVENTS.obj EVENTS.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoEVENTS.obj EVENTS.CPP
<<
!ENDIF

DESKTOP.obj : DESKTOP.CPP pc64.h winhelp.h ..\version.h windows.h commdlg.h\
        dirtree.h resource.h winternl.h device.h floppy.h link.h image.h\
        printer.h help.h window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDESKTOP.obj DESKTOP.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDESKTOP.obj DESKTOP.CPP
<<
!ENDIF

SEARCH.obj : SEARCH.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoSEARCH.obj SEARCH.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoSEARCH.obj SEARCH.CPP
<<
!ENDIF

ADJUST.obj : ADJUST.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoADJUST.obj ADJUST.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoADJUST.obj ADJUST.CPP
<<
!ENDIF

WINHELP.obj : WINHELP.C window.h winhelp.h winternl.h windecls.h help.h\
        wprndev.h
!IF $(DEBUG)
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoWINHELP.obj WINHELP.C
<<
!ELSE
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoWINHELP.obj WINHELP.C
<<
!ENDIF

LINKWND.obj : LINKWND.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoLINKWND.obj LINKWND.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoLINKWND.obj LINKWND.CPP
<<
!ENDIF

CLONE.obj : CLONE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoCLONE.obj CLONE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoCLONE.obj CLONE.CPP
<<
!ENDIF

HARDWARE.obj : HARDWARE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoHARDWARE.obj HARDWARE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoHARDWARE.obj HARDWARE.CPP
<<
!ENDIF

INITMENU.obj : INITMENU.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoINITMENU.obj INITMENU.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoINITMENU.obj INITMENU.CPP
<<
!ENDIF

WINTERNP.obj : WINTERNP.C wmdilib.h wprivate.h window.h windecls.h winternl.h\
        wprndev.h
!IF $(DEBUG)
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoWINTERNP.obj WINTERNP.C
<<
!ELSE
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoWINTERNP.obj WINTERNP.C
<<
!ENDIF

TIMER.obj : TIMER.ASM
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoTIMER.obj TIMER.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoTIMER.obj TIMER.ASM
!ENDIF

LINK.obj : LINK.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoLINK.obj LINK.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoLINK.obj LINK.CPP
<<
!ENDIF

PROGRESS.obj : PROGRESS.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoPROGRESS.obj PROGRESS.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoPROGRESS.obj PROGRESS.CPP
<<
!ENDIF

FILEWND.obj : FILEWND.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFILEWND.obj FILEWND.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFILEWND.obj FILEWND.CPP
<<
!ENDIF

WNDPROC.obj : WNDPROC.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoWNDPROC.obj WNDPROC.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoWNDPROC.obj WNDPROC.CPP
<<
!ENDIF

TIMING.obj : TIMING.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoTIMING.obj TIMING.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoTIMING.obj TIMING.CPP
<<
!ENDIF

SOUND.obj : SOUND.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoSOUND.obj SOUND.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoSOUND.obj SOUND.CPP
<<
!ENDIF

STEXT.obj : STEXT.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoSTEXT.obj STEXT.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoSTEXT.obj STEXT.CPP
<<
!ENDIF

SADR.obj : SADR.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoSADR.obj SADR.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoSADR.obj SADR.CPP
<<
!ENDIF

pc64.res : pc64.RC ..\german.h dirtree.h resource.h
        $(RC) $(RCMFLAGS1) /r pc64.RC

FILE.obj : FILE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoFILE.obj FILE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoFILE.obj FILE.CPP
<<
!ENDIF

DEVICE.obj : DEVICE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDEVICE.obj DEVICE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDEVICE.obj DEVICE.CPP
<<
!ENDIF

DIR.obj : DIR.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h resource.h\
        winternl.h device.h floppy.h link.h image.h printer.h window.h\
        wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoDIR.obj DIR.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoDIR.obj DIR.CPP
<<
!ENDIF

PRINTER.obj : PRINTER.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoPRINTER.obj PRINTER.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoPRINTER.obj PRINTER.CPP
<<
!ENDIF

COMPTEST.obj : COMPTEST.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoCOMPTEST.obj COMPTEST.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoCOMPTEST.obj COMPTEST.CPP
<<
!ENDIF

readroms.obj : readroms.cpp pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /Foreadroms.obj readroms.cpp
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /Foreadroms.obj readroms.cpp
<<
!ENDIF

printopt.obj : printopt.cpp pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /Foprintopt.obj printopt.cpp
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /Foprintopt.obj printopt.cpp
<<
!ENDIF

IMAGE.obj : IMAGE.CPP pc64.h ..\version.h windows.h commdlg.h dirtree.h\
        resource.h winternl.h device.h floppy.h link.h image.h printer.h\
        window.h wprndev.h windecls.h
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /FoIMAGE.obj IMAGE.CPP
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /FoIMAGE.obj IMAGE.CPP
<<
!ENDIF

IMAGEASM.obj : IMAGEASM.ASM
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoIMAGEASM.obj IMAGEASM.ASM
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoIMAGEASM.obj IMAGEASM.ASM
!ENDIF


$(PROJ).exe : $(DEF_FILE) $(OBJS) $(RESS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
        $(LINKER) @$(PROJ).lrf >link.err
        $(RC) $(RCFLAGS2) $(RESS) $@

$(PROJ).pbt : 
        $(PROFSET) MAKEFLAGS=
        $(PROFNMAKE) $(NMFLAGS) -f $(PROJFILE) $(PBTDEPEND)
        $(PREP) /P $(PBTDEPEND) /OT $(PROJ).pbt


.c.obj :
!IF $(DEBUG)
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /Fo$@ $<
<<
!ELSE
        @$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /Fo$@ $<
<<
!ENDIF

.cpp.obj :
!IF $(DEBUG)
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_D) /Fo$@ $<
<<
!ELSE
        @$(CXX) @<<$(PROJ).rsp
/c $(CXXFLAGS_G)
$(CXXFLAGS_R) /Fo$@ $<
<<
!ENDIF

.asm.obj :
!IF $(DEBUG)
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /Fo$@ $<
!ELSE
        $(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /Fo$@ $<
!ENDIF

.rc.res :
        $(RC) $(RCMFLAGS1) /r $<


run: $(PROJ).exe
        $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
        CV $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
