// Verwaltung der emulierten Tastatur

#include "pc64.h"

flag SetKeyboard(FILEWND* pfw, flag fReport) {
  assert(pfw);
  if (*(long*)(lpKernel + 0x0A88) != 0x028D8D00) {
    if (!pfw->c.keyboard.fNationalKeys || !fReport) return TRUE;
    strcpy(pcStart, pfw->c.roms.aacName[1]);
    return ErrorBox(acStart, acUseBIOS);
  }
  if (pfw->c.keyboard.fNationalKeys) lpKernel[0x0A87] = 0x92;
  else lpKernel[0x0A87] = 0xA9;
  return TRUE;
}

BOOL FAR PASCAL KeyboardDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  KEYBOARD keyboard;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    CheckDlgButton(hwnd, IDB_NATIONALKEYS, pfw->c.keyboard.fNationalKeys);
    CheckDlgButton(hwnd, IDB_TABSWITCH, pfw->c.keyboard.fTabSwitch);
    wDialogHelp = IDM_OPTIONSKEYBOARD;
    break;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      keyboard.fNationalKeys = IsDlgButtonChecked(hwnd, IDB_NATIONALKEYS);
      keyboard.fTabSwitch = IsDlgButtonChecked(hwnd, IDB_TABSWITCH);
      if (memcmp(&keyboard, &pfw->c.keyboard, sizeof KEYBOARD)) {
        pfw->c.keyboard = keyboard;
        pfw->fModified = TRUE;
        Database(pfw, TRUE);
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFKEYBOARD)) {
        if (memcmp(&keyboard, &def.c.keyboard, sizeof KEYBOARD)) {
          def.c.keyboard = keyboard;
          SaveDefault();
        }
      }
      SetROMs(pfw);
      SetKeyboard(pfw, TRUE);
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
