// Filter fr aufzuzeichnende Ereignisse einstellen

#include "pc64.h"

BOOL FAR PASCAL FiltersDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  int i;
  FILTERS filters;
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    assert(pfw);
    for (i = 0; i < 8; i++) {
      CheckDlgButton(hwnd, IDB_FILTERS + i, pfw->c.filters.wFlags & 1 << i);
    }
    wDialogHelp = IDM_RUNFILTERS;
    break;
  case WM_COMMAND:
    switch (wParam) {
    case IDB_ALL:
    case IDB_NONE:
      for (i = 0; i < 8; i++) {
        CheckDlgButton(hwnd, IDB_FILTERS + i, wParam == IDB_ALL);
      }
      SetFocus(GetDlgItem(hwnd, IDB_FILTERS));
      break;
    case IDOK:
      filters.wFlags = 0;
      for (i = 0; i < 8; i++) {
        if (IsDlgButtonChecked(hwnd, IDB_FILTERS + i)) {
          filters.wFlags |= 1 << i;
        }
      }
      if (memcmp(&filters, &pfw->c.filters, sizeof FILTERS)) {
        pfw->c.filters = filters;
        pfw->fModified = TRUE;
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
