// Kompatibilittstest bei unbekanntem Diskettenlaufwerk

#include "pc64.h"

CLink* pLink;
char* pcType;

static void SetSwitch(HWND hwnd, word wID, char* pcEntry, flag fYes) {
  SetDlgItemText(hwnd, wID, fYes ? "Ja" : "Nein");
  WritePrivateProfileString(pcType, pcEntry, fYes ? "1" : "0", "DRIVES.INI");
}

BOOL FAR PASCAL CompTestDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    SetWindowText(hwnd, pcType);
    return TRUE;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      {
        SetDlgItemText(hwnd, IDT_GETRELLENGTH, "ungeprft");
        SetDlgItemText(hwnd, IDT_CREATEDEL, "ungeprft");
        SetDlgItemText(hwnd, IDT_IMAGE, "ungeprft");
        SetDlgItemText(hwnd, IDT_FASTLOAD, "ungeprft");
        iRetries = 50;
        char ac[40];
        pLink->Command("I", 1);
        if (pLink->GetError(ac, 40)) {
          return ErrorBox(NULL, ac);
        }
        iRetries = 50;
        pLink->Command("S:(PC64COMPTEST)", 16);
        pLink->Open(2, "(PC64COMPTEST),L,X", 18);
        if (pLink->GetError(ac, 40)) {
          return ErrorBox(NULL, ac);
        }
        pLink->Close(2);
        iRetries = 50;
        pLink->Open(3, "(PC64COMPTEST),L", 16);
        if (pLink->GetError(ac, 40)) {
          pLink->Command("S:(PC64COMPTEST)", 16);
          return ErrorBox(NULL, ac);
        }
        iRetries = 50;
        SetSwitch(hwnd, IDT_GETRELLENGTH, "ReadRecordLength", pLink->GetRelLength(3) == 'X');
        pLink->Close(3);
        pLink->Command("S:(PC64COMPTEST)", 16);
        iRetries = 50;
        pLink->Open(2, "(PC64COMPTEST),D,W", 18);
        if (pLink->GetError(ac, 40)) {
          return ErrorBox(NULL, ac);
        }
        pLink->Close(2);
        iRetries = 50;
        pLink->Command("S:(PC64COMPTEST)=S", 18);
        if (pLink->GetError(ac, 40) != 1) {
          pLink->Command("S:(PC64COMPTEST)", 16);
          return ErrorBox(NULL, ac);
        }
        char* pc = strtok(ac, ",");
        assert(pc);
        pc = strtok(NULL, ",");
        assert(pc);
        pc = strtok(NULL, ",");
        assert(pc);
        flag fDEL = !atoi(pc);
        SetSwitch(hwnd, IDT_CREATEDEL, "CreateDELFile", fDEL);
        if (fDEL) {
          pLink->Command("S:(PC64COMPTEST)", 16);
        }
        iRetries = 50;
        flag fImage = pLink->CompliantImage(ac, 40);
        if (ac[0]) {
          return ErrorBox(NULL, ac);
        }
        SetSwitch(hwnd, IDT_IMAGE, "CompliantImage", fImage);
        if (fImage) {
          gpbError = (byte*)malloc(683);
          assert(gpbError);
          iRetries = 50;
          fImage = pLink->BeginTrack(FALSE);
          if (fImage) {
            byte* pbBuffer = (byte*)malloc(21 * 256);
            assert(pbBuffer);
            word wBytes;
            for (int i = 1; i <= 18; i++) {
              iRetries = 50;
              wBytes = pLink->ReadNextTrack(pbBuffer);
              assert(wBytes <= 21 * 256);
              if (!wBytes) {
                break;
              }
            }
            if (wBytes != 19 * 256 || pbBuffer[0] != 18 || pbBuffer[1] != 1 || pbBuffer[2] != 'A') {
              fImage = FALSE;
            }
            free(pbBuffer);
            pLink->EndTrack();
          }
          free(gpbError);
          gpbError = NULL;
        }
        SetSwitch(hwnd, IDT_FASTLOAD, "UseL64FastAccess", fImage);
      }
    case IDCANCEL:
      EndDialog(hwnd, 0);
      return TRUE;
    }
  }
  return FALSE;
}
