/*
  These definitions must be exactly the same like the ones in WINMDI.C
*/
#define MEWEL  1
#define MODSOFT
#define NEW_PROP
#define NOGDI
#define NOGRAPHICS
#define NOKERNEL
#include "wmdilib.h"

/*
  Get window state, normal and iconic position
*/
extern int FAR PASCAL GetInternalWindowPos(HWND hwnd, LPRECT prc, LPPOINT ppt)
{
  WINDOW *pw = WID_TO_WIN(hwnd);

  /*
    Get the true window RECT even in zoomed or iconic state
  */
  if (pw->pRestoreInfo) *prc = ((PRESTOREINFO)pw->pRestoreInfo)->rect;
  else if (IS_MDIDOC(pw) && pw->flags & WS_MAXIMIZE) {
    prc->left = (int)MdiGetProp(hwnd, PROP_LEFT);
    prc->top = (int)MdiGetProp(hwnd, PROP_TOP);
    ClientToScreen(GetParent(hwnd), (LPPOINT)prc);
    prc->right = prc->left + (int)MdiGetProp(hwnd, PROP_WIDTH);
    prc->bottom = prc->top + (int)MdiGetProp(hwnd, PROP_HEIGHT);
  } else *prc = pw->rect;

  /*
    MEWEL doesn't support icon positions, so set it to default
  */
  ppt->x = ppt->y = -1;

  /*
    Return the state for ShowWindow()
  */
  if (pw->flags & WS_MAXIMIZE) return SW_SHOWMAXIMIZED;
  else if (pw->flags & WS_MINIMIZE) return SW_SHOWMINIMIZED;
  else return SW_SHOWNORMAL;
}

/*
  The counterpart would be:

    BOOL FAR PASCAL SetInternalWindowPos(HWND, int, LPRECT, LPPOINT);

  But as
  - this is done by MDI automatically and
  - MEWEL doesn't support icon positions and
  - I'am very lazy...
*/
