/*===========================================================================*/
/*                                                                           */
/* File    : WINDOWS.H                                                       */
/*                                                                           */
/* Purpose : Dummy Windows-compatible include file for MEWEL                 */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1989-1993 Marc Adler/Magma Systems     All Rights Reserved  */
/*===========================================================================*/

#ifndef _INC_WINDOWS
#ifndef __WINDOWS_H

#define _INC_WINDOWS
#define __WINDOWS_H

#include "window.h"

#ifndef RC_INVOKED

#ifdef __cplusplus
extern "C" {
#endif

BOOL    FAR PASCAL FillRgn(HDC, HRGN, HBRUSH);
BOOL    FAR PASCAL FrameRgn(HDC, HRGN, HBRUSH, int, int);
BOOL    FAR PASCAL InvertRgn(HDC, HRGN);
BOOL    FAR PASCAL PaintRgn(HDC, HRGN);
BOOL    FAR PASCAL PtInRegion(HRGN, int, int);

BOOL    FAR PASCAL CallMsgFilter(LPMSG, int);
BOOL    FAR PASCAL EnumTaskWindows(HANDLE, FARPROC, LONG);
VOID    FAR PASCAL FatalExit(int);
VOID    FAR PASCAL GetKeyboardState(BYTE FAR *);
BOOL    FAR PASCAL IsTwoByteCharPrefix(char);
VOID    FAR PASCAL SetKeyboardState(BYTE FAR *);


/****************************************************************************/
/*                                                                          */
/*     SOUND-type stuff not supported in MEWEL....                          */
/*                                                                          */
/****************************************************************************/
#ifndef NOSOUND
int   FAR PASCAL SetVoiceQueueSize(int, int);
int   FAR PASCAL SetVoiceEnvelope(int, int, int);
int   FAR PASCAL SetSoundNoise(int, int);
int   FAR PASCAL StopSound(VOID);
int   FAR PASCAL SyncAllVoices(VOID);
int   FAR PASCAL CountVoiceNotes(int);
LPINT FAR PASCAL GetThresholdEvent(VOID);
int   FAR PASCAL GetThresholdStatus(VOID);
int   FAR PASCAL SetVoiceThreshold(int, int);
#endif

/****************************************************************************/
/*                                                                          */
/*     KERNEL-type stuff not supported in MEWEL....                         */
/*                                                                          */
/****************************************************************************/
VOID    FAR PASCAL DebugBreak();
VOID    FAR PASCAL FreeLibrary(HANDLE);
BOOL    FAR PASCAL FreeModule(HANDLE);
HANDLE  FAR PASCAL GetCodeHandle(FARPROC);
VOID    FAR PASCAL GetCodeInfo(FARPROC, LPVOID);
WORD    FAR PASCAL GetCurrentPDB(VOID);
int     FAR PASCAL GetModuleUsage(HANDLE);
FARPROC FAR PASCAL GetProcAddress(HANDLE, LPSTR);
VOID    FAR PASCAL LimitEmsPages(DWORD);
HANDLE  FAR PASCAL LoadLibrary(LPSTR);
HANDLE  FAR PASCAL LoadModule(LPSTR, LPVOID);
HANDLE  FAR PASCAL LockSegment(WORD);
WORD    FAR PASCAL SetHandleCount(WORD);
LONG    FAR PASCAL SetSwapAreaSize(WORD);
VOID    FAR PASCAL SwapRecording(WORD);
VOID    FAR PASCAL SwitchStackBack();
VOID    FAR PASCAL SwitchStackTo(WORD, WORD, WORD);
HANDLE  FAR PASCAL UnlockSegment(WORD);
VOID    FAR PASCAL ValidateCodeSegments(VOID);
LPSTR   FAR PASCAL ValidateFreeSpaces(VOID);

/****************************************************************************/
/*                                                                          */
/*                WINDOWS 3.1 specific definitions                          */
/*                                                                          */
/****************************************************************************/

#ifndef _WIN31_H
#define _WIN31_H

#if (WINVER >= 0x030a)

/*
  BOOL WINAPI EnableScrollBar(HWND hWnd, int nBar, UINT flags)
*/
#ifdef __cplusplus
inline BOOL WINAPI EnableScrollBar(HWND hWnd, int nBar, UINT flags)
{
  (VOID) hWnd;  (VOID) nBar;  (VOID) flags;
  return TRUE;
}
#else
#define EnableScrollBar(hWnd, nBar, flags)    (TRUE)
#endif
#define ESB_ENABLE_BOTH     0x0000
#define ESB_DISABLE_BOTH    0x0003
#define ESB_DISABLE_LEFT    0x0001
#define ESB_DISABLE_RIGHT   0x0002
#define ESB_DISABLE_UP      0x0001
#define ESB_DISABLE_DOWN    0x0002
#define ESB_DISABLE_LTUP    ESB_DISABLE_LEFT
#define ESB_DISABLE_RTDN    ESB_DISABLE_RIGHT

/* 
  HDC WINAPI GetDCEx(HWND hwnd, HRGN hrgnClip, DWORD flags);
*/
#ifdef __cplusplus
inline HDC WINAPI GetDCEx(HWND hwnd, HRGN hrgnClip, DWORD flags)
{
  (VOID) hrgnClip;   (VOID) flags;
  return GetDC(hwnd);
}
#else
#define GetDCEx(hwnd, hrgnClip, flags)    GetDC(hwnd)
#endif
#define DCX_WINDOW          0x00000001L
#define DCX_CACHE           0x00000002L
#define DCX_CLIPCHILDREN    0x00000008L
#define DCX_CLIPSIBLINGS    0x00000010L
#define DCX_PARENTCLIP      0x00000020L
#define DCX_EXCLUDERGN      0x00000040L
#define DCX_INTERSECTRGN    0x00000080L
#define DCX_LOCKWINDOWUPDATE 0x00000400L
#define DCX_USESTYLE        0x00010000L

/*
  BOOL WINAPI LockWindowUpdate(HWND hwndLock);
*/
#ifdef __cplusplus
inline BOOL WINAPI LockWindowUpdate(HWND hwndLock)
{
  (void) hwndLock;
  return TRUE;
}
#else
#define LockWindowUpdate(hwndLock)     (TRUE)
#endif

/*
  VOID WINAPI MapWindowPoints(HWND hwndFrom, HWND hwndTo, 
                              POINT FAR* lppt, UINT cpt);
*/
#ifdef __cplusplus
inline VOID WINAPI MapWindowPoints(HWND hwndFrom, HWND hwndTo, 
                                   POINT FAR* lppt, UINT cpt)
{
  (VOID) hwndFrom;   (VOID) hwndTo;  (VOID) lppt;  (VOID) cpt;
}
#else
#define MapWindowPoints(hwndFrom, hwndTo, lppt, cpt)
#endif

/* 
  BOOL WINAPI QueryAbort(HDC, int);
*/
#ifdef __cplusplus
inline BOOL WINAPI QueryAbort(HDC hDC, int reserved)
{
  (VOID) hDC;  (VOID) reserved;
  return TRUE;
}
#else
#define QueryAbort(hDC, reserved)     (TRUE)
#endif

/*
  BOOL WINAPI RedrawWindow(HWND hwnd, CONST RECT FAR* lprcUpdate, 
                           HRGN hrgnUpdate, UINT flags);
*/
#ifdef __cplusplus
inline BOOL WINAPI RedrawWindow(HWND hwnd, CONST RECT FAR* lprcUpdate, 
                         HRGN hrgnUpdate, UINT flags)
{
  (VOID) hwnd;  (VOID) lprcUpdate;  (VOID) hrgnUpdate;  (VOID) flags;
  return TRUE;
}
#else
#define RedrawWindow(hwnd, lprcUpdate, hrgnUpdate, flags)   (TRUE)
#endif
#define RDW_INVALIDATE     0x0001
#define RDW_INTERNALPAINT  0x0002
#define RDW_ERASE          0x0004
#define RDW_VALIDATE       0x0008
#define RDW_NOINTERNALPAINT  0x0010
#define RDW_NOERASE        0x0020
#define RDW_NOCHILDREN     0x0040
#define RDW_ALLCHILDREN    0x0080
#define RDW_UPDATENOW      0x0100
#define RDW_ERASENOW       0x0200
#define RDW_FRAME          0x0400
#define RDW_NOFRAME        0x0800

/*
  int WINAPI ScrollWindowEx(HWND hwnd, int dx, int dy,...);
*/
#ifdef __cplusplus
inline int WINAPI ScrollWindowEx(HWND hwnd, int dx, int dy,
                   CONST RECT FAR* prcScroll, CONST RECT FAR* prcClip,
                   HRGN hrgnUpdate, RECT FAR* prcUpdate, UINT flags)
{
  (void) hrgnUpdate;  (void) prcUpdate;  (void) flags;
  ScrollWindow(hwnd,dx,dy,prcScroll,prcClip);
  return TRUE;
}
#else
#define ScrollWindowEx(hwnd,dx,dy,prcScroll,prcClip,hrgnUpdate,prcUpdate,flags) \
  ScrollWindow(hwnd,dx,dy,prcScroll,prcClip)
#endif
#define SW_SCROLLCHILDREN   0x0001
#define SW_INVALIDATE       0x0002
#define SW_ERASE            0x0004


/*
  UINT    WINAPI SetBoundsRect(HDC hDC, CONST RECT FAR* lprcBounds, UINT flags);
*/
#ifdef __cplusplus
inline UINT WINAPI SetBoundsRect(HDC hDC, CONST RECT FAR* lprcBounds, UINT flags)
{
  (void) hDC;  (void) lprcBounds;  (void) flags;
  return 0;
}
#else
#define SetBoundsRect(hDC, lprcBounds, flags)  (0)
#endif

/*
  UINT    WINAPI GetBoundsRect(HDC hDC, RECT FAR* lprcBounds, UINT flags);
*/
#ifdef __cplusplus
inline UINT WINAPI GetBoundsRect(HDC hDC, RECT FAR* lprcBounds, UINT flags)
{
  (void) hDC;  (void) lprcBounds;  (void) flags;
  return 0;
}
#else
#define GetBoundsRect(hDC, lprcBounds, flags)  (0)
#endif


/* WM_WINDOWPOSCHANGING/CHANGED struct pointed to by lParam */
typedef struct tagWINDOWPOS
{
  HWND    hwnd;
  HWND    hwndInsertAfter;
  int     x;
  int     y;
  int     cx;
  int     cy;
  UINT    flags;
} WINDOWPOS, FAR* LPWINDOWPOS;

typedef struct tagWINDOWPLACEMENT
{
  UINT  length;
  UINT  flags;
  UINT  showCmd;
  POINT ptMinPosition;
  POINT ptMaxPosition;
  RECT  rcNormalPosition;
} WINDOWPLACEMENT, *PWINDOWPLACEMENT, FAR* LPWINDOWPLACEMENT;

#define WPF_SETMINPOSITION      0x0001
#define WPF_RESTORETOMAXIMIZED  0x0002

/*
  BOOL    WINAPI GetWindowPlacement(HWND, WINDOWPLACEMENT FAR*);
*/
#ifdef __cplusplus
inline BOOL WINAPI GetWindowPlacement(HWND hWnd, CONST WINDOWPLACEMENT FAR* lppl)
{
  (void) hWnd;  (void) lppl;
  return FALSE;
}
#else
#define GetWindowPlacement(hWnd, lppl)   (FALSE)
#endif

/*
  BOOL    WINAPI SetWindowPlacement(HWND, CONST WINDOWPLACEMENT FAR*);
*/
#ifdef __cplusplus
inline BOOL WINAPI SetWindowPlacement(HWND hWnd, CONST WINDOWPLACEMENT FAR* lppl)
{
  (void) hWnd;  (void) lppl;
  return FALSE;
}
#else
#define SetWindowPlacement(hWnd, lppl)   (FALSE)
#endif


/* WM_NCCALCSIZE return flags */
#define WVR_ALIGNTOP       0x0010
#define WVR_ALIGNLEFT      0x0020
#define WVR_ALIGNBOTTOM    0x0040
#define WVR_ALIGNRIGHT     0x0080
#define WVR_HREDRAW        0x0100
#define WVR_VREDRAW        0x0200
#define WVR_REDRAW         (WVR_HREDRAW | WVR_VREDRAW)
#define WVR_VALIDRECTS     0x0400

/* WM_NCCALCSIZE parameter structure */
typedef struct tagNCCALCSIZE_PARAMS
{
  RECT     rgrc[3];
  WINDOWPOS FAR* lppos;
} NCCALCSIZE_PARAMS, FAR* LPNCCALCSIZE_PARAMS;

/* Struct pointed to by WM_GETMINMAXINFO lParam */
typedef struct tagMINMAXINFO
{
  POINT ptReserved;
  POINT ptMaxSize;
  POINT ptMaxPosition;
  POINT ptMinTrackSize;
  POINT ptMaxTrackSize;
} MINMAXINFO;



#ifndef NOSCALABLEFONT
/*
  DWORD WINAPI GetFontData(HDC, DWORD, DWORD, VOID FAR*, DWORD);
*/
#ifdef __cplusplus
inline DWORD WINAPI GetFontData(HDC hDC, DWORD dwTable, DWORD dwOffset, 
                                VOID FAR* lpvBuf, DWORD cbData)
{
  (void) hDC;  (void) dwTable;  (void) dwOffset;  (void) lpvBuf;  (void) cbData;
  return 0L;
}
#else
#define GetFontData(hDC, dwTable, dwOffset, lpvBuf, cbData)  (0L)
#endif


/*
  BOOL  WINAPI CreateScalableFontResource(UINT, LPCSTR, LPCSTR, LPCSTR);
*/
#ifdef __cplusplus
inline BOOL  WINAPI CreateScalableFontResource(UINT fHidden, LPCSTR lpszRes, 
                                               LPCSTR lpszFont, LPCSTR lpszPath)
{
  (void) fHidden;  (void) lpszRes;  (void) lpszFont;  (void) lpszPath;
  return FALSE;
}
#else
#define CreateScalableFontResource(fHidden,lpszRes,lpszFont,lpszPath)  FALSE
#endif


typedef struct tagGLYPHMETRICS
{
    UINT    gmBlackBoxX;
    UINT    gmBlackBoxY;
    POINT   gmptGlyphOrigin;
    int     gmCellIncX;
    int     gmCellIncY;
} GLYPHMETRICS, FAR* LPGLYPHMETRICS;

typedef struct tagFIXED
{
    UINT    fract;
    int     value;
} FIXED, FAR* LPFIXED;

typedef struct tagMAT2
{
    FIXED  eM11;
    FIXED  eM12;
    FIXED  eM21;
    FIXED  eM22;
} MAT2, FAR* LPMAT2;

/*
  DWORD WINAPI GetGlyphOutline(HDC hDC, UINT uChar, UINT fuFormat, 
                               GLYPHMETRICS FAR* lpgm, DWORD cbBuffer,
                               VOID FAR *lpBuffer, CONST MAT2 FAR* lpMat2)
*/
#ifdef __cplusplus
inline DWORD WINAPI GetGlyphOutline(HDC hDC, UINT uChar, UINT fuFormat, 
                                    GLYPHMETRICS FAR* lpgm, DWORD cbBuffer,
                                    VOID FAR *lpBuffer, CONST MAT2 FAR* lpMat2)
{
  (void) hDC;  (void) uChar;  (void) fuFormat;  (void) lpgm;  (void) cbBuffer;
  (void) lpBuffer;  (void) lpMat2;
  return 0L;
}
#else
#define GetGlyphOutline(hDC,uChar,fuFormat,lpgm,cbBuffer,lpBuffer,lpMat2) (0L)
#endif

/* GetGlyphOutline constants */
#define GGO_METRICS        0
#define GGO_BITMAP         1
#define GGO_NATIVE         2

#define TT_POLYGON_TYPE   24

#define TT_PRIM_LINE       1
#define TT_PRIM_QSPLINE    2

typedef struct tagPOINTFX
{
    FIXED x;
    FIXED y;
} POINTFX, FAR* LPPOINTFX;

typedef struct tagTTPOLYCURVE
{
    UINT    wType;
    UINT    cpfx;
    POINTFX apfx[1];
} TTPOLYCURVE, FAR* LPTTPOLYCURVE;

typedef struct tagTTPOLYGONHEADER
{
    DWORD   cb;
    DWORD   dwType;
    POINTFX pfxStart;
} TTPOLYGONHEADER, FAR* LPTTPOLYGONHEADER;

typedef struct tagABC
{
  int   abcA;
  UINT  abcB;
  int   abcC;
} ABC;
typedef ABC FAR* LPABC;

/*
  BOOL WINAPI GetCharABCWidths(HDC hDC, UINT chFirst, UINT chLast, ABC FAR* lpabc);
*/
#ifdef __cplusplus
inline BOOL WINAPI GetCharABCWidths(HDC hDC, UINT chFirst, UINT chLast, 
                                    ABC FAR* lpabc)
{
  (void) hDC;  (void) chFirst;  (void) chLast;  (void) lpabc;
  return 0;
}
#else
#define GetCharABCWidths(hDC, chFirst, chLast, lpabc)  (0)
#endif


typedef struct tagKERNINGPAIR
{
  WORD wFirst;
  WORD wSecond;
  int  iKernAmount;
} KERNINGPAIR, FAR* LPKERNINGPAIR;

/*
  int WINAPI GetKerningPairs(HDC hDC, int nPairs, KERNINGPAIR FAR* lpkp)
*/
#ifdef __cplusplus
inline int WINAPI GetKerningPairs(HDC hDC, int nPairs, KERNINGPAIR FAR* lpkp)
{
  (void) hDC;  (void) nPairs;  (void) lpkp;
  return 0;
}
#else
#define GetKerningPairs(hDC, nPairs, lpkp)    (0)
#endif

typedef struct tagRASTERIZER_STATUS
{
    int   nSize;
    int   wFlags;
    int   nLanguageID;
} RASTERIZER_STATUS;
typedef RASTERIZER_STATUS FAR* LPRASTERIZER_STATUS;

/* bits defined in wFlags of RASTERIZER_STATUS */
#define TT_AVAILABLE  0x0001
#define TT_ENABLED  0x0002

/*
  BOOL WINAPI GetRasterizerCaps(RASTERIZER_STATUS FAR* lprs, int cb)
*/
#ifdef __cplusplus
inline BOOL WINAPI GetRasterizerCaps(RASTERIZER_STATUS FAR* lprs, int cb)
{
  (void) lprs;  (void) cb;
  return FALSE;
}
#else
#define GetRasterizerCaps(lprs, cb)   (FALSE)
#endif

typedef struct tagPANOSE
{
  BYTE    bFamilyType;
  BYTE    bSerifStyle;
  BYTE    bWeight;
  BYTE    bProportion;
  BYTE    bContrast;
  BYTE    bStrokeVariation;
  BYTE    bArmStyle;
  BYTE    bLetterform;
  BYTE    bMidline;
  BYTE    bXHeight;
} PANOSE, FAR* LPPANOSE;

typedef struct tagOUTLINETEXTMETRIC
{
  UINT    otmSize;
  TEXTMETRIC otmTextMetrics;
  BYTE    otmFiller;
  PANOSE  otmPanoseNumber;
  UINT    otmfsSelection;
  UINT    otmfsType;
  int     otmsCharSlopeRise;
  int     otmsCharSlopeRun;
  int     otmItalicAngle;
  UINT    otmEMSquare;
  int     otmAscent;
  int     otmDescent;
  UINT    otmLineGap;
  UINT    otmsCapEmHeight;
  UINT    otmsXHeight;
  RECT    otmrcFontBox;
  int     otmMacAscent;
  int     otmMacDescent;
  UINT    otmMacLineGap;
  UINT    otmusMinimumPPEM;
  POINT   otmptSubscriptSize;
  POINT   otmptSubscriptOffset;
  POINT   otmptSuperscriptSize;
  POINT   otmptSuperscriptOffset;
  UINT    otmsStrikeoutSize;
  int     otmsStrikeoutPosition;
  int     otmsUnderscorePosition;
  int     otmsUnderscoreSize;
  PSTR    otmpFamilyName;
  PSTR    otmpFaceName;
  PSTR    otmpStyleName;
  PSTR    otmpFullName;
} OUTLINETEXTMETRIC, FAR* LPOUTLINETEXTMETRIC;

/*
  WORD WINAPI GetOutlineTextMetrics(HDC hDC, UINT cbData, 
                                    OUTLINETEXTMETRIC FAR* lpotm)
*/
#ifdef __cplusplus
inline WORD WINAPI GetOutlineTextMetrics(HDC hDC, UINT cbData, 
                                         OUTLINETEXTMETRIC FAR* lpotm)
{
  (void) hDC;  (void) cbData;  (void) lpotm;
  return FALSE;
}
#else
#define GetOutlineTextMetrics(hDC, cbData, lpotm)    (FALSE)
#endif

#endif  /* NOSCALABLEFONT */

#ifdef __cplusplus
inline UINT WINAPI GetFreeSystemResources(UINT fuSysResource)
{
  (void) fuSysResource;
  return 0;
}
#else
#define GetFreeSystemResources(fuSysResource)  (0)
#endif
#define GFSR_SYSTEMRESOURCES   0x0000
#define GFSR_GDIRESOURCES      0x0001
#define GFSR_USERRESOURCES     0x0002

#endif  /* WINVER >= 0x030a */
#endif /* _WIN31_H */

#ifdef MEWELMAIN
extern int PASCAL WinMain(HANDLE, HANDLE, LPSTR, INT);
MEWELmain(0)
#endif

#ifdef __cplusplus
}
#endif

#endif /* RC_INVOKED   */
#endif /* __WINDOWS_H  */
#endif /* _INC_WINDOWS */

