;Routinen fr die Debug-Version

DEBUG equ 1
include pc64.inc

;Variablen und Funktionen in anderen Modulen
const 1
IMP CommandTable,word
data 1
extrn c sImage:byte
extrn awError:word
data? 1
extrn Akku:byte
extrn XWord:word
extrn YWord:word
extrn Flags_SignZero:word
extrn Overflow:byte
extrn StackPtr:word
extrn Events:byte
code 1
IMP Stop,near
IMP Update,near
extrn c vsprintf:far

;Speicher und Zeiger fr die Pufferverwaltung
TRACEMAX equ 100                        ;Anzahl der Zeilen im Trace-Puffer
DISKMAX equ 500                         ;Anzahl der Zeilen im Diskettenpuffer
DISKSAVE equ 16                         ;Zustzliche Zeilen Sicherheitszone
BUFFERS segment para public use16 'BSS'
abTraceBuf db TRACEMAX dup (80 dup (?))
  public abTraceBuf
abDiskBuf db DISKMAX+DISKSAVE dup (80 dup (?))
  public abDiskBuf
BUFFERS ends
data 4
lpLine dd abTraceBuf
  public lpLine
lpfnCheck dd DefCheck
wRunDebug dw ?
  public c wRunDebug
data? 4
lReadAdr dd ?
  public lReadAdr
lWriteAdr dd ?
  public lWriteAdr
wReadData dw ?
  public wReadData
wWriteData dw ?
  public wWriteData
pTrace dw ?
  public pTrace
nTrace dw ?
  public nTrace
pDisk dw ?
  public pDisk

;Default-Prozedur fr das berprfen von Registerwerten
code 4
DefCheck proc far
  ret
DefCheck endp

;Tabelle der Hexadezimalzahlen von 00 bis FF in ASCII
const 2
HexTable label word
  public HexTable
  i=0
  rept 256
    Lo substr <0123456789ABCDEF>,(i and 15)+1,1
    Hi substr <0123456789ABCDEF>,(i/16)+1,1
    LoChar catstr <'>,Lo,<'>
    HiChar catstr <'>,Hi,<'>
    db HiChar,LoChar
    i=i+1
  endm

;Definition eines Flagszustandes
FLDEF macro Mask,On,Off
  if i and Mask
    db '&On'
  else
    db '&Off'
  endif
endm

;Tabelle der Flag-Zustnde
const 4
FlagsTable label byte
  i=0
  rept 256
    FLDEF 10000000b,N,n
    FLDEF 01000000b,V,v
    FLDEF 00100000b,1,0
    FLDEF 00010000b,B,b
    FLDEF 00001000b,D,d
    FLDEF 00000100b,I,i
    FLDEF 00000010b,Z,z
    FLDEF 00000001b,C,c
    i=i+1
  endm

;Puffer auf Diskette schreiben
data? 2
hLogFile dw ?
  public C hLogFile
sLogFile db 80 dup (?)
  public C sLogFile
code 1
WriteBuffer proc near
  public WriteBuffer
  push DX
  mov DX,offset abDiskBuf
  mov BX,hLogFile
  cmp BX,0
  jle @@DontWrite
  mov CX,pDisk
  sub CX,DX
  jcxz @@DontWrite
  push DS
  mov AX,BUFFERS
  mov DS,AX
  mov AH,40h
  int 21h
  pop DS
  mov pDisk,DX
  jc @@Error
  cmp AX,CX
  jc @@DiskFull
@@DontWrite:
  mov pDisk,DX
  pop DX
  ret
@@Error:
  mov awError[0],offset ErrorMsg        ;Nicht Makro ERROR, weil Stop
  mov awError[2],CS                     ;den Puffer erneut schreibt
  mov awError[4],AX
  mov awError[6],offset DGROUP:sLogFile
  mov awError[8],DS
  jmp Stop
ErrorMsg db "Diskettenfehler Nummer %02X beim Schreiben in die Log-Datei %s!",0
@@DiskFull:
  mov awError[0],offset DiskFullMsg
  mov awError[2],CS
  mov awError[4],offset DGROUP:sLogFile
  mov awError[6],DS
  jmp Stop
DiskFullMsg db "Es ist nicht mehr gengend Plattenkapazitt fr die Log-Datei %s vorhanden!",0
WriteBuffer endp

;Befehl ausfhren im Debug-Modus
code 1
NextCmd proc near
  public NextCmd
  les DI,lpLine                         ;Register eintragen
  movzx BX,Akku
  mov AX,HexTable[EBX*2]
  mov ES:[DI+38],AX
  mov BX,XWord
  mov AX,HexTable[EBX*2]
  mov ES:[DI+41],AX
  mov BX,YWord
  mov AX,HexTable[EBX*2]
  mov ES:[DI+44],AX
  GETFLAGS
  shrd BX,AX,13
  and BX,0000011111111000b
  mov EAX,dword ptr FlagsTable[BX+0]
  mov ES:[DI+47],EAX
  mov EAX,dword ptr FlagsTable[BX+4]
  mov ES:[DI+51],EAX
  mov BX,StackPtr
  mov AX,HexTable[EBX*2-200h]
  mov ES:[DI+58],AX
  mov byte ptr ES:[DI+60],':'
  i=0
  rept 6
    inc BL
    movzx EAX,byte ptr GS:[BX]
    mov AX,HexTable[EAX*2]
    mov ES:[DI+61+i*3],AX
    i=i+1
  endm
FirstCmd label near
  public FirstCmd
  cmp pDisk,offset abDiskBuf+DISKMAX*80 ;Puffer auf Diskette schreiben?
  jb @@NotWrite
  call WriteBuffer
@@NotWrite:
  and BP,BP
  js Update
  call lpfnCheck                        ;Haltepunkte berprfen
  test wRunDebug,MSG_TRA                ;Adresse des Trace-Puffers feststellen
  jne @@TraceToDisk
  mov DI,pTrace
  lea AX,[DI+80]
  cmp AX,offset abTraceBuf+TRACEMAX*80  ;Ende des Ringpuffers bercksichtigen
  jne @@NoWrap
  mov AX,offset abTraceBuf
@@NoWrap:
  mov pTrace,AX
  mov AX,nTrace                         ;Anzahl der Zeilen im Puffer erhhen
  cmp AX,TRACEMAX
  jae @@SetLine
  inc AX
  mov nTrace,AX
  jmp @@SetLine
@@TraceToDisk:
  mov DI,pDisk                          ;Direkt in Diskettenpuffer schreiben
  lea AX,[DI+80]
  mov pDisk,AX
@@SetLine:
  mov word ptr lpLine,DI
  mov AX,BUFFERS                        ;Zeile mit Leerzeichen fllen
  mov ES,AX
  mov CX,80/4
  mov EAX,20202020h
  rep stosd
  mov word ptr ES:[DI-2],0A0Dh
  sub DI,80
  shld BX,SI,9                          ;Befehlsadresse eintragen
  and BX,0000000111111110b
  mov AX,HexTable[BX]
  mov ES:[DI+0],AX
  shrd BX,SI,15
  and BX,0000000111111110b
  mov AX,HexTable[BX]
  mov ES:[DI+2],AX
  lods byte ptr FS:[SI]                 ;Befehlsbyte holen und eintragen
  and EAX,000000FFh
  mov BX,HexTable[EAX*2]
  mov ES:[DI+5],BX
  jmp CommandTable[EAX*2]               ;Befehl ausfhren
NextCmd endp

;Einen Text in Assembler ausgeben
data? 4
fnContinue dw ?,?
  public fnContinue
wParam dw 8 dup (?,?)
  public wParam
pFormat dw ?
intseg 1
DumpText proc far
  public DumpText
  pop pFormat                           ;Offset der Zeichenkette
  pop fnContinue[2]                     ;Segment Zeichenkette/Rcksprung
  push AX                               ;Aufruf einer C-Funktion vorgesehen
  push BX
  push CX
  push DX
  push DI
  push ES
  push FS
  push GS
  mov DI,pDisk                          ;Gengend Platz im Ausgabepuffer?
  cmp DI,offset abDiskBuf+(DISKMAX+DISKSAVE-1)*80
  jae NotEnoughSave
  push DS                               ;Variable Parameter
  push offset DGROUP:wParam
  push fnContinue[2]                    ;Formatstring
  push pFormat
  push BUFFERS                          ;Ziel
  push DI
  call vsprintf                         ;Meldung ber C-Funktion ausgeben
  add SP,12
  mov BX,BUFFERS                        ;Mit Leerzeichen auf Lnge 78 fllen
  mov ES,BX
  add DI,AX
  mov CX,78
  sub CX,AX
  jb @@LineOverflow                     ;Zeile lnger als 78 Zeichen?
  mov AL,32
  rep stosb
@@LineOverflow:
  add DI,CX                             ;Zeiger auf nchste Zeile - 2
  mov AX,0A0Dh                          ;Mit CR/LF abschlieen
  stosw
  mov pDisk,DI                          ;Pufferzeiger anpassen
  pop GS                                ;Zurck zum Assembler-Makro
  pop FS                                ;INFO/WARNING
  pop ES
  pop DI
  pop DX
  pop CX
  pop BX
  pop AX
  jmp dword ptr fnContinue              ;Sprung hinter den String
DumpText endp

;Einen Text in C ausgeben
intseg 1
CMsg proc far
  public c CMsg
  push BP
  mov BP,SP
  push DI
  mov DI,pDisk                          ;Gengend Platz im Ausgabepuffer?
  cmp DI,offset abDiskBuf+(DISKMAX+DISKSAVE-1)*80
  jae NotEnoughSave
  lea AX,[BP+10]                        ;Variable Parameter
  push SS
  push AX
  push word ptr SS:[BP+8]               ;Formatstring
  push word ptr SS:[BP+6]
  push BUFFERS                          ;Ziel
  push DI
  call vsprintf                         ;Meldung ber C-Funktion ausgeben
  add SP,12
  mov BX,BUFFERS                        ;Mit Leerzeichen auf Lnge 78 fllen
  mov ES,BX
  add DI,AX
  mov CX,78
  sub CX,AX
  jb @@LineOverflow                     ;Zeile lnger als 78 Zeichen?
  mov AL,32
  rep stosb
@@LineOverflow:
  add DI,CX                             ;Zeiger auf nchste Zeile - 2
  mov AX,0A0Dh                          ;Mit CR/LF abschlieen
  stosw
  mov pDisk,DI                          ;Pufferzeiger anpassen
  pop DI                                ;Zurck zum C-Makro INFO/WARNING
  pop BP
  ret
NotEnoughSave label near
  ERROR "Interner Fehler: DISKSAVE equ %d ist zu wenig!",<DISKSAVE>
CMsg endp

;BCD-Zeit in EAX ausgeben
traceseg 1
DumpTime proc far
  public DumpTime
  shld EDI,EAX,8
  mov wParam[0],'A'
  test DI,0000000010000000b
  je @@AM
  mov wParam[0],'P'
@@AM:
  and DI,0000000001111111b
  mov wParam[2],DI
  shld EDI,EAX,16
  and DI,0000000011111111b
  mov wParam[4],DI
  shld EDI,EAX,24
  and DI,0000000011111111b
  mov wParam[6],DI
  mov DI,AX
  and EDI,0000000011111111b
  mov wParam[8],DI
  jmp DumpText
DumpTime endp

ende
