// Text, Adressen und Ereignisse suchen

#include "pc64.h"

static char* pcBuffer;
static char acMsg[80];
static flag (*SearchFunc)();
static long lTag;
static char cChar;
static long lStart;
static word wLength;
static word w;

static flag NextText() {
  if (wLength) {
    pcBuffer[wLength - 1] = 0;
    AnsiUpper(pcBuffer);
    char* pcFound = strstr(pcBuffer, acSearchText);
    if (pcFound) {
      w = pcFound - pcBuffer;
      return TRUE;
    }
  }
  return FALSE;
}

static flag PrevText() {
  if (wLength) {
    pcBuffer[wLength - 1] = 0;
    AnsiUpper(pcBuffer);
    char* pcFound = NULL;
    char* pc = pcBuffer - 1;
    while ((pc = strstr(pc + 1, acSearchText)) != NULL) {
      pcFound = pc;
    }
    if (pcFound) {
      w = pcFound - pcBuffer;
      return TRUE;
    }
  }
  return FALSE;
}

static flag Adr(char* pc) {
  const char acHex[256] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
  };
  word wAdr = acHex[pc[0]] << 12 | acHex[pc[1]] << 8 | acHex[pc[2]] << 4 | acHex[pc[3]];
  if (wAdr >= wSearchFrom && wAdr <= wSearchTo) {
    if (acHex[pc[0]] >= 0 && acHex[pc[1]] >= 0 && acHex[pc[2]] >= 0 && acHex[pc[3]] >= 0) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag NextAdr() {
  for (w = 0; w < wLength; w += 80) {
    if (Adr(pcBuffer + w + 0) || Adr(pcBuffer + w + 26)) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag PrevAdr() {
  for (w = wLength - 80; w < (word)-80; w -= 80) {
    if (Adr(pcBuffer + w + 0) || Adr(pcBuffer + w + 26)) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag NextTag() {
  for (w = 0; w < wLength; w += 80) {
    if (*(long*)(pcBuffer + w + 1) == lTag) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag PrevTag() {
  for (w = wLength - 80; w < (word)-80; w -= 80) {
    if (*(long*)(pcBuffer + w + 1) == lTag) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag NextChar() {
  for (w = 0; w < wLength; w += 80) {
    if (pcBuffer[w] == cChar) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag PrevChar() {
  for (w = wLength - 80; w < (word)-80; w -= 80) {
    if (pcBuffer[w] == cChar) {
      return TRUE;
    }
  }
  return FALSE;
}

static flag Block() {
  word wSize = 40000;
  if (fSearchBack) {
    if (lStart >= 40000) {
      lStart -= 40000;
    } else {
      wSize = (word)lStart;
      lStart = 0;
    }
  }
  _llseek(hLogFile, lStart, 0);
  wLength = _lread(hLogFile, pcBuffer, wSize);
  if (wLength == (word)-1) {
    ErrorBox(sLogFile, NULL);
    return TRUE;
  }
  if (!wLength) {
    MessageBeep(MB_ICONEXCLAMATION);
    return TRUE;
  }
  if (SearchFunc()) {
    pfw->lPosition = (lStart + w) / 80;
    long lOffset = pfw->lPosition - pfw->lStart;
    if (lOffset < 0 || lOffset >= pfw->iHeight) {
      pfw->lStart = pfw->lPosition - (pfw->iHeight - 1) / 2;
    }
    AdjustFileWnd(pfw, hwndChild);
    InvalidateRect(hwndChild, NULL, FALSE);
    return TRUE;
  }
  if (!fSearchBack) {
    lStart += wLength;
  }
  return FALSE;
}

BOOL FAR PASCAL SearchingDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  static flag fAbort;
  switch (wMsg) {
  case WM_INITDIALOG:
    CenterWindow(hwnd);
    PostMessage(hwnd, WM_TIMER, 0, 0);
    return TRUE;
  case WM_TIMER:
    fAbort = FALSE;
    SetDlgItemText(hwnd, IDT_SEARCHSTR, acMsg);
    do {
      SetDlgItemProgress(hwnd, IDT_PROGRESS, lStart / 80, pfw->lSize);
    } while (!fAbort && !Block());
    EndDialog(hwnd, 0);
    return TRUE;
  case WM_COMMAND:
    fAbort = TRUE;
    return TRUE;
  }
  return FALSE;
}

static void DoSearch() {
  assert(pfw);
  assert(hLogFile);
  assert(hwndChild);
  pcBuffer = (char*)malloc(40000);
  assert(pcBuffer);
  if (!pcBuffer) {
    ErrorBox(NULL, apcDOSError[8]);
    return;
  }
  if (fSearchBack) {
    lStart = pfw->lPosition * 80;
  } else {
    lStart = pfw->lPosition * 80 + 80;
  }
  if (!Block() && !Block()) {
    DialogBox(hInst, "Searching", hwndFrame, (FARPROC)SearchingDlgProc);
  }
  free(pcBuffer);
}

void Search() {
  if (fSearchAdr) {
    if (wSearchFrom == wSearchTo) {
      #if GERMAN
        wsprintf(acMsg, "Adresse %04X", wSearchFrom);
      #else
        wsprintf(acMsg, "Address %04X", wSearchFrom);
      #endif
    } else {
      #if GERMAN
        wsprintf(acMsg, "Bereich von %04X bis %04X", wSearchFrom, wSearchTo);
      #else
        wsprintf(acMsg, "Range from %04X to %04X", wSearchFrom, wSearchTo);
      #endif
    }
    if (fSearchBack) {
      SearchFunc = PrevAdr;
    } else {
      SearchFunc = NextAdr;
    }
  } else {
    strcpy(acMsg, acSearchText);
    if (fSearchBack) {
      SearchFunc = PrevText;
    } else {
      SearchFunc = NextText;
    }
  }
  DoSearch();
}

void SearchTag(char* pcTag, flag fBack) {
  fSearchBack = fBack;
  if (strlen(pcTag) == 4) {
    #if GERMAN
      wsprintf(acMsg, "Ereignis %s", pcTag);
    #else
      wsprintf(acMsg, "Event %s", pcTag);
    #endif
    lTag = *(long*)pcTag;
    if (fSearchBack) {
      SearchFunc = PrevTag;
    } else {
      SearchFunc = NextTag;
    }
  } else {
    if (pcTag[0] == '\xFF') {
      #if GERMAN
        strcpy(acMsg, "Fehler");
      #else
        strcpy(acMsg, "Error");
      #endif
    } else {
      #if GERMAN
        strcpy(acMsg, "Trennstrich");
      #else
        strcpy(acMsg, "Line");
      #endif
    }
    cChar = pcTag[0];
    if (fSearchBack) {
      SearchFunc = PrevChar;
    } else {
      SearchFunc = NextChar;
    }
  }
  DoSearch();
}
