// Verwaltung der Systemsoftware

#include "pc64.h"

flag SetROMs(FILEWND* pfw) {
  static char aacOldName[4][13];
  assert(pfw);
  int i;
  if (pfw->c.roms.aacName[0][0] == '(') {
    bModule = 0;
    i = 1;
  } else {
    bModule = 8;
    i = 0;
  }
  int iSkip = -1;
  while (i < 4) {
    if (i != iSkip && strcmp(pfw->c.roms.aacName[i], aacOldName[i])) {
      strcpy(pcStart, pfw->c.roms.aacName[i]);
      OFSTRUCT of;
      int hFile = OpenFile(acStart, &of, OF_READ | OF_SHARE_DENY_WRITE);
      if (hFile == -1) {
        return ErrorBox(acStart);
      }
      int iResult;
      switch (i) {
      case 0:
        iResult = _lread(hFile, lpModule, 8192);
        if (iResult != 8192 || eof(hFile)) {
          break;
        }
        aacOldName[2][0] = 0;
        iSkip = 2;
      case 2:
        iResult = _lread(hFile, lpBasic, 8192);
        break;
      case 1:
        iResult = _lread(hFile, lpKernel, 8192);
        break;
      case 3:
        iResult = _lread(hFile, lpChar, 4096);
        break;
      }
      if (iResult == -1) {
        ErrorBox(acStart);
        _lclose(hFile);
        return FALSE;
      }
      flag fEof = (flag)eof(hFile);
      _lclose(hFile);
      if (!(iResult == 8192 || iResult == 4096 && i == 3) || !fEof) {
        return ErrorBox(acStart, acROMLength);
      }
      if (i == 1) {
        if (*(word*)(lpKernel + 0x1FB2) == 0xED0C &&
            *(word*)(lpKernel + 0x1FB5) == 0xED09 &&
            *(word*)(lpKernel + 0x1F94) == 0xEDB9 &&
            *(word*)(lpKernel + 0x1F97) == 0xEDC7 &&
            *(word*)(lpKernel + 0x1FA9) == 0xEDDD &&
            *(word*)(lpKernel + 0x1FA6) == 0xEE13 &&
            *(word*)(lpKernel + 0x1FAF) == 0xEDFE &&
            *(word*)(lpKernel + 0x1FAC) == 0xEDEF)
        {
          lpKernel[0x0D0C] = 0x02;
          lpKernel[0x0D0E] = 0x02;
          lpKernel[0x0D09] = 0x12;
          lpKernel[0x0DB9] = 0x22;
          lpKernel[0x0DC7] = 0x32;
          lpKernel[0x0DDD] = 0x42;
          lpKernel[0x0E13] = 0x52;
          lpKernel[0x0DFE] = 0x62;
          lpKernel[0x0DEF] = 0x72;
        } else {
          ErrorBox(acStart, acNoIEC);
        }
      }
      strcpy(aacOldName[i], pfw->c.roms.aacName[i]);
    }
    i++;
  }
  return TRUE;
}

BOOL FAR PASCAL ROMsDlgProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam) {
  ROMS roms;
  int i;
  switch (wMsg) {
  case WM_INITDIALOG:
    SetOptionDlgTitle(hwnd, pfw);
    if (pfw->c.roms.aacName[0][0] == '(') {
      memset(pfw->c.roms.aacName[0], 0, sizeof pfw->c.roms.aacName[0]);
      strcpy(pfw->c.roms.aacName[0], acNone);
    }
    SendDlgItemMessage(hwnd, IDL_ROMS + 0, LB_ADDSTRING, 0, (LONG)(LPSTR)acNone);
    strcpy(pcStart, "*.64?");
    for (i = 0; i < 4; i++) {
      pcStart[4] = "MKBC"[i];
      SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_DIR, 0, (LONG)(LPSTR)acStart);
      if (SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_SELECTSTRING, -1, (LONG)(LPSTR)pfw->c.roms.aacName[i]) == LB_ERR) {
        SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_SETCURSEL, (WORD)SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_ADDSTRING, 0, (LONG)(LPSTR)acUnknown), 0L);
      }
    }
    wDialogHelp = IDM_OPTIONSROMS;
    break;
  case WM_COMMAND:
    switch (wParam) {
    case IDOK:
      memset(&roms, 0, sizeof ROMS);
      for (i = 0; i < 4; i++) {
        int iSel = (int)SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_GETCURSEL, 0, 0);
        assert(iSel >= 0);
        int iLength = (int)SendDlgItemMessage(hwnd, IDL_ROMS + i, LB_GETTEXT, iSel, (LONG)(LPSTR)roms.aacName[i]);
        assert(iLength > 0);
        assert(iLength < 13);
      }
      if (memcmp(&roms, &pfw->c.roms, sizeof ROMS)) {
        pfw->c.roms = roms;
        pfw->fModified = TRUE;
        if (!SetROMs(pfw)) break;
        Database(pfw, TRUE);
        SetKeyboard(pfw, TRUE);
      }
      if (IsDlgButtonChecked(hwnd, IDB_DEFROMS)) {
        if (memcmp(&roms, &def.c.roms, sizeof ROMS)) {
          def.c.roms = roms;
          SaveDefault();
        }
      }
    case IDCANCEL:
      wDialogHelp = 0;
      EndDialog(hwnd, 0);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}
