// Klassendefinition eines ber das parallele Kabel angeschlossenen Gerts

class CLink : public CDevice {
  // Private Variablen
  word wLpt;           // Parallele Schnittstelle von 0 bis 3
  word wDevice;        // Gertenummer von 0 bis 15
  byte* apbBuffer[15]; // Zeiger auf Puffer
  word awIn[15];       // Index auf eingelesene Zeichen
  word awOut[15];      // Index auf ausgegebene Zeichen
  word awState[15];    // Gepufferter Status
  char sError[64];     // Fehlermeldung der letzten Operation
  char acType[40];     // Einschaltmeldung fr Kompatibilitt
  int iFastAccess;     // 0 = Nein, 1 = Ein, -1 = Aus
  flag fWriteTrack;
  word wTrack;
  byte __far* pbError;
  // Zeichen im Puffer auf Diskette schreiben
  word Flush(word wChannel);
  // Status holen und Fehlerkanal auslesen
  word GetState(flag fSet);
  // Auf Kompatibilitt prfen
  flag CanHandle(char* pcEntry, flag fSetError);
  // Fehler zurcksetzen fr Del-Test
  word NoError();
public:
  // Konstruktor
  CLink();
  // Destruktor
  ~CLink();
  // Typ liefern
  word GetType();
  // Verzeichnis setzen
  flag SetDir(char* pDir);
  // Verzeichnis liefern
  void GetDir(char* pDir, word wMax);
  // Floppy zurcksetzen
  word Reset();
  // Befehl abschicken
  word Command(char* sCommand, word wLength);
  // Fehlermeldung holen
  word GetError(char* pBuffer, word wMax);
  // Status in Image schreiben
  flag Save(int hFile);
  // Status aus Image lesen
  flag Load(int hFile);
  // C64-Dateien unter DOS ffnen
  word Start();
  // C64-Dateien unter DOS schlieen
  word Stop();
  // Datei oder Verzeichnis ffnen
  word Open(word wChannel, char* pcName, word wLength);
  // Zeichen in Datei schreiben
  word Put(word wChannel, byte bValue);
  // Ende Schreiben
  virtual word Unlisten();
  // Zeichen aus Datei lesen
  word Get(word wChannel);
  // Block schreiben
  word Write(word wChannel, byte* pbBuffer, word* pwCount);
  // Block lesen
  word Read(word wChannel, byte* pbBuffer, word* pwCount);
  // Datei schliessen
  word Close(word wChannel);
  // Satzlnge einer relativen Datei liefern
  byte GetRelLength(word wChannel);
  // Disketten kopieren
  flag CompliantImage(char* pcError, int iLength);
  flag BeginTrack(flag fWrite);
  word ReadNextTrack(byte* pbBuffer);
  flag WriteNextTrack(byte* pbBuffer, word wLength);
  flag EndTrack();
private:
  flag SetFastAccess(flag fOn);
  int __cdecl AskUser(word wButtons, char* pcFormat, ...);
  int AskJobError(byte bError, word wTrack, word wSector);
};

// Deklaration der Maschinensprachefunktionen
extern "C" byte __cdecl L64State[4];
extern "C" byte __cdecl L64LinkWaits[4];
extern "C" byte __cdecl L64JoyWaits[4];
extern "C" byte __cdecl L64AlternateJoy[4];
extern "C" int __cdecl L64Result;
extern "C" int __cdecl L64Send(word wLpt, void __far * fpBuffer, int iSize);
extern "C" int __cdecl L64Receive(word wLpt, void __far * fpBuffer, int iSize);
extern "C" int __cdecl L64Joystick(word wLpt);
