// Verwaltung der 1:1 Floppyimages

class CImage : public CDevice {
private:
  byte* pbBuffer;
  word wRAMSeg;
  char acFile[80];
  flag fWriteTrack;
  word wTrack;
public:
  // Konstruktor
  CImage();
  // Destruktor
  ~CImage();
  // Typ liefern
  word GetType();
  // Verzeichnis setzen
  flag SetDir(char* pDir);
  // Verzeichnis liefern
  void GetDir(char* pDir, word wMax);
  // Gert zurcksetzen
  word Reset();
  // Befehl abschicken
  word Command(char* sCommand, word wLength);
  // Fehlermeldung holen
  word GetError(char* pBuffer, word wMax);
  // Status in Image schreiben
  flag Save(int hFile);
  // Status aus Image lesen
  flag Load(int hFile);
  // Emulation beginnen
  word Start();
  // Emulation beenden
  word Stop();
  // Datei ffnen
  word Open(word wChannel, char* pcName, word wLength);
  // Zeichen schreiben
  word Put(word wChannel, byte bValue);
  // Ende Schreiben
  virtual word Unlisten();
  // Zeichen lesen
  word Get(word wChannel);
  // Block schreiben
  word Write(word wChannel, byte* pbBuffer, word* pwCount);
  // Block lesen
  word Read(word wChannel, byte* pbBuffer, word* pwCount);
  // Datei schlieen
  word Close(word wChannel);
  // Satzlnge einer relativen Datei liefern
  byte GetRelLength(word wChannel);
  // Disketten kopieren
  flag BeginTrack(flag fWrite);
  word ReadNextTrack(byte* pbBuffer);
  flag WriteNextTrack(byte* pbBuffer, word wLength);
  flag EndTrack();
  // Datum holen
  dword GetDateAndTime(word wChannel);
};
