;Hauptmodul des Assemblerteils, Hochspracheninterface und Speicherverwaltung

include pc64.inc

ifndef DEBUG

;Variablen in der Imagedatei
data? 4
ImageStart label near

;Ab hier Doppelwort-Ausrichtung
Frame32 dd ?                            ;4 mal die aktuelle Rahmenfarbe
  public Frame32
Back32 dd ?                             ;4 mal die aktuelle Hintergrundfarbe
  public Back32
abSpritePtr db 8 dup (?)                ;Adressen fr nchsten Update
  public abSpritePtr
Top_Bottom label dword                  ;Alias fr 32-Bit-Zugriff
  public Top_Bottom
VisibleTop dw ?                         ;Erste sichtbare Pixelzeile
  public VisibleTop
VisibleBottom dw ?                      ;Erste nicht sichtbare Pixelzeile
  public VisibleBottom
abCharBuf db 40 dup (?)                 ;Puffer fr aktuelle Zeile Text
  public abCharBuf
abColorBuf db 40 dup (?)                ;Puffer fr aktuelle Zeile Farbe
  public abColorBuf
wYOffset dw ?                           ;Zhler fr Zeile 0..7
  public wYOffset
ScrollX dw ?                            ;Bildverschiebung in X-Richtung
  public ScrollX
IRQLine dw ?                            ;Rasterzeile fr IRQ-Auslsung
  public IRQLine
VICBasePara dw ?                        ;Basisadresse VIC in Paragraphen
  public VICBasePara
RasterLine dw ?                         ;Aktuelle Rasterzeile von 0 bis 311
  public RasterLine
wYBlock dw ?                            ;Zellenblock von 0..24
  public wYBlock
awSpriteX dw 8 dup (?)                  ;X-Position der Sprites
  public awSpriteX
awSpriteYCount dw 8 dup (?)             ;Index in dargestelltes Bitmuster
  public awSpriteYCount
awSpriteYAdd dw 8 dup (?)               ;2 = einfache Hhe, 1 = doppelte Hhe
  public awSpriteYAdd
awVICEvents dw 200 dup (?)              ;Kollisionen bei Leerdurchlufen
  public awVICEvents
VIC db 47 dup (?)                       ;Emulierte Hardware-Register
  public VIC
bScreenOn db ?                          ;Bildschirm ist ein (nicht Randbereich)
  public bScreenOn

NoVICStart label near

dADSR3 dd ?                             ;Zhler fr KeyOn-Wechsel Stimme 3
  public dADSR3
dTime1Count dd ?                        ;Zhler 1/10 sec
  public dTime1Count
dTime2Count dd ?
  public dTime2Count
dTime1Add dd ?                          ;Startwert 1/10 sec (50 oder 60 Hz)
  public dTime1Add
dTime2Add dd ?
  public dTime2Add
abTime1 db 4 dup (?)                    ;Uhrzeit in BCD-Darstellung
  public abTime1
abTime2 db 4 dup (?)
  public abTime2
abAlarm1 db 4 dup (?)                   ;Alarmzeit in BCD-Darstellung
  public abAlarm1
abAlarm2 db 4 dup (?)
  public abAlarm2

;Ab hier Wort-Ausrichtung
ProgCounter dw ?                        ;Program Counter
  public ProgCounter
Clock dw ?                              ;Zhler fr periodisches Update
  public Clock
SaveDX dw ?                             ;CF und Schreiben D000 IO/Ram
  public SaveDX
StackPtr dw ?                           ;SP + 100h
  public StackPtr
XReg label byte                         ;X-Register
  public XReg
XWord dw ?                              ;X-Register fr Adreberechnung
  public XWord
YReg label byte                         ;Y-Register
  public YReg
YWord dw ?                              ;Y-Register fr Adreberechnung
  public YWord
Flags_SignZero label word               ;Fr schnelleren Zugriff
  public Flags_SignZero
Flags db ?                              ;BF (Bit 4), DF (Bit 3) und IF (Bit 2)
  public Flags
SignZero db ?                           ;NF (Bit 7) und ZF (Bit 6)
  public SignZero
CIA1 db 16 dup (?)                      ;Registersatz CIA 1
  public CIA1
CIA2 db 16 dup (?)                      ;Registersatz CIA 2
  public CIA2
Timer1A dw ?                            ;Aktuelle Zhlerstnde der CIA-Timer
  public Timer1A
Timer1B dw ?
  public Timer1B
Timer2A dw ?
  public Timer2A
Timer2B dw ?
  public Timer2B
CIAEvents dw ?                          ;Aufgetretene Ereignisse
  public CIAEvents
abAdlib db 256 dup (?)                  ;Inhalt der Soundkarte
  public abAdlib
wVolume dw ?                            ;Lautstrke fr Adlib 1..256
  public wVolume
wVolCounter dw ?                        ;Lautstrke in SID[24] wurde gendert
  public wVolCounter
abVolume db 6 dup (?)                   ;Lautstrken fr Modulator/Carrier
  public abVolume
wPaddleSet dw ?                         ;-4 = keins, 0 = Set 1, 4 = Set 2
  public wPaddleSet
abConfig db ?,?                         ;Tatschlicher Inhalt von 0 und 1
  public abConfig

;Ab hier Byte-Ausrichtung
SID db 29 dup (?)                       ;Emulierte Hardware-Register
  public SID
abPulse db 3 dup (?)                    ;Puls/Pause-Verhltnis 0..63
  public abPulse
Akku db ?                               ;Akkumulator
  public Akku
Overflow db ?                           ;VF (Bit 0)
  public Overflow
Events db ?                             ;Hardware-Ereignisse und Ende
  public Events
QueryState db ?                         ;Byte an DFFFh zur Emulatorerkennung
  public QueryState
abCellOn db 6 dup (?)                   ;-1 = Adlib-Stimme ist an, fr Freq = 0
  public abCellOn
bTime1Running db ?                      ;Uhrzeit wird weitergezhlt
  public bTime1Running
bTime2Running db ?
  public bTime2Running
bTime1Buffered db ?                     ;Uhrzeit wurde zum Lesen gepuffert
  public bTime1Buffered
bTime2Buffered db ?
  public bTime2Buffered

ImageEnd label near
const 2
pImageStart dw ImageStart
  public c pImageStart
iImageSize dw ImageEnd-ImageStart
  public c iImageSize

else

data?
extrn Flags:byte
extrn Flags_SignZero:word
extrn Overflow:byte
extrn StackPtr:word
extrn Events:byte
extrn Clock:word
extrn abConfig:byte

endif

;Variablen und Funktionen in anderen Modulen
data?
extrn c fTotalReset:word
extrn c iClocksPerInt:word
extrn c awUpdate:word
extrn c fLocalBus:word
extrn c bModule:byte
IMP CommandTable,word
extrn CacheSeg:word
code
extrn c vsprintf:far
extrn c ResetIEC:far
extrn c StartIEC:far
extrn c StopIEC:far
extrn ResetCPU:near
extrn ResetCIA:near
extrn ResetVIC:near
extrn ResetSID:near
IMP StartSID,near
IMP StartVIC,near
IMP StartCIA,near
IMP StartCPU,near
IMP UpdateCIA,near
IMP StopCPU,near
IMP StopCIA,near
IMP StopVIC,near
IMP StopSID,near
IMP JumpToIO,near

ifdef DEBUG

RAM segment para public use16 'BSS'
RAM ends
KERNEL segment para public use16 'BSS'
KERNEL ends
_BASIC segment para public use16 'BSS'
_BASIC ends
MODULE segment para public use16 'BSS'
MODULE ends
CHAR segment para public use16 'BSS'
CHAR ends
BUFFERS segment para public use16 'BSS'
extrn abTraceBuf:byte
extrn abDiskBuf:byte
BUFFERS ends
const
extrn HexTable:word
data
extrn c wRunDebug:word
extrn fnContinue:word
extrn pTrace:word
extrn nTrace:word
extrn pDisk:word
extrn wParam:word
extrn ReadConfig:word
extrn ReadTable:word
extrn WriteConfig:byte
data?
extrn c sImage:word
extrn c acRunError:byte
extrn awError:word
extrn SaveSP:word
extrn awEndDelay:word
code
extrn FirstCmd:near
extrn NextCmd:near
extrn WriteBuffer:near
traceseg
extrn DumpText:far

else

;Emulierter Speicher
RAM segment para public use16 'BSS'     ;64 KByte Hauptspeicher
  db 65535 dup (?)                      ;Para-Alignment rundet auf 65536 auf
RAM ends
KERNEL segment para public use16 'BSS'  ;Betriebssystem von E000 bis FFFF
  db 8192 dup (?)
KERNEL ends
_BASIC segment para public use16 'BSS'  ;Basic von A000 bis BFFF
  db 8192 dup (?)
_BASIC ends
MODULE segment para public use16 'BSS'  ;extrnes Modul von 8000 bis 9FFF
  db 8192 dup (?)
MODULE ends
CHAR segment para public use16 'BSS'    ;Zeichensatz von D000 bis DFFF
  db 4096 dup (?)
CHAR ends

;Far-Zeiger auf Speicherbereiche fr Hochsprache
const 4
lpRam dw 0,RAM
  public c lpRam
lpKernel dw 0,KERNEL
  public c lpKernel
lpBasic dw 0,_BASIC
  public c lpBasic
lpModule dw 0,MODULE
  public c lpModule
lpChar dw 0,CHAR
  public c lpChar

;Datenbereich fr die Funktion Emulate
data? 4
sImage dw 80 dup (?)
  public c sImage
acRunError db 256 dup (?)
  public c acRunError
awError dw 8 dup (?,?)
  public awError
SaveSP dw ?
  public SaveSP
awEndDelay dw ?,?
  public awEndDelay

;Speicherkonfigurationen (Bits 0 bis 2 an Adresse 1 und Bit 3 fr Modul)
data 4
ReadConfig label word
  public ReadConfig
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   RAM,   RAM,   RAM     ;0000
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   CHAR,  RAM,   RAM     ;0001
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   CHAR,  KERNEL,KERNEL  ;0010
  dw RAM,   RAM,   _BASIC,_BASIC,RAM,   CHAR,  KERNEL,KERNEL  ;0011
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   RAM,   RAM,   RAM     ;0100
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   0,     RAM,   RAM     ;0101
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   0,     KERNEL,KERNEL  ;0110
  dw RAM,   RAM,   _BASIC,_BASIC,RAM,   0,     KERNEL,KERNEL  ;0111
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   RAM,   RAM,   RAM     ;1000
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   CHAR,  RAM,   RAM     ;1001
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   CHAR,  KERNEL,KERNEL  ;1010
  dw MODULE,MODULE,_BASIC,_BASIC,RAM,   CHAR,  KERNEL,KERNEL  ;1011
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   RAM,   RAM,   RAM     ;1100
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   0,     RAM,   RAM     ;1101
  dw RAM,   RAM,   RAM,   RAM   ,RAM,   0,     KERNEL,KERNEL  ;1110
  dw MODULE,MODULE,_BASIC,_BASIC,RAM,   0,     KERNEL,KERNEL  ;1111
ReadTable dw RAM,RAM,RAM,RAM,RAM,RAM,RAM,RAM,8 dup (?)
  public ReadTable
WriteConfig db 0FFh,0FFh,0FFh,0FFh,0FFh,0D0h,0D0h,0D0h
  public WriteConfig

;Der Linker kann keine Segmentarithmetik durchfhren. Konstruktionen wie
;KERNEL-0E00h werden zwar nicht angemkelt, funktionieren aber nicht. Deshalb
;mssen die Segmentadressen bei Programmstart von Hand reloziert werden
code 1
RelocateSegments proc far
  public c RelocateSegments
  xor BX,BX
@@RelocNext:
  mov AX,ReadConfig[BX]
  mov CX,0E00h
  cmp AX,KERNEL
  je @@Found
  mov CX,0A00h
  cmp AX,_BASIC
  je @@Found
  mov CX,0800h
  cmp AX,MODULE
  je @@Found
  mov CX,0D00h
  cmp AX,CHAR
  je @@Found
  xor CX,CX
@@Found:
  sub ReadConfig[BX],CX
  add BL,2
  jne @@RelocNext
  ret
RelocateSegments endp

;Rechner zurcksetzen
code 1
Reset proc far
  public c Reset
  push BP
  push SI
  push DI
  call InitRegisters                    ;32-Bit-Register lschen
  mov AX,DS                             ;Variablen im Imagebereich zurcksetzen
  mov ES,AX
  mov DI,offset DGROUP:ImageStart
  mov CX,ImageEnd-ImageStart
  cmp fTotalReset,0
  jne @@DoResetVIC
  mov DI,offset DGROUP:NoVICStart
  mov CX,ImageEnd-NoVICStart
@@DoResetVIC:
  xor AX,AX
  rep stosb
  mov AX,RAM                            ;Speicherkonfiguration
  mov ES,AX
  mov word ptr ES:[0],0001011100000000b
  call ResetCPU                         ;Hardware zurcksetzen
  call ResetCIA
  cmp fTotalReset,0
  je @@DontResetVIC
  call ResetVIC
@@DontResetVIC:
  call ResetSID
  call ResetIEC
  pop DI
  pop SI
  pop BP
  ret
Reset endp

endif

;Schreibzugriff auf den CPU-Port an den Adressen 0 und 1
code 4
EXP WriteCPU,near
WriteCPU proc near
  mov abConfig[BX],AL                        ;Neuen Wert schreiben
  ifdef DEBUG
    TBEG CIA
    xor AH,AH
    and BX,BX
    je @@Direction
    if GERMAN
      INFO "Daten CPU Port schreiben (%02X)",<AX>
    else
      INFO "Write CPU port data (%02X)",<AX>
    endif
    jmp @@DataCont
  @@Direction:
    if GERMAN
      INFO "Richtung CPU Port schreiben (%02X)",<AX>
    else
      INFO "Write CPU port data direction (%02X)",<AX>
    endif
  @@DataCont:
    TEND
  endif
  mov AX,word ptr abConfig[0]           ;Eingnge Bit 0..4 auf 1
  mov BL,AL
  not BL
  and BL,00011111b
  or AH,BL
  mov BL,AL                             ;Eingang Bit 5 auf 0
  or BL,11011111b
  and AH,BL
  test AL,01000000b                     ;Eingang Bit 6 bernehmen
  jne @@NoGet6
  mov BL,GS:[1]
  and BL,01000000b
  and AH,10111111b
  or AH,BL
@@NoGet6:
  test AL,10000000b                     ;Eingang Bit 7 bernehmen
  jne @@NoGet7
  mov BL,GS:[1]
  and BL,10000000b
  and AH,01111111b
  or AH,BL
@@NoGet7:
  mov GS:[0],AX                         ;Fr das Auslesen durch CPU speichern
  ifdef DEBUG
    TBEG CIA
    mov AL,AH
    and AH,00000011b
    cmp AH,00000011b
    je @@Basic
    if GERMAN
      INFO2 "A000-BFFF = RAM"
    else
      INFO2 "A000-BFFF = RAM"
    endif
    jmp @@BasicOK
  @@Basic:
    cmp bModule,0
    je @@NoModule
    if GERMAN
      INFO2 "8000-9FFF = Modul lesen, RAM schreiben"
    else
      INFO2 "8000-9FFF = read from cartridge, write to RAM"
    endif
    if GERMAN
      INFO2 "A000-BFFF = Basic oder 16K-Modul lesen, RAM schreiben"
    else
      INFO2 "A000-BFFF = read from BASIC ROM or 16k cartridge, write to RAM"
    endif
    jmp @@BasicOK
  @@NoModule:
    if GERMAN
      INFO2 "A000-BFFF = Basic lesen, RAM schreiben"
    else
      INFO2 "A000-BFFF = read from BASIC ROM, write to RAM"
    endif
  @@BasicOK:
    test AL,00000011b
    jne @@IOorChar
    if GERMAN
      INFO2 "D000-DFFF = RAM"
    else
      INFO2 "D000-DFFF = RAM"
    endif
    jmp @@D000OK
  @@IOorChar:
    test AL,00000100b
    jne @@IO
    if GERMAN
      INFO2 "D000-DFFF = Zeichensatz lesen, RAM schreiben"
    else
      INFO2 "D000-DFFF = read from character generator ROM, write to RAM"
    endif
    jmp @@D000OK
  @@IO:
    if GERMAN
      INFO2 "D000-DFFF = Ein-/Ausgabebausteine"
    else
      INFO2 "D000-DFFF = Input/Output chips"
    endif
  @@D000OK:
    test AL,00000010b
    jne @@Kernel
    if GERMAN
      INFO2 "E000-FFFF = RAM"
    else
      INFO2 "E000-FFFF = RAM"
    endif
    jmp @@NoKernel
  @@Kernel:
    if GERMAN
      INFO2 "E000-FFFF = Kernal lesen, RAM schreiben"
    else
      INFO2 "E000-FFFF = read from KERNAL ROM, write to RAM"
    endif
  @@NoKernel:
    test AL,00001000b
    je @@NoBit3
    if GERMAN
      INFO2 "Bit 3 = 1: Schreibleitung Kassettenrecorder wird nicht untersttzt"
    else
      INFO2 "Bit 3 = 1: Cassette write line is not supported"
    endif
  @@NoBit3:
    test AL,00010000b
    jne @@Bit4
    if GERMAN
      INFO2 "Bit 4 = 0: Tastenabfrage Kassettenrecorder wird nicht untersttzt"
    else
      INFO2 "Bit 4 = 0: Cassette sense line is not supported"
    endif
  @@Bit4:
    test AL,00100000b
    jne @@Bit5
    if GERMAN
      INFO2 "Bit 5 = 0: Motorsteuerung Kassettenrecorder wird nicht untersttzt"
    else
      INFO2 "Bit 5 = 0: Cassette motor line is not supported"
    endif
  @@Bit5:
    TEND
  endif
ConfigMemory label near
  mov BL,GS:[1]                         ;Konfiguration holen
  and BX,0000000000000111b              ;Nur Speicherauswahl interessiert
  mov DH,WriteConfig[BX]                ;Eingeblendetes IO fr Schreiben
  or BL,bModule                         ;externes Modul nach Bit 3
  shl BX,4                              ;Neue Konfiguration setzen
  mov EAX,dword ptr ReadConfig[BX+0]
  mov dword ptr ReadTable[16+0],EAX
  mov EAX,dword ptr ReadConfig[BX+4]
  mov dword ptr ReadTable[16+4],EAX
  mov EAX,dword ptr ReadConfig[BX+8]
  mov dword ptr ReadTable[16+8],EAX
  mov EAX,dword ptr ReadConfig[BX+12]
  mov dword ptr ReadTable[16+12],EAX
  JUMP                                  ;Segmentbasis anpassen
  xor EAX,EAX                           ;EAX wird fr Indizierung gebraucht
  jmp CX                                ;Weiter im Programm
WriteCPU endp

;Register fr Emulation vorbereiten
code 1
InitRegisters proc near
  cld                                   ;Stringbefehle aufsteigend
  xor EAX,EAX                           ;Alle erweiterten Register wegen
  xor EBX,EBX                           ;32-Bit-Indizierung lschen
  xor ECX,ECX
  xor EDX,EDX
  xor ESI,ESI
  xor EDI,EDI
  xor EBP,EBP
  ret
InitRegisters endp

;Hochspracheneinsprung fr Emulation
code 1
EXP Emulate,far
Emulate proc far
  push BP
  push SI
  push DI
  mov SaveSP,SP                         ;Fr Fehlerausgang aus Unterprozedur
  mov awError[0],0                      ;Kein Fehler aufgetreten
  call InitRegisters                    ;32-Bit-Register lschen
  ifdef DEBUG
    mov pDisk,offset abDiskBuf
  endif
  call StartIEC
  call StartSID                         ;Hardware einschalten
  call StartVIC
  call StartCIA
  call StartCPU
  ifdef DEBUG
    mov CX,offset FirstCmd
  else
    mov CX,offset @@Continue
  endif
  jmp ConfigMemory                      ;Speicherkonfiguration einstellen
align 4
EXP Update,near
Update label near                       ;Periodische Arbeiten alle 64us
  push DX                               ;Emulator-Register retten
  push SI
  mov Clock,BP
  push FS
  push GS
  jmp UpdateCIA                         ;Update ausfhren CIA->VIC->SID
align 4
EXP EndUpdate,near
EndUpdate label near
  pop GS                                ;Emulator-Register wiederherstellen
  pop FS
  mov BP,Clock
  pop SI
  pop DX
  movzx EAX,awUpdate[0]                 ;Hiword(EAX) mu 0 sein
  add BP,AX                             ;Taktzhler setzen
  mov AL,Events                         ;Irgendwelche besonderen Vorkommnisse?
  and AL,AL
  jne @@CheckEvents
@@Continue:
  ifdef DEBUG
    jmp FirstCmd
  else
    NEXTCMD                             ;Nchsten Befehl holen und ausfhren
  endif
@@CheckEvents:
  test AL,evSTOP                        ;Emulation beenden?
  jne Stop
  test AL,evNMI                         ;NMI aufgetreten?
  jne @@ExecuteNMI
  test AL,evIRQ                         ;IRQ aufgetreten?
  je @@Continue
  test Flags,00000100b                  ;Interrupts zulssig?
  jne @@Continue                        ;Nein
  mov AL,FS:[SI]                        ;Bei SEI, RTI und BRK verzgern
  cmp AL,78h
  je @@Continue
  cmp AL,40h
  je @@Continue
  cmp AL,00h
  je @@Continue
  sub BP,iClocksPerInt                  ;Taktzyklen fr Interrupt
  ifdef DEBUG
    TBEG INT
    if GERMAN
      INFO "Sprung zum IRQ-Vektor an Adresse FFFE"
    else
      INFO "Jump to IRQ vector at FFFE"
    endif
    TEND
  endif
  INTERRUPT 0FFFEh,0                    ;IRQ ausfhren (Break-Flag lschen)
  or Flags,00000100b                    ;Weitere Interrupts sperren
  NEXTCMD                               ;Nchsten Befehl holen und ausfhren
align 4
@@ExecuteNMI:
  sub BP,iClocksPerInt                  ;Taktzyklen fr Interrupt
  ifdef DEBUG
    TBEG INT
    if GERMAN
      INFO "Sprung zum NMI-Vektor an Adresse FFFA"
    else
      INFO "Jump to NMI vector at FFFA"
    endif
    TEND
  endif
  and AL,not evNMI                      ;NMI wurde erkannt
  mov Events,AL
  INTERRUPT 0FFFAh,1                    ;NMI ausfhren (Break-Flag bleibt 1)
;Der 6502 sperrt bei einem NMI die Interrupts nicht, das mu der erste
;Befehl des NMI-Handlers tun
  ifdef DEBUG
    jmp FirstCmd
  else
    NEXTCMD                             ;Nchsten Befehl holen und ausfhren
  endif
EXP Stop,near
Stop label near
  and Events,not evSTOP                 ;Endekennung zurcksetzen
  cmp fLocalBus,0
  jne @@LocalBus
  cmp CacheSeg,0
  je @@VICFailed
@@LocalBus:
  call StopCPU                          ;Hardware ausschalten
  call StopCIA
  call StopVIC
@@VICFailed:
  call StopSID
  call StopIEC
  ifdef DEBUG
    cmp pDisk,offset abDiskBuf
    je @@Empty
    call WriteBuffer
  @@Empty:
  endif
  cmp awError[0],0
  je @@NoError
  push DS
  push word ptr offset DGROUP:awError[4]
  push dword ptr awError[0]
  push DS
  push word ptr offset DGROUP:acRunError
  call vsprintf
@@NoError:
  mov SP,SaveSP
  pop DI
  pop SI
  pop BP
  ret
Emulate endp

ende
