/* rexx */

/*
A:*
Set of routines to control the cursor with Ansi escape sequences.     :*
For a quick index, Grep -i "^[A-z]" <this_file> | grep ":" | grep "\*"
A:*
*/
/* since this file was [accidentally?] launched, display index */
Call Cls
Call Locate 5,1
Say "This is a file of Rexx Procedures to control display I/O with"
Call CsrAttrib "High"
Call Charout ,"ANSII"
Call Csrattrib "Normal"
Say " codes."
Say " "
Call Charout ,"If you have the "
Call Color "RED"
Call Charout ,"EGREP"
Call Color "White"
Say " program, this will display a quick index of it's "
Say "procedures."
Say " "
Call Charout ,"I can be reached at: "
Call Csrattrib "Reverse"
Say "jhoglund@cscns.com"
Call Csrattrib "Normal"
Call Charout ,"Or through compuserve:"
Call Csrattrib "Reverse"
Call Charout ,"70244,3234"
Call Csrattrib "Normal"
Call Charout ,"  If you have any questions"

Say ""
Say ""
Say "Jamie Hoglund"
Say ""
Say "Press 'Y' if you have the egrep program, and wish to view an index"
Pull Q
If Q = "Y" then do
PARSE SOURCE J1 J2 FIL Garbage
Say "File: "Fil
'@EGrep -i "^[A-z]" 'FIL' | Egrep ":" | Egrep "\*" | more '
end
Exit

/* ---------------- Cut Here -------------------------*/
/* Ansi Procedures for moving the cursor */
Locate: Procedure   /*  Call Locate Row,Col */
Row = arg(1)
Col = Arg(2)
Rc = Charout(,D2C(27)"["Row";"col"H")
return ""

CsrUp: Procedure  /* CsrUp(Rows) */
Arg u
Rc = Charout(,D2C(27)"["u"A")
return ""

CsrDown: Procedure /* CsrDn(Rows) */
Arg d
Rc = Charout(,D2C(27)"["d"B")
return ""

CsrRight: Procedure  /* CsrRight(Cols) */
arg r
Rc = Charout(,D2C(27)"["r"C")
Return ""

CsrLeft: procedure  /* CsrLeft(Cols) */
arg l
Rc = Charout(,D2C(27)"["l"D")
Return ""


/*
A------------------------------------------------------------:*
SaveCsr and PutCsr are meant to be used together for saving  :*
and restoring the cursor location. Do not confuse            :*
with Locate, CsrRow, CsrCol, these are different routines.   :*
SaveCsr Returns a string that PutCsr can use.                :*
A:*/
SaveCsr: procedure  /* cursor_location = SaveCsr() (for PutCsr(x))*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Call CsrUp
return Q

PutCsr: procedure  /* Call PutCsr <Previous_Location>  (From SaveCsr() ) */
Where = arg(1)
Rc = Charout(,substr(Where,1,7)"H")
return ""
/*
A:*/
/* clear screen :*/
Cls: Procedure      /* cls() Call Cls */
Rc = CharOut(,D2C(27)"[2J")
return ""

    /* get cursors Line */
CsrRow: Procedure      /* Row = CsrRow()*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Return substr(Q,3,2)

   /* get cursors column */    
CsrCol: Procedure          /*  Col = CsrCol()  */
Rc = Charout(,D2C(27)"[6n")
Pull Q
return Substr(Q,6,2)

/* procedure to color screen 
A:--------------------------------------------------------------*
accepts colors: BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE  *
*/
Color: Procedure /* Call Color <ForeGround>,<BackGround> */
arg F,B
Colors = "BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE"  
return CHAROUT(,D2C(27)"["WORDPOS(F,COLORS)+29";"WORDPOS(B,COLORS)+39";m")

/*  change screen attributes
A:---------------------------------------------------------------*
attributes: NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE *
*/
CsrAttrib: Procedure  /* call CsrAttrib <Attrib> */
Arg A
attr = "NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE"
return CHAROUT(,D2C(27)"["WORDPOS(A,ATTR) - 1";m")

EndAll:
Call Color "White","Black"
CALL CsrAttrib "Normal"
