// Tutor8.CPP
// This Programming Tutorial show how to Animate more than
// one 3D Object created with the Citigrade 3D Editor,
// without destroying something on the background.

#include <wgt4.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include "Object3D.HPP"
#include "Anim3D.HPP"

// The 3D Object
a3DObject Boat;
a3DObject Jet;

// The Animation
a3DAnimation BoatMovie;
a3DAnimation JetMovie;

// A block of memory for Page Swapping and restoring the Background
block Swap;
block Back;

void main()
{
 // Description of Tutorial1
 clrscr();
 cout << "This is a Programming Tutorial for the Citigrade 3D Editor, version 1.01\n\n"
      << "Tuturial 8:\n"
      << "This Tutorial shows how easy it is to use 3D Objects in your own programs.\n"
      << "A 3D Boat and Jet will be Animated on the screen.\n"
      << "A flickering will be seen when the two objects overlaps one another.\n"
      << "This is due to the objects getting drawn the one after the other. In\n"
      << "feature versions, a Multiple Object handler will be introduced which\n"
      << "will solve this problem.\n\n"
      << "Press any key to continue...";
 getch();

 // Initialize Graphics with WGT
 int OldMode = wgetmode();
 vga256();

 // Initialize 3D Graphics, for Sin and Cos lookup tables
 Init3D();

 // Write something on the background
 wtextcolor (1);
 wgtprintf (100,80,0, "This is someting on");
 wgtprintf (100,100,0,"the Background that");
 wgtprintf (100,120,0,"will NOT be destroyed !");

 // Get a block of memory for Page Swapping
 Swap = wnewblock(0,0,319,199);
 // Get the Background
 Back = wnewblock(0,0,319,199);

 // Load and set Object Data
 Boat.Load ("Boat2.3d");
 Boat.SetPage (Swap);
 Boat.SetBackground (Back);

 Jet.Load ("Jet.3d");
 Jet.SetPage (Swap);
 Jet.SetBackground (Back);

 // Load and set Animation Data
 BoatMovie.Load ("Circle.3da");
 BoatMovie.SetObject (&Boat);
 BoatMovie.Faster (12);
 JetMovie.Load ("Flight.3da");
 JetMovie.SetObject (&Jet);
 JetMovie.Faster (10);

 // Animate Object until key is pressed
 do
 {
  BoatMovie.Show();
  JetMovie.Show();
 } while (!kbhit());
 getch();

 // Restore Text Mode
 wfreeblock (Swap);
 wsetmode (OldMode);
}