#ifndef __OGL2_TEXTURE__
#define __OGL2_TEXTURE__

#include "types.h"
#include "entity.h"
#include "image.h"

extern "C++" {

class Texture : public Entity
{
protected:
  GLuint texture;
  GLint wrap_s;
  GLint wrap_t;
  GLint min_filter;
  GLint mag_filter;
  GLfloat border_color[4];
  GLfloat priority;
  GLenum env_mode;
  GLfloat env_color[4];

  bool transferred;
  bool altered;

public:

  Texture();
  virtual ~Texture ();

  virtual void GL () = 0;

  void WrapS (GLint n),
       WrapT (GLint n),
       MinFilter (GLint n),
       MagFilter (GLint n),
       Priority (GLfloat f),
       BorderColor4fv (GLfloat *v),
       EnvMode (GLenum e),
       EnvColor4f (GLfloat r, GLfloat g, GLfloat b, GLfloat a),
       EnvColor4fv (GLfloat *v);

  // Feedback 
  GLint WrapS (),
        WrapT (),
        MinFilter (),
        MagFilter ();
  GLfloat Priority ();
  GLenum EnvMode ();
  const GLfloat* BorderColor4fv ();
  const GLfloat* EnvColor4fv ();

};

template class EntityList<Texture>;
typedef EntityList<Texture> Textures;


class TextureGL : public Texture {
public:
  void GL ();
  void TexImage2D (GLenum target, GLint level, GLint internalformat,
                   GLsizei width, GLsizei height, GLint border,
                   GLenum format, GLenum type, void *data);
};

class TextureFile : public Texture {
public:
  void GL ();
};

} // extern "C++"

#endif

