/*

deformacia gule

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_10.h"
#include "syncs.h"

extern int sync_id;

int  efekt_10::init()
{
    cout << "Efekt 10 init ... ";
    start=TRUE;
    counter=ZACIATOK10*refresh;
//->init
    f_cntr=0.0;
    amount=0.0;


//<-
    cout << "ok" << endl;
    return 1;
}

int  efekt_10::load()
{
    cout << "Loading efekt10 ... ";
// -> load
    FILE *stream;
    stream=fopen(CFGNAME10,"r");
    if (!stream) return 0;

    fscanf(stream,"file name            %s\n",scene_name);
    fscanf(stream,"object name          %s\n",object_name);
    fscanf(stream,"visibility           %f\n",&vis);
    fscanf(stream,"minvisibility        %f\n",&minvis);
    Vector3f o,i,j,k;
    fscanf(stream,"Descent origin       (%f,%f,%f)\n",&o.x,&o.y,&o.z);
    fscanf(stream,"Descent right        (%f,%f,%f)\n",&i.x,&i.y,&i.z);
    fscanf(stream,"Descent up           (%f,%f,%f)\n",&j.x,&j.y,&j.z);
    fscanf(stream,"Descent forward      (%f,%f,%f)\n",&k.x,&k.y,&k.z);
    cam.SetAll(o,i,j,k);
    fclose(stream);
    cam.FarClipplane(vis);
    cam.NearClipplane(minvis);
    cam.HorizontalFOV(PI/3);
    cam.VerticalFOV(PI/4);

    Loader3DS loader;
    sce = loader.Load(scene_name, texture_library);

    obj  = dynamic_cast<Object3DS*>(sce->GetObject(object_name));
    numver = obj->NumVertices();
    vtx  = obj->Vertices();
  
    Vertex3DS *v=vtx;
    DeformVtx *d=infoDV;
    for (int i=numver;i;i--)
      {
      d->x=v->x;
      d->y=v->y;
      d->z=v->z;
      d->a1=atan2(v->x,v->y);
      d->a2=atan2(v->x,v->z);
      d->a3=atan2(v->y,v->z);
      v++;
      d++;
      }
    
  
// <-
    cout << "ok!"<<endl;
    return 1;
}

int  efekt_10::free()  //vrati 3 ako ok, 0 ak doslo k chybe
{
    end=true;
    cout << "Efekt 08 free ... ";
// -> free

// <-
    cout << "ok!" << endl;
    return 3;
}

int  efekt_10::update()
{
    id=Sync[GetSyncNum(float(counter)/float(refresh))].id;
// -> update
    f_cntr+=0.01;
    if (amount<(0.7-0.0055)) amount+=0.0055;
               else amount=0.7;

// <-
    return 1;
}

int efekt_10::go(double t)
{
if (t<ZACIATOK10) return 1;
if (end) return 3;
if (counter>=KONIEC10*refresh) return free();

if (!start) if (!init()) return 0;
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC10*refresh) cur_frm=int(KONIEC10*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC10*refresh) update();
    }
if (counter>=KONIEC10*refresh) return free();
//tu sa kresli->
   glDisable(GL_LIGHTING);    
   glDisable(GL_FOG);    
   cam.GL();

   Vertex3DS *v=vtx;
   DeformVtx *d=infoDV;
 if (amount>0.0)
   {
   for (int i=numver;i;i--)
     {
     float aa=( sin(3*d->a1+f_cntr)*cos(3*d->a2-f_cntr*0.7)+sin(2*d->a3+1.4*f_cntr) )*0.5;

     v->R=fabs(aa);
     v->G=fabs(aa);
     v->B=fabs(aa);

     v->s+=cos(aa-f_cntr)/1000;
     v->t+=sin(aa+f_cntr)/1000;

     aa=1/ (amount*(1+0.15*sin(f_cntr*5.64))*(1+0.7*aa));
     v->w=aa;
     v++;
     d++;
     }
   sce->Render();
   }
//<-
return 2;
}