%TITLE  "NEXTEMPIRE VMM/DPMI/DIRECT DRAW ENGINE"
%SUBTTL "(C)COPYRIGHT 1998 NEXTEMPIRE"
%SUBTTL "ALL CODE BY KOSMIK"

; 0000:7C00H->0000:7CFE SVGA STANDARD 256 BYTE INFO
; 
;

;#######################################################################################################
;       HEADER 
;#######################################################################################################
        SMART
        RADIX   10
        IDEAL
        JUMPS
        P486
        LOCALS  @@
        MODEL   LARGE,WINDOWS PASCAL
        %NOINCL
        MASM
;        INCLUDE WINDOWS.INC
        IDEAL
;#######################################################################################################
;       CONSTS
;#######################################################################################################
ALLOCATE_DOS_MEMORY_BLOCK_EQUATE                                EQU 000000100H
ALLOCATE_LDT_DESCRIPTORS_EQUATE                                 EQU 000000000H
ALLOCATE_MEMORY_BLOCK_EQUATE                                    EQU 000000501H
ALLOCATE_REAL_MODE_CALLBACK_ADDRESS_EQUATE                      EQU 000000303H
ALLOCATE_SPECIFIC_LDT_DESCRIPTOR_EQUATE                         EQU 00000000DH
APPLICATION_SEGMENT_EXECUTE_ONLY_ACCESSED_EQUATE                EQU 000000009H
APPLICATION_SEGMENT_EXECUTE_ONLY_CONFORMING_ACCESSED_EQUATE     EQU 00000000DH
APPLICATION_SEGMENT_EXECUTE_ONLY_CONFORMING_EQUATE              EQU 00000000CH
APPLICATION_SEGMENT_EXECUTE_ONLY_EQUATE                         EQU 000000008H
APPLICATION_SEGMENT_EXECUTE_READ_ACCESSED_EQUATE                EQU 00000000BH
APPLICATION_SEGMENT_EXECUTE_READ_CONFORMING_ACCESSED_EQUATE     EQU 00000000FH
APPLICATION_SEGMENT_EXECUTE_READ_CONFORMING_EQUATE              EQU 00000000EH
APPLICATION_SEGMENT_EXECUTE_READ_EQUATE                         EQU 00000000AH
APPLICATION_SEGMENT_READ_ONLY_ACCESSED_EQUATE                   EQU 000000001H
APPLICATION_SEGMENT_READ_ONLY_EQUATE                            EQU 000000000H
APPLICATION_SEGMENT_READ_ONLY_EXPAND_DOWN_ACCESSED_EQUATE       EQU 000000005H
APPLICATION_SEGMENT_READ_ONLY_EXPAND_DOWN_EQUATE                EQU 000000004H
APPLICATION_SEGMENT_READ_WRITE_ACCESSED_EQUATE                  EQU 000000003H
APPLICATION_SEGMENT_READ_WRITE_EQUATE                           EQU 000000002H
APPLICATION_SEGMENT_READ_WRITE_EXPAND_DOWN_ACCESSED_EQUATE      EQU 000000007H
APPLICATION_SEGMENT_READ_WRITE_EXPAND_DOWN_EQUATE               EQU 000000006H
BEGIN_CRITICAL_SECTION_EQUATE                                   EQU 000001681H
BIOS_VIDEO_GENERAL_SERVICES_INTERRUPT_EQUATE                    EQU 000000010H
BOOTSTRAP_MEMORY_OFFSET_EQUATE                                  EQU 000007C00H
BOOTSTRAP_MEMORY_SEGMENT_EQUATE                                 EQU 000000000H
BREAKPOINT_INSTRUCTION_INTERRUPT_EQUATE                         EQU 000000003H
BYTE_TO_KILOBYTE_SHIFT_EQUATE                                   EQU 00000000AH
CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_EQUATE           EQU 000000301H
CALL_REAL_MODE_PROCEDURE_WITH_IRET_RETURN_FRAME_EQUATE          EQU 000000302H
CHECK_IF_PASSWORD_INSTALLED_EQUATE                              EQU 0000000A4H
CHECK_PASSWORD_EQUATE                                           EQU 0000000A6H
CLEAR_DEBUG_WATCHPOINT_EQUATE                                   EQU 000000B01H
CONTINUOUS_INPUT_PORT_POLL_HIGH_EQUATE                          EQU 0000000C2H
CONTINUOUS_INPUT_PORT_POLL_LOW_EQUATE                           EQU 0000000C1H
CREATE_ALIAS_DESCRIPTOR_EQUATE                                  EQU 00000000AH
CURRENT_PRIVILEGE_LEVEL_MASK_EQUATE                             EQU 000000003H
CURRENT_PRIVILEGE_LEVEL_SHIFT_EQUATE                            EQU 000000005H
DECREMENTED_HALF_SECTOR_BYTE_HIGH_EQUATE                        EQU 000000000H
DECREMENTED_HALF_SECTOR_BYTE_LOW_EQUATE                         EQU 0000000FFH
DECREMENTED_SECTOR_BYTE_HIGH_EQUATE                             EQU 000000000H
DECREMENTED_SECTOR_BYTE_LOW_EQUATE                              EQU 0000001FFH
DECREMENTED_SEGMENT_BYTE_HIGH_EQUATE                            EQU 000000000H
DECREMENTED_SEGMENT_BYTE_LOW_EQUATE                             EQU 00000FFFFH
DESCRIPTOR_PRIVILEGE_LEVEL_ZERO_EQUATE                          EQU 000000000H
DESCRIPTOR_PRIVILEGE_LEVEL_ONE_EQUATE                           EQU 000000020H
DESCRIPTOR_PRIVILEGE_LEVEL_TWO_EQUATE                           EQU 000000040H
DESCRIPTOR_PRIVILEGE_LEVEL_THREE_EQUATE                         EQU 000000060H
DESCRIPTOR_TYPE_APPLICATION_SEGMENT_EQUATE                      EQU 000000010H
DESCRIPTOR_TYPE_SYSTEM_SEGMENT_EQUATE                           EQU 000000000H
DEVICE_CALL_OUT_EQUATE                                          EQU 000001607H
DIAGNOSTIC_DUMP_EQUATE                                          EQU 0000000ACH
DIAGNOSTIC_ECHO_EQUATE                                          EQU 0000000EEH
DISABLE_A20_ADDRESS_LINE_EQUATE                                 EQU 0000000DDH
DISABLE_KEYBOARD_EQUATE                                         EQU 0000000ADH
DISABLE_MOUSE_PORT_EQUATE                                       EQU 0000000A7H
DISABLE_VM_ASSISTED_SAVE_RESTORE_EQUATE                         EQU 000004007H
DISCARD_PAGE_CONTENTS_EQUATE                                    EQU 000000703H
DOS_GENERAL_SERVICES_INTERRUPT_EQUATE                           EQU 000000021H
DOS_MULTIPLEX_INTERRUPT_EQUATE                                  EQU 00000002FH
DOS_PROTECTED_MODE_INTERRUPT_EQUATE                             EQU 000000031H
EIGTH_LOWEST_NIBBLE_MASK_EQUATE                                 EQU 0F0000000H
ENABLE_A20_ADDRESS_LINE_EQUATE                                  EQU 0000000DFH
ENABLE_KEYBOARD_EQUATE                                          EQU 0000000AEH
ENABLE_MOUSE_PORT_EQUATE                                        EQU 0000000A8H
ENABLE_VM_ASSISTED_SAVE_RESTORE_EQUATE                          EQU 000004000H
END_CRITICAL_SECTION_EQUATE                                     EQU 000001682H
ENTER_CRITICAL_SECTION_EQUATE                                   EQU 000004003H
EXIT_CRITICAL_SECTION_EQUATE                                    EQU 000004004H
EXIT_TO_DOS_EQUATE                                              EQU 000004C00H
FIFTH_LOWEST_NIBBLE_MASK_EQUATE                                 EQU 0000F0000H
FIRST_LOWEST_BYTE_MASK_EQUATE                                   EQU 0000000FFH
FIRST_LOWEST_NIBBLE_MASK_EQUATE                                 EQU 00000000FH
FIRST_LOWEST_WORD_MASK_EQUATE                                   EQU 00000FFFFH
FLAT_MODE_SEGMENT_EQUATE                                        EQU 000000000H
FOURTH_LOWEST_BYTE_MASK_EQUATE                                  EQU 0FF000000H
FOURTH_LOWEST_NIBBLE_MASK_EQUATE                                EQU 00000F000H
FREE_DOS_MEMORY_BLOCK_EQUATE                                    EQU 000000101H
FREE_LDT_DESCRIPTOR_EQUATE                                      EQU 000000001H
FREE_MEMORY_BLOCK_EQUATE                                        EQU 000000502H
FREE_REAL_MODE_CALLBACK_ADDRESS_EQUATE                          EQU 000000304H
GET_AND_DISABLE_VIRTUAL_INTERRUPT_STATE_EQUATE                  EQU 000000900H
GET_AND_ENABLE_VIRTUAL_INTERRUPT_STATE_EQUATE                   EQU 000000901H
GET_COMMAND_BYTE_EQUATE                                         EQU 000000020H
GET_CPU_MODE_EQUATE                                             EQU 000001686H
GET_CURRENT_SVGA_VIDEO_MODE_EQUATE                              EQU 000004F03H
GET_CURRENT_VIRTUAL_MACHINE_ID_EQUATE                           EQU 000001683H
GET_DESCRIPTOR_EQUATE                                           EQU 00000000BH
GET_DEVICE_ENTRY_POINT_ADDRESS_EQUATE                           EQU 000001684H
GET_DPMI_VERSION_EQUATE                                         EQU 000000400H
GET_ENHANCED_MODE_WINDOWS_ENTRY_POINT_ADDRESS_EQUATE            EQU 000001602H
GET_ENHANCED_MODE_WINDOWS_INSTALLED_STATE_EQUATE                EQU 000001600H
GET_FREE_MEMORY_INFORMATION_EQUATE                              EQU 000000500H
GET_LOGICAL_DISPLAY_START_EQUATE                                EQU 000004F07H
GET_LOGICAL_SCAN_LINE_LENGTH_EQUATE                             EQU 000004F06H
GET_MOUSE_INFORMATION_EQUATE                                    EQU 0000000E9H
GET_PAGE_SIZE_EQUATE                                            EQU 000000604H
GET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_EQUATE                   EQU 000000202H
GET_PROTECTED_MODE_INTERRUPT_VECTOR_EQUATE                      EQU 000000204H
GET_RAW_CPU_MODE_SWITCH_ADDRESSES_EQUATE                        EQU 000000306H
GET_REAL_MODE_INTERRUPT_VECTOR_EQUATE                           EQU 000000200H
GET_SAVE_STATE_BUFFER_SIZE_EQUATE                               EQU 000004F04H
GET_SELECTOR_INCREMENT_VALUE_EQUATE                             EQU 000000003H
GET_SEGMENT_BASE_ADDRESS_EQUATE                                 EQU 000000006H
GET_STATE_OF_DEBUG_WATCHPOINT_EQUATE                            EQU 000000B02H
GET_STATE_SAVE_RESTORE_ADDRESSES_EQUATE                         EQU 000000305H
GET_SVGA_GENERAL_INFORMATION_EQUATE                             EQU 000004F00H
GET_SVGA_GENERAL_MODE_EQUATE                                    EQU 000004F01H
GET_SVGA_MEMORY_WINDOW_POSITION_EQUATE                          EQU 000004F05H
GET_VENDOR_SPECIFIC_API_ENTRY_POINT_EQUATE                      EQU 000000A00H
GET_VIRTUAL_INTERRUPT_STATE_EQUATE                              EQU 000000902H
HALF_SECTOR_BYTE_HIGH_EQUATE                                    EQU 000000000H
HALF_SECTOR_BYTE_LOW_EQUATE                                     EQU 000000100H
HIGH_BYTE_TO_LOW_BYTE_SHIFT_EQUATE                              EQU 000000008H
HIGH_NIBBLE_TO_LOW_NIBBLE_SHIFT_EQUATE                          EQU 000000004H
HIGH_WORD_TO_LOW_WORD_SHIFT_EQUATE                              EQU 000000010H
INTERFACE_TEST_EQUATE                                           EQU 0000000ABH
KEYBOARD_COMMAND_PORT_EQUATE                                    EQU 000000060H
KEYBOARD_ENABLE_EQUATE                                          EQU 0000000F4H
KEYBOARD_RESET_EQUATE                                           EQU 0000000FFH
KILOBYTE_TO_BYTE_SHIFT_EQUATE                                   EQU 00000000AH
LED_WRITE_EQUATE                                                EQU 0000000EDH
LINEAR_MEMORY_TO_PHYSICAL_MEMORY                                EQU 000000010H
LOAD_PASSWORD_EQUATE                                            EQU 0000000A5H
LOCK_LINEAR_REGION_EQUATE                                       EQU 000000600H
LOW_BYTE_TO_HIGH_BYTE_SHIFT_EQUATE                              EQU 000000008H
LOW_NIBBLE_TO_HIGH_NIBBLE_SHIFT_EQUATE                          EQU 000000004H
LOW_WORD_TO_HIGH_WORD_SHIFT_EQUATE                              EQU 000000010H
MARK_PAGE_AS_DEMAND_PAGING_CANDIDATE_EQUATE                     EQU 000000702H
MAP_REAL_MODE_SEGMENT_TO_DESCRIPTOR_EQUATE                      EQU 000000002H
MARK_REAL_MODE_REGION_AS_PAGEABLE_EQUATE                        EQU 000000602H
MOTHERBOARD_CONTROLLER_COMMAND_PORT_EQUATE                      EQU 000000064H
MOUSE_ENABLE_EQUATE                                             EQU 0000000F4H
MOUSE_RESET_EQUATE                                              EQU 0000000FFH
NOTIFY_BACKGROUND_SWITCH_EQUATE                                 EQU 000004001H
NOTIFY_FOREGROUND_SWITCH_EQUATE                                 EQU 000004002H
OBTAIN_REAL_TO_PROTECTED_MODE_SWITCH_ENTRY_POINT_EQUATE         EQU 000001687H
ONE_EQUATE                                                      EQU 000000001H
PHYSICAL_ADDRESS_MAPPING_EQUATE                                 EQU 000000800H
PHYSICAL_MEMORY_TO_LINEAR_MEMORY                                EQU 000000010H
PULSE_OUTPUT_BIT_EQUATE                                         EQU 0000000F0H
READ_CONTROLLER_RAM_EQUATE                                      EQU 000000021H
READ_INPUT_PORT_EQUATE                                          EQU 0000000C0H
READ_KEYBOARD_ID_EQUATE                                         EQU 0000000F2H
READ_MOUSE_ID_EQUATE                                            EQU 0000000F2H
READ_OUTPUT_PORT_EQUATE                                         EQU 0000000D0H
READ_TEST_INPUTS_EQUATE                                         EQU 0000000E0H
RELEASE_CURRENT_VM_TIME_SLICE_EQUATE                            EQU 000001680H
RELOCK_REAL_MODE_REGION_EQUATE                                  EQU 000000603H
RESEND_EQUATE                                                   EQU 0000000FEH
RESET_DEBUG_WATCHPOINT_EQUATE                                   EQU 000000B03H
RESIZE_DOS_MEMORY_BLOCK_EQUATE                                  EQU 000000102H
RESIZE_MEMORY_BLOCK_EQUATE                                      EQU 000000503H
RESTORE_SVGA_STATE                                              EQU 000004F04H
RESTORE_VIDEO_REGISTER_STATE_EQUATE                             EQU 000004006H
SAVE_SVGA_STATE_EQUATE                                          EQU 000004F04H
SAVE_VIDEO_REGISTER_STATE_EQUATE                                EQU 000004005H
SECOND_LOWEST_BYTE_MASK_EQUATE                                  EQU 00000FF00H
SECOND_LOWEST_NIBBLE_MASK_EQUATE                                EQU 0000000F0H
SECOND_LOWEST_WORD_MASK_EQUATE                                  EQU 0FFFF0000H
SECTOR_BYTE_EQUATE                                              EQU 000000200H
SEGMENT_HIGH_BYTE_EQUATE                                        EQU 000000001H
SEGMENT_LOW_BYTE_EQUATE                                         EQU 000000000H
SEGMENT_NOT_PRESENT_IN_MEMORY_EQUATE                            EQU 000000000H
SEGMENT_PRESENT_IN_MEMORY_EQUATE                                EQU 000000080H
SELF_TEST_EQUATE                                                EQU 0000000AAH
SET_A_KEY_TO_MAKE_ONLY_EQUATE                                   EQU 0000000FDH
SET_A_KEY_TO_MAKE_RELEASE_EQUATE                                EQU 0000000FCH
SET_A_KEY_TO_TYPEMATIC_EQUATE                                   EQU 0000000FBH
SET_ALL_KEYS_TO_MAKE_EQUATE                                     EQU 0000000F9H
SET_ALL_KEYS_TO_MAKE_RELEASE_EQUATE                             EQU 0000000F8H
SET_ALL_KEYS_TO_TYPEMATIC_EQUATE                                EQU 0000000F7H
SET_ALL_KEYS_TO_TYPEMATIC_MAKE_RELEASE_EQUATE                   EQU 0000000FAH
SET_DEBUG_WATCHPOINT_EQUATE                                     EQU 000000B00H
SET_DEFAULTS_AND_DISABLE_KEYBOARD_EQUATE                        EQU 0000000F5H
SET_DEFAULTS_AND_DISABLE_MOUSE_EQUATE                           EQU 0000000F6H
SET_DESCRIPTOR_ACCESS_RIGHTS_EQUATE                             EQU 000000009H
SET_DESCRIPTOR_EQUATE                                           EQU 00000000CH
SET_GET_ALTERNATE_SCAN_CODES_EQUATE                             EQU 0000000F0H
SET_LOGICAL_DISPLAY_START_EQUATE                                EQU 000004F07H
SET_LOGICAL_SCAN_LINE_LENGTH_EQUATE                             EQU 000004F06H
SET_MOUSE_RESOLUTION_EQUATE                                     EQU 0000000E8H
SET_MOUSE_SAMPLE_RATE_EQUATE                                    EQU 0000000F3H
SET_MOUSE_SCALING_TO_1_1_EQUATE                                 EQU 0000000E6H
SET_MOUSE_SCALING_TO_2_1_EQUATE                                 EQU 0000000E7H
SET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_EQUATE                   EQU 000000203H
SET_PROTECTED_MODE_INTERRUPT_VECTOR_EQUATE                      EQU 000000205H
SET_REAL_MODE_INTERRUPT_VECTOR_EQUATE                           EQU 000000201H
SET_SEGMENT_BASE_ADDRESS_EQUATE                                 EQU 000000007H
SET_SEGMENT_LIMIT_EQUATE                                        EQU 000000008H
SET_SVGA_MEMORY_WINDOW_POSITION_EQUATE                          EQU 000004F05H
SET_SVGA_VIDEO_MODE_EQUATE                                      EQU 000004F02H
SET_TYPEMATIC_INFORMATION_EQUATE                                EQU 0000000F3H
SEVENTH_LOWEST_NIBBLE_MASK_EQUATE                               EQU 00F000000H
SIMULATE_REAL_MODE_INTERRUPT_EQUATE                             EQU 000000300H
SIXTH_LOWEST_NIBBLE_MASK_EQUATE                                 EQU 000F00000H
SVGA_BANK_SIZE_IN_KILOBYTES_EQUATE                              EQU 00000001DH
SVGA_BITS_PER_PIXEL_EQUATE                                      EQU 00000001AH
SVGA_BYTES_PER_LOGICAL_SCAN_LINE_EQUATE                         EQU 000000010H
SVGA_CAPABILITIES_EQUATE                                        EQU 00000000AH
SVGA_CHARACTER_CELL_HEIGHT_EQUATE                               EQU 000000017H
SVGA_CHARACTER_CELL_WIDTH_EQUATE                                EQU 000000016H
SVGA_HORIZONTAL_RESOLUTION_EQUATE                               EQU 000000012H
SVGA_MEMORY_ORGANIZATION_EQUATE                                 EQU 00000001CH
SVGA_MODE_ATTRIBUTES_EQUATE                                     EQU 000000000H
SVGA_MODE_LIST_EQUATE                                           EQU 00000000EH
SVGA_NUMBER_OF_BANKS_EQUATE                                     EQU 00000001BH
SVGA_NUMBER_OF_IMAGE_PAGES_EQUATE                               EQU 00000001EH
SVGA_NUMBER_OF_MEMORY_PLANES_EQUATE                             EQU 000000018H
SVGA_PAGE_FUNCTION_EQUATE                                       EQU 00000001FH
SVGA_SIGNATURE_EQUATE                                           EQU 000000000H
SVGA_TOTAL_MEMORY_EQUATE                                        EQU 000000012H
SVGA_VENDOR_STRING_EQUATE                                       EQU 000000006H
SVGA_VERTICAL_RESOLUTION_EQUATE                                 EQU 000000014H
SVGA_VESA_VERSION_NUMBER_EQUATE                                 EQU 000000004H
SVGA_VIDEO_MEMORY_BUFFER_OFFSET_EQUATE                          EQU 000000000H
SVGA_WINDOW_A_ATTRIBUTES_EQUATE                                 EQU 000000002H
SVGA_WINDOW_B_ATTRIBUTES_EQUATE                                 EQU 000000003H
SVGA_WINDOW_A_SEGMENT_EQUATE                                    EQU 000000008H
SVGA_WINDOW_B_SEGMENT_EQUATE                                    EQU 00000000AH
SVGA_WINDOW_GRANULARITY_EQUATE                                  EQU 000000004H
SVGA_WINDOW_SCHEME_FUNCTION_POINTER_EQUATE                      EQU 00000000CH
SVGA_WINDOW_SIZE_EQUATE                                         EQU 000000006H
SWITCH_VMS_AND_CALLBACK_EQUATE                                  EQU 000001685H
SYSTEM_RESET_EQUATE                                             EQU 0000000FEH
TEST_MOUSE_PORT_EQUATE                                          EQU 0000000A9H
THIRD_LOWEST_BYTE_MASK_EQUATE                                   EQU 000FF0000H
THIRD_LOWEST_NIBBLE_MASK_EQUATE                                 EQU 000000F00H
UNLOCK_LINEAR_REGION_EQUATE                                     EQU 000000601H
VIDEO_CURSOR_INTERFACE_EQUATE                                   EQU 000004F4DH
VIDEO_MODE_NUMBER_MASK_EQUATE                                   EQU 00000007FH
WINDOWS_BEGIN_EXIT_EQUATE                                       EQU 000001609H
WINDOWS_INITIALIZATION_COMPLETE_NOTIFICATION_EQUATE             EQU 000001608H
WINDOWS_INITIALIZATION_NOTIFICATION_EQUATE                      EQU 000001605H
WINDOWS_TERMINATION_NOTIFICATION_EQUATE                         EQU 000001606H
WRITE_COMMAND_BYTE_EQUATE                                       EQU 000000060H
WRITE_CONTROLLER_RAM_EQUATE                                     EQU 000000061H
WRITE_KEYBOARD_OUTPUT_BUFFER_EQUATE                             EQU 0000000D2H
WRITE_MOUSE_OUTPUT_BUFFER_EQUATE                                EQU 0000000D3H
WRITE_OUTPUT_PORT_EQUATE                                        EQU 0000000D1H
WRITE_TO_MOUSE_EQUATE                                           EQU 0000000D4H
ZERO_EQUATE                                                     EQU 000000000H
;#######################################################################################################
;       EXTRN
;#######################################################################################################
EXTRN  CLIENTTOSCREEN                                                    :PROC
EXTRN  CREATEWINDOW                                                      :PROC
EXTRN  DEFWINDOWPROC                                                     :PROC
EXTRN  DISPATCHMESSAGE                                                   :PROC
EXTRN  GETDC                                                             :PROC
EXTRN  GETMESSAGE                                                        :PROC
EXTRN  GETWINDOWORG                                                      :PROC
EXTRN  INITAPP                                                           :PROC
EXTRN  INITTASK                                                          :PROC
EXTRN  POSTQUITMESSAGE                                                   :PROC
EXTRN  RELEASEDC                                                         :PROC
EXTRN  REGISTERCLASS                                                     :PROC
EXTRN  SHOWWINDOW                                                        :PROC
EXTRN  TRANSLATEMESSAGE                                                  :PROC
EXTRN  UPDATEWINDOW                                                      :PROC
EXTRN  WAITEVENT                                                         :PROC
EXTRN  RING0FUNC                                                         :PROC
;#######################################################################################################
;       GLOBAL
;#######################################################################################################
GLOBAL PASCAL WINMAIN                                                    :PROC
GLOBAL PASCAL WINDOW_INIT_PROCEDURE                                      :PROC
GLOBAL PASCAL WINDOW_RUN_PROCEDURE                                       :PROC
;maya
GLOBAL PASCAL GLOBALPAGELOCK                                             :PROC
GLOBAL PASCAL ALLOCSELECTOR                                              :PROC
GLOBAL PASCAL ALLOCATE_DOS_MEMORY_BLOCK_PROCEDURE                        :PROC
GLOBAL PASCAL ALLOCATE_LDT_DESCRIPTORS_PROCEDURE                         :PROC
GLOBAL PASCAL ALLOCATE_MEMORY_BLOCK_PROCEDURE                            :PROC
GLOBAL PASCAL ALLOCATE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE              :PROC
GLOBAL PASCAL ALLOCATE_SELECTOR_PROCEDURE                                :PROC  
GLOBAL PASCAL ALLOCATE_SPECIFIC_LDT_DESCRIPTOR_PROCEDURE                 :PROC
GLOBAL PASCAL BEGIN_CRITICAL_SECTION_PROCEDURE                           :PROC
GLOBAL PASCAL CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_PROCEDURE   :PROC
GLOBAL PASCAL CALL_REAL_MODE_PROCEDURE_WITH_IRET_FRAME_PROCEDURE         :PROC
GLOBAL PASCAL CLEAR_DEBUG_WATCHPOINT_PROCEDURE                           :PROC
GLOBAL PASCAL CREATE_ALIAS_DESCRIPTOR_PROCEDURE                          :PROC
GLOBAL PASCAL DEVICE_CALL_OUT_PROCEDURE                                  :PROC
GLOBAL PASCAL DISABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE                 :PROC
GLOBAL PASCAL DISCARD_PAGE_CONTENTS_PROCEDURE                            :PROC
GLOBAL PASCAL ENABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE                  :PROC
GLOBAL PASCAL END_CRITICAL_SECTION_PROCEDURE                             :PROC
GLOBAL PASCAL ENTER_CRITICAL_SECTION_PROCEDURE                           :PROC
GLOBAL PASCAL EXIT_CRITICAL_SECTION_PROCEDURE                            :PROC
GLOBAL PASCAL FREE_DOS_MEMORY_BLOCK_PROCEDURE                            :PROC
GLOBAL PASCAL FREE_LDT_DESCRIPTOR_PROCEDURE                              :PROC
GLOBAL PASCAL FREE_MEMORY_BLOCK_PROCEDURE                                :PROC
GLOBAL PASCAL FREE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE                  :PROC
GLOBAL PASCAL FREE_SELECTOR_PROCEDURE                                    :PROC  
GLOBAL PASCAL GET_AND_DISABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE          :PROC
GLOBAL PASCAL GET_AND_ENABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE           :PROC
GLOBAL PASCAL GET_CURRENT_VIRTUAL_MACHINE_ID_PROCEDURE                   :PROC
GLOBAL PASCAL GET_DEVICE_ENTRY_POINT_ADDRESS_PROCEDURE                   :PROC
GLOBAL PASCAL GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE    :PROC
GLOBAL PASCAL GET_STATE_OF_DEBUG_WATCHPOINT_PROCEDURE                    :PROC
GLOBAL PASCAL GET_VENDOR_SPECIFIC_API_ENTRY_POINT_PROCEDURE              :PROC
GLOBAL PASCAL GET_VIRTUAL_INTERRUPT_STATE_PROCEDURE                      :PROC
GLOBAL PASCAL GET_CPU_MODE_PROCEDURE                                     :PROC
GLOBAL PASCAL GET_DESCRIPTOR_PROCEDURE                                   :PROC
GLOBAL PASCAL GET_ENHANCED_MODE_WINDOWS_INSTALLED_STATE_PROCEDURE        :PROC
GLOBAL PASCAL GET_ENHANCED_MODE_WINDOWS_ENTRY_POINT_ADDRESS_PROCEDURE    :PROC
GLOBAL PASCAL GET_FREE_MEMORY_INFORMATION_PROCEDURE                      :PROC
GLOBAL PASCAL GET_RAW_CPU_MODE_SWITCH_ADDRESSES_PROCEDURE                :PROC
GLOBAL PASCAL GET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE                   :PROC
GLOBAL PASCAL GET_SELECTOR_INCREMENT_VALUE_PROCEDURE                     :PROC
GLOBAL PASCAL GET_SEGMENT_BASE_ADDRESS_PROCEDURE                         :PROC
GLOBAL PASCAL GET_STATE_SAVE_RESTORE_ADDRESSES_PROCEDURE                 :PROC
GLOBAL PASCAL GET_PAGE_SIZE_PROCEDURE                                    :PROC
GLOBAL PASCAL GET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE           :PROC
GLOBAL PASCAL GET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE              :PROC
GLOBAL PASCAL GET_VERSION_PROCEDURE                                      :PROC
GLOBAL PASCAL LOCK_LINEAR_REGION_PROCEDURE                               :PROC
GLOBAL PASCAL MAP_REAL_MODE_SEGMENT_TO_DESCRIPTOR_PROCEDURE              :PROC
GLOBAL PASCAL MARK_PAGE_AS_DEMAND_PAGING_CANDIDATE_PROCEDURE             :PROC
GLOBAL PASCAL MARK_REAL_MODE_REGION__AS_PAGEABLE_PROCEDURE               :PROC
GLOBAL PASCAL NOTIFY_BACKGROUND_SWITCH_PROCEDURE                         :PROC
GLOBAL PASCAL NOTIFY_FOREGROUND_SWITCH_PROCEDURE                         :PROC
GLOBAL PASCAL OBTAIN_REAL_TO_PROTECTED_MODE_SWITCH_ENTRY_POINT_PROCEDURE :PROC
GLOBAL PASCAL PHYSICAL_ADDRESS_MAPPING_PROCEDURE                         :PROC
GLOBAL PASCAL RELEASE_CURRENT_VM_TIME_SLICE_PROCEDURE                    :PROC
GLOBAL PASCAL RESET_DEBUG_WATCHPOINT_PROCEDURE                           :PROC
GLOBAL PASCAL RESIZE_DOS_MEMORY_BLOCK_PROCEDURE                          :PROC
GLOBAL PASCAL RESIZE_MEMORY_BLOCK_PROCEDURE                              :PROC
GLOBAL PASCAL RESTORE_VIDEO_REGISTER_STATE_PROCEDURE                     :PROC
GLOBAL PASCAL SAVE_VIDEO_REGISTER_STATE_PROCEDURE                        :PROC
GLOBAL PASCAL SET_DEBUG_WATCHPOINT_PROCEDURE                             :PROC
GLOBAL PASCAL SET_DESCRIPTOR_PROCEDURE                                   :PROC
GLOBAL PASCAL SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE                     :PROC
GLOBAL PASCAL SET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE           :PROC
GLOBAL PASCAL SET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE              :PROC
GLOBAL PASCAL SET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE                   :PROC
GLOBAL PASCAL SET_SEGMENT_BASE_ADDRESS_PROCEDURE                         :PROC
GLOBAL PASCAL SET_SEGMENT_LIMIT_PROCEDURE                                :PROC
GLOBAL PASCAL SIMULATE_REAL_MODE_INTERRUPT_PROCEDURE                     :PROC
GLOBAL PASCAL SWITCH_VMS_AND_CALLBACK_PROCEDURE                          :PROC
GLOBAL PASCAL UNLOCK_LINEAR_REGION_PROCEDURE                             :PROC
GLOBAL PASCAL WINDOWS_BEGIN_EXIT_PROCEDURE                               :PROC
GLOBAL PASCAL WINDOWS_INITIALIZATION_NOTIFICATION_PROCEDURE              :PROC
GLOBAL PASCAL WINDOWS_INITIALIZATION_COMPLETE_NOTIFICATION_PROCEDURE     :PROC
GLOBAL PASCAL WINDOWS_TERMINATION_NOTIFICATION_PROCEDURE                 :PROC
GLOBAL PASCAL ERROR_MEMDRV_NOTIFICATION_PROCEDURE                        :PROC

GLOBAL PASCAL GRAPHIC_DRIVER_INSTALL_PROCEDURE                           :PROC
GLOBAL PASCAL GRAPHIC_DRIVER_RELEASE_PROCEDURE                           :PROC
GLOBAL PASCAL SCREEN_ALOC_ACTUAL_PROCEDURE                               :PROC
GLOBAL PASCAL SCREEN_ALOC_LOGICAL_PROCEDURE                              :PROC
GLOBAL PASCAL SCREEN_ALOC_PHYSICAL_PROCEDURE                             :PROC
GLOBAL PASCAL SCREEN_INIT_ACTUAL_PROCEDURE                               :PROC
GLOBAL PASCAL SCREEN_FREE_ACTUAL_PROCEDURE                               :PROC
GLOBAL PASCAL SCREEN_FREE_LOGICAL_PROCEDURE                              :PROC
GLOBAL PASCAL SCREEN_FREE_PHYSICAL_PROCEDURE                             :PROC

GLOBAL PASCAL VIDEO_BANK_SWAP_PROCEDURE                                  :PROC
GLOBAL PASCAL PIXEL_PLOT_ACTUAL_PROCEDURE                                :PROC
GLOBAL PASCAL PIXEL_PLOT_LOGICAL_PROCEDURE                               :PROC
GLOBAL PASCAL PIXEL_PLOT_PHYSICAL_PROCEDURE                              :PROC

GLOBAL PASCAL GRAPHIC_DRIVER_INSTALL_PROCEDURE                           :PROC
GLOBAL PASCAL GRAPHIC_DRIVER_RELEASE_PROCEDURE                           :PROC
GLOBAL PASCAL PIXEL_PLOT_ACTUAL_PROCEDURE                                :PROC
;#######################################################################################################
;       EXPORT
;#######################################################################################################
PUBLIC  WINDOW_LOOP_PROCEDURE
;#######################################################################################################
;       DATASEG
;#######################################################################################################
DATASEG
                                                                         DB  16 DUP (0)     
EMPTY_ASCIIZ_STRING_GLOBAL                                               DB  020H,000H
_DPMIGATE       DD     0                  ; DPMI GATE ADDRESS
;#######################################################################################################
;       UDATASEG
;#######################################################################################################
UDATASEG

LABEL           _RING0GATE      DWORD 
_RING0_OFF      DW     0
_RING0_SEL      DW     0
_MSDOSZSTR      DB     "MS-DOS",0                  ; DPMI STRING ARGUMENT
_DSC_SEL_       DW     0
_LDT_SEL        DW     0                           ; LOCAL DESCRIPTOR TABLE


dpmiproc        DD      0       ;dpmi extensions entry point.
LABEL RING0CALLGATE DWORD       ;use this to call ring-0 code.
ring0_off       DW      0       ;callgate selector for RING0FUNC
ring0_cs        DW      0       ;       /
ms_dos_str      DB      "MS-DOS",0
ldt_selector    DW      0       ;for direct writing to ldt.
descriptor_selector DW  0       ;ring0, cannot be accessed directly.


HANDLE_DEVICE_CONTEXT_GLOBAL                                              DW ?
HANDLE_PROGRAM_PREVIOUS_INSTANCE_GLOBAL                                   DW ?
HANDLE_PROGRAM_CURRENT_INSTANCE_GLOBAL                                    DW ?
HANDLE_WINDOW_INSTANCE_GLOBAL                                             DW ?
POINTER_COMMAND_LINE_GLOBAL                                               DW ?
PROGRAM_SEGMENT_PREFIX_GLOBAL                                             DW ?
WINDOW_DISPLAY_STYLE_GLOBAL                                               DW ?
STRUCTURE_MESSAGE_GLOBAL                                           MSGSTRUCT ?

BYTES_PER_LOGICAL_SCAN_LINE_SHIFT_GLOBAL                                  DB ?
CURRENT_VIDEO_BANK_GLOBAL                                                 DB ?
SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL                                     DW ?
SELECTOR_BASE_ACTUAL_BANK_GLOBAL                                          DW ?
SELECTOR_BASE_ACTUAL_OFFSET1_GLOBAL                                       DW ?
SELECTOR_BASE_ACTUAL_OFFSET2_GLOBAL                                       DW ?
SELECTOR_BASE_LOGICAL_COLOR_BLUE_GLOBAL                                   DW ?
SELECTOR_BASE_LOGICAL_COLOR_GREEN_GLOBAL                                  DW ?
SELECTOR_BASE_LOGICAL_COLOR_RED_GLOBAL                                    DW ?
SELECTOR_BASE_PHYSICAL_COLOR_BLUE_GLOBAL                                  DW ?
SELECTOR_BASE_PHYSICAL_COLOR_GREEN_GLOBAL                                 DW ?
SELECTOR_BASE_PHYSICAL_COLOR_RED_GLOBAL                                   DW ?
SELECTOR_HANDLE_ACTUAL_BANK_HIGH_GLOBAL                                   DW ?
SELECTOR_HANDLE_ACTUAL_BANK_LOW_GLOBAL                                    DW ?
SELECTOR_HANDLE_ACTUAL_OFFSET1_HIGH_GLOBAL                                DW ?
SELECTOR_HANDLE_ACTUAL_OFFSET1_LOW_GLOBAL                                 DW ?
SELECTOR_HANDLE_ACTUAL_OFFSET2_HIGH_GLOBAL                                DW ?
SELECTOR_HANDLE_ACTUAL_OFFSET2_LOW_GLOBAL                                 DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_HIGH_GLOBAL                            DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_LOW_GLOBAL                             DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_HIGH_GLOBAL                           DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_LOW_GLOBAL                            DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_RED_HIGH_GLOBAL                             DW ?
SELECTOR_HANDLE_LOGICAL_COLOR_RED_LOW_GLOBAL                              DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_HIGH_GLOBAL                           DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_LOW_GLOBAL                            DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_HIGH_GLOBAL                          DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_LOW_GLOBAL                           DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_RED_HIGH_GLOBAL                            DW ?
SELECTOR_HANDLE_PHYSICAL_COLOR_RED_LOW_GLOBAL                             DW ?
WINDOW_GRANULARITY_MASK_GLOBAL                                            DW ?
WINDOW_GRANULARITY_SHIFT_GLOBAL                                           DB ?
WINDOW_SCHEME_FUNCTION_POINTER_HIGH_GLOBAL                                DW ?
WINDOW_SCHEME_FUNCTION_POINTER_LOW_GLOBAL                                 DW ?

STRUC REAL_MODE_REGISTER_DATA_STRUCTURE
EDI_REGISTER                                                              DD  ?
ESI_REGISTER                                                              DD  ?
EBP_REGISTER                                                              DD  ?
RES_REGISTER                                                              DD  ?
EBX_REGISTER                                                              DD  ?
EDX_REGISTER                                                              DD  ?
ECX_REGISTER                                                              DD  ?
EAX_REGISTER                                                              DD  ?
CPU_REGISTER                                                              DW  ?
 ES_REGISTER                                                              DW  ?
 DS_REGISTER                                                              DW  ?
 FS_REGISTER                                                              DW  ?
 GS_REGISTER                                                              DW  ?
 IP_REGISTER                                                              DW  ?
 CS_REGISTER                                                              DW  ?
 SP_REGISTER                                                              DW  ?
 SS_REGISTER                                                              DW  ?
ENDS REAL_MODE_REGISTER_DATA_STRUCTURE
REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL REAL_MODE_REGISTER_DATA_STRUCTURE <>

;#######################################################################################################
;       CODESEG
;#######################################################################################################
CODESEG
;#######################################################################################################
;       WINMAIN
;#######################################################################################################
        PROC    WINMAIN PASCAL

        CALL    WINDOW_INIT_PROCEDURE
;        CALL    GRAPHIC_DRIVER_INSTALL_PROCEDURE
        CALL    WINDOW_RUN_PROCEDURE
;        CALL    GRAPHIC_DRIVER_RELEASE_PROCEDURE

        RET
        ENDP    WINMAIN
;#######################################################################################################
;       WINDOW INIT PROCEDURE
;#######################################################################################################
        PROC    WINDOW_INIT_PROCEDURE PASCAL
        LOCAL   @@STRUCTURE_WINDOW_CLASS_LOCAL:WNDCLASS
        USES    DI
        USES    SI

        CMP     [HANDLE_PROGRAM_PREVIOUS_INSTANCE_GLOBAL],ZERO_EQUATE
        JNE     @@10
        MOV     SI,[HANDLE_PROGRAM_CURRENT_INSTANCE_GLOBAL]
        MOV     [@@STRUCTURE_WINDOW_CLASS_LOCAL.clsStyle], CS_BYTEALIGNCLIENT
        MOV     [WORD PTR @@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpfnWndProc      ],OFFSET WINDOW_LOOP_PROCEDURE
        MOV     [WORD PTR (@@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpfnWndProc) + 2],SEG WINDOW_LOOP_PROCEDURE
        MOV     [@@STRUCTURE_WINDOW_CLASS_LOCAL.clsCbClsExtra],ZERO_EQUATE
        MOV     [@@STRUCTURE_WINDOW_CLASS_LOCAL.clsCbWndExtra],ZERO_EQUATE
        MOV     [@@STRUCTURE_WINDOW_CLASS_LOCAL.clsHInstance],SI
        MOV     [@@STRUCTURE_WINDOW_CLASS_LOCAL.clsHbrBackground],COLOR_WINDOW + 1
        MOV     [WORD PTR @@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpszMenuName       ],ZERO_EQUATE
        MOV     [WORD PTR (@@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpszMenuName) + 2 ],ZERO_EQUATE
        MOV     [WORD PTR @@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpszClassName      ],OFFSET EMPTY_ASCIIZ_STRING_GLOBAL
        MOV     [WORD PTR (@@STRUCTURE_WINDOW_CLASS_LOCAL.clsLpszClassName) + 2],DS
        PUSH    SS
        LEA     AX,[@@STRUCTURE_WINDOW_CLASS_LOCAL]
        PUSH    AX
        CALL    REGISTERCLASS
@@10:   MOV     SI,[HANDLE_PROGRAM_CURRENT_INSTANCE_GLOBAL]
        PUSH    DS
        PUSH    OFFSET EMPTY_ASCIIZ_STRING_GLOBAL
        PUSH    DS
        PUSH    OFFSET EMPTY_ASCIIZ_STRING_GLOBAL
        PUSH    WS_DLGFRAME OR WS_SYSMENU
        PUSH    ZERO_EQUATE
        PUSH    CW_USEDEFAULT
        PUSH    CW_USEDEFAULT
        PUSH    256
        PUSH    256
        PUSH    ZERO_EQUATE
        PUSH    ZERO_EQUATE
        PUSH    SI
        PUSH    ZERO_EQUATE
        PUSH    ZERO_EQUATE
        CALL    CREATEWINDOW
        MOV     DI,AX                   ; Save window handle in di
        MOV     [HANDLE_WINDOW_INSTANCE_GLOBAL],DI
        PUSH    DI
        PUSH    [WINDOW_DISPLAY_STYLE_GLOBAL]
        CALL    SHOWWINDOW
        PUSH    DI
        CALL    UPDATEWINDOW
        RET
ENDP    WINDOW_INIT_PROCEDURE
;#######################################################################################################
;       WINDOW RUN
;#######################################################################################################
PROC    WINDOW_RUN_PROCEDURE PASCAL

@@10:   PUSH    DS
        PUSH    OFFSET STRUCTURE_MESSAGE_GLOBAL
        PUSH    ZERO_EQUATE
        PUSH    ZERO_EQUATE
        PUSH    ZERO_EQUATE
        CALL    GETMESSAGE
        OR      AX,AX
        JZ      @@99
        PUSH    DS
        PUSH    OFFSET STRUCTURE_MESSAGE_GLOBAL
        CALL    TRANSLATEMESSAGE
        PUSH    DS
        PUSH    OFFSET STRUCTURE_MESSAGE_GLOBAL
        CALL    DISPATCHMESSAGE
        JMP     @@10
@@99:   RET
ENDP    WINDOW_RUN_PROCEDURE
;#######################################################################################################
;       WINDOW LOOP (callback)
;#######################################################################################################
        PROC    WINDOW_LOOP_PROCEDURE WINDOWS PASCAL FAR
        ARG     OPTIONAL_SECOND_PARAMETER_ARGUMENT:DWORD
        ARG     OPTIONAL_FIRST_PARAMETER_ARGUMENT :WORD
        ARG     STRUCTURE_MESSAGE_ARGUMENT        :WORD
        ARG     WINDOW_HANDLE_ARGUMENT            :WORD
        USES    SI

        MOV     SI,[STRUCTURE_MESSAGE_ARGUMENT]
        CMP     SI,WM_LBUTTONDOWN
        JE      @@WMLBUTTONDOWN
        CMP     SI,WM_DESTROY
        JE      @@WMDESTROY
        JMP     @@DEFWINDOWPROC


@@WMLBUTTONDOWN:
; 
;       RING 0 INSTALL
;       BEFORE:USER PRIVILEGES - NO DIRECT HARDWARE ACCESS
;       THUNK FROM ENH386 PMODE16 RING LEVEL 3 TO LEVEL 0
;       AFTER: SUPERVISOR PRIVILEGES - DIRECT HARDWARE ACCESS 
; 
jmp there
mov ax,cs
push ax
call GLOBALPAGELOCK
                LEA     SI,[_MSDOSZSTR]             ; UNDOCUMENTED PARAM CALL
                MOV     AX,00000168AH               ; GET DPMI CALL GATE
                INT     00000002FH                  ; MULTIPLEX SERVICES
                MOV     WORD PTR DS:[_DPMIGATE  ],DI; SAVE DPMI GATE OFFSET
                MOV     WORD PTR DS:[_DPMIGATE+2],ES; SAVE DPMI GATE SEGMENT
                MOV     AX,000000100H               ; UNDOCUMENTED GET LDT SEL
                CALL    _DPMIGATE                   ; GET GATE LDT SELECTOR
                MOV     WORD PTR DS:[_LDT_SEL],AX   ; LOCAL DESCRIPTOR TABLE
                MOV     BX,CS                       ; LOCAL DESCRIPTOR TABLE
                PUSH    AX                          ; SAVE 32-BIT DESCRIPTOR
;                MOV     AX,00000000AH               ; CREATE ALIAS DESCRIPTOR
;                INT     000000031H                  ; DPMI SERVICES
PUSH CS
CALL ALLOCSELECTOR
                AND     AX,00000FFF8H               ; LDT DESCRIPTOR OFFSET
                MOV     BX,AX                       ; LDT DESCRIPTOR OFFSET
                POP     ES                          ; GET 32-BIT DESCRIPTOR
                MOV     AL,BYTE PTR ES:[BX+5]       ; GET ACCESS RIGHTS BYTE
                AND     AL,10011111B                ; CLEAR DPL FIELD NUMBER
                MOV     BYTE PTR ES:[BX+5],AL       ; SET ACCESS RIGHTS BYTE
                MOV     AL,BYTE PTR ES:[BX+6]       ; GET GRANUL AND SEG SIZE
                OR      AL,01000000B                ; BIT 7= 32-BIT
                MOV     BYTE PTR ES:[BX+6],AL       ; SET GRANUL AND SEG SIZE
                OR      BX,00000100B                ; BIT 2= LDT LEAV DPL NUM
                MOV     DI,BX                       ; TEMP SAVE.
                MOV     WORD PTR DS:[_DSC_SEL_],BX  ; SAVE RING0 OFFSET
                MOV     BX,0                        ; CREATE 0 SEG LDT DESC
                MOV     AX,00000000AH               ; CREATE ALIAS DESCRIPTOR
                INT     000000031H                  ; DPMI SERVICES
                MOV     WORD PTR DS:[_RING0_SEL],AX ; SAVE RING0 SELECTOR
                AND     AX,00000FFF8H               ; LDT DESCRIPTOR OFFSET    
                MOV     BX,AX                       ; LDT DESCRIPTOR OFFSET
                MOV     WORD PTR ES:[BX+0],OFFSET RING0FUNC  ; RING 0 CODE OFFSET
                MOV     ES:[BX+2],DI                ; RING 0 CS ALIAS
                MOV     BYTE PTR ES:[BX+4],0        ; 4 DWORDS COPIED TO STACK
                MOV     BYTE PTR ES:[BX+5],11101100B; PRESENT=1 DPL=3 APP=0 TYP=C
                MOV     WORD PTR ES:[BX+6],0        ; TYPE=C:386 CALLGATE
                CLI                                 ; CLEAR INTERRUPTS
                CALL    DWORD PTR DS:[_RING0GATE]    ; THUNK FROM RING 3 TO 0
                STI                                 ; SET INTERRUPTS

;                MOV     AX,000000500H               ; GET FREE MEM INFORMATION
;                INT     000000031H                  ; DPMI SERVICES
;                PUSH    BX                          ; BYTE BLOCK SIZE MSWORD
;                PUSH    CX                          ; BYTE BLOCK SIZE LSWORD
;                MOV     CX,WORD PTR ES:[DI]         ; LARGEST BLOCK BYTE SIZE
;                MOV     BX,WORD PTR ES:[DI+2]       ; 48-BYTE BUFF SEL:OFF
;                MOV     AX,000000501H               ; ALLOCATE MEMORY BLOCK
;                INT     000000031H                  ; DPMI SERVICES
;                POP     SI                          ; BYTE BLOCK SIZE MSWORD
;                POP     DI                          ; BYTE BLOCK SIZE LSWORD
;                MOV     AX,000000600H               ; LOCK LINEAR REGION
;                INT     000000031H                  ; DPMI SERVICES


;makering0selector PROC
;
;        invoke GLOBALPAGELOCK,cs
there:
        push cs
        call GLOBALPAGELOCK

        cmp     ax,0
        je      lockfailed
;
        lea     si,ms_dos_str
        mov     ax,168Ah        ;get dpmi extensions entry point.
        int     2Fh             ;-->es:di (undocumented)
;;***        cmp     al,0                 ?????
;;***        jne      extensionsnotfnd
        mov     WORD PTR DS:[dpmiproc],di   ;save entry point
        mov     WORD PTR DS:[dpmiproc+2],es ;       /
        mov     ax,100h         ;undocumented
        call    dpmiproc        ;-->ax=selector to ldt.
        jc      extensionsnotfnd
        mov     ldt_selector,ax
        mov     es,ax
;;create a ring-0 32-bit descriptor...
         push   es

;        invoke  ALLOCSELECTOR,cs        ;-->ax=alias to cs.

         push cs
         call ALLOCSELECTOR

         pop    es
        cmp     ax,0
        je      selectorerror
        and     ax,0FFF8h               ;get offset of descriptor in ldt.
        mov     bx,ax
        mov     al,es:[bx+5]            ;get access-rights byte.
        and     al,10011111b            ;clear dpl field.#
        mov     es:[bx+5],al
        mov     al,es:[bx+6]            ;get granularity & seg-size bits.
        or      al,01000000b            ;set bit7, for 32-bit.
        mov     es:[bx+6],al
        or      bx,0100b                ;set bit-2, selects ldt.leave dpl=0.#
        mov     di,bx                   ;temp save.
        mov     descriptor_selector,bx  ;save.
;;create callgate, to above descriptor.....
         push   es

;        invoke  ALLOCSELECTOR,0         ;create a descriptor in ldt.

         push 0
         call ALLOCSELECTOR


         pop    es
        cmp     ax,0
        je      selectorerror
        mov     ring0_cs,ax             ;save final selector.
        and     ax,0FFF8h               ;get offset of descriptor in ldt.
        mov     bx,ax
mov ax,offset RING0FUNC
        mov     es:[bx],ax       ;my ring0 code
        mov     es:[bx+2],di            ;ring0 alias.
        mov     BYTE PTR es:[bx+4],0 ;04        ;****??dwords copied to stack.
        mov     BYTE PTR es:[bx+5],11101100b    ;present=1,dpl=3,app=00,type=C
        mov     WORD PTR es:[bx+6],0            ;      (type=C: 386 callgate)
;
qwert:  jmp     SHORT qwerty
lockfailed:
extensionsnotfnd:
selectorerror:
qwerty:

        cli
        call RING0CALLGATE      ;will call ring-0 code
; in al,61h      ;####turn off tone
; and al,0FCh    ;####
; out 61h,al     ;####
        sti

                JMP     @@99
@@WMDESTROY:
        PUSH    ZERO_EQUATE
        CALL    POSTQUITMESSAGE
        XOR     DX,DX
        XOR     AX,AX
        JMP     @@99
@@DEFWINDOWPROC:
        PUSH    [WINDOW_HANDLE_ARGUMENT]
        PUSH    SI
        PUSH    [OPTIONAL_FIRST_PARAMETER_ARGUMENT]
        PUSH    [OPTIONAL_SECOND_PARAMETER_ARGUMENT]
        CALL    DEFWINDOWPROC
@@99:   RET
        ENDP    WINDOW_LOOP_PROCEDURE
;#######################################################################################################
;       ALLOCATE DOS MEMORY BLOCK 
;#######################################################################################################
        PROC  ALLOCATE_DOS_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   NUMBER_OF_PARAGRAPHS_DESIRED_ARGUMENT:WORD
              
        MOV   BX,[NUMBER_OF_PARAGRAPHS_DESIRED_ARGUMENT]
        MOV   AX,ALLOCATE_DOS_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET
        ENDP  ALLOCATE_DOS_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       ALLOCATE LDT DESCRIPTORS
;#######################################################################################################
        PROC  ALLOCATE_LDT_DESCRIPTORS_PROCEDURE PASCAL
        ARG   NUMBER_OF_DESCRIPTORS_TO_ALLOCATE_ARGUMENT:WORD
              
        MOV   CX,[NUMBER_OF_DESCRIPTORS_TO_ALLOCATE_ARGUMENT]
        MOV   AX,ALLOCATE_LDT_DESCRIPTORS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  ALLOCATE_LDT_DESCRIPTORS_PROCEDURE
;#######################################################################################################
;       ALLOCATE MEMORY BLOCK
;#######################################################################################################
        PROC  ALLOCATE_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   SIZE_OF_BLOCK_LOW_ARGUMENT :WORD
        ARG   SIZE_OF_BLOCK_HIGH_ARGUMENT:WORD
               
        MOV   BX,[SIZE_OF_BLOCK_HIGH_ARGUMENT]
        MOV   CX,[SIZE_OF_BLOCK_LOW_ARGUMENT]
        MOV   AX,ALLOCATE_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  ALLOCATE_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       ALLOCATE REAL MODE CALLBACK ADDRESS
;#######################################################################################################
        PROC  ALLOCATE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE PASCAL
        ARG   OFFSET_OF_PROTECTED_MODE_PROCEDURE_TO_CALL_ARGUMENT  :WORD
        ARG   SELECTOR_OF_PROTECTED_MODE_PROCEDURE_TO_CALL_ARGUMENT:WORD

        CALL  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE
        MOV   DS,[SELECTOR_OF_PROTECTED_MODE_PROCEDURE_TO_CALL_ARGUMENT]
        MOV   SI,[OFFSET_OF_PROTECTED_MODE_PROCEDURE_TO_CALL_ARGUMENT]
        MOV   AX,ALLOCATE_REAL_MODE_CALLBACK_ADDRESS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  ALLOCATE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE
;#######################################################################################################
;       ALLOCATE SELECTOR
;#######################################################################################################
        PROC  ALLOCATE_SELECTOR_PROCEDURE PASCAL
        LOCAL @@SELECTOR_LINEAR_MEMORY_HIGH_LOCAL:WORD
        LOCAL @@SELECTOR_LINEAR_MEMORY_LOW_LOCAL :WORD
        LOCAL @@SELECTOR_HANDLE_HIGH_LOCAL       :WORD
        LOCAL @@SELECTOR_HANDLE_LOW_LOCAL        :WORD
        LOCAL @@SELECTOR_LOCAL                   :WORD

        PUSH  SEGMENT_HIGH_BYTE_EQUATE
        PUSH  SEGMENT_LOW_BYTE_EQUATE
        CALL  ALLOCATE_MEMORY_BLOCK_PROCEDURE
        MOV   [@@SELECTOR_LINEAR_MEMORY_HIGH_LOCAL],BX
        MOV   [@@SELECTOR_LINEAR_MEMORY_LOW_LOCAL],CX
        MOV   [@@SELECTOR_HANDLE_HIGH_LOCAL],SI
        MOV   [@@SELECTOR_HANDLE_LOW_LOCAL],DI
        PUSH  ONE_EQUATE
        CALL  ALLOCATE_LDT_DESCRIPTORS_PROCEDURE
        MOV   [@@SELECTOR_LOCAL],AX
        PUSH  [@@SELECTOR_LOCAL]
        PUSH  [@@SELECTOR_LINEAR_MEMORY_HIGH_LOCAL]
        PUSH  [@@SELECTOR_LINEAR_MEMORY_LOW_LOCAL]
        CALL  SET_SEGMENT_BASE_ADDRESS_PROCEDURE
        PUSH  [@@SELECTOR_LOCAL]
        PUSH  DECREMENTED_SEGMENT_BYTE_HIGH_EQUATE
        PUSH  DECREMENTED_SEGMENT_BYTE_LOW_EQUATE
        CALL  SET_SEGMENT_LIMIT_PROCEDURE
        PUSH  [@@SELECTOR_LOCAL]
        MOV   CX,CS
        AND   CX,CURRENT_PRIVILEGE_LEVEL_MASK_EQUATE
        SHL   CL,CURRENT_PRIVILEGE_LEVEL_SHIFT_EQUATE
        OR    CL,SEGMENT_PRESENT_IN_MEMORY_EQUATE
        OR    CL,DESCRIPTOR_PRIVILEGE_LEVEL_ZERO_EQUATE
        OR    CL,DESCRIPTOR_TYPE_APPLICATION_SEGMENT_EQUATE
        OR    CL,APPLICATION_SEGMENT_READ_WRITE_EQUATE
        PUSH  CX
        PUSH  ZERO_EQUATE
        CALL  SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE
        MOV   AX,[@@SELECTOR_LOCAL]
        MOV   SI,[@@SELECTOR_HANDLE_HIGH_LOCAL]
        MOV   DI,[@@SELECTOR_HANDLE_LOW_LOCAL]
        RET
        ENDP  ALLOCATE_SELECTOR_PROCEDURE
;#######################################################################################################
;       ALLOCATE SPECIFIC LDT DESCRIPTOR
;#######################################################################################################
        PROC  ALLOCATE_SPECIFIC_LDT_DESCRIPTOR_PROCEDURE PASCAL
        ARG   SELECTOR_ARGUMENT:WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   AX,ALLOCATE_SPECIFIC_LDT_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  ALLOCATE_SPECIFIC_LDT_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       BEGIN CRITICAL SECTION
;#######################################################################################################
        PROC  BEGIN_CRITICAL_SECTION_PROCEDURE PASCAL
;for debugging
;        MOV   AX,BEGIN_CRITICAL_SECTION_EQUATE
;        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  BEGIN_CRITICAL_SECTION_PROCEDURE
;#######################################################################################################
;       CALL REAL MODE PROCEDURE WITH FAR RETURN FRAME
;#######################################################################################################
        PROC  CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_PROCEDURE PASCAL
        ARG   SS_REGISTER_ARGUMENT                                      :WORD
        ARG   SP_REGISTER_ARGUMENT                                      :WORD
        ARG   CS_REGISTER_ARGUMENT                                      :WORD
        ARG   IP_REGISTER_ARGUMENT                                      :WORD
        ARG   GS_REGISTER_ARGUMENT                                      :WORD
        ARG   FS_REGISTER_ARGUMENT                                      :WORD
        ARG   DS_REGISTER_ARGUMENT                                      :WORD
        ARG   ES_REGISTER_ARGUMENT                                      :WORD
        ARG   CPU_REGISTER_ARGUMENT                                     :WORD
        ARG   EAX_REGISTER_ARGUMENT                                     :WORD
        ARG   ECX_REGISTER_ARGUMENT                                     :WORD
        ARG   EDX_REGISTER_ARGUMENT                                     :WORD
        ARG   EBX_REGISTER_ARGUMENT                                     :WORD
        ARG   RES_REGISTER_ARGUMENT                                     :WORD
        ARG   EBP_REGISTER_ARGUMENT                                     :WORD
        ARG   ESI_REGISTER_ARGUMENT                                     :WORD
        ARG   EDI_REGISTER_ARGUMENT                                     :WORD
        ARG   NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT:WORD

        XOR   EAX,EAX
        MOV   AX,[EDI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDI_REGISTER],EAX
        MOV   AX,[ESI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ESI_REGISTER],EAX
        MOV   AX,[EBP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBP_REGISTER],EAX
        MOV   AX,[RES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.RES_REGISTER],EAX
        MOV   AX,[EBX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBX_REGISTER],EAX
        MOV   AX,[EDX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDX_REGISTER],EAX
        MOV   AX,[ECX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ECX_REGISTER],EAX
        MOV   AX,[EAX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EAX_REGISTER],EAX
        MOV   AX,[CPU_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CPU_REGISTER],AX
        MOV   AX,[ES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ES_REGISTER],AX
        MOV   AX,[DS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.DS_REGISTER],AX
        MOV   AX,[FS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.FS_REGISTER],AX
        MOV   AX,[GS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.GS_REGISTER],AX
        MOV   AX,[IP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.IP_REGISTER],AX
        MOV   AX,[CS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CS_REGISTER],AX
        MOV   AX,[SP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SP_REGISTER],AX
        MOV   AX,[SS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SS_REGISTER],AX
        CALL  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE
        XOR   BH,BH
        MOV   CX,[NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT]
        MOV   AX,CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_PROCEDURE
;#######################################################################################################
;       CALL REAL MODE PROCEDURE WITH IRET FRAME
;#######################################################################################################
        PROC  CALL_REAL_MODE_PROCEDURE_WITH_IRET_FRAME_PROCEDURE PASCAL
        ARG   SS_REGISTER_ARGUMENT                                      :WORD
        ARG   SP_REGISTER_ARGUMENT                                      :WORD
        ARG   CS_REGISTER_ARGUMENT                                      :WORD
        ARG   IP_REGISTER_ARGUMENT                                      :WORD
        ARG   GS_REGISTER_ARGUMENT                                      :WORD
        ARG   FS_REGISTER_ARGUMENT                                      :WORD
        ARG   DS_REGISTER_ARGUMENT                                      :WORD
        ARG   ES_REGISTER_ARGUMENT                                      :WORD
        ARG   CPU_REGISTER_ARGUMENT                                     :WORD
        ARG   EAX_REGISTER_ARGUMENT                                     :WORD
        ARG   ECX_REGISTER_ARGUMENT                                     :WORD
        ARG   EDX_REGISTER_ARGUMENT                                     :WORD
        ARG   EBX_REGISTER_ARGUMENT                                     :WORD
        ARG   RES_REGISTER_ARGUMENT                                     :WORD
        ARG   EBP_REGISTER_ARGUMENT                                     :WORD
        ARG   ESI_REGISTER_ARGUMENT                                     :WORD
        ARG   EDI_REGISTER_ARGUMENT                                     :WORD
        ARG   NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT:WORD

        XOR   EAX,EAX
        MOV   AX,[EDI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDI_REGISTER],EAX
        MOV   AX,[ESI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ESI_REGISTER],EAX
        MOV   AX,[EBP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBP_REGISTER],EAX
        MOV   AX,[RES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.RES_REGISTER],EAX
        MOV   AX,[EBX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBX_REGISTER],EAX
        MOV   AX,[EDX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDX_REGISTER],EAX
        MOV   AX,[ECX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ECX_REGISTER],EAX
        MOV   AX,[EAX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EAX_REGISTER],EAX
        MOV   AX,[CPU_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CPU_REGISTER],AX
        MOV   AX,[ES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ES_REGISTER],AX
        MOV   AX,[DS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.DS_REGISTER],AX
        MOV   AX,[FS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.FS_REGISTER],AX
        MOV   AX,[GS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.GS_REGISTER],AX
        MOV   AX,[IP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.IP_REGISTER],AX
        MOV   AX,[CS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CS_REGISTER],AX
        MOV   AX,[SP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SP_REGISTER],AX
        MOV   AX,[SS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SS_REGISTER],AX
        CALL  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE
        XOR   BH,BH
        MOV   CX,[NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT]
        MOV   AX,CALL_REAL_MODE_PROCEDURE_WITH_IRET_RETURN_FRAME_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  CALL_REAL_MODE_PROCEDURE_WITH_IRET_FRAME_PROCEDURE
;#######################################################################################################
;       CLEAR DEBUG WATCHPOINT
;#######################################################################################################
        PROC  CLEAR_DEBUG_WATCHPOINT_PROCEDURE PASCAL
        ARG   WATCHPOINT_HANDLE_ARGUMENT:WORD
              
        MOV   BX,[WATCHPOINT_HANDLE_ARGUMENT]
        MOV   AX,CLEAR_DEBUG_WATCHPOINT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  CLEAR_DEBUG_WATCHPOINT_PROCEDURE
;#######################################################################################################
;       CREATE ALIAS DESCRIPTOR
;#######################################################################################################
        PROC  CREATE_ALIAS_DESCRIPTOR_PROCEDURE PASCAL
        ARG   SELECTOR_ARGUMENT:WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   AX,CREATE_ALIAS_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET
        ENDP  CREATE_ALIAS_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       DEVICE CALL OUT
;#######################################################################################################
        PROC  DEVICE_CALL_OUT_PROCEDURE PASCAL
        ARG   DEVICE_IDENTIFIER_FOR_A_VIRTUAL_DEVICE_ARGUMENT:WORD

        MOV   BX,[DEVICE_IDENTIFIER_FOR_A_VIRTUAL_DEVICE_ARGUMENT]
        MOV   AX,DEVICE_CALL_OUT_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  DEVICE_CALL_OUT_PROCEDURE
;#######################################################################################################
;       DISABLE VM ASSISTED SAVE RESTORE
;#######################################################################################################
        PROC  DISABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE PASCAL
              
        MOV   AX,DISABLE_VM_ASSISTED_SAVE_RESTORE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  DISABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE
;#######################################################################################################
;       DISCARD PAGE CONTENTS
;#######################################################################################################
        PROC  DISCARD_PAGE_CONTENTS_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_DISCARD_LOW_ARGUMENT                  :WORD
        ARG   SIZE_OF_REGION_TO_DISCARD_HIGH_ARGUMENT                 :WORD
        ARG   STARTING_LINEAR_ADDRESS_OF_PAGE_TO_DISCARD_LOW_ARGUMENT :WORD
        ARG   STARTING_LINEAR_ADDRESS_OF_PAGE_TO_DISCARD_HIGH_ARGUMENT:WORD
              
        MOV   BX,[STARTING_LINEAR_ADDRESS_OF_PAGE_TO_DISCARD_HIGH_ARGUMENT]
        MOV   CX,[STARTING_LINEAR_ADDRESS_OF_PAGE_TO_DISCARD_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_DISCARD_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_DISCARD_LOW_ARGUMENT]
        MOV   AX,DISCARD_PAGE_CONTENTS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  DISCARD_PAGE_CONTENTS_PROCEDURE
;#######################################################################################################
;       ENABLE VM ASSISTED SAVE RESTORE
;#######################################################################################################
        PROC  ENABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE PASCAL

        MOV   AX,ENABLE_VM_ASSISTED_SAVE_RESTORE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  ENABLE_VM_ASSISTED_SAVE_RESTORE_PROCEDURE
;#######################################################################################################
;       END CRITICAL SECTION
;#######################################################################################################
        PROC  END_CRITICAL_SECTION_PROCEDURE PASCAL

        MOV   AX,END_CRITICAL_SECTION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  END_CRITICAL_SECTION_PROCEDURE
;#######################################################################################################
;       ENTER CRITICAL SECTION
;#######################################################################################################
        PROC  ENTER_CRITICAL_SECTION_PROCEDURE PASCAL
              
        MOV   AX,ENTER_CRITICAL_SECTION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  ENTER_CRITICAL_SECTION_PROCEDURE
;#######################################################################################################
;       EXIT CRITICAL SECTION
;#######################################################################################################
        PROC  EXIT_CRITICAL_SECTION_PROCEDURE PASCAL
              
        MOV   AX,EXIT_CRITICAL_SECTION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  EXIT_CRITICAL_SECTION_PROCEDURE
;#######################################################################################################
;       FREE DOS MEMORY BLOCK
;#######################################################################################################
        PROC  FREE_DOS_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   SELECTOR_OF_BLOCK_TO_FREE_ARGUMENT:WORD
              
        MOV   DX,[SELECTOR_OF_BLOCK_TO_FREE_ARGUMENT]
        MOV   AX,FREE_DOS_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  FREE_DOS_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       FREE LDT DESCRIPTOR
;#######################################################################################################
        PROC  FREE_LDT_DESCRIPTOR_PROCEDURE PASCAL
        ARG   SELECTOR_OF_DESCRIPTOR_TO_FREE_ARGUMENT:WORD
              
        MOV   BX,[SELECTOR_OF_DESCRIPTOR_TO_FREE_ARGUMENT]
        MOV   AX,FREE_LDT_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  FREE_LDT_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       FREE MEMORY BLOCK
;#######################################################################################################
        PROC  FREE_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   MEMORY_BLOCK_HANDLE_LOW_ARGUMENT:WORD
        ARG   MEMORY_BLOCK_HANDLE_HIGH_ARGUMENT:WORD
              
        MOV   SI,[MEMORY_BLOCK_HANDLE_HIGH_ARGUMENT]
        MOV   DI,[MEMORY_BLOCK_HANDLE_LOW_ARGUMENT]
        MOV   AX,FREE_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  FREE_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       FREE REAL MODE CALLBACK ADDRESS
;#######################################################################################################
        PROC  FREE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE PASCAL
        ARG   REAL_MODE_ADDRESS_TO_FREE_LOW_ARGUMENT :WORD
        ARG   REAL_MODE_ADDRESS_TO_FREE_HIGH_ARGUMENT:WORD
              
        MOV   CX,[REAL_MODE_ADDRESS_TO_FREE_HIGH_ARGUMENT]
        MOV   DX,[REAL_MODE_ADDRESS_TO_FREE_LOW_ARGUMENT]
        MOV   AX,FREE_REAL_MODE_CALLBACK_ADDRESS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  FREE_REAL_MODE_CALLBACK_ADDRESS_PROCEDURE
;#######################################################################################################
;       FREE SELECTOR
;#######################################################################################################
        PROC  FREE_SELECTOR_PROCEDURE PASCAL
        ARG   @@SELECTOR_HANDLE_LOW_ARGUMENT :WORD
        ARG   @@SELECTOR_HANDLE_HIGH_ARGUMENT:WORD
        ARG   @@SELECTOR_ARGUMENT            :WORD

        PUSH  [@@SELECTOR_ARGUMENT]
        CALL  FREE_LDT_DESCRIPTOR_PROCEDURE
        PUSH  [@@SELECTOR_HANDLE_HIGH_ARGUMENT]
        PUSH  [@@SELECTOR_HANDLE_LOW_ARGUMENT]
        CALL  FREE_MEMORY_BLOCK_PROCEDURE
        RET
        ENDP  FREE_SELECTOR_PROCEDURE
;#######################################################################################################
;       GET AND DISABLE VIRTUAL INTERRUPT STATE
;#######################################################################################################
        PROC  GET_AND_DISABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE PASCAL
              
        MOV   AX,GET_AND_DISABLE_VIRTUAL_INTERRUPT_STATE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_AND_DISABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE
;#######################################################################################################
;       GET AND ENABLE VIRTUAL INTERRUPT STATE
;#######################################################################################################
        PROC  GET_AND_ENABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE PASCAL
              
        MOV   AX,GET_AND_ENABLE_VIRTUAL_INTERRUPT_STATE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_AND_ENABLE_VIRTUAL_INTERRUPT_STATE_PROCEDURE
;#######################################################################################################
;       GET CURRENT VIRTUAL MACHINE ID
;#######################################################################################################
        PROC  GET_CURRENT_VIRTUAL_MACHINE_ID_PROCEDURE PASCAL
              
        MOV   AX,GET_CURRENT_VIRTUAL_MACHINE_ID_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  GET_CURRENT_VIRTUAL_MACHINE_ID_PROCEDURE
;#######################################################################################################
;       GET DEVICE ENTRY POINT ADDRESS
;#######################################################################################################
        PROC  GET_DEVICE_ENTRY_POINT_ADDRESS_PROCEDURE PASCAL
        ARG   DEVICE_IDENTIFIER_ARGUMENT:WORD
              
        MOV   AX,ZERO_EQUATE
        MOV   ES,AX
        XOR   DI,DI
        MOV   BX,[DEVICE_IDENTIFIER_ARGUMENT]
        MOV   AX,GET_DEVICE_ENTRY_POINT_ADDRESS_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        MOV   AX,ES
        OR    AX,DI
        JZ    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_DEVICE_ENTRY_POINT_ADDRESS_PROCEDURE
;#######################################################################################################
;       GET RAW CPU MODE SWITCH ADDRESSES
;#######################################################################################################
        PROC GET_RAW_CPU_MODE_SWITCH_ADDRESSES_PROCEDURE PASCAL

        MOV   AX,GET_RAW_CPU_MODE_SWITCH_ADDRESSES_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET
        ENDP GET_RAW_CPU_MODE_SWITCH_ADDRESSES_PROCEDURE
;#######################################################################################################
;       GET REAL MODE REGISTER DATA STRUCTURE ADDRESS
;#######################################################################################################
        PROC  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE PASCAL
              
        PUSH  DS
        POP   ES
        MOV   DI,OFFSET REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL
        RET
        ENDP  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE
;#######################################################################################################
;       GET STATE OF DEBUG WATCHPOINT
;#######################################################################################################
        PROC  GET_STATE_OF_DEBUG_WATCHPOINT_PROCEDURE PASCAL
        ARG   WATCHPOINT_HANDLE_ARGUMENT:WORD

        MOV   BX,[WATCHPOINT_HANDLE_ARGUMENT]
        MOV   AX,GET_STATE_OF_DEBUG_WATCHPOINT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_STATE_OF_DEBUG_WATCHPOINT_PROCEDURE
;#######################################################################################################
;       GET VENDOR SPECIFIC API ENTRY POINT
;#######################################################################################################
        PROC  GET_VENDOR_SPECIFIC_API_ENTRY_POINT_PROCEDURE PASCAL
        ARG   OFFSET_OF_ASCIIZ_DPMI_HOST_VENDOR_ARGUMENT  :WORD
        ARG   SELECTOR_OF_ASCIIZ_DPMI_HOST_VENDOR_ARGUMENT:WORD
              
        MOV   DS,[SELECTOR_OF_ASCIIZ_DPMI_HOST_VENDOR_ARGUMENT]
        MOV   SI,[OFFSET_OF_ASCIIZ_DPMI_HOST_VENDOR_ARGUMENT]
        MOV   AX,GET_VENDOR_SPECIFIC_API_ENTRY_POINT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_VENDOR_SPECIFIC_API_ENTRY_POINT_PROCEDURE
;#######################################################################################################
;       GET VIRTUAL INTERRUPT STATE
;#######################################################################################################
        PROC  GET_VIRTUAL_INTERRUPT_STATE_PROCEDURE PASCAL
              
        MOV   AX,GET_VIRTUAL_INTERRUPT_STATE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_VIRTUAL_INTERRUPT_STATE_PROCEDURE
;#######################################################################################################
;       GET CPU MODE
;#######################################################################################################
        PROC  GET_CPU_MODE_PROCEDURE PASCAL
              
        MOV   AX,GET_CPU_MODE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  GET_CPU_MODE_PROCEDURE
;#######################################################################################################
;       GET DESCRIPTOR
;#######################################################################################################
        PROC  GET_DESCRIPTOR_PROCEDURE PASCAL
        ARG   OFFSET_OF_8_BYTE_BUFFER_ARGUMENT  :WORD
        ARG   SELECTOR_OF_8_BYTE_BUFFER_ARGUMENT:WORD
        ARG   SELECTOR_ARGUMENT                 :WORD 
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   ES,[SELECTOR_OF_8_BYTE_BUFFER_ARGUMENT]
        MOV   DI,[OFFSET_OF_8_BYTE_BUFFER_ARGUMENT]
        MOV   AX,GET_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       GET ENHANCED MODE WINDOWS INSTALLED STATE
;#######################################################################################################
        PROC  GET_ENHANCED_MODE_WINDOWS_INSTALLED_STATE_PROCEDURE PASCAL
              
        MOV   AX,GET_ENHANCED_MODE_WINDOWS_INSTALLED_STATE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  GET_ENHANCED_MODE_WINDOWS_INSTALLED_STATE_PROCEDURE
;#######################################################################################################
;       GET ENHANCED MODE WINDOWS ENTRY POINT ADDRESS
;#######################################################################################################
        PROC  GET_ENHANCED_MODE_WINDOWS_ENTRY_POINT_ADDRESS_PROCEDURE PASCAL
              
        MOV   AX,GET_ENHANCED_MODE_WINDOWS_ENTRY_POINT_ADDRESS_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  GET_ENHANCED_MODE_WINDOWS_ENTRY_POINT_ADDRESS_PROCEDURE
;#######################################################################################################
;       GET FREE MEMORY INFORMATION
;#######################################################################################################
        PROC  GET_FREE_MEMORY_INFORMATION_PROCEDURE PASCAL
        ARG   OFFSET_OF_48_BYTE_BUFFER_ARGUMENT  :WORD
        ARG   SELECTOR_OF_48_BYTE_BUFFER_ARGUMENT:WORD
              
        MOV   ES,[SELECTOR_OF_48_BYTE_BUFFER_ARGUMENT]
        MOV   DI,[OFFSET_OF_48_BYTE_BUFFER_ARGUMENT]
        MOV   AX,GET_FREE_MEMORY_INFORMATION_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_FREE_MEMORY_INFORMATION_PROCEDURE
;#######################################################################################################
;       GET REAL MODE INTERRUPT VECTOR
;#######################################################################################################
        PROC  GET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE PASCAL
        ARG   INTERRUPT_NUMBER_ARGUMENT:WORD
              
        MOV   BL,[BYTE PTR INTERRUPT_NUMBER_ARGUMENT]
        MOV   AX,GET_REAL_MODE_INTERRUPT_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE
;#######################################################################################################
;       GET SELECTOR INCREMENT VALUE
;#######################################################################################################
        PROC  GET_SELECTOR_INCREMENT_VALUE_PROCEDURE PASCAL
              
        MOV   AX,GET_SELECTOR_INCREMENT_VALUE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_SELECTOR_INCREMENT_VALUE_PROCEDURE
;#######################################################################################################
;       GET SEGMENT BASE ADDRESS
;#######################################################################################################
        PROC  GET_SEGMENT_BASE_ADDRESS_PROCEDURE PASCAL
        ARG   SELECTOR_ARGUMENT:WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   AX,GET_SEGMENT_BASE_ADDRESS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_SEGMENT_BASE_ADDRESS_PROCEDURE
;#######################################################################################################
;       GET SEGMENT BASE ADDRESS
;#######################################################################################################
        PROC  GET_STATE_SAVE_RESTORE_ADDRESSES_PROCEDURE PASCAL
              
        MOV   AX,GET_STATE_SAVE_RESTORE_ADDRESSES_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_STATE_SAVE_RESTORE_ADDRESSES_PROCEDURE
;#######################################################################################################
;       GET PAGE SIZE PROCEDURE
;#######################################################################################################
        PROC  GET_PAGE_SIZE_PROCEDURE PASCAL
              
        MOV   AX,GET_PAGE_SIZE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_PAGE_SIZE_PROCEDURE
;#######################################################################################################
;       GET PROCESSOR EXCEPTION HANDLER VECTOR
;#######################################################################################################
        PROC  GET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE PASCAL
        ARG   EXCEPTION_NUMBER_ARGUMENT:WORD
              
        MOV   BL,[BYTE PTR EXCEPTION_NUMBER_ARGUMENT]
        MOV   AX,GET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE
;#######################################################################################################
;       GET PROTECTED MODE INTERRUPT VECTOR
;#######################################################################################################
        PROC  GET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE PASCAL
        ARG   INTERRUPT_NUMBER_ARGUMENT:WORD
              
        MOV   BL,[BYTE PTR INTERRUPT_NUMBER_ARGUMENT]
        MOV   AX,GET_PROTECTED_MODE_INTERRUPT_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  GET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE
;#######################################################################################################
;       GET DPMI VERSION PROCEDURE
;#######################################################################################################
        PROC  GET_DPMI_VERSION_PROCEDURE PASCAL

        MOV   AX,GET_DPMI_VERSION_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  GET_DPMI_VERSION_PROCEDURE
;#######################################################################################################
;       GET DPMI VERSION PROCEDURE
;#######################################################################################################
        PROC  LOCK_LINEAR_REGION_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_LOCK_LOW_ARGUMENT                   :WORD
        ARG   SIZE_OF_REGION_TO_LOCK_HIGH_ARGUMENT                  :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_LOW_ARGUMENT :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_HIGH_ARGUMENT:WORD
              
        MOV   BX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_HIGH_ARGUMENT]
        MOV   CX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_LOCK_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_LOCK_LOW_ARGUMENT]
        MOV   AX,LOCK_LINEAR_REGION_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  LOCK_LINEAR_REGION_PROCEDURE
;#######################################################################################################
;       MAP REAL MODE SEGMENT TO DESCRIPTOR PROCEDURE
;#######################################################################################################
        PROC  MAP_REAL_MODE_SEGMENT_TO_DESCRIPTOR_PROCEDURE PASCAL
        ARG   REAL_MODE_SEGMENT_ADDRESS_ARGUMENT:WORD
              
        MOV   BX,[REAL_MODE_SEGMENT_ADDRESS_ARGUMENT]
        MOV   AX,MAP_REAL_MODE_SEGMENT_TO_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  MAP_REAL_MODE_SEGMENT_TO_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       MARK PAGE AS DEMAND PAGING CANDIDATE
;#######################################################################################################
        PROC  MARK_PAGE_AS_DEMAND_PAGING_CANDIDATE_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_MARK_LOW_ARGUMENT                  :WORD
        ARG   SIZE_OF_REGION_TO_MARK_HIGH_ARGUMENT                 :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_PAGES_TO_MARK_LOW_ARGUMENT :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_PAGES_TO_MARK_HIGH_ARGUMENT:WORD
              
        MOV   BX,[STARING_LINEAR_ADDRESS_OF_PAGES_TO_MARK_HIGH_ARGUMENT]
        MOV   CX,[STARING_LINEAR_ADDRESS_OF_PAGES_TO_MARK_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_MARK_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_MARK_LOW_ARGUMENT]
        MOV   AX,MARK_PAGE_AS_DEMAND_PAGING_CANDIDATE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  MARK_PAGE_AS_DEMAND_PAGING_CANDIDATE_PROCEDURE
;#######################################################################################################
;       MARK REAL MODE REGION AS PAGEABLE
;#######################################################################################################
        PROC  MARK_REAL_MODE_REGION_AS_PAGEABLE_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_MARK_LOW_ARGUMENT                   :WORD
        ARG   SIZE_OF_REGION_TO_MARK_HIGH_ARGUMENT                  :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_MARK_LOW_ARGUMENT :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_MARK_HIGH_ARGUMENT:WORD
              
        MOV   BX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_MARK_HIGH_ARGUMENT]
        MOV   CX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_MARK_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_MARK_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_MARK_LOW_ARGUMENT]
        MOV   AX,MARK_REAL_MODE_REGION_AS_PAGEABLE_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  MARK_REAL_MODE_REGION_AS_PAGEABLE_PROCEDURE
;#######################################################################################################
;       NOTIFY BACKGROUND SWITCH
;#######################################################################################################
        PROC  NOTIFY_BACKGROUND_SWITCH_PROCEDURE PASCAL
              
        MOV   AX,NOTIFY_BACKGROUND_SWITCH_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  NOTIFY_BACKGROUND_SWITCH_PROCEDURE
;#######################################################################################################
;       NOTIFY FOREGROUND SWITCH
;#######################################################################################################
        PROC  NOTIFY_FOREGROUND_SWITCH_PROCEDURE PASCAL
              
        MOV   AX,NOTIFY_FOREGROUND_SWITCH_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  NOTIFY_FOREGROUND_SWITCH_PROCEDURE
;#######################################################################################################
;       OBTAIN REAL TO PROTECTED MODE SWITCH ENTRY POINT
;#######################################################################################################
        PROC  OBTAIN_REAL_TO_PROTECTED_MODE_SWITCH_ENTRY_POINT_PROCEDURE PASCAL
              
        MOV   AX,OBTAIN_REAL_TO_PROTECTED_MODE_SWITCH_ENTRY_POINT_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        OR    AX,AX
        JNZ   ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  OBTAIN_REAL_TO_PROTECTED_MODE_SWITCH_ENTRY_POINT_PROCEDURE
;#######################################################################################################
;       PHYSICAL ADDRESS MAPPING
;#######################################################################################################
        PROC  PHYSICAL_ADDRESS_MAPPING_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_MAP_LOW_ARGUMENT      :WORD
        ARG   SIZE_OF_REGION_TO_MAP_HIGH_ARGUMENT     :WORD
        ARG   PHYSICAL_ADDRESS_OF_MEMORY_LOW_ARGUMENT :WORD
        ARG   PHYSICAL_ADDRESS_OF_MEMORY_HIGH_ARGUMENT:WORD

        MOV   BX,[PHYSICAL_ADDRESS_OF_MEMORY_HIGH_ARGUMENT]
        MOV   CX,[PHYSICAL_ADDRESS_OF_MEMORY_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_MAP_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_MAP_LOW_ARGUMENT]
        MOV   AX,PHYSICAL_ADDRESS_MAPPING_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  PHYSICAL_ADDRESS_MAPPING_PROCEDURE
;#######################################################################################################
;       RELEASE CURRENT VM TIME SLICE
;#######################################################################################################
        PROC  RELEASE_CURRENT_VM_TIME_SLICE_PROCEDURE PASCAL
              
        MOV   AX,RELEASE_CURRENT_VM_TIME_SLICE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        OR    AL,AL
        JNZ   ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  RELEASE_CURRENT_VM_TIME_SLICE_PROCEDURE
;#######################################################################################################
;       RESET DEBUG WATCHPOINT PROCEDURE
;#######################################################################################################
        PROC  RESET_DEBUG_WATCHPOINT_PROCEDURE PASCAL
        ARG   WATCHPOINT_HANDLE_ARGUMENT:WORD
              
        MOV   BX,[WATCHPOINT_HANDLE_ARGUMENT]
        MOV   AX,RESET_DEBUG_WATCHPOINT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET
        ENDP  RESET_DEBUG_WATCHPOINT_PROCEDURE
;#######################################################################################################
;       RESIZE DOS MEMORY BLOCK
;#######################################################################################################
        PROC  RESIZE_DOS_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   SELECTOR_OF_BLOCK_TO_MODIFY_ARGUMENT :WORD
        ARG   NEW_BLOCK_SIZE_IN_PARAGRAPHS_ARGUMENT:WORD
              
        MOV   BX,[NEW_BLOCK_SIZE_IN_PARAGRAPHS_ARGUMENT]
        MOV   DX,[SELECTOR_OF_BLOCK_TO_MODIFY_ARGUMENT]
        MOV   AX,RESIZE_DOS_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  RESIZE_DOS_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       RESIZE MEMORY BLOCK
;#######################################################################################################
        PROC  RESIZE_MEMORY_BLOCK_PROCEDURE PASCAL
        ARG   MEMORY_BLOCK_HANDLE_LOW_ARGUMENT :WORD
        ARG   MEMORY_BLOCK_HANDLE_HIGH_ARGUMENT:WORD
        ARG   NEW_SIZE_OF_BLOCK_LOW_ARGUMENT   :WORD
        ARG   NEW_SIZE_OF_BLOCK_HIGH_ARGUMENT  :WORD
              
        MOV   BX,[NEW_SIZE_OF_BLOCK_HIGH_ARGUMENT]
        MOV   CX,[NEW_SIZE_OF_BLOCK_LOW_ARGUMENT]
        MOV   SI,[MEMORY_BLOCK_HANDLE_HIGH_ARGUMENT]
        MOV   DI,[MEMORY_BLOCK_HANDLE_LOW_ARGUMENT]
        MOV   AX,RESIZE_MEMORY_BLOCK_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  RESIZE_MEMORY_BLOCK_PROCEDURE
;#######################################################################################################
;       RESTORE VIDEO REGISTER STATE
;#######################################################################################################
        PROC  RESTORE_VIDEO_REGISTER_STATE_PROCEDURE PASCAL
              
        MOV   AX,RESTORE_VIDEO_REGISTER_STATE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  RESTORE_VIDEO_REGISTER_STATE_PROCEDURE
;#######################################################################################################
;       SAVE VIDEO REGISTER STATE
;#######################################################################################################
        PROC  SAVE_VIDEO_REGISTER_STATE_PROCEDURE PASCAL
              
        MOV   AX,SAVE_VIDEO_REGISTER_STATE_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  SAVE_VIDEO_REGISTER_STATE_PROCEDURE
;#######################################################################################################
;       SET DEBUG WATCHPOINT
;#######################################################################################################
        PROC  SET_DEBUG_WATCHPOINT_PROCEDURE PASCAL
        ARG   TYPE_OF_WATCHPOINT_ARGUMENT               :WORD
        ARG   SIZE_OF_WATCHPOINT_ARGUMENT               :WORD
        ARG   LINEAR_ADDRESS_OF_WATCHPOINT_LOW_ARGUMENT :WORD
        ARG   LINEAR_ADDRESS_OF_WATCHPOINT_HIGH_ARGUMENT:WORD
              
        MOV   BX,[LINEAR_ADDRESS_OF_WATCHPOINT_HIGH_ARGUMENT]
        MOV   CX,[LINEAR_ADDRESS_OF_WATCHPOINT_LOW_ARGUMENT]
        MOV   DL,[BYTE PTR SIZE_OF_WATCHPOINT_ARGUMENT]
        MOV   DH,[BYTE PTR TYPE_OF_WATCHPOINT_ARGUMENT]
        MOV   AX,SET_DEBUG_WATCHPOINT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_DEBUG_WATCHPOINT_PROCEDURE
;#######################################################################################################
;       SET DESCRIPTOR
;#######################################################################################################
        PROC  SET_DESCRIPTOR_PROCEDURE PASCAL
        ARG   OFFSET_OF_8_BYTE_BUFFER_CONTAINING_DESCRIPTOR_ARGUMENT  :WORD
        ARG   SELECTOR_OF_8_BYTE_BUFFER_CONTAINING_DESCRIPTOR_ARGUMENT:WORD
        ARG   SELECTOR_ARGUMENT                                       :WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   ES,[SELECTOR_OF_8_BYTE_BUFFER_CONTAINING_DESCRIPTOR_ARGUMENT]
        MOV   DI,[OFFSET_OF_8_BYTE_BUFFER_CONTAINING_DESCRIPTOR_ARGUMENT]
        MOV   AX,SET_DESCRIPTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_DESCRIPTOR_PROCEDURE
;#######################################################################################################
;       SET DESCRIPTOR ACCESS RIGHTS
;#######################################################################################################
        PROC  SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE PASCAL
        ARG   EXTENDED_ACCESS_RIGHTS_TYPE_ARGUMENT:WORD
        ARG   ACCESS_RIGHTS_TYPE_ARGUMENT         :WORD
        ARG   SELECTOR_ARGUMENT                   :WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   CL,[BYTE PTR ACCESS_RIGHTS_TYPE_ARGUMENT]
        MOV   CH,[BYTE PTR EXTENDED_ACCESS_RIGHTS_TYPE_ARGUMENT]
        MOV   AX,SET_DESCRIPTOR_ACCESS_RIGHTS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE
;#######################################################################################################
;       SET PROCESSOR EXCEPTION HANDLER VECTOR
;#######################################################################################################
        PROC  SET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE PASCAL
        ARG   OFFSET_OF_EXCEPTION_HANDLER_ARGUMENT  :WORD
        ARG   SELECTOR_OF_EXCEPTION_HANDLER_ARGUMENT:WORD
        ARG   EXCEPTION_FAULT_NUMBER_ARGUMENT       :WORD
              
        MOV   BL,[BYTE PTR EXCEPTION_FAULT_NUMBER_ARGUMENT]
        MOV   CX,[SELECTOR_OF_EXCEPTION_HANDLER_ARGUMENT]
        MOV   DX,[OFFSET_OF_EXCEPTION_HANDLER_ARGUMENT]
        MOV   AX,SET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_PROCESSOR_EXCEPTION_HANDLER_VECTOR_PROCEDURE
;#######################################################################################################
;       SET PROTECTED MODE INTERRUPT VECTOR
;#######################################################################################################
        PROC  SET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE PASCAL
        ARG   OFFSET_OF_EXCEPTION_HANDLER_ARGUMENT  :WORD
        ARG   SELECTOR_OF_EXCEPTION_HANDLER_ARGUMENT:WORD
        ARG   INTERRUPT_NUMBER_ARGUMENT             :WORD
              
        MOV   BL,[BYTE PTR INTERRUPT_NUMBER_ARGUMENT]
        MOV   CX,[SELECTOR_OF_EXCEPTION_HANDLER_ARGUMENT]
        MOV   DX,[OFFSET_OF_EXCEPTION_HANDLER_ARGUMENT]
        MOV   AX,SET_PROTECTED_MODE_INTERRUPT_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_PROTECTED_MODE_INTERRUPT_VECTOR_PROCEDURE
;#######################################################################################################
;       SET REAL MODE INTERRUPT VECTOR
;#######################################################################################################
        PROC  SET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE PASCAL
        ARG   OFFSET_OF_REAL_MODE_INTERRUPT_HANDLER_ARGUMENT :WORD
        ARG   SEGMENT_OF_REAL_MODE_INTERRUPT_HANDLER_ARGUMENT:WORD
        ARG   INTERRUPT_NUMBER_ARGUMENT                      :WORD
              
        MOV   BL,[BYTE PTR INTERRUPT_NUMBER_ARGUMENT]
        MOV   CX,[SEGMENT_OF_REAL_MODE_INTERRUPT_HANDLER_ARGUMENT]
        MOV   DX,[OFFSET_OF_REAL_MODE_INTERRUPT_HANDLER_ARGUMENT]
        MOV   AX,SET_REAL_MODE_INTERRUPT_VECTOR_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        RET   
        ENDP  SET_REAL_MODE_INTERRUPT_VECTOR_PROCEDURE
;#######################################################################################################
;       SET SEGMENT BASE ADDRESS
;#######################################################################################################
        PROC  SET_SEGMENT_BASE_ADDRESS_PROCEDURE PASCAL
        ARG   LINEAR_BASE_ADDRESS_OF_SEGMENT_LOW_ARGUMENT :WORD
        ARG   LINEAR_BASE_ADDRESS_OF_SEGMENT_HIGH_ARGUMENT:WORD
        ARG   SELECTOR_ARGUMENT                           :WORD
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   CX,[LINEAR_BASE_ADDRESS_OF_SEGMENT_HIGH_ARGUMENT]
        MOV   DX,[LINEAR_BASE_ADDRESS_OF_SEGMENT_LOW_ARGUMENT]
        MOV   AX,SET_SEGMENT_BASE_ADDRESS_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_SEGMENT_BASE_ADDRESS_PROCEDURE
;#######################################################################################################
;       SET SEGMENT LIMIT
;#######################################################################################################
        PROC  SET_SEGMENT_LIMIT_PROCEDURE PASCAL
        ARG   SEGMENT_LIMIT_LOW :WORD
        ARG   SEGMENT_LIMIT_HIGH:WORD
        ARG   SELECTOR_ARGUMENT :WORD  
              
        MOV   BX,[SELECTOR_ARGUMENT]
        MOV   CX,[SEGMENT_LIMIT_HIGH]
        MOV   DX,[SEGMENT_LIMIT_LOW]
        MOV   AX,SET_SEGMENT_LIMIT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SET_SEGMENT_LIMIT_PROCEDURE
;#######################################################################################################
;       SIMULATE REAL MODE INTERRUPT
;#######################################################################################################
        PROC  SIMULATE_REAL_MODE_INTERRUPT_PROCEDURE PASCAL
        ARG   SS_REGISTER_ARGUMENT                                      :WORD
        ARG   SP_REGISTER_ARGUMENT                                      :WORD
        ARG   CS_REGISTER_ARGUMENT                                      :WORD
        ARG   IP_REGISTER_ARGUMENT                                      :WORD
        ARG   GS_REGISTER_ARGUMENT                                      :WORD
        ARG   FS_REGISTER_ARGUMENT                                      :WORD
        ARG   DS_REGISTER_ARGUMENT                                      :WORD
        ARG   ES_REGISTER_ARGUMENT                                      :WORD
        ARG   CPU_REGISTER_ARGUMENT                                     :WORD
        ARG   EAX_REGISTER_ARGUMENT                                     :WORD
        ARG   ECX_REGISTER_ARGUMENT                                     :WORD
        ARG   EDX_REGISTER_ARGUMENT                                     :WORD
        ARG   EBX_REGISTER_ARGUMENT                                     :WORD
        ARG   RES_REGISTER_ARGUMENT                                     :WORD
        ARG   EBP_REGISTER_ARGUMENT                                     :WORD
        ARG   ESI_REGISTER_ARGUMENT                                     :WORD
        ARG   EDI_REGISTER_ARGUMENT                                     :WORD
        ARG   NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT:WORD
        ARG   INTERRUPT_NUMBER_ARGUMENT                                 :WORD 

        XOR   EAX,EAX
        MOV   AX,[EDI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDI_REGISTER],EAX
        MOV   AX,[ESI_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ESI_REGISTER],EAX
        MOV   AX,[EBP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBP_REGISTER],EAX
        MOV   AX,[RES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.RES_REGISTER],EAX
        MOV   AX,[EBX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EBX_REGISTER],EAX
        MOV   AX,[EDX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EDX_REGISTER],EAX
        MOV   AX,[ECX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ECX_REGISTER],EAX
        MOV   AX,[EAX_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.EAX_REGISTER],EAX
        MOV   AX,[CPU_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CPU_REGISTER],AX
        MOV   AX,[ES_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.ES_REGISTER],AX
        MOV   AX,[DS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.DS_REGISTER],AX
        MOV   AX,[FS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.FS_REGISTER],AX
        MOV   AX,[GS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.GS_REGISTER],AX
        MOV   AX,[IP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.IP_REGISTER],AX
        MOV   AX,[CS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.CS_REGISTER],AX
        MOV   AX,[SP_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SP_REGISTER],AX
        MOV   AX,[SS_REGISTER_ARGUMENT]
        MOV   [REAL_MODE_REGISTER_DATA_STRUCTURE_GLOBAL.SS_REGISTER],AX
        CALL  GET_REAL_MODE_REGISTER_DATA_STRUCTURE_ADDRESS_PROCEDURE
        MOV   BL,[BYTE PTR INTERRUPT_NUMBER_ARGUMENT]
        XOR   BH,BH
        MOV   CX,[NUMBER_OF_STACK_WORDS_FROM_PROTECTED_TO_REAL_MODE_ARGUMENT]
        MOV   AX,SIMULATE_REAL_MODE_INTERRUPT_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SIMULATE_REAL_MODE_INTERRUPT_PROCEDURE
;#######################################################################################################
;       SWITCH VMS AND CALLBACK
;#######################################################################################################
        PROC  SWITCH_VMS_AND_CALLBACK_PROCEDURE PASCAL
        ARG   PRIORITY_LOW_ARGUMENT      :WORD
        ARG   PRIORITY_HIGH_ARGUMENT     :WORD
        ARG   FLAGS_ARGUMENT             :WORD
        ARG   VIRTUAL_MACHINE_ID_ARGUMENT:WORD
              
        MOV   BX,[VIRTUAL_MACHINE_ID_ARGUMENT]
        MOV   CX,[FLAGS_ARGUMENT]
        MOV   DX,[PRIORITY_HIGH_ARGUMENT]
        MOV   SI,[PRIORITY_LOW_ARGUMENT]
        MOV   AX,SWITCH_VMS_AND_CALLBACK_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  SWITCH_VMS_AND_CALLBACK_PROCEDURE
;#######################################################################################################
;       UNLOCK LINEAR REGION
;#######################################################################################################
        PROC  UNLOCK_LINEAR_REGION_PROCEDURE PASCAL
        ARG   SIZE_OF_REGION_TO_LOCK_LOW_ARGUMENT                   :WORD
        ARG   SIZE_OF_REGION_TO_LOCK_HIGH_ARGUMENT                  :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_LOW_ARGUMENT :WORD
        ARG   STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_HIGH_ARGUMENT:WORD
              
        MOV   BX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_HIGH_ARGUMENT]
        MOV   CX,[STARING_LINEAR_ADDRESS_OF_MEMORY_TO_LOCK_LOW_ARGUMENT]
        MOV   SI,[SIZE_OF_REGION_TO_LOCK_HIGH_ARGUMENT]
        MOV   DI,[SIZE_OF_REGION_TO_LOCK_LOW_ARGUMENT]
        MOV   AX,UNLOCK_LINEAR_REGION_EQUATE
        INT   DOS_PROTECTED_MODE_INTERRUPT_EQUATE
        JC    ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  UNLOCK_LINEAR_REGION_PROCEDURE
;#######################################################################################################
;       WINDOWS BEGIN EXIT
;#######################################################################################################
        PROC  WINDOWS_BEGIN_EXIT_PROCEDURE PASCAL
              
        MOV   AX,WINDOWS_BEGIN_EXIT_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  WINDOWS_BEGIN_EXIT_PROCEDURE
;#######################################################################################################
;       WINDOWS INITIALIZATION NOTIFICATION
;#######################################################################################################
        PROC  WINDOWS_INITIALIZATION_NOTIFICATION_PROCEDURE PASCAL
        ARG   WINDOWS_VERSION_NUMBER_ARGUMENT:WORD
        ARG   WINDOWS_MODE_ARGUMENT          :WORD
              
        MOV   AX,ZERO_EQUATE
        MOV   ES,AX
        MOV   DS,AX
        XOR   BX,BX
        XOR   SI,SI
        XOR   CX,CX
        MOV   DX,[WINDOWS_MODE_ARGUMENT]
        MOV   DI,[WINDOWS_VERSION_NUMBER_ARGUMENT]
        MOV   AX,WINDOWS_INITIALIZATION_NOTIFICATION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        OR    CX,CX
        JNZ   ERROR_MEMDRV_NOTIFICATION_PROCEDURE
        RET   
        ENDP  WINDOWS_INITIALIZATION_NOTIFICATION_PROCEDURE
;#######################################################################################################
;       WINDOWS INITIALIZATION COMPLETE NOTIFICATION
;#######################################################################################################
        PROC  WINDOWS_INITIALIZATION_COMPLETE_NOTIFICATION_PROCEDURE PASCAL

        MOV   AX,WINDOWS_INITIALIZATION_COMPLETE_NOTIFICATION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  WINDOWS_INITIALIZATION_COMPLETE_NOTIFICATION_PROCEDURE
;#######################################################################################################
;       WINDOWS TERMINATION NOTIFICATION
;#######################################################################################################
        PROC  WINDOWS_TERMINATION_NOTIFICATION_PROCEDURE PASCAL
        ARG   WINDOWS_MODE_ARGUMENT          :WORD
              
        MOV   DX,[WINDOWS_MODE_ARGUMENT]
        MOV   AX,WINDOWS_TERMINATION_NOTIFICATION_EQUATE
        INT   DOS_MULTIPLEX_INTERRUPT_EQUATE
        RET   
        ENDP  WINDOWS_TERMINATION_NOTIFICATION_PROCEDURE
;#######################################################################################################
;       ERROR MEMDRV NOTIFICATION
;#######################################################################################################
        PROC  ERROR_MEMDRV_NOTIFICATION_PROCEDURE PASCAL

        INT   BREAKPOINT_INSTRUCTION_INTERRUPT_EQUATE
        RET
        ENDP  ERROR_MEMDRV_NOTIFICATION_PROCEDURE
;#######################################################################################################
;       GRAPHIC DRIVER INSTALL
;#######################################################################################################
        PROC  GRAPHIC_DRIVER_INSTALL_PROCEDURE PASCAL

        CALL  SCREEN_ALOC_ACTUAL_PROCEDURE
        CALL  SCREEN_ALOC_LOGICAL_PROCEDURE
        CALL  SCREEN_ALOC_PHYSICAL_PROCEDURE
        RET
        ENDP  GRAPHIC_DRIVER_INSTALL_PROCEDURE
;#######################################################################################################
;       GRAPHIC DRIVER RELEASE
;#######################################################################################################
        PROC  GRAPHIC_DRIVER_RELEASE_PROCEDURE PASCAL

        CALL  SCREEN_FREE_ACTUAL_PROCEDURE
        CALL  SCREEN_FREE_LOGICAL_PROCEDURE
        CALL  SCREEN_FREE_PHYSICAL_PROCEDURE
        RET
        ENDP  GRAPHIC_DRIVER_RELEASE_PROCEDURE
;#######################################################################################################
;       SCREEN ALOC ACTUAL
;#######################################################################################################
        PROC  SCREEN_ALOC_ACTUAL_PROCEDURE PASCAL
        LOCAL @@SELECTOR_LOCAL                        :WORD
        LOCAL @@SVGA_VIDEO_MEMORY_BUFFER_SEGMENT_LOCAL:WORD
        LOCAL @@SVGA_WINDOW_GRANULARITY_LOCAL         :WORD
        LOCAL @@SVGA_BYTES_PER_LOGICAL_SCAN_LINE_LOCAL:WORD

;hm....
int 3 

        PUSH  ONE_EQUATE
        CALL  ALLOCATE_LDT_DESCRIPTORS_PROCEDURE
        MOV   [@@SELECTOR_LOCAL],AX
;AX=selector to free

;edda before we submit to set segment address we must
;before transpose bootstrap address to linear address

        PUSH  BOOTSTRAP_MEMORY_SEGMENT_EQUATE
        PUSH  BOOTSTRAP_MEMORY_OFFSET_EQUATE
        PUSH  0
        PUSH  0FFH
        CALL  PHYSICAL_ADDRESS_MAPPING_PROCEDURE
;->BX:CX=linear address that can be used to access physical mem

 

        PUSH  [@@SELECTOR_LOCAL]
PUSH BX
PUSH CX
;        PUSH  BOOTSTRAP_MEMORY_SEGMENT_EQUATE
;        PUSH  BOOTSTRAP_MEMORY_OFFSET_EQUATE
        CALL  SET_SEGMENT_BASE_ADDRESS_PROCEDURE

 


;
        PUSH  [@@SELECTOR_LOCAL]
        PUSH  DECREMENTED_HALF_SECTOR_BYTE_HIGH_EQUATE
        PUSH  DECREMENTED_HALF_SECTOR_BYTE_LOW_EQUATE
        CALL  SET_SEGMENT_LIMIT_PROCEDURE
        MOV   CX,CS
        AND   CX,CURRENT_PRIVILEGE_LEVEL_MASK_EQUATE
        SHL   CL,CURRENT_PRIVILEGE_LEVEL_SHIFT_EQUATE
        OR    CL,SEGMENT_PRESENT_IN_MEMORY_EQUATE
        OR    CL,DESCRIPTOR_PRIVILEGE_LEVEL_ZERO_EQUATE
        OR    CL,DESCRIPTOR_TYPE_APPLICATION_SEGMENT_EQUATE
        OR    CL,APPLICATION_SEGMENT_READ_WRITE_EQUATE
        PUSH  [@@SELECTOR_LOCAL]
        PUSH  CX
        PUSH  ZERO_EQUATE
        CALL  SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE
int 3
;get video mode
        MOV   AX,GET_CURRENT_SVGA_VIDEO_MODE_EQUATE
        INT   BIOS_VIDEO_GENERAL_SERVICES_INTERRUPT_EQUATE
        AND   BX,VIDEO_MODE_NUMBER_MASK_EQUATE
;video mode in bx
        PUSH  BIOS_VIDEO_GENERAL_SERVICES_INTERRUPT_EQUATE
        PUSH  ZERO_EQUATE 
        PUSH  BOOTSTRAP_MEMORY_OFFSET_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  BX
        PUSH  GET_SVGA_GENERAL_MODE_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  BOOTSTRAP_MEMORY_SEGMENT_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
        PUSH  ZERO_EQUATE
int 3
        CALL  SIMULATE_REAL_MODE_INTERRUPT_PROCEDURE

        MOV   AX,[@@SELECTOR_LOCAL]
        MOV   ES,AX
        MOV   AX,[ES:SVGA_WINDOW_A_SEGMENT_EQUATE]
        MOV   [@@SVGA_VIDEO_MEMORY_BUFFER_SEGMENT_LOCAL],AX

; now get real physical screen adress
        PUSH  ONE_EQUATE
        CALL  ALLOCATE_LDT_DESCRIPTORS_PROCEDURE
        MOV   [SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL],AX
;AX=selector to free
        PUSH  [@@SVGA_VIDEO_MEMORY_BUFFER_SEGMENT_LOCAL]
        PUSH  SVGA_VIDEO_MEMORY_BUFFER_OFFSET_EQUATE
        PUSH  SEGMENT_HIGH_BYTE_EQUATE
        PUSH  SEGMENT_LOW_BYTE_EQUATE
        CALL  PHYSICAL_ADDRESS_MAPPING_PROCEDURE
;->BX:CX=linear address that can be used to access physical mem
        PUSH  [SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL]
;PUSH   0A000H
;PUSH    0000H
;        PUSH  CX
;        PUSH  BX
        PUSH  BX
        PUSH  CX

        CALL  SET_SEGMENT_BASE_ADDRESS_PROCEDURE
;
        PUSH  [SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL]
        PUSH  DECREMENTED_SEGMENT_BYTE_HIGH_EQUATE
        PUSH  DECREMENTED_SEGMENT_BYTE_LOW_EQUATE
        CALL  SET_SEGMENT_LIMIT_PROCEDURE

        MOV   CX,CS
        AND   CX,CURRENT_PRIVILEGE_LEVEL_MASK_EQUATE
        SHL   CL,CURRENT_PRIVILEGE_LEVEL_SHIFT_EQUATE
        OR    CL,SEGMENT_PRESENT_IN_MEMORY_EQUATE
        OR    CL,DESCRIPTOR_PRIVILEGE_LEVEL_ZERO_EQUATE
        OR    CL,DESCRIPTOR_TYPE_APPLICATION_SEGMENT_EQUATE
        OR    CL,APPLICATION_SEGMENT_READ_WRITE_EQUATE
        PUSH  [SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL]
        PUSH  CX
        PUSH  ZERO_EQUATE
        CALL  SET_DESCRIPTOR_ACCESS_RIGHTS_PROCEDURE
; end of actual allocation

        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_ACTUAL_BANK_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_ACTUAL_BANK_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_ACTUAL_BANK_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_ACTUAL_OFFSET1_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_ACTUAL_OFFSET1_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_ACTUAL_OFFSET1_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_ACTUAL_OFFSET2_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_ACTUAL_OFFSET2_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_ACTUAL_OFFSET2_LOW_GLOBAL],DI

; now get rest of svga information
        MOV   AX,[@@SELECTOR_LOCAL]
        MOV   ES,AX
        MOV   AX,[ES:SVGA_WINDOW_GRANULARITY_EQUATE]
        MOV   [@@SVGA_WINDOW_GRANULARITY_LOCAL],AX
        MOV   AX,[ES:SVGA_BYTES_PER_LOGICAL_SCAN_LINE_EQUATE]
        MOV   [@@SVGA_BYTES_PER_LOGICAL_SCAN_LINE_LOCAL],AX
        MOV   AX,[ES:SVGA_WINDOW_SCHEME_FUNCTION_POINTER_EQUATE]
        MOV   [WINDOW_SCHEME_FUNCTION_POINTER_LOW_GLOBAL],AX
        MOV   AX,[ES:SVGA_WINDOW_SCHEME_FUNCTION_POINTER_EQUATE+2]
        MOV   [WINDOW_SCHEME_FUNCTION_POINTER_HIGH_GLOBAL],AX

int 3
;line below added
MOV   AX,1000H
MOV   [@@SVGA_WINDOW_GRANULARITY_LOCAL],AX

; calculate masks and shift
        MOV   EAX,ZERO_EQUATE
        MOV   AX,[@@SVGA_WINDOW_GRANULARITY_LOCAL]
        SHL   EAX,KILOBYTE_TO_BYTE_SHIFT_EQUATE
        MOV   EBX,ONE_EQUATE
        MOV   CL,ZERO_EQUATE
@@01:   CMP   EAX,EBX
        JZ    @@02
        SHL   EBX,ONE_EQUATE
        INC   CL
        JMP   @@01
@@02:   MOV   [WINDOW_GRANULARITY_SHIFT_GLOBAL],CL

        DEC   EBX
        MOV   [WINDOW_GRANULARITY_MASK_GLOBAL],BX
        
        MOV   EAX,ZERO_EQUATE
        MOV   AX,[@@SVGA_BYTES_PER_LOGICAL_SCAN_LINE_LOCAL]
        MOV   EBX,ONE_EQUATE
        MOV   CL,ZERO_EQUATE



;@@03:   CMP   EAX,EBX
;        JZ    @@04
;        SHL   EBX,ONE_EQUATE
;        INC   CL
;        JMP   @@03

;@@04:   MOV   [BYTES_PER_LOGICAL_SCAN_LINE_SHIFT_GLOBAL],CL

@@04:   MOV   [BYTES_PER_LOGICAL_SCAN_LINE_SHIFT_GLOBAL],0FH


; free selector
        PUSH  [@@SELECTOR_LOCAL]
        CALL  FREE_LDT_DESCRIPTOR_PROCEDURE

; and init screen
        CALL  SCREEN_INIT_ACTUAL_PROCEDURE
        RET
        ENDP  SCREEN_ALOC_ACTUAL_PROCEDURE
;#######################################################################################################
;       SCREEN ALOC LOGICAL
;#######################################################################################################
        PROC  SCREEN_ALOC_LOGICAL_PROCEDURE PASCAL

        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_LOGICAL_COLOR_RED_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_RED_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_RED_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_LOGICAL_COLOR_GREEN_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_LOGICAL_COLOR_BLUE_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_LOW_GLOBAL],DI
        RET
        ENDP  SCREEN_ALOC_LOGICAL_PROCEDURE
;#######################################################################################################
;       SCREEN ALOC PHYSICAL
;#######################################################################################################
        PROC  SCREEN_ALOC_PHYSICAL_PROCEDURE PASCAL

        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_PHYSICAL_COLOR_RED_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_RED_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_RED_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_PHYSICAL_COLOR_GREEN_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_LOW_GLOBAL],DI
        CALL  ALLOCATE_SELECTOR_PROCEDURE
        MOV   [SELECTOR_BASE_PHYSICAL_COLOR_BLUE_GLOBAL],AX
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_HIGH_GLOBAL],SI
        MOV   [SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_LOW_GLOBAL],DI
        RET
        ENDP  SCREEN_ALOC_PHYSICAL_PROCEDURE
;#######################################################################################################
;       SCREEN INIT ACTUAL
;#######################################################################################################
        PROC  SCREEN_INIT_ACTUAL_PROCEDURE PASCAL
        LOCAL @@POINT_STRUCTURE_LOCAL              :POINT
        LOCAL @@PIXEL_COORDINATE_X_LOCAL           :WORD
        LOCAL @@PIXEL_COORDINATE_Y_LOCAL           :WORD

        PUSH  [HANDLE_WINDOW_INSTANCE_GLOBAL]
        CALL  GETDC
        MOV   [HANDLE_DEVICE_CONTEXT_GLOBAL],AX
        PUSH  [HANDLE_DEVICE_CONTEXT_GLOBAL]
        CALL  GETWINDOWORG
        MOV   [@@POINT_STRUCTURE_LOCAL.ptX],AX
        MOV   [@@POINT_STRUCTURE_LOCAL.ptY],DX
        LEA   AX,[@@POINT_STRUCTURE_LOCAL]
        PUSH  [HANDLE_WINDOW_INSTANCE_GLOBAL]
        PUSH  SS
        PUSH  AX
        CALL  CLIENTTOSCREEN
        PUSH  [HANDLE_WINDOW_INSTANCE_GLOBAL]
        PUSH  [HANDLE_DEVICE_CONTEXT_GLOBAL]
        CALL  RELEASEDC

        MOV   AX,[@@POINT_STRUCTURE_LOCAL.ptX]
        MOV   [@@PIXEL_COORDINATE_X_LOCAL],AX
        MOV   AX,[@@POINT_STRUCTURE_LOCAL.ptY]
        MOV   [@@PIXEL_COORDINATE_Y_LOCAL],AX
;start loading 
        XOR   SI,SI
        XOR   DI,DI
        MOV   FS,[SELECTOR_BASE_ACTUAL_BANK_GLOBAL]
;first 128 lines
        MOV   GS,[SELECTOR_BASE_ACTUAL_OFFSET1_GLOBAL]
        MOV   DX,128
        BSWAP EDX
@@01:   MOV   DX,256
@@02:   MOV   BX,[@@PIXEL_COORDINATE_Y_LOCAL]
        MOV   AX,[@@PIXEL_COORDINATE_X_LOCAL]
        LEA   EAX,[EAX*2+EAX]
        MOV   CL,[BYTES_PER_LOGICAL_SCAN_LINE_SHIFT_GLOBAL]
        SHL   EBX,CL
        ADD   EBX,EAX
        PUSH  BX
        MOV   CL,[WINDOW_GRANULARITY_SHIFT_GLOBAL]
        SHR   EBX,CL
        MOV   [FS:SI],BL
        POP   BX
        AND   BX,[WINDOW_GRANULARITY_MASK_GLOBAL]
        MOV   [GS:DI],BX
        INC   [@@PIXEL_COORDINATE_X_LOCAL]
        INC   SI
        INC   DI
        INC   DI
        DEC   DX
        JNZ   @@02
        BSWAP EDX
        INC   [@@PIXEL_COORDINATE_Y_LOCAL]
        DEC   DX
        BSWAP EDX
        JNZ   @@01
;next 128 lines
        MOV   GS,[SELECTOR_BASE_ACTUAL_OFFSET2_GLOBAL]
        MOV   DX,128
        BSWAP EDX
@@03:   MOV   DX,256
@@04:   MOV   BX,[@@PIXEL_COORDINATE_Y_LOCAL]
        MOV   AX,[@@PIXEL_COORDINATE_X_LOCAL]
        LEA   EAX,[EAX*2+EAX]
        MOV   CL,[BYTES_PER_LOGICAL_SCAN_LINE_SHIFT_GLOBAL]
        SHL   EBX,CL
        ADD   EBX,EAX
        PUSH  BX
        MOV   CL,[WINDOW_GRANULARITY_SHIFT_GLOBAL]
        SHR   EBX,CL
        MOV   [FS:SI],BL
        POP   BX
        AND   BX,[WINDOW_GRANULARITY_MASK_GLOBAL]
        MOV   [GS:DI],BX
        INC   [@@PIXEL_COORDINATE_X_LOCAL]
        INC   SI
        INC   DI
        INC   DI
        DEC   DX
        JNZ   @@04
        BSWAP EDX
        INC   [@@PIXEL_COORDINATE_Y_LOCAL]
        DEC   DX
        BSWAP EDX
        JNZ   @@03
        RET
        ENDP  SCREEN_INIT_ACTUAL_PROCEDURE
;#######################################################################################################
;       SCREEN FREE ACTUAL
;#######################################################################################################
        PROC  SCREEN_FREE_ACTUAL_PROCEDURE PASCAL

        PUSH  [SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL]
        CALL  FREE_LDT_DESCRIPTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_ACTUAL_BANK_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_BANK_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_BANK_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_ACTUAL_OFFSET1_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_OFFSET1_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_OFFSET1_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_ACTUAL_OFFSET2_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_OFFSET2_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_ACTUAL_OFFSET2_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        RET
        ENDP  SCREEN_FREE_ACTUAL_PROCEDURE
;#######################################################################################################
;       SCREEN FREE LOGICAL
;#######################################################################################################
        PROC  SCREEN_FREE_LOGICAL_PROCEDURE PASCAL

        PUSH  [SELECTOR_BASE_LOGICAL_COLOR_RED_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_RED_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_RED_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_LOGICAL_COLOR_GREEN_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_GREEN_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_LOGICAL_COLOR_BLUE_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_LOGICAL_COLOR_BLUE_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        RET
        ENDP  SCREEN_FREE_LOGICAL_PROCEDURE
;#######################################################################################################
;       SCREEN FREE PHYSICAL
;#######################################################################################################
        PROC  SCREEN_FREE_PHYSICAL_PROCEDURE PASCAL

        PUSH  [SELECTOR_BASE_PHYSICAL_COLOR_RED_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_RED_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_RED_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_PHYSICAL_COLOR_GREEN_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_GREEN_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        PUSH  [SELECTOR_BASE_PHYSICAL_COLOR_BLUE_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_HIGH_GLOBAL]
        PUSH  [SELECTOR_HANDLE_PHYSICAL_COLOR_BLUE_LOW_GLOBAL]
        CALL  FREE_SELECTOR_PROCEDURE
        RET
        ENDP  SCREEN_FREE_PHYSICAL_PROCEDURE
;#######################################################################################################
;       VIDEO BANK SWAP
;#######################################################################################################
        PROC  VIDEO_BANK_SWAP_PROCEDURE PASCAL
        USES  ES

        PUSH  ZERO_EQUATE;stack words
        PUSH  ZERO_EQUATE;edi
        PUSH  ZERO_EQUATE;esi
        PUSH  ZERO_EQUATE;ebp
        PUSH  ZERO_EQUATE;res
        PUSH  ZERO_EQUATE;ebx:bh=set window position bl=0 window a
        XOR   AX,AX
        MOV   AL,[CURRENT_VIDEO_BANK_GLOBAL]
        PUSH  AX
        PUSH  ZERO_EQUATE;ecx
        PUSH  ZERO_EQUATE;eax
        PUSH  ZERO_EQUATE;cpu
        PUSH  ZERO_EQUATE;es
        PUSH  ZERO_EQUATE;ds
        PUSH  ZERO_EQUATE;fs
        PUSH  ZERO_EQUATE;gs
        PUSH  [WINDOW_SCHEME_FUNCTION_POINTER_LOW_GLOBAL];ip
        PUSH  [WINDOW_SCHEME_FUNCTION_POINTER_HIGH_GLOBAL];cs     cs:ip =far address
        PUSH  ZERO_EQUATE;sp
        PUSH  ZERO_EQUATE;ss
        CALL  CALL_REAL_MODE_PROCEDURE_WITH_FAR_RETURN_FRAME_PROCEDURE
        RET
        ENDP  VIDEO_BANK_SWAP_PROCEDURE
;#######################################################################################################
;       PIXEL PLOT ACTUAL
;#######################################################################################################
        PROC  PIXEL_PLOT_ACTUAL_PROCEDURE PASCAL
        ARG   PIXEL_COLOR_BLUE_ARGUMENT  :WORD
        ARG   PIXEL_COLOR_GREEN_ARGUMENT :WORD
        ARG   PIXEL_COLOR_RED_ARGUMENT   :WORD
        ARG   PIXEL_COORDINATE_Y_ARGUMENT:WORD
        ARG   PIXEL_COORDINATE_X_ARGUMENT:WORD

        MOV   ES,[SELECTOR_BASE_ACTUAL_COLOR_RGB_GLOBAL]
        MOV   BL,[BYTE PTR PIXEL_COORDINATE_X_ARGUMENT]
        MOV   BH,[BYTE PTR PIXEL_COORDINATE_Y_ARGUMENT]
        MOV   FS,[SELECTOR_BASE_ACTUAL_BANK_GLOBAL]
        MOV   DL,[FS:BX]
        CMP   DL,[CURRENT_VIDEO_BANK_GLOBAL]
        JZ    @@01
        MOV   [CURRENT_VIDEO_BANK_GLOBAL],DL
        CALL  VIDEO_BANK_SWAP_PROCEDURE
@@01:   OR    BX,BX
        JS    @@02
        MOV   GS,[SELECTOR_BASE_ACTUAL_OFFSET1_GLOBAL]
        JMP   @@03
@@02:   MOV   GS,[SELECTOR_BASE_ACTUAL_OFFSET2_GLOBAL]
@@03:   ADD   BX,BX
        MOV   DI,[GS:BX]
        MOV   AL,[BYTE PTR PIXEL_COLOR_BLUE_ARGUMENT]
        MOV   AH,[BYTE PTR PIXEL_COLOR_GREEN_ARGUMENT]
        MOV   [ES:DI],AX
        MOV   AL,[BYTE PTR PIXEL_COLOR_RED_ARGUMENT]
        MOV   [ES:DI+2],AL
        RET
        ENDP  PIXEL_PLOT_ACTUAL_PROCEDURE
;#######################################################################################################
;       PIXEL PLOT LOGICAL
;#######################################################################################################
        PROC  PIXEL_PLOT_LOGICAL_PROCEDURE PASCAL
        ARG   PIXEL_COLOR_BLUE_ARGUMENT  :WORD
        ARG   PIXEL_COLOR_GREEN_ARGUMENT :WORD
        ARG   PIXEL_COLOR_RED_ARGUMENT   :WORD
        ARG   PIXEL_COORDINATE_Y_ARGUMENT:WORD
        ARG   PIXEL_COORDINATE_X_ARGUMENT:WORD

        MOV   ES,[SELECTOR_BASE_LOGICAL_COLOR_RED_GLOBAL]
        MOV   FS,[SELECTOR_BASE_LOGICAL_COLOR_GREEN_GLOBAL]
        MOV   GS,[SELECTOR_BASE_LOGICAL_COLOR_BLUE_GLOBAL]
        MOV   BL,[BYTE PTR PIXEL_COORDINATE_X_ARGUMENT]
        MOV   BH,[BYTE PTR PIXEL_COORDINATE_Y_ARGUMENT]
        MOV   AL,[BYTE PTR PIXEL_COLOR_RED_ARGUMENT]
        MOV   [ES:BX],AL
        MOV   AL,[BYTE PTR PIXEL_COLOR_GREEN_ARGUMENT]
        MOV   [FS:BX],AL
        MOV   AL,[BYTE PTR PIXEL_COLOR_BLUE_ARGUMENT]
        MOV   [GS:BX],AL
        RET
        ENDP  PIXEL_PLOT_LOGICAL_PROCEDURE
;#######################################################################################################
;       PIXEL PLOT PHYSICAL
;#######################################################################################################
        PROC  PIXEL_PLOT_PHYSICAL_PROCEDURE PASCAL
        ARG   PIXEL_COLOR_BLUE_ARGUMENT  :WORD
        ARG   PIXEL_COLOR_GREEN_ARGUMENT :WORD
        ARG   PIXEL_COLOR_RED_ARGUMENT   :WORD
        ARG   PIXEL_COORDINATE_Y_ARGUMENT:WORD
        ARG   PIXEL_COORDINATE_X_ARGUMENT:WORD

        MOV   ES,[SELECTOR_BASE_PHYSICAL_COLOR_RED_GLOBAL]
        MOV   FS,[SELECTOR_BASE_PHYSICAL_COLOR_GREEN_GLOBAL]
        MOV   GS,[SELECTOR_BASE_PHYSICAL_COLOR_BLUE_GLOBAL]
        MOV   BL,[BYTE PTR PIXEL_COORDINATE_X_ARGUMENT]
        MOV   BH,[BYTE PTR PIXEL_COORDINATE_Y_ARGUMENT]
        MOV   AL,[BYTE PTR PIXEL_COLOR_RED_ARGUMENT]
        MOV   [ES:BX],AL
        MOV   AL,[BYTE PTR PIXEL_COLOR_GREEN_ARGUMENT]
        MOV   [FS:BX],AL
        MOV   AL,[BYTE PTR PIXEL_COLOR_BLUE_ARGUMENT]
        MOV   [GS:BX],AL
        RET
        ENDP  PIXEL_PLOT_PHYSICAL_PROCEDURE
;#######################################################################################################
;       ENTRY POINT
;#######################################################################################################
ENTRY_POINT:
;#######################################################################################################
;       STARTUP 
;#######################################################################################################
        CALL    INITTASK
        OR      AX,AX
        JZ      EXITAPP
        MOV     [PROGRAM_SEGMENT_PREFIX_GLOBAL],ES
        MOV     [POINTER_COMMAND_LINE_GLOBAL],BX
        MOV     [HANDLE_PROGRAM_PREVIOUS_INSTANCE_GLOBAL],SI
        MOV     [HANDLE_PROGRAM_CURRENT_INSTANCE_GLOBAL],DI
        MOV     [WINDOW_DISPLAY_STYLE_GLOBAL],DX
        PUSH    ZERO_EQUATE
        CALL    WAITEVENT
        PUSH    DI
        CALL    INITAPP
        OR      AX,AX
        JZ      EXITAPP
        CALL    WINMAIN
EXITAPP:MOV     AX,EXIT_TO_DOS_EQUATE
        INT     DOS_GENERAL_SERVICES_INTERRUPT_EQUATE
;#######################################################################################################
;       EXIT POINT
;#######################################################################################################
        END     ENTRY_POINT
