/***************************************************************** CONFIG.CPP
 *                                                                          *
 *                        Clock Configuration Dialog                        *
 *                                                                          *
 ****************************************************************************/

#define INCL_BASE
#define INCL_PM
#define INCL_WINSTDSPIN
#define INCL_WINWORKPLACE
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "debug.h"
#include "support.h"

#include "memsize.h"
#include "config.h"

 
/****************************************************************************
 *                                                                          *
 *                     Definitions & Declarations                           *
 *                                                                          *
 ****************************************************************************/

  // Function Prototypes

static FNWP InitDlg ;
static FNWP Control ;
static FNWP Command ;
static FNWP OK ;
static FNWP Cancel ;

typedef struct {
   char  DefaultLabel [80] ;
   char  CurrentLabel [80] ;
   ULONG DefaultLevels [2] ;
   ULONG WarningLevel ;
   ULONG ErrorLevel ;
   int   LevelSense ;
   ULONG MinLevel ;
   ULONG MaxLevel ;
   BOOL  Initializing ;
} LABEL_PARMS, *PLABEL_PARMS ;

static FNWP Label_Processor ;
static FNWP Static_Processor ;
static PFNWP OldStaticProcessor = 0 ;
 
/****************************************************************************
 *                                                                          *
 *      "Configure" Dialog Processor                                        *
 *                                                                          *
 ****************************************************************************/

extern MRESULT EXPENTRY ConfigureProcessor ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Dispatch the message according to the method table and return the      *
   *   result.  Any messages not defined above get handled by the system    *
   *   default dialog processor.                                            *
   **************************************************************************/

   static METHOD Methods [] = {
      { WM_INITDLG, InitDlg },
      { WM_CONTROL, Control },
      { WM_COMMAND, Command }
   } ;

   return ( DispatchMessage ( hwnd, msg, mp1, mp2, Methods, sizeof(Methods)/sizeof(Methods[0]), WinDefDlgProc ) ) ;
}
 
/****************************************************************************
 *                                                                          *
 *      Initialize Dialog                                                   *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY InitDlg ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Get initial parameters.                                                *
   **************************************************************************/

   PCONFIG_PARMS Parms = PCONFIG_PARMS ( PVOIDFROMMP ( mp2 ) ) ;

   WinSetWindowPtr ( hwnd, QWL_USER, Parms ) ;

  /**************************************************************************
   * Associate the help instance.                                           *
   **************************************************************************/

   WinAssociateHelpInstance ( WinQueryHelpInstance(WinQueryWindow(hwnd,QW_OWNER)), hwnd ) ;

  /**************************************************************************
   * Load the list box.                                                     *
   **************************************************************************/

   Parms->Ready = FALSE ;

   for ( int i=0; i<Parms->ItemCount; i++ ) {

      char Label [164] ;
      strcpy ( Label, Parms->CurrentLabels[i] ) ;
      if ( strcmp ( Parms->DefaultLabels[i], Parms->CurrentLabels[i] ) ) {
         strcat ( Label, " (" ) ;
         strcat ( Label, Parms->DefaultLabels[i] ) ;
         strcat ( Label, ")" ) ;
      } /* endif */

      WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ITEMS, LM_INSERTITEM,
         MPFROMSHORT(LIT_END), MPFROMP(Label) ) ;

      if ( Parms->ItemFlags[i] )
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ITEMS, LM_SELECTITEM, MPFROMSHORT(i), MPFROMSHORT(TRUE) ) ;

   } /* endfor */

  /**************************************************************************
   * Set the radio button and checkbox values.                              *
   **************************************************************************/

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_HIDECONTROLS,
      BM_SETCHECK, MPFROMSHORT(Parms->HideControls), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_FLOAT,
      BM_SETCHECK, MPFROMSHORT(Parms->Float), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ANIMATE,
      BM_SETCHECK, MPFROMSHORT(Parms->Animate), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TABLE,
      BM_SETCHECK, MPFROMSHORT(Parms->TableFormat), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWREMOTES,
      BM_SETCHECK, MPFROMSHORT(Parms->ShowRemoteDrives), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_FSNAME,
      BM_SETCHECK, MPFROMSHORT(Parms->ShowFileSystemNames), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_DLABEL,
      BM_SETCHECK, MPFROMSHORT(Parms->ShowDiskLabels), 0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SECONDS,
      BM_SETCHECK, MPFROMSHORT(Parms->ShowSeconds), 0 ) ;

   switch ( Parms->ShowK ) {
      case SHOWK_NEVER:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_NEVER, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
      case SHOWK_ALWAYS:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_ALWAYS, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
      case SHOWK_ABOVE512:
      default:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_ABOVE512, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
   } /* endswitch */

   switch ( Parms->AnchorCorner ) {
      case CORNER_BL:
      default:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_BL, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
      case CORNER_BR:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_BR, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
      case CORNER_TL:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TL, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
      case CORNER_TR:
         WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TR, BM_SETCHECK, MPFROMSHORT(TRUE), 0 ) ;
         break;
   } /* endswitch */

  /**************************************************************************
   * Set the limits and initial value of the spin-button controls.          *
   **************************************************************************/

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_PRIORITY,
      SPBM_SETLIMITS, (MPARAM)PRTYD_MAXIMUM, (MPARAM)0 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_PRIORITY,
      SPBM_SETCURRENTVALUE, (MPARAM)(Parms->MonitorPriority), NULL ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TIMER,
      SPBM_SETLIMITS, (MPARAM)300, (MPARAM)10 ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TIMER,
      SPBM_SETCURRENTVALUE, (MPARAM)(Parms->TimerInterval/100), NULL ) ;

  /**************************************************************************
   * Initialize state.                                                      *
   **************************************************************************/

   Parms->Ready = TRUE ;
   Parms->MostRecentSelection = -1 ;

  /**************************************************************************
   * Set the initial values of the color controls.                          *
   **************************************************************************/

   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_NORMAL), 
      PP_BACKGROUNDCOLOR, sizeof(Parms->NormalBackground), MPFROMP(&Parms->NormalBackground) ) ;
   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_NORMAL), 
      PP_FOREGROUNDCOLOR, sizeof(Parms->NormalForeground), MPFROMP(&Parms->NormalForeground) ) ;
   OldStaticProcessor = WinSubclassWindow ( WinWindowFromID(hwnd,IDD_CONFIG_NORMAL), Static_Processor ) ;

   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_WARNING), 
      PP_BACKGROUNDCOLOR, sizeof(Parms->WarningBackground), MPFROMP(&Parms->WarningBackground) ) ;
   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_WARNING), 
      PP_FOREGROUNDCOLOR, sizeof(Parms->WarningForeground), MPFROMP(&Parms->WarningForeground) ) ;
   WinSubclassWindow ( WinWindowFromID(hwnd,IDD_CONFIG_WARNING), Static_Processor ) ;

   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_ERROR), 
      PP_BACKGROUNDCOLOR, sizeof(Parms->ErrorBackground), MPFROMP(&Parms->ErrorBackground) ) ;
   WinSetPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_ERROR), 
      PP_FOREGROUNDCOLOR, sizeof(Parms->ErrorForeground), MPFROMP(&Parms->ErrorForeground) ) ;
   WinSubclassWindow ( WinWindowFromID(hwnd,IDD_CONFIG_ERROR), Static_Processor ) ;

  /**************************************************************************
   * Return without error.                                                  *
   **************************************************************************/

   return ( 0 ) ;
}
 
/****************************************************************************
 *                                                                          *
 *      Process control messages.                                           *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY Control ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Find the instance data.                                                *
   **************************************************************************/

   PCONFIG_PARMS Parms = PCONFIG_PARMS ( WinQueryWindowPtr ( hwnd, QWL_USER ) ) ;

  /**************************************************************************
   * Decode the message.  Find out what control sent it, and what the       *
   *   control had to say.                                                  *
   **************************************************************************/

   SHORT Id = SHORT1FROMMP ( mp1 ) ;
   SHORT Message = SHORT2FROMMP ( mp1 ) ;

  /**************************************************************************
   * If the message origin was the List Box, process the message here.      *
   **************************************************************************/

   if ( Id == IDD_CONFIG_ITEMS ) {

      switch ( Message ) {

         case LN_SELECT: {
            if ( NOT Parms->Ready )
               break ;
            SHORT Selection = LIT_FIRST ;
            SHORT Last = -1 ;
            do {
               Selection = short ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
                  IDD_CONFIG_ITEMS, LM_QUERYSELECTION,
                  MPFROMSHORT(SHORT(Selection)), 0 ) ) ) ;
               if ( Selection != LIT_NONE ) {
                  for ( Last++; Last<Selection; Last++ ) {
                     if ( Parms->ItemFlags[Last] ) {
                        Parms->ItemFlags[Last] = FALSE ;
                        Parms->MostRecentSelection = Last ;
                     } /* endif */
                  } /* endfor */
                  if ( Parms->ItemFlags[Selection] == FALSE ) {
                     Parms->ItemFlags[Selection] = TRUE ;
                     Parms->MostRecentSelection = Selection ;
                  } /* endif */
               } else {
                  for ( Last++; Last<Parms->ItemCount; Last++ ) {
                     if ( Parms->ItemFlags[Last] ) {
                        Parms->ItemFlags[Last] = FALSE ;
                        Parms->MostRecentSelection = Last ;
                     } /* endif */
                  } /* endfor */
               } /* endif */
            } while ( Selection != LIT_NONE ) ;
            break ;
         } /* endcase */

         case LN_ENTER: {
            if ( Parms->MostRecentSelection == -1 ) 
               break ;

            LABEL_PARMS LabelParms ;
            strcpy ( LabelParms.DefaultLabel, Parms->DefaultLabels[Parms->MostRecentSelection] ) ;
            strcpy ( LabelParms.CurrentLabel, Parms->CurrentLabels[Parms->MostRecentSelection] ) ;
            LabelParms.DefaultLevels [0] = Parms->DefaultLevels[Parms->MostRecentSelection] [0] ;
            LabelParms.DefaultLevels [1] = Parms->DefaultLevels[Parms->MostRecentSelection] [1] ;
            LabelParms.WarningLevel = Parms->WarningLevel[Parms->MostRecentSelection] ;
            LabelParms.ErrorLevel = Parms->ErrorLevel[Parms->MostRecentSelection] ;
            LabelParms.LevelSense = Parms->LevelSense[Parms->MostRecentSelection] ;
            LabelParms.MinLevel = Parms->MinLevel[Parms->MostRecentSelection] ;
            LabelParms.MaxLevel = Parms->MaxLevel[Parms->MostRecentSelection] ;
            if ( WinDlgBox ( HWND_DESKTOP, hwnd, Label_Processor, LibraryHandle, IDD_LABEL, &LabelParms ) ) {
               strcpy ( Parms->CurrentLabels[Parms->MostRecentSelection], LabelParms.CurrentLabel ) ;
               char Label [164] ;
               strcpy ( Label, Parms->CurrentLabels[Parms->MostRecentSelection] ) ;
               if ( strcmp ( Parms->DefaultLabels[Parms->MostRecentSelection], Parms->CurrentLabels[Parms->MostRecentSelection] ) ) {
                  strcat ( Label, " (" ) ;
                  strcat ( Label, Parms->DefaultLabels[Parms->MostRecentSelection] ) ;
                  strcat ( Label, ")" ) ;
               } /* endif */
               Parms->WarningLevel[Parms->MostRecentSelection] = LabelParms.WarningLevel ;
               Parms->ErrorLevel[Parms->MostRecentSelection] = LabelParms.ErrorLevel ;
               WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ITEMS, LM_DELETEITEM,
                  MPFROMSHORT(Parms->MostRecentSelection), 0 ) ;
               WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ITEMS, LM_INSERTITEM,
                  MPFROMSHORT(Parms->MostRecentSelection), MPFROMP(Label) ) ;
               WinSendDlgItemMsg ( hwnd, IDD_CONFIG_ITEMS, LM_SELECTITEM,
                  MPFROMSHORT(Parms->MostRecentSelection), MPFROMSHORT(TRUE) ) ;
            } /* endif */
            break ;
         } /* endcase */

      } /* endswitch */

   } /* endif */

  /**************************************************************************
   * Return without error.                                                  *
   **************************************************************************/

   return ( 0 ) ;
}
 
/****************************************************************************
 *                                                                          *
 *      Process commands.                                                   *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY Command ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Dispatch the message without a default message processor.              *
   **************************************************************************/

   static METHOD Methods [] = {
      { DID_OK,             OK            },
      { DID_CANCEL,         Cancel        },
   } ;

   return ( DispatchMessage ( hwnd, SHORT1FROMMP(mp1), mp1, mp2, Methods, sizeof(Methods)/sizeof(Methods[0]), PFNWP(NULL) ) ) ;
}
 
/****************************************************************************
 *                                                                          *
 *      Process the OK button being pressed.                                *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY OK ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Find the instance data.                                                *
   **************************************************************************/

   PCONFIG_PARMS Parms = PCONFIG_PARMS ( WinQueryWindowPtr ( hwnd, QWL_USER ) ) ;

  /**************************************************************************
   * Query the list box items for their selection.                          *
   **************************************************************************/

   for ( int i=0; i<Parms->ItemCount; i++ )
      Parms->ItemFlags[i] = FALSE ;

   SHORT Selection = LIT_FIRST ;
   do {

      Selection = short ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
         IDD_CONFIG_ITEMS, LM_QUERYSELECTION,
         MPFROMSHORT(SHORT(Selection)), 0 ) ) ) ;

      if ( Selection != LIT_NONE ) 
        Parms->ItemFlags[Selection] = TRUE ;

   } while ( Selection != LIT_NONE ) ;

  /**************************************************************************
   * Query the buttons for their new settings.                              *
   **************************************************************************/

   Parms->HideControls = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_HIDECONTROLS, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->Float = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_FLOAT, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->Animate = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_ANIMATE, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->TableFormat = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_TABLE, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->ShowRemoteDrives = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_SHOWREMOTES, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->ShowFileSystemNames = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_FSNAME, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->ShowDiskLabels = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_DLABEL, BM_QUERYCHECK, 0, 0 ) ) ;

   Parms->ShowSeconds = (BOOL) SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd,
      IDD_CONFIG_SECONDS, BM_QUERYCHECK, 0, 0 ) ) ;

   if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_NEVER, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->ShowK = SHOWK_NEVER ;
   } else if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_ABOVE512, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->ShowK = SHOWK_ABOVE512 ;
   } else if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_SHOWK_ALWAYS, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->ShowK = SHOWK_ALWAYS ;
   } /* endif */

   if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_BL, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->AnchorCorner = CORNER_BL ;
   } else if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_BR, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->AnchorCorner = CORNER_BR ;
   } else if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TL, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->AnchorCorner = CORNER_TL ;
   } else if ( SHORT1FROMMR ( WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TR, BM_QUERYCHECK, 0, 0 ) ) ) {
      Parms->AnchorCorner = CORNER_TR ;
   } /* endif */

  /**************************************************************************
   * Query the spinbuttons for their new settings.                          *
   **************************************************************************/

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_PRIORITY, SPBM_QUERYVALUE,
      &Parms->MonitorPriority, MPFROM2SHORT(0,SPBQ_UPDATEIFVALID) ) ;

   WinSendDlgItemMsg ( hwnd, IDD_CONFIG_TIMER, SPBM_QUERYVALUE,
      &Parms->TimerInterval, MPFROM2SHORT(0,SPBQ_UPDATEIFVALID) ) ;

   Parms->TimerInterval *= 100 ;

  /**************************************************************************
   * Query the color boxes for their new settings.                          *
   **************************************************************************/

   ULONG ppid ;

   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_NORMAL), PP_BACKGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->NormalBackground), &Parms->NormalBackground, 0 ) ;
   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_NORMAL), PP_FOREGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->NormalForeground), &Parms->NormalForeground, 0 ) ;

   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_WARNING), PP_BACKGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->WarningBackground), &Parms->WarningBackground, 0 ) ;
   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_WARNING), PP_FOREGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->WarningForeground), &Parms->WarningForeground, 0 ) ;

   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_ERROR), PP_BACKGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->ErrorBackground), &Parms->ErrorBackground, 0 ) ;
   WinQueryPresParam ( WinWindowFromID(hwnd,IDD_CONFIG_ERROR), PP_FOREGROUNDCOLOR, 0, &ppid,
      sizeof(Parms->ErrorForeground), &Parms->ErrorForeground, 0 ) ;

  /**************************************************************************
   * Dismiss the dialog with a TRUE status.                                 *
   **************************************************************************/

   WinDismissDlg ( hwnd, TRUE ) ;

   return ( 0 ) ;
}
 
/****************************************************************************
 *                                                                          *
 *      Process the Cancel button being pressed.                            *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY Cancel ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

  /**************************************************************************
   * Dismiss the dialog with a TRUE status.                                 *
   **************************************************************************/

   WinDismissDlg ( hwnd, FALSE ) ;

   return ( 0 ) ;
}

/****************************************************************************
 *                                                                          *
 *      Item Label dialog processor.                                        *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY Label_Processor ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

   switch ( msg ) {

      case WM_INITDLG: {
         PLABEL_PARMS Parms = PLABEL_PARMS ( PVOIDFROMMP ( mp2 ) ) ;
         Parms->Initializing = TRUE ;
         WinSetWindowPtr ( hwnd, QWL_USER, Parms ) ;
         WinAssociateHelpInstance ( WinQueryHelpInstance(WinQueryWindow(hwnd,QW_OWNER)), hwnd ) ;
         WinSetDlgItemText ( hwnd, IDD_LABEL_DEFLABEL, PSZ(Parms->DefaultLabel) ) ;
         WinSetDlgItemText ( hwnd, IDD_LABEL_NEWLABEL, PSZ(Parms->CurrentLabel) ) ;
         WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_NEWLABEL), EM_SETTEXTLIMIT, MPFROM2SHORT(sizeof(Parms->CurrentLabel),0), 0 ) ;
         if ( Parms->LevelSense ) {
            int Divisor = 1 ;
            char *Suffix = "" ;
            if ( Parms->MaxLevel > 1024*1024 ) {
               Divisor = 1024*1024 ;
               Suffix = "M" ;
            } else if ( Parms->MaxLevel > 1024 ) {
               Divisor = 1024 ;
               Suffix = "K" ;
            } /* endif */
            char Text [20] ;
            sprintf ( Text, "%i%s", Parms->MinLevel/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(0), MPFROMP(Text) ) ;
            sprintf ( Text, "%i%s", (Parms->MinLevel+(Parms->MaxLevel-Parms->MinLevel)/2)/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(99), MPFROMP(Text) ) ;
            sprintf ( Text, "%i%s", Parms->MaxLevel/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(199), MPFROMP(Text) ) ;
            sprintf ( Text, "%i%s", Parms->MinLevel/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(0), MPFROMP(Text) ) ;
            sprintf ( Text, "%i%s", (Parms->MinLevel+(Parms->MaxLevel-Parms->MinLevel)/2)/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(99), MPFROMP(Text) ) ;
            sprintf ( Text, "%i%s", Parms->MaxLevel/Divisor, Suffix ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_SETSCALETEXT, MPFROMSHORT(199), MPFROMP(Text) ) ;
            short Tick = short ( ( ( ( Parms->WarningLevel - Parms->MinLevel ) / Divisor ) * 200 ) / ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_SETSLIDERINFO, 
               MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), MPFROMSHORT(Tick) ) ;
            Tick = short ( ( ( ( Parms->ErrorLevel - Parms->MinLevel ) / Divisor ) * 200 ) / ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) ;
            WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_SETSLIDERINFO, 
               MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), MPFROMSHORT(Tick) ) ;
            sprintf ( Text, "%i", Parms->WarningLevel ) ;
            WinSetDlgItemText ( hwnd, IDD_LABEL_WARNING_VALUE, PSZ(Text) ) ;
            sprintf ( Text, "%i", Parms->ErrorLevel ) ;
            WinSetDlgItemText ( hwnd, IDD_LABEL_ERROR_VALUE, PSZ(Text) ) ;
         } else {
            WinEnableWindow ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), FALSE ) ;
            WinEnableWindow ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_VALUE), FALSE ) ;
            WinEnableWindow ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), FALSE ) ;
            WinEnableWindow ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_VALUE), FALSE ) ;
         } /* endif */
         Parms->Initializing = FALSE ;
         return ( 0 ) ; }

      case WM_CONTROL: {
         PLABEL_PARMS Parms = PLABEL_PARMS ( WinQueryWindowPtr ( hwnd, QWL_USER ) ) ;
         if ( Parms->Initializing ) 
            return ( 0 ) ;
         SHORT Id = SHORT1FROMMP ( mp1 ) ;
         SHORT Message = SHORT2FROMMP ( mp1 ) ;
         int Divisor = 1 ;
         if ( Parms->MaxLevel > 1024*1024 ) {
            Divisor = 1024*1024 ;
         } else if ( Parms->MaxLevel > 1024 ) {
            Divisor = 1024 ;
         } /* endif */
         switch ( Id ) {
            case IDD_LABEL_WARNING_SLIDER: {
               if ( ( Message == SLN_CHANGE ) || ( Message == SLN_SLIDERTRACK ) ) {
                  ULONG Tick = LONGFROMMR ( WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_QUERYSLIDERINFO, 
                     MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), 0 ) ) ;
                  Parms->WarningLevel = ( ( Tick * ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) / 200 ) * Divisor + Parms->MinLevel ;
                  char Text [20] ;
                  sprintf ( Text, "%i", Parms->WarningLevel ) ;
                  WinSetDlgItemText ( hwnd, IDD_LABEL_WARNING_VALUE, PSZ(Text) ) ;
               } /* endif */
               break; }
            case IDD_LABEL_ERROR_SLIDER: {
               if ( ( Message == SLN_CHANGE ) || ( Message == SLN_SLIDERTRACK ) ) {
                  ULONG Tick = LONGFROMMR ( WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_QUERYSLIDERINFO, 
                     MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), 0 ) ) ;
                  Parms->ErrorLevel = ( ( Tick * ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) / 200 ) * Divisor + Parms->MinLevel ;
                  char Text [20] ;
                  sprintf ( Text, "%i", Parms->ErrorLevel ) ;
                  WinSetDlgItemText ( hwnd, IDD_LABEL_ERROR_VALUE, PSZ(Text) ) ;
               } /* endif */
               break; }
         } /* endswitch */
         return ( 0 ) ; }

      case WM_COMMAND: {
         PLABEL_PARMS Parms = PLABEL_PARMS ( WinQueryWindowPtr ( hwnd, QWL_USER ) ) ;
         switch ( SHORT1FROMMP(mp1) ) {
            case DID_OK: {
               WinQueryDlgItemText ( hwnd, IDD_LABEL_NEWLABEL, sizeof(Parms->CurrentLabel), PSZ(Parms->CurrentLabel) ) ;
               if ( Parms->CurrentLabel[0] == 0 ) {
                  WinAlarm ( HWND_DESKTOP, WA_NOTE ) ;
                  WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwnd, IDD_LABEL_NEWLABEL ) ) ;
                  break ;
               } /* endif */
               char Text [20] ;
               WinQueryDlgItemText ( hwnd, IDD_LABEL_WARNING_VALUE, sizeof(Text), PSZ(Text) ) ;
               Parms->WarningLevel = atol ( Text ) ;
               WinQueryDlgItemText ( hwnd, IDD_LABEL_ERROR_VALUE, sizeof(Text), PSZ(Text) ) ;
               Parms->ErrorLevel = atol ( Text ) ;
               WinDismissDlg ( hwnd, TRUE ) ;
               break ; }
            case DID_CANCEL:
               WinDismissDlg ( hwnd, FALSE ) ;
               break ;
            case IDD_LABEL_DEFAULT:
               Parms->Initializing = TRUE ;
               strcpy ( Parms->CurrentLabel, Parms->DefaultLabel ) ;
               WinSetDlgItemText ( hwnd, IDD_LABEL_NEWLABEL, PSZ(Parms->CurrentLabel) ) ;
               Parms->WarningLevel = Parms->DefaultLevels [0] ;
               Parms->ErrorLevel = Parms->DefaultLevels [1] ;
               int Divisor = 1 ;
               if ( Parms->MaxLevel > 1024*1024 ) {
                  Divisor = 1024*1024 ;
               } else if ( Parms->MaxLevel > 1024 ) {
                  Divisor = 1024 ;
               } /* endif */
               short Tick = short ( ( ( ( Parms->WarningLevel - Parms->MinLevel ) / Divisor ) * 200 ) / ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) ;
               WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_WARNING_SLIDER), SLM_SETSLIDERINFO, 
                  MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), MPFROMSHORT(Tick) ) ;
               Tick = short ( ( ( ( Parms->ErrorLevel - Parms->MinLevel ) / Divisor ) * 200 ) / ( ( Parms->MaxLevel - Parms->MinLevel ) / Divisor ) ) ;
               WinSendMsg ( WinWindowFromID(hwnd,IDD_LABEL_ERROR_SLIDER), SLM_SETSLIDERINFO, 
                  MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE), MPFROMSHORT(Tick) ) ;
               char Text [20] ;
               sprintf ( Text, "%i", Parms->WarningLevel ) ;
               WinSetDlgItemText ( hwnd, IDD_LABEL_WARNING_VALUE, PSZ(Text) ) ;
               sprintf ( Text, "%i", Parms->ErrorLevel ) ;
               WinSetDlgItemText ( hwnd, IDD_LABEL_ERROR_VALUE, PSZ(Text) ) ;
               WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwnd, IDD_LABEL_NEWLABEL ) ) ;
               Parms->Initializing = FALSE ;
               break ;
         } /* endswitch */
         return ( 0 ) ; }

   } /* endswitch */

   return ( WinDefDlgProc ( hwnd, msg, mp1, mp2 ) ) ;
}

/****************************************************************************
 *                                                                          *
 *      Subclasses STATIC control message processor                         *
 *                                                                          *
 ****************************************************************************/

static MRESULT APIENTRY Static_Processor ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {

   switch ( msg ) {

      case WM_SINGLESELECT:
      case WM_CONTEXTMENU: {
         HOBJECT hObject = WinQueryObject ( "<WP_LORESCLRPAL>" ) ;
         if ( hObject ) 
            WinOpenObject ( hObject, 0, FALSE ) ;
         break ; }

   } /* endswitch */

   return ( OldStaticProcessor ( hwnd, msg, mp1, mp2 ) ) ;
}


