/* FRANCAIS.CMD : installation de 'Ressources systme' en franais. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation de 'D2C(39)'Ressources systme'D2C(39)'...'
Say ''


/* Vrification de l'existance des diffrents fichiers. */

Language = 'FRANCAIS'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : MEMSIZE.EXE introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : 'Language'.DLL introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : 'Language'.HLP introuvable !'
  Signal DONE
  End

/* Saisie du rpertoire de destination. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Veuillez saisir le nom complet du rpertoire o Ressources Systme'
Say '  doit tre install (par dfaut, 'Default') : '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Cration du rpertoire destination si ncessaire. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'Erreur : Impossible de crer le rpertoire destination.'
    Signal DONE
    End
  End
Say ''


/* Saisie par l'utilisateur du dossier destination. */

Say 'Dsirez-vous ajouter 'D2C(39)'Ressources systme'D2C(39)' au dossier de lancement ? (O/N) '
Pull YesNo
If YesNo = "O" Then
  Do
  Folder = '<WP_START>'
  Say 'L'D2C(39)'objet sera plac dans le dossier de lancement.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'L'D2C(39)'objet sera plac sur le bureau.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Installation */

Say 'Copie de 'D2C(39)'Ressources systme'D2C(39)' vers 'Directory' ...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'Cration de l'D2C(39)'objet programme...'
Type = 'WPProgram'
Title = 'Ressources systme'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objet cr ! Termin.'
Else
  Say 'Erreur : l'D2C(39)'objet n'D2C(39)'a pas pu tre cr.'

Signal DONE

FAILURE:
Say 'chec REXX.'
Signal DONE

HALT:
Say 'Halte REXX.'
Signal DONE

SYNTAX:
Say 'Erreur de syntaxe REXX.'
Signal DONE

DONE:
Exit
