/*Sprite-tekniikkaa esittelev ohjelma, Copyright (C) 1995, Tarmo Toikkanen

	Ohjelma kntyy sellaisenaan sek Borlandin C++:lla ett DJGPP:lla.

	Kntmiskomennot:
		bcc sprite2.cpp
	tai
		gcc sprite2.cpp -lpc -o sprite2.out
		strip sprite2.out
		coff2exe sprite2.out
*/

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#ifdef __BORLANDC__
	#include <mem.h>
	// Normaalisti grafiikkamuisti alkaa osoitteesta A0000h
	char *puskuri,*ruutu=(char *)(0xA0000000);
	#define random rand
	#define int long
#else
	#include <djgppstd.h>
	#include <pc.h>
	// DJGPP:ss grafiikkamuisti alkaa osoitteesta D0000h
	char *puskuri,*ruutu=(char *)(0xD0000000);
	#define CLK_TCK 1000000
#endif

#define LEVEYS	 320		// Ruudun mitat
#define KORKEUS  200
#define TRANS	     0  	// Vri 0 mritetn lpinkyvksi
#define SPRITENUM  4 		// Tehdn 4 spriten taulukko

#define TOP        1		// Ruudun laitojen arvot
#define BOTTOM     2		//   trmystarkistuksia varten
#define LEFT       4
#define RIGHT      8


/************************************************************************/
/*                           LUOKKA: BitMap                             */
/************************************************************************/

class BitMap {
	unsigned short w,h;				// Leveys ja korkeus
	char *kuva;								// Osoitin kuvatietoihin
public:
	BitMap(char *);
	~BitMap(void);
	int Leveys(void) { return(w); }
	int Korkeus(void) { return(h); }
	unsigned char Pixel(short x,short y);
	void Ruudulle(short,short,short tr=-1);
};

// Konstruktori: parametrina PCX-tiedoston nimi
BitMap::BitMap(char *tiedosto) {
	unsigned int p;
	short tavu,tavu2;
	FILE *pcx=fopen(tiedosto,"rb");		// Avataan tiedosto
	if (!pcx) {												// Tarkistetaan
		textmode(0x3);
		fprintf(stderr,"Tiedosto %s puuttuu!",tiedosto);
		exit(1);
	}
	fseek(pcx,8,SEEK_SET);							// Kohdassa 8 on (leveys-1)
	w=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Luetaan integer
	h=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Seuraavana on (korkeus-1)
	kuva=(char *)malloc(w*h);						// Varataan muistia kuvalle
	if (kuva==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui tiedoston %s kohdalla!",tiedosto);
		exit(1);
	}
	fseek(pcx,128,SEEK_SET);				// Kohdassa 128 alkaa kuvatieto
	for(p=0; p<w*h;) {						// Luetaan korkeus*leveys tavua
		tavu=fgetc(pcx);						// Luetaan tavu
		if (tavu>192) {						// Jos tavu>192, sen perss
			tavu2=fgetc(pcx);					//   oleva tavu2 on toistettava
			for(;tavu>192; tavu--)        //   (tavu-192) kertaa
				kuva[p++]=tavu2;
		} else kuva[p++]=tavu;				// Muussa tapauksessa tavu
	}												//   esiintyy vain kerran
	fclose(pcx);
}

// Destruktori, vapauttaa kuvalle varatun muistin
BitMap::~BitMap(void) {
	free(kuva);
}

// Palauttaa pikselin vrin haetussa kohdassa
unsigned char BitMap::Pixel(short x,short y) {
	if (x<0 || x>=w || y<0 || y>=h) return(TRANS);
	return(kuva[y*w+x]);
}

// Piirt bittikartan ruudulle kohtaan (x,y)
void BitMap::Ruudulle(short x,short y,short tr) {
	unsigned short xx,yy,o0,o1,o2,ww,hh;
	if (y + h > KORKEUS) hh=KORKEUS-y; else hh=h;
	if (x + w > LEVEYS) ww=LEVEYS-x; else ww=w;
	if (tr==TRANS) {			// Piirretn lpinkyvn
		for(yy=0,o0=y*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
			for(xx=0,o1=x; xx<ww; xx++,o1++,o2++)
				if (kuva[o2]!=TRANS)
					puskuri[o0+o1]=kuva[o2];
	} else {						// Piirretn tydellisen
		for(yy=0,o0=y*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
			for(xx=0,o1=x; xx<ww; xx++,o1++,o2++)
				puskuri[o0+o1]=kuva[o2];
	}
}

/************************************************************************/
/*                           LUOKKA: Animation                          */
/************************************************************************/

#define MAXANIM 20
#define S_MBNET 1					// Spritetyyppi 1: MBnet-logo
#define S_STAR 2					// Spritetyyppi 2: Thti
#define LOOP 1						// Animaatiotyyppi: looppaava

class Animation {
	BitMap *bitmap[MAXANIM];
	short nopeus,loop;
public:
	short tyyppi;
	Animation (short t=0,short s=1,short l=0);
	void Rakenna(BitMap *);
	short Seuraava(short n,long laskuri);
	BitMap *Kuva(short n) { return(bitmap[n]); };
};

// Konstruktori: parametreina tyyppi, nopeus ja looppaus
Animation::Animation(short t,short s,short l) {
	for(short n=0;n<MAXANIM;n++) bitmap[n]=NULL;
	tyyppi=t; nopeus=s; loop=l;
}

// Lis bittikartan "bm" animaatioketjun pern
void Animation::Rakenna(BitMap *bm) {
	for(short n=0;n<MAXANIM;n++) if (bitmap[n]==NULL) {
		bitmap[n]=bm;
		break;
	}
}

// Palauttaa animaatioketjun seuraavan kuvan numeron
short Animation::Seuraava(short n,long laskuri) {
	if (laskuri%nopeus!=0) return(n);
	if (n+1<MAXANIM && bitmap[n+1]!=NULL) return(n+1);
	if (loop) return(0);
	return(n);
}

/************************************************************************/
/*                           LUOKKA: Sprite                             */
/************************************************************************/

class Sprite {
	short x,y,bx,by;				// Koordinaatit (uudet ja vanhat)
	short dirx,diry;    		// Liikkumasuunnat
	unsigned short w,h;			// Spriten koko (taustaa varten)
	Animation *animation;		// Osoitin animaatiosarjaan
	char *tausta; 					// Osoitin taustan varastotilaan
public:
	int anim;

	void Animoi(long laskuri) { anim=animation->Seuraava(anim,laskuri); }
	void Link(Animation *a) { animation=a; anim=0; }
	BitMap *Kuva(void) { return(animation->Kuva(anim)); }
	int Tyyppi(void) { return(animation->tyyppi); }

	// Tietojenpalautusfunktiot
	short GetX(void) { return(x); }
	short GetY(void) { return(y); }
	short GetXSuunta(void) { return(dirx); }
	short GetYSuunta(void) { return(diry); }
	// Liikkumasuuntien mrittelyfunktiot
	void XSuunta(short dx) { dirx=dx; }
	void YSuunta(short dy) { diry=dy; }
	void XYSuunta(short dx,short dy) { dirx=dx; diry=dy; }

	// Siirt spriten paikkaan (nx,ny)
	void Paikka(short nx,short ny) { x=nx; y=ny; }
	// Siirt sprite liikkumasuuntien mukaan
	void Siirry(void) { x+=dirx; y+=diry; }

	Sprite(short,short);			// Konstruktori, luo uuden spriten
	~Sprite(void);						// Destruktori, poistaa spriten

	// Tarkistukset ruudun laitaan ja toisiin spriteihin
	short Laidassa(void);
	short Osuma(Sprite *s);

	// Piirto- ja pyyhintfunktiot
	void Ruudulle(void);
	void Pyyhi(void);
};

// Konstruktori: parametreina spriten leveys ja korkeus
Sprite::Sprite(short leveys,short korkeus) {
	w=leveys; h=korkeus; 						// Talletetaan kokotiedot
	tausta=(char *)malloc(w*h);			// Varataan taustavarasto
	if (tausta==NULL) {  						// Tarkistetaan ett muistia riitti
		textmode(0x3);
		fprintf(stderr,"Muisti loppui spritess!");
		exit(3);
	}
	x=0; y=0; bx=0; by=0; dirx=0; diry=0;	// Alustetaan muuttujat
}

// Destruktori: vapauttaa taustavaraston
Sprite::~Sprite(void) { free(tausta); }

// Tarkistaa trmk kaksi sprite toisiinsa seuraavalla pivityksell
// Parametrina osoitin spriteen jonka kanssa trmys tarkistetaan
// Palauttaa 1 jos trmys tapahtuu, muuten 0
short Sprite::Osuma(Sprite *s) {
	unsigned short xx,yy;
		// Lasketaan spritejen vliset etisyydet
	unsigned int dx=abs(x + dirx - (s->x + s->GetXSuunta()));
	unsigned int dy=abs(y + diry - (s->y + s->GetXSuunta()));
		// Ovatko spritet osittain toisensa pll?
	if (dx > w && dx > s->w) return(0);
	if (dy > h && dy > s->h) return(0);
		// Jos ovat, niin kydn ne lpi pikseli pikselilt
		// Jos kaksi pllekkist pikseli on lpinkymttmi,
		//   on trmys tapahtunut
	for(yy=0; yy<h; yy++) for(xx=0; xx<w; xx++)
		if (yy-dy < s->h && xx-dx < s->w)
			if (Kuva()->Pixel(yy,xx)!=TRANS &&
				 s->Kuva()->Pixel(yy-dy,xx-dx)!=TRANS) return(1);
	return(0);
}

// Tarkistaa trmk sprite ruudun laitaan seuraavalla pivityksell
// Palauttaa bittikentn jossa on tiedot kaikista laidoista
short Sprite::Laidassa(void) {
	short res=0;
	if (x + dirx < 0) res|=LEFT;
	else if (x + dirx + w>=LEVEYS) res|=RIGHT;
	if (y + diry < 0) res|=TOP;
	else if (y + diry + h>=KORKEUS) res|=BOTTOM;
	return(res);
}

// Poistaa spriten ruudulta ja palauttaa taustan entiselleen
void Sprite::Pyyhi(void) {
	unsigned short xx,yy,o0,o1,o2,hh,ww;
	if (by + h > KORKEUS) hh=KORKEUS-by; else hh=h;
	if (bx + w > LEVEYS) ww=LEVEYS-bx; else ww=w;
	for(yy=0,o0=by*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
		for(xx=0,o1=bx; xx<ww; xx++,o1++,o2++)
				puskuri[o0+o1]=tausta[o2];
}

// Piirt spriten ruudulle ja ottaa sen ylikirjoittaman taustan talteen
void Sprite::Ruudulle(void) {
	unsigned short xx,yy,hh,ww,o0,o1,o2;
	unsigned char pixel;
	bx=x; by=y;		 // Pivitetn vanhoille koordinaateille uudet arvot
	if (y + h > KORKEUS) hh=KORKEUS-y; else hh=h;
	if (x + w > LEVEYS) ww=LEVEYS-x; else ww=w;
	for(yy=0,o0=by*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
		for(xx=0,o1=bx; xx<ww; xx++,o1++,o2++)
				tausta[o2]=puskuri[o0+o1];
	Kuva()->Ruudulle(x,y,TRANS);	// Piirretn sprite lpinkyvn
}

/************************************************************************/
/*                                Pkoodi                              */
/************************************************************************/

// Muuttaa Nytnohjaimen paletin PCX-tiedoston mukaan
void Paletti(char *tiedosto) {
	short c;
	unsigned char paletti[256*3];		// Tilaa 256 vrin RGB-arvoille
	FILE *pcx=fopen(tiedosto,"rb");	// Avataan tiedosto
	fseek(pcx,-768l,SEEK_END);			// Paletti alkaa 768 tavua lopusta lukien
	for(c=0;c<256;c++) {						// Luetaan kaikki 256 vri
		paletti[c*3+0]=fgetc(pcx)/4;
		paletti[c*3+1]=fgetc(pcx)/4;	// Saatu arvo jaetaan neljll koska
		paletti[c*3+2]=fgetc(pcx)/4;	//   VGA-paletissa on vain arvot 0..63
	}
	fclose(pcx);
	outportb(0x3C8,0);
	for(c=0;c<256*3;c++) outportb(0x03C9,paletti[c]);
}

// Kopioi kaksoispuskurin sislln ruudulle
void Puskuri(void) {
	// Odotetaan nytnohjaimen pystypalautusta
	while(inportb(0x03DA)&8!=0);
	while(inportb(0x03DA)&8==0);
	#ifdef __BORLANDC__
	asm {		// Kopioidaan kaksoispuskuri nytlle
		push ds
		les di,[ruutu]
		lds si,[puskuri]
		mov cx,64000/4
		db 0x66
		rep movsw
		pop ds
	}
	#else
	memcpy(ruutu,puskuri,64000);
	#endif
}

short main(void) {
	short n,x,y,viive,ulos;
	unsigned long frames=0;
	// Varataan kaksoispuskurille muistia
	puskuri=(char *)malloc(64000);
	if (puskuri==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui puskurissa!");
		exit(3);
	}
	// Luodaan animaatio-, bittikartta- ja spritetaulukot
	Animation anim_mb(S_MBNET),anim_star(S_STAR,4,LOOP);
	BitMap *tausta,*mbnet[7],*star[4];
	Sprite *kuvat[SPRITENUM];

	tausta=new BitMap("MB.PCX");		// Ladataan tausta,
	tausta->Ruudulle(0,0);          // piirretn puskuriin
	delete(tausta);									// ja poistetaan muistista

	// Ladataan bittikartat spriteille
	mbnet[0]=new BitMap("MBNET1.PCX");
	mbnet[1]=new BitMap("MBNET2.PCX");
	mbnet[2]=new BitMap("MBNET3.PCX");
	mbnet[3]=new BitMap("MBNET4.PCX");
	mbnet[4]=new BitMap("MBNET5.PCX");
	mbnet[5]=new BitMap("MBNET6.PCX");
	mbnet[6]=new BitMap("MBNET7.PCX");
	star[0]=new BitMap("STAR.PCX");
	star[1]=new BitMap("STAR2.PCX");
	star[2]=new BitMap("STAR3.PCX");
	star[3]=new BitMap("STAR4.PCX");

	// Rakennetaan animaatioketjut
	for(n=0;n<7;n++) anim_mb.Rakenna(mbnet[n]);
	for(n=5;n>=0;n--) anim_mb.Rakenna(mbnet[n]);
	for(n=0;n<4;n++) anim_star.Rakenna(star[n]);

	x=star[0]->Leveys();
	y=star[0]->Korkeus();
	for(n=0;n<2;n++) {						// Ladataan spritet muistiin
		kuvat[n]=new Sprite(x,y);
		kuvat[n]->Link(&anim_star);	// ja linkataan animaatiot niihin
		kuvat[n]->Paikka(random()%(320-x),random()%(200-x));
		kuvat[n]->XYSuunta(random()%(3)-1,random()%(3)-1);
	}
	x=mbnet[0]->Leveys();
	y=mbnet[0]->Korkeus();
	for(n=2;n<SPRITENUM;n++) {
		kuvat[n]=new Sprite(x,y);
		kuvat[n]->Link(&anim_mb);
		kuvat[n]->Paikka(random()%(320-x),random()%(200-x));
		kuvat[n]->XYSuunta(random()%(3)-1,random()%(3)-1);
	}

	textmode(0x13); 			// Siirrytn grafiikkatilaan 13h eli 320x200x256
	Paletti("MB.PCX");		// Luetaan paletti
	Puskuri();						// Kopioidaan puskuri (eli tausta) nytlle
	ulos=0; viive=20;
	clock_t start=clock();
	while(!ulos) {				// Plooppi
		frames++;
		for(n=0;n<SPRITENUM;n++) {	// Jokaiselle spritelle:
			kuvat[n]->Ruudulle();			//  Piirretn puskuriin,
			kuvat[n]->Siirry();				//  siirretn liikkumasuuntien mukaan
			kuvat[n]->Animoi(frames);	//  ja pivitetn animaatio
		}
		Puskuri();							// Kopioidaan puskuri nytlle
		delay(viive);						// Odotetaan

		for(x=0;x<SPRITENUM;x++) {
			n=kuvat[x]->Laidassa();		// Kimmotetaan sprite seinmist
			if      (n&TOP || n&BOTTOM) kuvat[x]->XSuunta(random()%(3)-1);
			else if (n&LEFT || n&RIGHT) kuvat[x]->YSuunta(random()%(3)-1);
			if      (n&TOP)             kuvat[x]->YSuunta(1);
			else if (n&BOTTOM)          kuvat[x]->YSuunta(-1);
			if      (n&LEFT)            kuvat[x]->XSuunta(1);
			else if (n&RIGHT)           kuvat[x]->XSuunta(-1);

			// Tarkistetaan spritejen vliset trmykset
			for(y=x+1; y<SPRITENUM; y++)
				if (kuvat[x]->Osuma(kuvat[y])) {
					if (kuvat[x]->Tyyppi()==S_MBNET) kuvat[x]->anim=0;
					if (kuvat[y]->Tyyppi()==S_MBNET) kuvat[y]->anim=0;
					kuvat[x]->XYSuunta(random()%(5)-2, random()%(5)-2);
					kuvat[y]->XYSuunta(random()%(5)-2, random()%(5)-2);
				}
		}
		// Poistetaan spritet puskurista knteisess jrjestyksess
		for(n=SPRITENUM-1;n>=0;n--) kuvat[n]->Pyyhi();

		while (kbhit()) {		// Nppimisttarkistus
			switch(getch()) {
				case '-': viive++; break;
				case '+': if (viive) viive--; break;
				case 27: case 'q': case 'Q': case 'x': case 'X': ulos=1; break;
			}
		}
	}
	clock_t end=clock();
	for(n=0; n<SPRITENUM; n++) delete(kuvat[n]);	// Poistetaan spritet,
	for(n=0; n<7; n++) delete(mbnet[n]);        	//  bittikartat
	for(n=0; n<4; n++) delete(star[n]);
	delete(&anim_mb); delete(&anim_star);					//  animaatiot,
	free(puskuri);																//  ja puskuri
	textmode(3);                              	  // Siirrytn tekstitilaan
	printf("\nPivityksi: %li\nTickej: %li",frames,end-start);
	printf("\nRuudunpivityksi %.2f sekunnissa",
		(float)frames/(end-start)*CLK_TCK);			// Nytetn pivitysnopeus
	return(0);
}