/* sync.c
   Send a sync command to the control program.
*/

#define INCL_DOSFILEMGR
#define INCL_DOSNMPIPES
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "hfsapi.h"

static int parse_args(short argc, char *argv[]);

/* The name of the status pipe */
char status_pipe_name[] = "\\PIPE\\HFS_CONTROLPIPE";

/* The drive given on the command line */
unsigned short drive;

int main(int argc, char *argv[])
{
  APIRET rc;
  API_CMD_SYNC msg;
  API_RES res;
  ULONG bytes;

  if(parse_args(argc, argv)) {
    printf("\nsync writes any buffered data to the specified volume.\n");
    printf("Usage: sync [d:]\n");
    printf("where d: is the drive to sync. The default is A:\n");
    return 1;
  }

  /* Send a SYNC message to the control program */
  msg.id = API_SYNC;
  msg.drive = drive;

  rc = DosCallNPipe(status_pipe_name, &msg, sizeof(msg), &res, sizeof(res), &bytes, 10000L);
  if(rc!=NO_ERROR) {
    printf("sync: Error communicating with the control program.\n");
    return 1;
  }

  switch(res) {
  case API_RES_NO_ERROR:
    printf("The volume in drive %c: may now be removed safely.\n", drive+'A');
    return 0;
  case API_RES_NOT_HFS:
    printf("Drive %c: does not contain an HFS volume.\n", drive+'A');
    return 1;
  default:
    printf("Failed to sync the volume!\n");
    return 1;
  }
}

static int parse_args(short argc, char *argv[])
{
  int i, got_drive=0;
  for(i=1; i<argc; i++) {
    if(argv[i][0]=='/' || argv[i][0]=='-') {
      /* Switch */
      strupr(argv[i]);
      /* Check for switches here - none supported */
      fprintf(stderr, "Invalid option %s\n", argv[i]);
      return 1;
    }
    else if(strlen(argv[i])==2 && argv[i][1]==':') {
      /* Drive letter */
      if(got_drive) {
        fprintf(stderr, "Unexpected drive letter %s\n", argv[i]);
        return 1;
      }
      if(!isalpha(argv[i][0])) {
        fprintf(stderr, "Invalid drive letter %s\n", argv[i]);
        return 1;
      }
      drive = toupper(argv[i][0])-'A';
      got_drive = 1;   
    }
    else {
      /* Unrecognized argument */
      fprintf(stderr, "Invalid argument %s\n", argv[i]);
      return 1;
    }
  }

  /* Check that we got all necessary arguments */

  return 0;
}
