/* dirsearch.h
*/

#ifndef _DIRSEARCH_H
#define _DIRSEARCH_H

#define INCL_DOSFILEMGR
#define INCL_NOCOMMON
#define INCL_NOPMAPI
#include <os2.h>

#include "fsd.h"
#include "macfs/mountrec.h"

/* Undocumented info level - query all EAs */
#define FIL_QUERYALLEAS 4

/* Found file buffer, common part */
typedef struct FoundFileCommon {
  FDATE   fdateCreation;            /*  Date of file creation. */
  FTIME   ftimeCreation;            /*  Time of file creation. */
  FDATE   fdateLastAccess;          /*  Date of last access. */
  FTIME   ftimeLastAccess;          /*  Time of last access. */
  FDATE   fdateLastWrite;           /*  Date of last write. */
  FTIME   ftimeLastWrite;           /*  Time of last write. */
  ULONG   cbFile;                   /*  Size of file. */
  ULONG   cbFileAlloc;              /*  Allocation size. */
  USHORT  attrFile;                 /*  File attributes. */
  /* Note: attrFile is USHORT. It is the same as in FILEFINDBUF, the 16-bit
           found file struct. In FILEFINDBUF3 and 4 the attrFile
           field is an ULONG.
  */
} FOUNDFILECOMMON, *PFOUNDFILECOMMON;

unsigned short do_findnext(struct vpfsd *, struct fsfsd *, char *,
                           unsigned short, unsigned short *,
                           unsigned short, unsigned short);

unsigned short catrec_to_filebuf(char *, CATALOG_RECORD *, unsigned short);
unsigned short wildcard_match(char *, char *);
unsigned attrib_match(unsigned short, CATRECANDNAME *);
unsigned short put_eainfo(MOUNT_RECORD *, CATALOG_RECORD *, char *, 
			  unsigned, char *, unsigned short);

#endif /* _DIRSEARCH_H */
