/* attr.c
   File attributes
*/

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include "attr.h"
#include "MacFS/mountrec.h"
#include "MacFS/finder.h"

unsigned short set_file_attributes(CATALOG_RECORD *cr, unsigned short attr)
{
  if(cr->cdrType == CDR_FILE) {
    if(attr & FILE_DIRECTORY)
      return ERROR_ACCESS_DENIED;
    if(attr & FILE_HIDDEN)
      ((PFINFO)cr->U.cdrFilRec.filUsrWds)->Flags |= bswap16(F_INVISIBLE);
    else
      ((PFINFO)cr->U.cdrFilRec.filUsrWds)->Flags &= ~bswap16(F_INVISIBLE);
  }
  else if(cr->cdrType == CDR_DIR) {
    if(attr & FILE_DIRECTORY)
      return ERROR_ACCESS_DENIED;
    if(attr & FILE_HIDDEN)
      ((PDINFO)cr->U.cdrDirRec.dirUsrInfo)->Flags |= bswap16(F_INVISIBLE);
    else
      ((PDINFO)cr->U.cdrDirRec.dirUsrInfo)->Flags &= ~bswap16(F_INVISIBLE);
  }
  else
    return ERROR_ACCESS_DENIED;

  return NO_ERROR;
}

unsigned short get_file_attributes(CATALOG_RECORD *cr)
{
  unsigned short attr = FILE_NORMAL;

  switch(cr->cdrType) {
  case CDR_FILE:
    if(bswap16(((PFINFO)(cr->U.cdrFilRec.filUsrWds))->Flags) & F_INVISIBLE)
      attr |= FILE_HIDDEN;
    break;
  case CDR_DIR:
    attr |= FILE_DIRECTORY;
    if(bswap16(((PDINFO)(cr->U.cdrDirRec.dirUsrInfo))->Flags) & F_INVISIBLE)
      attr |= FILE_HIDDEN;
    break;
  }
  return attr;
}
