{****************************************************************************

                     Copyright (c) 1996 by Florian Klaempfl

 ****************************************************************************}
{ this unit manages the make and build process }
unit unitm;

  interface

    uses
       cobjects,objects,globals,symtable,systems;

    type
       punit = ^tunit;

       tunit = object
          { contains the global symtable of the unit     }
          { p=nil means that the unit must be recompiled }
          p : psymtable;
          name : pstring;
          next : punit;
          constructor init(const s : string;n : punit);
       end;

    var
       units : punit;

  implementation

{**************************************
               TUNIT
**************************************}

    constructor tunit.init(const s : string;n : punit);

      begin
         p:=nil;
         next:=n;
         name:=stringdup(s);
      end;

    procedure read_unit_(const s : string);

      var
         unitfile : file;
         dummy : boolean;
         unitfilesize : longint;
         b : byte;

      begin
         { unit isn't loaded }
         { try to load the unit }

         { search the directory of the input file }
         assign(unitfile,inputdir+s+'.PPU');
         reset(unitfile,1);
         if ioresult<>0 then
           begin
              { search the compiler path }
              assign(unitfile,exepath+s+'.PPU');
              reset(unitfile,1);
              if ioresult<>0 then
                begin
                   { searches unit path }
                   assign(unitfile,search(s+'.PPU',unitsearchpath,dummy)+s+'.PPU');
                   reset(unitfile,1);
                   if ioresult<>0 then
                     begin
                        units:=new(punit,init(s+'.PP',units));
                        exit;
                     end;
                end;
           end;
         unitfilesize:=filesize(unitfile);

         if unitfilesize>maxunitsize then
           fatalerror(error_reading_unit);

         { maybe write a message }
         if not(quiet) then
           writeln('Load '+s+'.PPU');
         getmem(buffer,unitfilesize);
         blockread(unitfile,buffer^,unitfilesize,bufferl);
         close(unitfile);

         { check the format }
         for b:=0 to 5 do
           if buffer^[b]<>byte(unitheader[b]) then
             fatalerror(malformed_unit);

         { check the target OS }
         if (rbuffer^[8])<>byte(target_info.target) then
           fatalerror(not_same_target);

         bufferp:=sizeof(unitheader);
         {
           there must be checked the cleanes of the unit
         }
         p:=new(punitsymtable,load(from));
         { read the checksum of the file }
         checksum:=plongint(@buffer^[10])^;
      end;

begin
   units:=nil;
end.
