{****************************************************************************

                   Copyright (c) 1993,96 by Florian Klmpfl

 ****************************************************************************}

unit scanner;

  interface

    uses
       cobjects,globals,symtable;

    const
       id_len = 14;

    type
       ident = string[id_len];

    const
{$ifdef L_C}
       anz_keywords = 32;

       keyword : array[1..anz_keywords] of ident = (
          'auto','break','case','char','const','continue','default','do',
          'double','else','enum','extern','float','for','goto','if',
          'int','long','register','return','short','signed','sizeof','static',
          'struct','switch','typedef','union','unsigned','void','volatile',
          'while');
{$else}
       anz_keywords = 83;

       keyword : array[1..anz_keywords] of ident = (
                 'ABSOLUTE','AND',
                 'ARRAY','AS','ASM','ASSEMBLER','BEGIN',
                 'BREAK','CASE','CLASS',
                 'CONST','CONSTRUCTOR','CONTINUE',
                 'DESTRUCTOR','DISPOSE','DIV','DO','DOWNTO','ELSE','END',
                 'EXCEPT',
                 'EXIT','EXPORT','EXPORTS','EXTERNAL','FAIL','FALSE','FAR',
                 'FINALLY','FOR',
                 'FORWARD','FUNCTION','GOTO','IF','IMPLEMENTATION','IN',
                 'INHERITED','INITIALIZATION',
                 'INLINE','INTERFACE','INTERRUPT','IS',
                 'LABEL','LIBRARY','MOD','NEAR','NEW','NIL','NOT','OBJECT',
                 'OF','ON','OPERATOR','OR','OTHERWISE','PACKED','PRIVATE',
                 'PROCEDURE','PROGRAM','PROPERTY','PROTECTED','PUBLIC',
                 'RAISE','RECORD','REPEAT','SELF',
                 'SET','SHL','SHR','STRING','THEN','TO',
                 'TRUE','TRY','TYPE','UNIT','UNTIL',
                 'USES','VAR','VIRTUAL','WHILE','WITH','XOR');

       keyword_token : array[1..anz_keywords] of ttoken = (
                 _ABSOLUTE,_AND,
                 _ARRAY,_AS,_ASM,_ASSEMBLER,_BEGIN,
                 _BREAK,_CASE,_CLASS,
                 _CONST,_CONSTRUCTOR,_CONTINUE,
                 _DESTRUCTOR,_DISPOSE,_DIV,_DO,_DOWNTO,
                 _ELSE,_END,_EXCEPT,
                 _EXIT,_EXPORT,_EXPORTS,_EXTERNAL,_FAIL,_FALSE,_FAR,
                 _FINALLY,_FOR,
                 _FORWARD,_FUNCTION,_GOTO,_IF,_IMPLEMENTATION,_IN,
                 _INHERITED,_INITIALIZATION,
                 _INLINE,_INTERFACE,_INTERRUPT,_IS,
                 _LABEL,_LIBRARY,_MOD,_NEAR,_NEW,_NIL,_NOT,_OBJECT,
                 _OF,_ON,_OPERATOR,_OR,_OTHERWISE,_PACKED,_PRIVATE,
                 _PROCEDURE,_PROGRAM,_PROPERTY,_PROTECTED,_PUBLIC,
                 _RAISE,_RECORD,_REPEAT,_SELF,
                 _SET,_SHL,_SHR,_STRING,_THEN,_TO,
                 _TRUE,_TRY,_TYPE,_UNIT,_UNTIL,
                 _USES,_VAR,_VIRTUAL,_WHILE,_WITH,_XOR);
{$endif}

    function yylex : ttoken;
    procedure initscanner(const source : string);
    procedure donescanner;

    { the asm parser use this function getting the input }
    function asmgetchar : char;

    { this procedure is called at the end of each line }
    { and the function does the statistics }
    procedure write_line;

    var
       pattern,orgpattern : string;
       yyin : file;
       { true, if type declarations are parsed }
       parse_types : boolean;

    { macros }

    const
{$ifdef TP}
       maxmacrolen = 1024;
{$else}
       maxmacrolen = 16*1024;
{$endif}

    type
       tmacrobuffer = array[0..maxmacrolen-1] of char;

    var
       macropos : longint;
       macrobuffer : ^tmacrobuffer;
       
  implementation

    const
       newline = #10;

    var
       inputbuffer : pinputbuffer;
       inputpointer : word;
       s_point : boolean;
       c : char;
       kommentarebene : word;

    procedure reload;

      var
         readsize : word;

      begin
         if inputstack=nil then
           internalerror(14);
         if inputstack^.filenotatend then
           begin
              { noch ein Teil laden }
              blockread(inputstack^.f,inputbuffer^,inputstack^.buffersize-1,readsize);
              inputbuffer^[readsize]:=#0;
              c:=inputbuffer^[0];
              inputpointer:=1;
              if eof(inputstack^.f) then
                begin
                   inputstack^.filenotatend:=false;
                   close(inputstack^.f);

                   { wenn auesserste Datei, dann EOF-Zeichen }
                   if inputstack^.next=nil then
                     inputbuffer^[readsize]:=#26;
                end;
           end
         else
           begin
              { Buffer loeschen }
              freemem(inputbuffer,inputstack^.buffersize);

              { inputstack *** nicht *** lschen da Treenodes }
              { Pointer darauf besitzen knnen                }
              inputstack:=inputstack^.next;
              inputbuffer:=inputstack^.inputbuffer;
              inputpointer:=inputstack^.inputpointer;
              if assigned(inputstack) then c:=inputbuffer^[inputpointer];
              inc(inputpointer);
           end;
      end;

    const
       lastmem : longint = 0;

    procedure write_line;

      var
         s : string;

      begin
         if not(quiet) then
           begin
              if (abslines=1) then
                case language of
                   'E' : writeln(memavail div 1024,' kB free');
                   'D' : writeln(memavail div 1024,' kB frei');
                end;
              if (abslines mod 100=0) then
                 begin
                    case language of
                       'E' : write(abslines,' lines','  ',memavail div 1024,' kB free');
                       'D' : write(abslines,' Zeilen','  ',memavail div 1024,' kB frei');
                    end;
{$ifdef tp}
                    if (use_big) then
                      case language of
                         'E' : write(', ',symbolstream.getsize div 1024,' kB EMS used');
                         'D' : write(', ',symbolstream.getsize div 1024,' kB EMS benutzt');
                      end;
{$endif}
                    writeln
                 end;
           end;
         {
         if lastmem<>0 then
           writeln('Benutzt ',lastmem-memavail,' Bytes');
         lastmem:=memavail;
         writeln(abslines,' ',inputstack^.filename^,'(',inputstack^.line_no,')');
         }
         inc(inputstack^.line_no);
         inc(abslines);
      end;

    procedure kommentar;forward;

    procedure skipspace;

      begin
         while (c=' ') or (c=#9) or (c=#13) or (c=#12) or (c=#10) do
           begin
              if c=#10 then write_line;
              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;if c='{' then kommentar;
           end;
      end;

    function is_keyword(var token : ttoken) : boolean;

      var
         m,n,k : integer;

      begin

         { lohnt sich meist, da viele Bezeichner nur ein Zeichen lang sind, }
         { aber alle Schlsselwrter lnger als ein Zeichen sind            }
         if length(pattern)<=1 then
           begin
              is_keyword:=false;
              exit;
           end;

         m:=1;
         n:=anz_keywords;
         while m<=n do
           begin
              k:=m+(n-m) div 2;
              if pattern=keyword[k] then
                begin
                   token:=keyword_token[k];
                   is_keyword:=true;
                   exit;
                end
              else if pattern>keyword[k] then m:=k+1 else n:=k-1;
          end;
        is_keyword:=false;
     end;

    type
       tpreproctoken = (_IFDEF,_IFNDEF,_ELSE,_ENDIF);

       ppreprocstack = ^tpreprocstack;

       tpreprocstack = object
          t : tpreproctoken;
          accept : boolean;
          next : ppreprocstack;
          constructor init(_t : tpreproctoken;a : boolean;n : ppreprocstack);
          destructor done;
       end;

    constructor tpreprocstack.init(_t : tpreproctoken;a : boolean;n : ppreprocstack);

      begin
         t:=_t;
         accept:=a;
         next:=n;
      end;

    destructor tpreprocstack.done;

      begin
      end;

    var
       preprocstack : ppreprocstack;
       { save value for pattern }
       hs2 : string;

    procedure handle_switches;

      function read_string : string;

        var
           hs : string;

        begin
           hs:='';
           while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                   or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                   or (c='_')
                   or ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
             begin
                hs:=hs+upcase(c);
                c:=inputbuffer^[inputpointer];if c=#0 then reload;inc(inputpointer);
             end;
           read_string:=hs;
        end;

      function read_number : longint;

        var
           hs : string;
           l : longint;
           w : word;

        begin
           read_number:=0;
           hs:='';
           while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
             begin
                hs:=hs+c;
                c:=inputbuffer^[inputpointer];if c=#0 then reload;inc(inputpointer);
             end;
           val(hs,l,w);
           read_number:=l;
        end;

      procedure skip_until_pragma;

        begin
           repeat
             while (c<>'{') and (kommentarebene>0) do
               begin
                  if c=#26 then fatalerror(endoffile);
                  if c=#10 then write_line;
                  if c='{' then inc(kommentarebene);
                  if c='}' then dec(kommentarebene);
                  c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
               end;
               c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
               if c='$' then
                 break;
               if c=#26 then fatalerror(endoffile);
               if c=#10 then write_line;
               if c='{' then inc(kommentarebene);
               if c='}' then dec(kommentarebene);
           until false;
           c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
        end;

      var
         hs : string;
         hp : pinputstack;
         mac : pmacrosym;
         startebene : word;
         i : longint;
         ht : ttoken;

      procedure popstack;

        var
           hp : ppreprocstack;

        begin
           hp:=preprocstack^.next;
           dispose(preprocstack,done);
           preprocstack:=hp;
        end;

      procedure write_c(c : char);

        begin
           if errortext then
             write(errorfile,c)
           else
             write(c);
        end;

      begin
         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
         hs:=read_string;
         if hs='I' then
           begin
              skipspace;
              hs:=c;
              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
              while (c<>' ') and (c<>'}') do
                begin
                   hs:=hs+c;
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
              { read until end of comment }
              while c<>'}' do
                begin
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                   if c=#10 then write_line;
                end;
              {
              dec(kommentarebene);
              }
              { Initialisieren: }
              inputstack^.inputpointer:=inputpointer;
              new(hp);
              assign(hp^.f,inputdir+hs);
              {$I-}
              reset(hp^.f,1);
              if ioresult<>0 then
                begin
                   if (hs='-') then
                     aktswitches:=aktswitches-[cs_iocheck]
                   else if (hs='+') then
                     aktswitches:=aktswitches+[cs_iocheck]
                   else
                     error(cannot_open_incfile);
                   dispose(hp);
                   { don't read next char
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   }
                end
              else
                begin
                   hp^.next:=inputstack;
                   inputstack:=hp;
                   sourcesize:=filesize(inputstack^.f)+4;
                   if sourcesize>maxinputlen then
                     sourcesize:=maxinputlen-1;
                   getmem(inputstack^.inputbuffer,sourcesize+1);
                   inputbuffer:=inputstack^.inputbuffer;
                   inputstack^.filenotatend:=true;
                   inputstack^.buffersize:=sourcesize;
                   inputstack^.filename:=stringdup(upper(hs));
                   inputstack^.line_no:=1;
                   reload;

                   { we have read the }
                   { comment end      }
                   dec(kommentarebene);
                end;
           end
         { never used:
         else if hs='E' then
           begin

               if c='-' then
                 aktswitches:=aktswitches-[cs_genexceptcode]
               else aktswitches:=aktswitches+[cs_genexceptcode];
           end
         }
         { conditional compiling ? }
         else if (hs='ELSE') or (hs='IFDEF') or (hs='IFNDEF') or
           (hs='ENDIF') then
           begin
              while true do
                begin
                   if hs='ENDIF' then
                     begin
                        { we can always accept an ELSE }
                        if assigned(preprocstack) then
                          begin
                             if preprocstack^.t=_ELSE then
                               popstack;
                          end
                        else
                          error(preprocerror);

                        { now pop the condition }
                        if assigned(preprocstack) then
                          begin
                             { we only use $ifdef in the stack }
                             if (preprocstack^.t=_IFDEF) then
                               popstack
                             else
                               error(too_much_endifs);
                          end
                       else
                          error(preprocerror);
                     end
                   else if hs='IFDEF' then
                     begin
                        skipspace;
                        hs:=read_string;
                        mac:=pmacrosym(macros^.search(hs));
                        preprocstack:=new(ppreprocstack,init(_IFDEF,
                          { the block before must be accepted }
                          { the symbole must be exist and be defined }
                          (
                           (preprocstack=nil) or
                            preprocstack^.accept
                          ) and
                           assigned(mac) and
                           mac^.defined,
                          preprocstack));
                     end
                   else if hs='IFNDEF' then
                     begin
                        skipspace;
                        hs:=read_string;
                        mac:=pmacrosym(macros^.search(hs));
                        preprocstack:=new(ppreprocstack,init(_IFDEF,
                          { the block before must be accepted }
                          (
                           (preprocstack=nil) or
                           preprocstack^.accept
                          ) and
                           not(assigned(mac) and
                           mac^.defined),
                          preprocstack));
                     end
                   else if hs='ELSE' then
                     begin
                        if assigned(preprocstack) then
                          preprocstack:=new(ppreprocstack,init(_ELSE,
                            { invert }
                            not(preprocstack^.accept) and
                            { but only true, if only the ifdef block is }
                            { not accepted                              }
                            (
                              (preprocstack^.next=nil) or
                              (preprocstack^.next^.accept)
                            ),
                            preprocstack))
                        else
                          error(preprocerror);
                     end;

                   { accept the text ? }
                   if (preprocstack=nil) or preprocstack^.accept then
                     break
                   else
                     begin
                        skip_until_pragma;
                        hs:=read_string;
                     end;
                end;
           end
         else if hs='MESSAGE' then
           begin
              skipspace;
              write_c(c);
              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
              while c<>'}' do
                begin
                   write_c(c);
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='WARNING' then
           begin
              skipspace;
              warning(user_defined);
              write_c(c);
              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
              while c<>'}' do
                begin
                   write_c(c);
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='ERROR' then
           begin
              skipspace;
              error(user_defined);
              write_c(c);
              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
              while (c<>'}') do
                begin
                   write_c(c);
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
{$ifdef DOS}
              write_c(#13);
{$endif}
              write_c(#10);
           end
         else if hs='L' then
           begin
              skipspace;
              hs:='';
              while (c<>' ') and (c<>'}') do
                begin
                   hs:=hs+c;
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   if c=#26 then fatalerror(endoffile);
                end;
              hs:=lowercasestring(hs);
              linkofiles.insert(hs);
           end
         else if hs='R' then
           begin
               if c='-' then
                 aktswitches:=aktswitches-[cs_rangechecking]
               else aktswitches:=aktswitches+[cs_rangechecking];
           end
         else if hs='DEFINE' then
           begin
              skipspace;
              hs:=read_string;
              mac:=pmacrosym(macros^.search(hs));
              if not assigned(mac) then
                begin
                   mac:=new(pmacrosym,init(hs));
                   mac^.defined:=true;
                   macros^.insert(mac);
                end
              else
                begin
                   mac^.defined:=true;

                   { delete old definition }
                   if assigned(mac^.buftext) then
                     begin
                        freemem(mac^.buftext,mac^.buflen);
                        mac^.buftext:=nil;
                     end;
                end;
              if support_macros then
                begin
                   { key words are never substituted }
                   hs2:=pattern;
                   pattern:=hs;
                   if is_keyword(ht) then
                     warning(keyword_cant_be_a_macro);
                   pattern:=hs2;

                   skipspace;
                   { !!!!!! handle macro params, need we this? }

                   { may be a macro? }
                   if c='=' then
                     begin
                        { first char }
                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                        macropos:=0;
                        while (c<>'}') do
                          begin
                             macrobuffer^[macropos]:=c;
                             if c=#10 then write_line;
                             c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                             if c=#26 then fatalerror(endoffile);

                             inc(macropos);
                             if macropos>maxmacrolen then
                               fatalerror(macro_buffer_overflow);
                          end;

                        { free buffer of macro ?}
                        if assigned(mac^.buftext) then
                          freemem(mac^.buftext,mac^.buflen);

                        { get new mem }
                        getmem(mac^.buftext,macropos);
                        mac^.buflen:=macropos;

                        { copy the text }
                        move(macrobuffer^,mac^.buftext^,macropos);
                     end;
                end;
           end
         else if hs='UNDEF' then
           begin
              skipspace;
              hs:=read_string;
              mac:=pmacrosym(macros^.search(hs));
              if not assigned(mac) then
                begin
                   mac:=new(pmacrosym,init(hs));
                   mac^.defined:=false;
                   macros^.insert(mac);
                end
              else
                begin
                   mac^.defined:=false;
                   { delete old definition }
                   if assigned(mac^.buftext) then
                     begin
                        freemem(mac^.buftext,mac^.buflen);
                        mac^.buftext:=nil;
                     end;
                end;
           end
         else if hs='PACKRECORDS' then
           begin
              skipspace;
              if upcase(c)='N' then
                begin
                   hs:=read_string;
                   if hs='NORMAL' then
                     aktpackrecords:=2
                   else warning(only_pack_records_);
                end
              else
                case read_number of
                   1 : aktpackrecords:=1;
                   2 : aktpackrecords:=2;
                   else warning(only_pack_records_);
                end;
           end
         else warning(ill_switch);
      end;

    procedure kommentar;

      begin
         inc(kommentarebene);
         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
         while true do
           begin
              { handle compiler switches }
              if (kommentarebene=1) and (c='$') then
                handle_switches;
              { handle_switches can dec kommentarebene, }
              { if there is an include file             }
              while (c<>'}') and (kommentarebene>0) do
                begin
                   if c='{' then
                     kommentar
                   else
                     begin
                        if c=#26 then fatalerror(endoffile);
                        if c=#10 then write_line;
                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                     end;
                end;
              { this is needed for the include files }
              { if there is a comment end read it }
              if c='}' then
                begin
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                   dec(kommentarebene);
                end;
              { checks }{ }
              if c='{' then
                begin
                   inc(kommentarebene);
                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                end
              else
                break;
           end;
      end;

   const
      yylexcount : longint = 0;

   function yylex : ttoken;

     var
        y : ttoken;
        code : word;
        l : longint;
        hs : string;
        mac : pmacrosym;
        hp : pinputstack;

     begin
        { was the last character a point ? }

        { this code is needed because the scanner if there is a 1. found if  }
        { this is a floating point number or range like 1..3                 }
        if s_point then
          begin
             s_point:=false;
             if c='.' then
               begin
                  c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                  yylex:=POINTPOINT;
                  exit;
               end;
             yylex:=POINT;
             exit;
          end;

        if c='{' then kommentar;
        while (c=' ') or (c=#9) or (c=#13) or (c=#12) or (c=#10) do
          begin
             if c=#10 then write_line;
             c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
             if c='{' then kommentar;
          end;
        case c of
           'A'..'Z','a'..'z','_' : begin
                         orgpattern:=c;
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                            or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                            or ((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                            or (c='_') do
                           begin
                              orgpattern:=orgpattern+c;
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                           pattern:=orgpattern;
                           uppervar(pattern);
                           if is_keyword(y) then
                             yylex:=y
			   else
                             begin
                                { this takes some time ... }
                                if support_macros then
                                  begin
                                     mac:=pmacrosym(macros^.search(pattern));
                                     if assigned(mac) then
                                       begin
                                          { don't forget the last char }
                                          dec(inputpointer);
                                          inputstack^.inputpointer:=inputpointer;
                                          new(hp);

                                          hp^.next:=inputstack;
                                          inputstack:=hp;
                                          sourcesize:=mac^.buflen;
                                          getmem(inputstack^.inputbuffer,sourcesize+1);

                                          inputbuffer:=inputstack^.inputbuffer;
                                          inputstack^.filenotatend:=false;
                                          inputstack^.buffersize:=sourcesize;
                                          inputstack^.filename:=stringdup('Macro '+pattern);
                                          inputstack^.line_no:=1;

                                          { copy text }
                                          move(mac^.buftext^,inputbuffer^,sourcesize);

                                          { put end sign }
                                          inputbuffer^[sourcesize]:=#0;

                                          { load c }
                                          c:=inputbuffer^[0];
                                          inputpointer:=1;

                                          { handle empty macros }
                                          if c=#0 then reload;

                                          { play it again ... }
                                          inc(yylexcount);
                                          if yylexcount>16 then
                                            warning(macro_deep_ten);
{$ifdef TP}
                                          yylex:=yylex;
{$else}
                                          { for you, FPKPascal ... }
                                          yylex:=yylex();
{$endif}
                                          { that's all folks }
                                          dec(yylexcount);
                                          exit;
                                       end;
                                  end;
                                yylex:=ID;
                             end;
                           exit;
                      end;
           '$'      : begin
                         pattern:=c;
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) or
                                (ord(upcase(c))>=ord('A')) and (ord(upcase(c))<=ord('F')) do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
{$ifdef FPK}
           '%'      : begin
                         pattern:=c;
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while (c='0') or (c='1') do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
{$endif}
           '0'..'9' : begin
                         pattern:=c;
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                           begin
                              pattern:=pattern+c;
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                           end;
                         if (c='.') or (upcase(c)='E') then
                           begin
                              if c='.' then
                                begin
                                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if not((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) then
                                     begin
                                        s_point:=true;
                                        yylex:=INTCONST;
                                        exit;
                                     end;
                                   pattern:=pattern+'.';
                                   while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                end;
                              if upcase(c)='E' then
                                begin
                                   pattern:=pattern+'E';
                                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if (c='-') or (c='+') then
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                   if not((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                                     then fatalerror(ill_character);
                                   while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) do
                                     begin
                                        pattern:=pattern+c;
                                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                     end;
                                end;
                              yylex:=REALNUMBER;
                              exit;
                           end;
                         yylex:=INTCONST;
                         exit;
                      end;
           ';'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=SEMICOLON;
                         exit;
                      end;
           '['      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=LECKKLAMMER;
                         exit;
                      end;
           ']'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=RECKKLAMMER;
                         exit;
                      end;
           '('      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=LKLAMMER;
                         exit;
                      end;
           ')'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=RKLAMMER;
                         exit;
                      end;
           '+'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_PLUSASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=PLUS;
                              exit;
                           end;
                      end;
           '-'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_MINUSASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=MINUS;
                              exit;
                           end;
                      end;
           ':'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='=' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=ASSIGNMENT;
                              exit;
                           end
                         else
                           begin
                              yylex:=COLON;
                              exit;
                           end;
                      end;
           '*'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_STARASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=STAR;
                              exit;
                           end;
                      end;
           '/'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if (c='=') and c_like_operators then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SLASHASN;
                              exit;
                           end
                         else
                           begin
                              yylex:=SLASH;
                              exit;
                           end;
                      end;
           '='      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=EQUAL;
                         exit;
                      end;
           '.'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='.' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=POINTPOINT;
                              exit;
                           end
                         else
                         yylex:=POINT;
                         exit;
                      end;
           '@'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=KLAMMERAFFE;
                         exit;
                      end;
           ','      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         yylex:=COMMA;
                         exit;
                      end;
           '''','#','^' :
                      begin
                         if c='^' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              c:=upcase(c);
                              if not(parse_types) and (c>='A') and (c<='Z') then
                                begin
                                   pattern:=chr(ord(c)-64);
                                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                end
                              else
                                begin
                                   yylex:=CARET;
                                   exit;
                                end;
                           end
                         else pattern:='';
                         while true do
                           case c of
                             '#' :
                                begin
                                   hs:='';
                                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if c='$' then
                                     begin
                                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        while ((ord(c)>=ord('0')) and (ord(c)<=ord('9'))) or
                                          (ord(upcase(c))>=ord('A')) and (ord(upcase(c))<=ord('F')) do
                                          begin
                                             hs:=hs+upcase(c);
                                             c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end
                                   else
                                   { FPKPascal supports binary constants }
                                   { %10101 evalutes to 37               }
{$ifdef FPK}
                                   if c='%' then
                                     begin
                                        c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                        while (c='0') or (c='1') do
                                          begin
                                             hs:=hs+upcase(c);
                                             c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end
                                   else
{$endif}
                                     begin
                                        while (ord(c)>=ord('0')) and (ord(c)<=ord('9')) do
                                          begin
                                             hs:=hs+c;
                                             c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          end;
                                     end;
                                   val(hs,l,code);
                                   if (code<>0) or (l<0) or (l>255) then
                                     fatalerror(ill_char_const);
                                    pattern:=pattern+chr(l);
                                 end;
                             '''' :
                                begin
                                   c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   if c=#13 then
                                     begin
                                        error(string_exceed_line);
                                        break;
                                     end;
                                   repeat
                                     if c=''''then
                                       begin
                                          c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          if c='''' then
                                            begin
                                               pattern:=pattern+'''';
                                               c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                               if c=#13 then
                                                 begin
                                                    error(string_exceed_line);
                                                    break;
                                                 end;
                                            end
                                          else break;
                                       end
                                     else
                                       begin
                                          pattern:=pattern+c;
                                          c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                          if c=#13 then
                                            begin
                                               error(string_exceed_line);
                                               break
                                            end;
                                       end;
                                   until false;
                                end;
                             '^' : begin
                                      c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                      c:=upcase(c);
                                      if (c>='A') or (c<='Z') then
                                        pattern:=pattern+chr(ord(c)-64)
                                      else fatalerror(ill_character);
                                      c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                                   end;
                             else break;
                           end;
                         { aus einem Zeichen bestehende  }
                         { Strings werden als Char-Kons- }
                         { tanten behandelt              }
                         if length(pattern)=1 then
                           yylex:=CCHAR
                           else yylex:=CSTRING;
                         exit;
                      end;
           '>'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='=' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=GTE;
                              exit;
                           end
                         else if c='>' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SHR;
                              exit;
                           end
                         else
                           begin
                              yylex:=GT;
                              exit;
                           end;
                      end;
           '<'      : begin
                         c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                         if c='>' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=UNEQUAL;
                              exit;
                           end
                         else if c='=' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=LTE;
                              exit;
                           end
                         else if c='<' then
                           begin
                              c:=inputbuffer^[inputpointer];inc(inputpointer);if c=#0 then reload;
                              yylex:=_SHL;
                              exit;
                           end
                         else
                           begin
                              yylex:=LT;
                              exit;
                           end;
                      end;
           #26      : begin
                         yylex:=_EOF;
                         exit;
                      end;
           else
             begin
                exterror:=strpnew(c);
                fatalerror(ill_character);
             end;
        end;
     end;

    function asmgetchar : char;

      begin
         c:=inputbuffer^[inputpointer];
         inc(inputpointer);if c=#0 then reload;
         if c='{' then kommentar;
         asmgetchar:=c;
      end;

   procedure initscanner(const source : string);

     begin
        new(inputstack);
        inputstack^.line_no:=1;
	inputstack^.filename:=stringdup('');
        assign(inputstack^.f,source);
        {$I-}
        reset(inputstack^.f,1);
        if ioresult<>0 then
          fatalerror(cannot_open_input);

        sourcesize:=filesize(inputstack^.f);
        inputstack^.next:=nil;
        if sourcesize>maxinputlen then
          sourcesize:=maxinputlen-1;
        getmem(inputstack^.inputbuffer,sourcesize+1);
        inputbuffer:=inputstack^.inputbuffer;
        inputstack^.filenotatend:=true;
        inputstack^.buffersize:=sourcesize+1;
        inputstack^.filename:=stringdup(source);
        preprocstack:=nil;
        macrobuffer:=nil;
        reload;
        kommentarebene:=0;
        s_point:=false;
     end;

   procedure donescanner;

     begin
        freemem(inputbuffer,sourcesize+1);
        if assigned(preprocstack) then
          error(endif_expect);
     end;

end.
