/* tl1.c (emx+gcc) */

/* Test _tl_lock() and _tl_unlock().  These functions are for internal
   use by the library, only. */

#include <sys/emx.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <io.h>

_TL_DEFINE_SEM (sem1)

static void thread (void *t)
{
  char c;

  c = *(char *)t;
  for (;;)
    {
      _tl_lock (sem1);
      write (1, &c, 1);
      sleep (1);
      write (1, &c, 1);
      _tl_unlock (sem1);
    }
}


int main (int argc, char *argv[])
{
  int rc, i;

  for (i = 0; i < 4; ++i)
    {
      char *tmp = alloca (1);
      *tmp = (char)('a' + i);
      rc = _beginthread (thread, NULL, 0x10000, tmp);
      if (rc == -1)
        {
          perror ("_beginthread");
          exit (2);
        }
    }
  sleep (60*60);
  return 0;
}
