/* exec.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <signal.h>
#include <sys/wait.h>
#include <os2.h>

static int wp;
static int gpid;

static void do_wait (void)
{
  int p, t;

  if (wp)
    p = waitpid (gpid, &t, 0);
  else
    p = wait (&t);
  if (p == -1)
    perror ("wait");
  else
    {
      if (WIFEXITED (t))
        fprintf (stderr, "Process %d terminated normally, rc=%d\n",
                 p, WEXITSTATUS (t));
      else if (WIFSTOPPED (t))
        fprintf (stderr, "Process %d stopped by signal %d\n",
                 p, WSTOPSIG (t));
      else
        fprintf (stderr, "Process %d terminated by signal %d\n",
                 p, WTERMSIG (t));
    }
}


static void handler (int sig)
{
  if (sig == SIGCHLD)
    {
      fprintf (stderr, "SIGCHLD: "); fflush (stderr);
      do_wait ();
      fflush (stderr);
      signal (SIGCHLD, SIG_ACK);
    }
  else
    {
      printf ("Signal %d received. Process stopped.\n", sig);
      exit (1);
    }
}


int main (int argc, char *argv[])
{
  char buf[4096], *p, *q, *r;
  char *nenvp[1];
  char *nargv[256];
  char args[8192];
  int i, j, mode, ask, eenv, quote, tilde;
  
  signal (SIGINT, handler);
  signal (SIGCHLD, handler);
  if (argc >= 2)
    {
      i = spawnvp (mode, argv[1], &argv[1]);
      if (i < 0)
        perror ("spawnve");
      else
        printf ("rc=%d\n", i);
      return (0);
    }
  ask = 0; wp = 0; eenv = 0; quote = 0; tilde = 0;
  for (;;)
    {
      printf ("pid=%d\n", (int)getpid ());
      printf ("command: ");
      fflush (stdout);
      if (fgets (buf, sizeof (buf), stdin) == NULL)
        {
          if (ferror (stdin))
            {
              perror ("fgets");
              return (1);
            }
          printf ("done\n");
          return (0);
        }
      p = strchr (buf, '\n');
      if (p != NULL) *p = 0;
      p = buf;
      if (*p == '?')
        {
          puts ("?      display help");
          puts ("v=n    set environment variable V to value N");
          puts ("!s p   send signal s to process p");
          puts ("~c     run C asynchronously");
          puts ("*c     run C as overlay");
          puts ("#c     run C for debugging");
          puts ("&c     run C detached");
          puts ("%c     start session running C");
          puts ("       Flags after %:");
          puts ("         + maximized");
          puts ("         - minimized");
          puts ("         % full-screen");
          puts ("         ! don't close window automatically");
          puts ("         $ background");
          puts ("^h      Set number of file handles (relatively if signed)");
          puts ("+x      Set flag");
          puts ("-x      Clear flag");
          puts ("        Flags:");
          puts ("        e  pass empty environment");
          puts ("        q  quote arguments (P_QUOTE)");
          puts ("        t  use tilde in 3rd arg string (P_TILDE)");
          puts ("        w  use waitpid()");
        }
      else if (strchr (p, '=') != NULL)
        {
          if (putenv (strdup (p)) != 0)
            perror ("putenv");
        }
      else if (sscanf (p, "!%d %d", &i, &j) == 2)
        {
          if (kill (j, i) < 0)
            perror ("kill");
        }
      else if (sscanf (p, "^%d", &i) == 1)
        {
          if (_osmode == OS2_MODE)
            {
              LONG req_count;
              ULONG handle_count;

              if (p[1] == '+' || p[1] == '-')
                req_count = i;
              else
                {
                  if (DosSetMaxFH (i) != 0)
                    fprintf (stderr, "DosSetMaxFH failed\n");
                  req_count = 0;
                }
              if (DosSetRelMaxFH (&req_count, &handle_count) != 0)
                fprintf (stderr, "DosSetRelMaxFH failed\n");
              printf ("Number of handles: %lu\n", handle_count);
            }
        }
      else if (p[0] == '+' || p[0] == '-')
        switch (p[1])
          {
          case 'a': ask = (p[0] == '+'); break;
          case 'e': eenv = (p[0] == '+'); break;
          case 'q': quote = (p[0] == '+'); break;
          case 't': tilde = (p[0] == '+'); break;
          case 'w': wp = (p[0] == '+'); break;
          default:
            printf ("Unknown flag\n");
          }
      else
        {
          if (*p == '*')
            {
              mode = P_OVERLAY; ++p;
            }
          else if (*p == '#')
            {
              mode = P_DEBUG; ++p;
            }
          else if (*p == '~')
            {
              mode = P_NOWAIT; ++p;
            }
          else if (*p == '&')
            {
              mode = P_DETACH; ++p;
            }
          else if (*p == '%')
            {
              mode = P_SESSION;
              ++p;
              if (*p == '-')
                {
                  mode |= P_MINIMIZE; ++p;
                }
              else if (*p == '+')
                {
                  mode |= P_MAXIMIZE; ++p;
                }
              else if (*p == '%')
                {
                  mode |= P_FULLSCREEN; ++p;
                }
              else
                mode |= P_WINDOWED;
              if (*p == '!')
                {
                  mode |= P_NOCLOSE; ++p;
                }
              if (*p == '$')
                {
                  mode |= P_BACKGROUND; ++p;
                }
            }
          else
            mode = P_WAIT;
          if (*p == 0)
            {
              printf ("done\n");
              return (0);
            }
          i = 0;
          q = p;
          while ((nargv[i++] = strtok (q, " \t")) != NULL)
            q = NULL;
          if (ask)
            {
              printf ("Enter arguments, one per line (. to end):\n");
              q = args; --i;
              for (;;)
                {
                  r = fgets (q, sizeof (args) - (q - args), stdin);
                  if (r == NULL)
                    return (0);
                  r = strchr (q, '\n');
                  if (r != NULL)
                    *r = 0;
                  else
                    r = strchr (q, 0);
                  if (strcmp (q, ".") == 0)
                    break;
                  nargv[i++] = q;
                  q = r + 1;
                }
              nargv[i] = NULL;
            }
          nenvp[0] = NULL;
          if (quote)
            mode |= P_QUOTE;
          if (tilde)
            mode |= P_TILDE;
          gpid = spawnvpe (mode, p, nargv, (eenv ? nenvp : environ));
          if (gpid < 0)
            {
              j = _syserrno ();
              perror ("spawnve");
              printf ("syserrno=%d\n", j);
            }
          else
            printf ("rc=%d\n", gpid);
        }
    }
  return (1);
}
