{PC Infrared Control Program. Author: Panu-Kristian Poiksalo TTKK 1999}

Uses Crt,Dos,Graph;

Const PrinterOutPort=$378;         {Usually Port 378H is LPT1}
      PrinterInPort=PrinterOutPort+1;
      BufferSize=60000;
      InitialDelayConstant=10;
Var
   IrWave:              Array [0..BufferSize] of byte;
   WavePoint:           Word;
   Ch:                  Char;
   a,b,x,DelayConstant: Word;
   i,j:                 Integer;
   f:                   file;

Function FileExists (S:String) : Boolean ;
var filesearch:searchrec;
Begin
     DosError:=0;
     FindFirst (s,anyfile,filesearch);
     If DosError = 0 then FileExists := True else FileExists := False;
end;

Procedure TDelay (t:word); Begin
     for a:=0 to t do b:=a;
End;

Procedure RecordSignal; Begin
     for x:=2 to BufferSize do begin
         IrWave[x]:=Port[PrinterInPort];
         TDelay (DelayConstant);
     end;
     for x:=2 to BufferSize do begin
         if (IrWave[x] and 16) <> 0 then IrWave[x]:=9 else IrWave[x]:=0;
     end;
End;

Procedure PlaySignal; Begin
     for x:=2 to BufferSize do begin
         Port[PrinterOutPort]:=IrWave[x];
         TDelay (DelayConstant);
     end;
End;

Procedure LoadSignal (filename:string);
begin
     if FileExists (filename)
     then begin
               assign (f,filename);
               reset (f,1);
               blockread (f,IrWave,Buffersize);
               DelayConstant:=IrWave[0]+256*irwave[1];
               close (f);
     end;
end;


Begin

     for x:=0 to BufferSize do IrWave[x]:=0;
           Writeln;
           Writeln ('Tallennettujen IR-signaalitiedostojen (IRDATAx.IRD) lhetysohjelma');
           Writeln ('Nppimet 0..9, A..Z : Signaalin lhettminen. [Esc] Lopettaa.');

     repeat
           ch:=UpCase (Readkey);


           if ((ch in ['0'..'9']) or (ch in ['A'..'Z']))
           then begin
                LoadSignal ('irdata'+ch+'.ird');
                PlaySignal;
           end;
     until ord(ch)=27;
End.

