{PC Infrared Control Program. Author: Panu-Kristian Poiksalo TTKK 1999}

Uses Crt,Dos,Graph;

Const PrinterOutPort=$378;         {Usually Port 378H is LPT1}
      PrinterInPort=PrinterOutPort+1;
      BufferSize=60000;
      InitialDelayConstant=10;
Var
   IrWave:              Array [0..BufferSize] of byte;
   WavePoint:           Word;
   Ch:                  Char;
   a,b,x,DelayConstant: Word;
   i,j:                 Integer;
   f:                   file;

Procedure WaitForSignal; Begin
     Port[PrinterOutPort]:=4;
     Repeat until ((port[PrinterInPort] and 16)<>0) or keypressed;
End;

Procedure C (fg,bg:byte);
begin
     TextColor (fg);
     TextBackground (bg);
end;

Function FileExists (S:String) : Boolean ;
var filesearch:searchrec;
Begin
     DosError:=0;
     FindFirst (s,anyfile,filesearch);
     If DosError = 0 then FileExists := True else FileExists := False;
end;

Procedure TDelay (t:word); Begin
     for a:=0 to t do b:=a;
End;

Procedure RecordSignal; Begin
     for x:=2 to BufferSize do begin
         IrWave[x]:=Port[PrinterInPort];
         TDelay (DelayConstant);
     end;
     for x:=2 to BufferSize do begin
         if (IrWave[x] and 16) <> 0 then IrWave[x]:=9 else IrWave[x]:=0;
     end;
End;

Procedure PlaySignal; Begin
     for x:=2 to BufferSize do begin
         Port[PrinterOutPort]:=IrWave[x];
         TDelay (DelayConstant);
     end;
End;

Procedure SaveSignalProc; Begin
     gotoxy (1,24);

     c(14,0);
     Write ('Tallennus: Muistipaikka (Kirjain tai numero)? ');
     ch:=upcase (readkey);
     if ((ch in ['0'..'9']) or (ch in ['A'..'Z']))
     then begin
               Write (ch);
               assign (f,'irdata'+ch+'.ird');
               rewrite (f,1);
               IrWave[0]:=lo(DelayConstant);
               IrWave[1]:=hi(DelayConstant);
               blockwrite (f,IrWave,Buffersize);
               close (f);
               Write (' OK.');

     end
     else begin
               write ('(Kumottu)');
     end;

     delay (4000);
     gotoxy (1,24);
     c(7,0); for i:=1 to 59 do write (' ');

end;

Procedure LoadSignalProc; Begin
     gotoxy (1,24);

     c(14,0);
     Write ('Lataus: Muistipaikka (Kirjain tai numero)? ');
     ch:=upcase (readkey);

     if FileExists ('irdata'+ch+'.ird') then begin


        if ((ch in ['0'..'9']) or (ch in ['A'..'Z']))
        then begin
               Write (ch);
               assign (f,'irdata'+ch+'.ird');
               reset (f,1);
               blockread (f,IrWave,Buffersize);
               DelayConstant:=IrWave[0]+256*irwave[1];
               close (f);
               Write (' OK.');

        end
        else begin
                  write ('(Kumottu)');
        end;
     end
     else begin
               write ('Ei lydy.');
     end;

     delay (4000);
     gotoxy (1,24);
     c(7,0); for i:=1 to 59 do write (' ');

end;


Begin
     for x:=0 to BufferSize do IrWave[x]:=0;
     DelayConstant:=InitialDelayConstant;
     i:=Vga; j:=VgaHi; InitGraph (i,j,''); DirectVideo:=False; GotoXy (1,20);
     Writeln ('Lhet kaukostimell signaalia kortin IR-diodille.');
     Writeln ('[P]: Signaalin lhetys kortilta ulos, [S] Talletus, [L] Lataus');
     Writeln ('[+/-]: luentaviiveen asetus, [Esc]: ohjelman lopetus.');
     Repeat
           GotoXy (60,24);Write ('Viive: ',DelayConstant,'  ');
           Ch:='r';WaitforSignal;
           If Keypressed then Ch:=UpCase (Readkey);
           if ch='+' then inc(DelayConstant);
           if ch='-' then dec(DelayConstant);
           if ch='P' then PlaySignal;
           if ch='r' then begin RecordSignal;
              for x:=2 to BufferSize do
                  putpixel (x mod 600, (x div 600)*3, IrWave[x]+1)
           end;
           if ch='S' then SaveSignalProc;

           if ch='L' then begin
              LoadSignalProc;
              for x:=2 to BufferSize do
                  putpixel (x mod 600, (x div 600)*3, IrWave[x]+1)
           end;


     until ch=chr(27);CloseGraph;
End.

