package jere.applets.onthisday;

import java.util.*;

/**
 * A helper class to sort events.
 * 
 * @author Jere Kpyaho (jere@sci.fi)
 */
public class EventSorter {
    /**
     * Sorts a vector of events by their compareTo() method.
     *
     * @param events The vector of events to sort
     */
    public static void sort(Vector events) {
        events.trimToSize();

        Object[] elements = new Object[events.size()];
        events.copyInto(elements);

        Object temp;

        for (int pass = 1; pass < elements.length; pass++) {
            for (int i = 0; i < elements.length - 1; i++) {
                Sortable s1 = (Sortable) elements[i];
                Sortable s2 = (Sortable) elements[i + 1];
                if (s1.compareTo(s2) > 0) {
                    temp = s1;
                    elements[i] = elements[i + 1];
                    elements[i + 1] = temp;
                }
            }
        }

        events.removeAllElements();

        // Add the elements of the sorted array back to the vector.
        for (int i = 0; i < elements.length; i++) {
            events.addElement(elements[i]);
        }
    }

}


