import java.applet.*;
import java.awt.*;

public class LEDButton extends Applet {
    LEDCanvas theLED;
    Button toggleButton;
    Choice colorSelector;

    public void init() {
        theLED = new LEDCanvas(LEDColor.REDLED);
        theLED.turnOn();

        toggleButton = new Button("PAINA!");

        colorSelector = new Choice();
        colorSelector.addItem("Punainen");
        colorSelector.addItem("Keltainen");
        colorSelector.addItem("Vihre");
        colorSelector.addItem("Sininen");

        setLayout(new BorderLayout());
        add("North", colorSelector);
        add("West", theLED);
        add("East", toggleButton);
    }

    public boolean action(Event e, Object arg) {
        Object target = e.target;
        if (target == toggleButton) {
            theLED.toggle();
            return true;
        }
        if (target instanceof Choice) {
            int selection = ((Choice)target).getSelectedIndex();
            theLED.setColor(selection);
            return true;
        }
        return false;
    }
}

