#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <string.h>
#include "zlib.h"

typedef unsigned char byte;

const int BUFFER_SIZE = 1024;
byte inputBuffer[BUFFER_SIZE];
byte outputBuffer[BUFFER_SIZE];

int decompressFile(ifstream& in, ofstream& out);
int fillInput(z_stream& z, ifstream& in);
int flushOutput(z_stream& z, ofstream& out);

int main(int argc, char *argv[])
{
    if (argc != 2)
    {
        cerr << "usage: decomp filename" << endl;
        return -1;
    }
    char inputFilename[260],
         outputFilename[260];
    strcpy(inputFilename, argv[1]);
    strcpy(outputFilename, argv[1]);

    ofstream outputFile;
    strcat(inputFilename, ".zlib");
    ifstream inputFile(inputFilename, ios::in | ios::binary);
    if (!inputFile) return -1;
    outputFile.open(outputFilename, ios::out | ios::binary);
    if (!outputFile) return -1;

    int status = decompressFile(inputFile, outputFile);
    inputFile.close();
    outputFile.close();
    return status;
}

int decompressFile(ifstream& in, ofstream& out)
{
    int status = Z_OK;
    z_stream z;

    z.zalloc = Z_NULL;  // use the default allocation functions
    z.zfree = Z_NULL;
    z.opaque = 0;

    status = inflateInit(&z);
    if (status != Z_OK)
        return status;

    z.avail_in = 0;
    z.avail_out = BUFFER_SIZE;
    z.next_out = outputBuffer;

    while (1)
    {
        if (!fillInput(z, in))
            break;
        status = inflate(&z, Z_NO_FLUSH);
        flushOutput(z, out);
        if (status != Z_OK)
            break;
    }

    while (1)
    {
        status = inflate(&z, Z_FINISH);
        if (!flushOutput(z, out))
            break;
        if (status != Z_OK)
            break;
    }
    status = inflateEnd(&z);
    return status; // Z_OK if all went well
}

int fillInput(z_stream& z, ifstream& in)
{
    if (z.avail_in == 0)
    {
        z.next_in = inputBuffer;
        in.read(inputBuffer, BUFFER_SIZE);
        z.avail_in = in.gcount();
    }
    return z.avail_in;
}

int flushOutput(z_stream& z, ofstream& out)
{
    int count = BUFFER_SIZE - z.avail_out;
    if (count)
    {
        out.write(outputBuffer, count);
        z.next_out = outputBuffer;
        z.avail_out = BUFFER_SIZE;
    }
    return count;
}
