/* SORTDEM2.C -- a graphic demonstration of popular sorting methods */
/* Runs in MCGA mode (320 by 200 pixels, 256 colors) */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>
#include <conio.h>

#define VIDEO_INTR 0x10
#define SCREEN_WIDTH 320
#define SCREEN_HEIGHT 200
#define ARRAY_SIZE SCREEN_WIDTH
#define VALUE_MAX  SCREEN_HEIGHT
#define PLOT_COLOR 10
#define BACK_COLOR 0

typedef unsigned short ushort;

typedef struct tagSortMethod
{
    char name[30];
    void (*func)( short *, const short );
}
SortMethod;

void BubbleSort( short *array, const short size );
void InsertionSort( short *array, const short size );
void Quicksort( short array[], const short size );

void InitValues( void );
void PlotValues( void );
void SetPixel( short x, short y, char color );

short Values[ARRAY_SIZE];
unsigned long plotcount;

SortMethod sorts[] =
{
    { "Bubble sort", BubbleSort },
    { "Insertion sort", InsertionSort },
    { "Quicksort", Quicksort }
};

void InitValues( void )
{
    short i;

    for ( i = 0;  i < ARRAY_SIZE;  i++ )
        Values[i] = (short)(rand() % VALUE_MAX);
}

void PlotValues( void )
{
    short i;

    for ( i = 0;  i < ARRAY_SIZE;  i++ )
        SetPixel( i, Values[i], PLOT_COLOR );
}

void SetPixel( short x, short y, char color )
{
    union REGS regs;

    regs.h.ah = 0x0C;
    regs.h.al = color;
    regs.h.bh = 0;      /* page 0 */
    regs.x.cx = x;
    regs.x.dx = y;
    int86( VIDEO_INTR, &regs, &regs );

    plotcount++;
}

void swap( short index1, short *item1, short index2, short *item2 )
{
    short temp;

    SetPixel( index1, *item1, BACK_COLOR );
    SetPixel( index2, *item2, BACK_COLOR );

    temp = *item1;
    *item1 = *item2;
    *item2 = temp;

    SetPixel( index1, *item1, PLOT_COLOR );
    SetPixel( index2, *item2, PLOT_COLOR );
}

/************ B U B B L E   S O R T ***********/
void BubbleSort( short *array, const short size )
{
    void swap( short, short *, short, short * );
    short i, j;

    for ( i = 1;  i < size;  i++ )
        for ( j = size-1;  j >= i;  j-- )
        {
            if ( array[j-1] > array[j] )
                swap( j, &array[j], j-1, &array[j-1] );
        }
}

/*************  I N S E R T I O N    S O R T *************/
void InsertionSort( short *array, const short size )
{
    short i, j, k;

    for ( j = 1;  j < size;  j++ )
    {
        k = array[j];
        SetPixel( j, array[j], BACK_COLOR );
        
        i = j - 1;
        while ( i >= 0 && array[i] > k )
        {
            array[i+1] = array[i];
            SetPixel( i, array[i], BACK_COLOR );
            SetPixel( i+1, array[i+1], PLOT_COLOR );
            i--;
        }
        array[i+1] = k;
        SetPixel( i+1, array[i+1], PLOT_COLOR );
    }
}

short Partition( short array[], short left, short right )
{
    short i, j, x;

    x = array[left];
    i = left - 1;
    j = right + 1;

    while ( 1 )
    {
        do j--; while ( array[j] > x );
        do i++; while ( array[i] < x );
        if ( i < j )
            swap( i, &array[i], j, &array[j] );
        else
            return j;
    }            
}

/************ Q U I C K S O R T ***********/
void DoQuicksort( short array[], const short left, const short right )
{
    short Partition( short [], short, short );

    if ( left < right )
    {
        short gap = Partition( &array[0], left, right );
        DoQuicksort( &array[0], left, gap );
        DoQuicksort( &array[0], gap+1, right );
    }
}

void Quicksort( short array[], const short size )
{
    DoQuicksort( &array[0], 0, size-1 ); 
}

int main( int argc, char *argv[] )
{
    union REGS regs;
    short sortnum, numsorts;

    srand( time( NULL ) );
    numsorts = sizeof(sorts) / sizeof(sorts[0]);

    if ( argc >= 2 )
        sortnum = argv[1][0] - '0';
    else
    {
        short i;

        printf( "Anna lajittelumenetelmn numero:\n" );
        for ( i = 0;  i < numsorts;  i++ )
            printf( "%d = %s\n", i, sorts[i].name );
        return -1;
    }

    if ( sortnum < 0 || sortnum > numsorts-1 )
    {
       printf( "Virheellinen lajittelumenetelmn numero\n" );
       return -1;
    }

    /* Set VGA mode (320 x 200 x 256) */
    regs.h.ah = 0x00;
    regs.h.al = 0x13;
    int86( VIDEO_INTR, &regs, &regs );

    InitValues();
    PlotValues();
    plotcount = 0;
    sorts[sortnum].func( Values, ARRAY_SIZE );
    getch();

    /* Set 80x25 text mode */
    regs.h.ah = 0x00;
    regs.h.al = 0x03;
    int86( VIDEO_INTR, &regs, &regs );

    printf( "%s\n", sorts[sortnum].name );
    printf( "Vaihtoja: %lu\n", plotcount / 4 );

    return 0;
}
