/*
  ODScrolledBox - a box with scroll bars

  The class is a GtkScrolledWindow modified with a few hacks:
  - Child should be a VBox.
  - No border around the viewport.
  - No spacing between the box and the scroll bar.
  - Requests a height that would fit the first n children of the box.
    Emil wanted to know how to do this. This widget is how. =)

  My original intentions were that it should have an interface to the GtkVBox
  and that it should do discrete scrolling.
  I have not found a clean method to do discrete scrolling and the box interface
  could be harmful.
  Perhaps I could write a completelly new kind of box that just gtk_widget_show()
  and gtk_widget_hide() the children at the top and bottom.

  This dirty hack was written by Johan Hanson <johan@tiq.com>.
  Pass bug reports and patches concerning this module to him.
*/

#ifndef __OD_SCROLLED_BOX_H__
#define __OD_SCROLLED_BOX_H__

#include <gtk/gtkscrolledwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Defines */
#define OD_TYPE_SCROLLED_BOX		(od_scrolled_box_get_type ())
#define OD_SCROLLED_BOX(obj)		(GTK_CHECK_CAST ((obj), OD_TYPE_SCROLLED_BOX, ODScrolledBox))
#define OD_SCROLLED_BOX_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), OD_TYPE_SCROLLED_BOX, ODScrolledBoxClass))
#define OD_IS_SCROLLED_BOX(obj)		(GTK_CHECK_TYPE ((obj), OD_TYPE_SCROLLED_BOX))
#define OD_IS_SCROLLED_BOX_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), OD_TYPE_SCROLLED_BOX))


/* Types */
typedef struct _ODScrolledBox		ODScrolledBox;
typedef struct _ODScrolledBoxClass	ODScrolledBoxClass;

struct _ODScrolledBox {
	GtkScrolledWindow parent;
	guint num;
};

struct _ODScrolledBoxClass {
	GtkScrolledWindowClass parent_class;
};


/* Functions */
GtkType		od_scrolled_box_get_type	(void);
GtkWidget *	od_scrolled_box_new		(void);

/* set number of widgets that should be visible at all times => height of box */
void		od_scrolled_box_set_num		(ODScrolledBox	*box,
						 guint		numwidgets);

/* wrappers around GtkBox.. but I am not using them anyway
void		od_scrolled_box_pack_start	(ODScrolledBox	*box,
						 GtkWidget	*widget);
void		od_scrolled_box_pack_end	(ODScrolledBox	*box,
						 GtkWidget	*widget);
void		od_scrolled_box_reorder_child	(ODScrolledBox	*box,
						 GtkWidget	*widget,
						 gint		position);
*/


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __OD_SCROLLED_BOX_H__ */

