/*
** 1999-01-27 -	Wrapper around the mntent API functions. These are used to parse system
**		databases holding information about filesystems that can be mounted, and
**		that are mounted. Needs to be wrapped since it seems to differ wildly
**		between various OSs (e.g. between Linux and Solaris).
*/

#include <stdio.h>

/* Contains (at least) one (device,mountpoint) pair. Opaque, use accessor functions
** declared below to manipulate.
*/
typedef struct _MntEnt	MntEnt;


/* Open database file. */
FILE *		mne_setmntent(const char *filename, const char *type);

/* Get next mount entry from file. Returns NULL if there are no more entries available.
** The entry returned is strictly read-only, and lives in static memory, so it will change
** with the next (successful) call. To keep it, use mne_copy() to create a copy of it.
*/
MntEnt *	mne_getmntent(FILE *filep);

/* Call this when you're done scanning the database, to close it down properly. */
gint		mne_endmntent(FILE *filep);

/* Create a copy of <src>, in dynamically allocated memory. Returns a pointer to
** the copy, or NULL on failure. The copy shares no memory with the original.
*/
MntEnt *	mne_copy(MntEnt *src);

/* Destroy a MntEnt, freeing all memory used by it. Only valid on entries created
** by mne_copy().
*/
void		mne_destroy(MntEnt *me);

/* Return a pointer to a string containing the mountpoint path for the given entry (e.g. "/cdrom"). */
const gchar *	mne_get_mountpoint(MntEnt *me);

/* Return pointer to a string with device name for given mount entry (e.g. "/dev/hdc"). */
const gchar *	mne_get_device(MntEnt *me);
