/*
** 1999-05-06 - Header file for color and style utilities.
**		The functions were originally in widgets/odemilbutton.c
**		Warning: They have not been tested with the pixmap theme.
**
** This module is written and maintained by Johan Hanson <johan@tiq.com>
*/

#include <gtk/gtkstyle.h>

/* go around flaw in gtk_style_copy(), by copying style structures directly */
#define COL_DIRTY	1

/* functions */
GtkStyle * col_make_style (GtkStyle *oldstyle, const GdkColor *fg, const GdkColor *bg);
GtkStyle * col_style_copy (GtkStyle *oldstyle);

/* these functions also apply the style to the widget's children */
void col_set_style (GtkWidget *widget, const GtkStyle *style);
void col_restore_style (GtkWidget *widget);

/* low-level functions that might be fun to export */
typedef struct {
	gdouble	h, s, l;
} ColHSL;

void col_rgb_to_hsl (const GdkColor *src, ColHSL *dst);
void col_hsl_to_rgb (const ColHSL *src, GdkColor *dst);

