/****************************************************************************

    Module  : Main.c

    Version : v1.0alpha

    Date    : 20/8/93

    Changes : None.


*****************************************************************************/

/****************************************************************************

    FUNCTION: WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                      LPSTR lpszCmdParam, int nCmdShow)

    VERSION : v1.0

    PURPOSE : Defines and registers window classes. Creates all windows for
              the application. Then enters a loops which process all the
              messages for the application

    MESSAGES: None specific to this function.

    COMMENTS: Window handles declared as global to allow inter-window message
              passing.
                hwndDock    - Dock window.

****************************************************************************/

#include <windows.h>
#include <stdio.h>		// for sprintf()
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "freedock.h"
#include "debug.h"

#ifdef DEBUGGING_ON
/***************************
	Debugging Options
***************************/
FARPROC  pDefEditWndFn;
HWND     hwndSubDebug, hwndDebug;
BOOL	 bDEBUG = FALSE;
#endif

/**************************************************************************
 * Set the name of the application                                        *
 **************************************************************************/

char           *szAppName[80];
char           *IniFile = "FreeDock.ini";
SLOT_ENTRY     *Slot;
SLOT_ENTRY     TmpSlot;
MAIN_OPTIONS   DockOptions;
int            CurSlot;
HANDLE         hAppInst;
HWND           hwndDock;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
    MSG       msg;
    WNDCLASS  wcDockClass;


#ifdef DEBUGGING_ON
    char     *szDebugName = "FreeDock Debug Window";
	char	 *szROEditName = "ReadOnly Edit Class";
    WNDCLASS wcDebugClass, wcROEditClass;
	HWND     hwndDebug;

	/********************************************
		Check Command Line for DEBUG Option
	********************************************/
	if( !stricmp( lpszCmdParam, "/DEBUG" ) ){
		bDEBUG = TRUE;
	}

if(bDEBUG){

    wcDebugClass.style = CS_HREDRAW | CS_VREDRAW;
	wcDebugClass.lpfnWndProc = (WNDPROC)DebugWinProc;
	wcDebugClass.cbClsExtra = 0;
	wcDebugClass.cbWndExtra = 0;
	wcDebugClass.hInstance = hInstance;
    wcDebugClass.hIcon = LoadIcon(hInstance, "ADOCKICON");
	wcDebugClass.hCursor = LoadCursor(NULL, IDC_ARROW);;
	wcDebugClass.hbrBackground = GetStockObject(WHITE_BRUSH);
	wcDebugClass.lpszMenuName = NULL;
	wcDebugClass.lpszClassName = szDebugName;

	RegisterClass(&wcDebugClass);


	    /* get default edit control class */
	GetClassInfo(NULL, "edit", &wcROEditClass);
	    /* save address of edit class window proc */
	pDefEditWndFn = (FARPROC) wcROEditClass.lpfnWndProc;

	    /* make changes */
	wcROEditClass.hInstance = hInstance;
	wcROEditClass.lpszClassName = szROEditName;
	wcROEditClass.lpfnWndProc = (WNDPROC)ROEditWinProc;

	    /* register changed version */
	RegisterClass(&wcROEditClass);

}/* end if(bDEBUG) */

#endif

	// Setup the application Name
	sprintf( szAppName, "FreeDock %s %s", VersionText, OS_Bits );

    /*****************************************************************************
        Test to make sure this is the only copy of this application running
        on this machine, if not activate previous instance and exit
    *****************************************************************************/
    if (hPrevInstance) {
        ShowWindow( hPrevInstance, SW_SHOW );
        exit (-1);
    }

    /*********************************************
      * define and register the dock window class *
     *********************************************/

    wcDockClass.style = CS_DBLCLKS;
    wcDockClass.lpfnWndProc = (WNDPROC) DockWinProc;
    wcDockClass.cbClsExtra = 0;
    wcDockClass.cbWndExtra = 0;
    wcDockClass.hInstance = hInstance;
    wcDockClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcDockClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wcDockClass.lpszMenuName = NULL;
    wcDockClass.lpszClassName = szAppName;

#ifdef WIN32
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK32");
#else
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK16");
#endif

    if(!RegisterClass(&wcDockClass)) return FALSE;

    hAppInst = hInstance;

    /*****************************************
      create and position the dock window
    *****************************************/

    hwndDock = CreateWindow(
        szAppName,                  /* window class name    */
        szAppName,                  /* window caption       */
        WS_VISIBLE | WS_POPUP | WS_BORDER,  /* window style         */
        0,          /* initial x position   */
        0,          /* initial y position   */
        20,                   /* initial x size       */
        20,                   /* initial y size       */
        NULL,                       /* parent window handle */
        NULL,                       /* window menu handle   */
        hInstance,                  /* program instance handle */
        lpszCmdParam                    /* creation parameters  */
        );

    if(!hwndDock) return FALSE;

    ShowWindow(hwndDock, SW_SHOW);
    UpdateWindow(hwndDock);


#ifdef DEBUGGING_ON
if( bDEBUG ){

    hwndDebug = CreateWindow(
			       szDebugName,	        /* window class name    */
			       szDebugName,	        /* window caption       */
			       WS_OVERLAPPEDWINDOW, /* window style         */
			       0,	                /* initial x position   */
			       0,                   /* initial y position   */
			       200,                 /* initial x size       */
			       300,                 /* initial y size       */
			       NULL,	            /* parent window handle */
			       NULL,	            /* window menu handle   */
			       hInstance,	        /* program instance handle */
			       NULL	                /* creation parameters  */
	);

    hwndSubDebug = CreateWindow(
				  szROEditName,
    			  NULL,
		     	  WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
				  WS_BORDER | ES_LEFT | ES_MULTILINE |
				  ES_AUTOHSCROLL | ES_AUTOVSCROLL |
				  ES_WANTRETURN,
				  0, 0, 0, 0,
				  hwndDebug, 1, hInstance, NULL
	);

    ShowWindow(hwndDebug, SW_SHOW);
    UpdateWindow(hwndDebug);

    ShowWindow(hwndSubDebug, SW_SHOW);
    UpdateWindow(hwndSubDebug);

} /* end if( bDEBUG ) */

#endif

    /************************************************
         enter message processing loop
    ************************************************/

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return msg.wParam;      /* exit application */
}
