#! /bin/sh -e

#
# usage: util/check.sh [directory]
#
# This script runs lzo_test with all algorithms on a complete directory tree.
# It is not suitable for accurate timings.
#
# Copyright (C) 1996, 1997 Markus Franz Xaver Johannes Oberhumer
#

dir=${1-"."}

LZO_FLAGS="-q -n2"

TMPFILE="./lzo_chk1.tmp"
rm -f $TMPFILE
find $dir -type f -print > $TMPFILE

## methods=`./lzo_test -m | sed -n 's/^ *-m\([0-9]*\).*/\1/p'`
methods="21 31 1 2 3 4 5 6 7 8 9 11 12 13 14 15 16 17 18 19 61 71 81"
methods="$methods 111 115"
methods="$methods 921 931 901 911"
methods="$methods 902 912 942 962 972 982"

for i in $methods; do
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS
done

rm -f $TMPFILE

echo Done.
exit 0

