#include <go32.h>
#include <sys/movedata.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

char *doublebuffer;

#include "palette.h"
#include "pcx.h"
#include "sprite.h"

#define flip(c) _dosmemputl(c, 64000/4, 0xA0000)

int main() {
    char palette[768];
    SPRITE pl1, pl2;
    int quit=0, waittime=0;

    doublebuffer=(char *)malloc(64000);
    if(doublebuffer==NULL) {
        printf("Ei tarpeeksi muistia kaksoipuskurin varaukseen!\n");
        return 1;
    }
    textmode(0x13);
    loadpcx("SPRITE.PCX", doublebuffer);
    loadpal("SPRITE.PCX", palette);
    setpal(palette);
    sload(&pl1, 100, 100, 0, 0, 16, 16, doublebuffer, 1, 1, 320, 8);
    sload(&pl2, 220, 100, 0, 0, 16, 16, doublebuffer, 1, 1, 320, 8);
    loadpcx("BITBACK.PCX", doublebuffer);

    while(!quit) {
        sdraw(&pl1);
        sdraw(&pl2);
        flip(doublebuffer);
        shide(&pl1);
        shide(&pl2);
        smove(&pl2);
        smove(&pl1);
        sanimate(&pl1);
        sanimate(&pl2);
        if((pl1.x+pl1.xsize+pl1.xspeed)>320 ||
           pl1.x+pl1.xspeed<0)
            pl1.xspeed= -pl1.xspeed;
        if((pl1.y+pl1.ysize+pl1.yspeed)>200 ||
           pl1.y+pl1.yspeed<0)
            pl1.yspeed= -pl1.yspeed;

        if((pl2.x+pl2.xsize+pl2.xspeed)>320 ||
           pl2.x+pl2.xspeed<0)
            pl2.xspeed= -pl2.xspeed;
        if((pl2.y+pl2.ysize+pl2.yspeed)>200 ||
           pl2.y+pl2.yspeed<0)
            pl2.yspeed= -pl2.yspeed;

        if(scollision(&pl1, &pl2))
            quit=2; /* 2 tarkoittaa, ett toinen saatiin kiinni */

        while(kbhit()) { /* tyhjennetn nppispuskuri */
            switch(getch()) {
                case 'w': pl1.yspeed=-1; pl1.xspeed=0; break;
                case 's': pl1.yspeed=1; pl1.xspeed=0; break;
                case 'a': pl1.xspeed=-1; pl1.yspeed=0; break;
                case 'd': pl1.xspeed=1; pl1.yspeed=0; break;

                case 'u': pl2.yspeed=-1; pl2.xspeed=0; break;
                case 'j': pl2.yspeed=1; pl2.xspeed=0; break;
                case 'h': pl2.xspeed=-1; pl2.yspeed=0; break;
                case 'k': pl2.xspeed=1; pl2.yspeed=0; break;

                case '+': if(waittime) waittime--; break;
                case '-': waittime++; break;

                case  27: quit=1; break;
            }
        }
        delay(waittime);
    }
    if(quit==2) { /* jos kiinni, niin feidataan ensin valkoiseen (rjhdys) */
        fadetowhite(palette);
        for(waittime=0; waittime<256*3; waittime++)
            palette[waittime]=63;
    }
    fadetoblack(palette);
    textmode(0x3);

    return 0;
}
