#include <conio.h>
#include <sys/farptr.h>
#include <go32.h>
#include <dos.h>

#include "palette.h"

#define putpixel(x, y, c) _farpokeb(_dos_ds, 0xA0000+(y)*320+(x), c)

void genpal(char *palette) {
    char r=0, g=0, b=0;
    int c, color=0;
    
    for(c=0; c<64; c++) { // MUSTA (0,0,0) - PUNAINEN (63,0,0)
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(r<63) r++;
    }
    for(c=0; c<64; c++) { // PUNAINEN (63,0,0) - VIOLETTI (63,0,63)
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(b<63) b++;
    }
    for(c=0; c<64; c++) { // VIOLETTI (63,0,63) - VALKOINEN (63,63,63)
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(g<63) g++;
    }
    for(c=0; c<64; c++) { // VALKOINEN (63, 63, 63) - MUSTA (0,0,0)
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(r) r--;
        if(g) g--;
        if(b) b--;
    }
}

void main() {
    int x, y;
    char palette[256*3];

    textmode(0x13);
    genpal(palette);
    setpal(palette);
    for(y=0; y<200; y++) for(x=0; x<320; x++)
        putpixel(x, y, y);
    while(!kbhit()) {
        rotatepal(1, 255, palette);
        waitsync(); /* odotetaan ett piirto on valmis ennen uuden
                       paletin asettamista! */
        setpal(palette);
    }
    getch();
    fadetowhite(palette);
    for(x=0; x<256*3; x++) palette[x]=63;
    fadetoblack(palette);
    textmode(0x3);
}
