{ UNZDLL.PAS   - Delphi v2 translation of file "wizunzip.h" by Eric W. Engler }
{ Import Unit for UNZDLL - put this into the "uses" clause of any
  other unit that wants to access the UNZDLL. }

{ Note: Don't use VC++ 4.2 to generate DLLs.  It's DLLEXPORT has a bug
  that causes them to be cdecl instead of stdcall. Also, OCXs generated
  with 4.2 can't fire Delphi events. }

unit UNZDLL;

interface

uses Windows, ZCallBck;

{ This record is very critical.  Any changes in the order of items, the
  size of items, or modifying the number of items, may have disasterous
  results.  You have been warned! }
Type UnZipParms = packed record
         Handle: THandle;
         Caller: Pointer;    { "self" referance of the Delphi form }
                     { This is passed back to us in the callback function
                     so we can direct the info to the proper form instance
                     - thanks to Dennis Passmore for this idea. }
         Version: LongInt;   { version of DLL we expect to see }
         ZCallbackFunc: ZFunctionPtrType; { typedef in ZIPDLL.PAS }
         fTraceEnabled: LongBool;

         {============== Begin UnZip Flag section ============== }
         fPromptToOverwrite: LongBool;  // not used yet
         fDecrypt: LongBool; // not supported yet
         fTest:    LongBool;  // if true, test zipfile (not used yet)
         fComments: LongBool;  // show zip comment (not supported yet)
         fConvert: LongBool;  // if true, do ASCII/EBCDIC or EOL translation

         fQuiet:   LongBool;        // DLL be quiet!
         fVerboseEnabled: LongBool; // verbose flag
         fUpdate:  LongBool;  // "update" (extract only newer files & brand new files)
         fFreshen: LongBool;  // "freshen" (extract only newer files that already exist)
         fDirectories: LongBool; // if true, recreate dir structure
         fOverwrite: LongBool;   // if true, overwrite existing (no asking)

         { Count of filespecs to extract - don't forget to set this! }
         argc: LongInt;
         { ptr to zipfile name }
         PZipFN: PChar;
         seven: LongInt; { pass a 7 here to validate struct size }
         { Array of filenames contained in the ZIP archive }
         PFileNames: array[0..FilesMax] of PChar;
      end;

 type
   PUnZipParms = ^UnZipParms;

{ Main call to execute a ZIP add or Delete.  This call returns the
  number of files that were sucessfully operated on. }
function DllProcessZipFiles(UnZipRec: PUnZipParms): DWORD; stdcall;

procedure GetDllVersionU(VersionHi: PWord;
                        VersionLo: PWord);
                        stdcall;
implementation

function DllProcessZipFiles(UnZipRec: PUnZipParms): DWORD;
                       external 'UNZDLL.DLL' index 2;

procedure GetDllVersionU(VersionHi: PWord;
                        VersionLo: PWord);
                        external 'UNZDLL.DLL' index 3;

end.
