{$AlignCode-,AlignData-,AlignRec-,G3+,Speed-,Frame-}
Unit Helpers;

Interface uses miscUtil;

type{ Parameter handling function definition }
      ParmHandleFn = Function(var Parm : string) : Byte;
    { Fast semaphore type }
      tSemaphore   = Longint;

{Command line parsing helper. PH gets called on each /# and -# parameter;}
{otherwise NH is called; they return number of chars starting from string}
{start which have to be stripped (i.e. when they were already recognized)}
{If ParmStr is #1 uses the real command line;otherwise ParmStr is used   }
 Procedure ParseCommandLine(const ParmStr : string; PH,NH : ParmHandleFn);

{Return TRUE if file exists; FALSE otherwise}
 Function  FileExist(const PathName : string) : Boolean;

{Try to rename file sName into dName. Returns TRUE if succesful}
 Function FileRename(const sName,dName : string) : Boolean;

{Try to erase file fName and returns TRUE if succesful}
 Function FileErase(const fName : string) : Boolean;

{Returns file length in bytes or -1 if no such file}
 Function FileLength(const fName : string) : Longint;

{Copy file srcName into dstName; return TRUE if o.k.}
 Function FileCopy(const srcName,dstName : string) : boolean;

{Return a string containing executable`s source path including last '\'}
 Function SourcePath : string;

{Read EAs from given file into EA dynamic array}
 Function ReadEAs(const fName : string; var EA : pDarray) : boolean;

{Append EAs from EA to file fName}
 Function WriteEAs(const fName : string; EA : pDarray) : boolean;

{Free EAs in dynamic array and array itself}
 Procedure FreeEAs(var EA : pDarray);

{ A very FAST semaphore realization; 32 semaphores (0-31) in one variable }
 Procedure fsInit(var Sem : tSemaphore);
 Procedure fsRelease(var Sem : tSemaphore; semNo : Byte);
 Procedure fsRequest(var Sem : tSemaphore; semNo : Byte; Sleep : boolean);
 Function  fsCheck(var Sem : tSemaphore; semNo : Byte) : boolean;

Implementation uses dos, os2def, os2base, strOp, strings;

Procedure ParseCommandLine;
var S : String;
begin
 if ParmStr = #1
  then S := StrPas(GetASCIIZptr(CmdLine^, 2))
  else S := ParmStr;
 While S <> '' do
  begin
   While (S <> '') and ((S[1] = ' ') or (S[1] = #9)) do Delete(S, 1, 1);
   if S <> ''
    then
     if (S[1] in ['/','-'])
      then begin
            Delete(S, 1, 1);
            if (@PH <> NIL) and (S <> '') then Delete(S, 1, PH(S));
           end
      else
     if @NH <> NIL
      then Delete(S, 1, NH(S))
      else Delete(S, 1, 1);
  end;
end;

Function FileExist;
var F : File;
begin
 Assign(F, PathName); Reset(F, 1); Close(F);
 FileExist := ioResult = 0;
end;

Function FileRename;
var F : File;
begin
 Assign(F, sName); Rename(F, dName);
 FileRename := ioResult = 0;
end;

Function FileErase;
var F : File;
begin
 Assign(F, FName); SetFAttr(F, Archive);
 Erase(F); FileErase := ioResult = 0;
end;

Function FileLength;
var F : File;
    I : Longint;
begin
 I := FileMode; FileMode := $40;
 Assign(F, fName); Reset(F, 1);
 FileMode := I;
 if ioResult <> 0
  then FileLength := -1
  else begin
        FileLength := FileSize(F);
        Close(F);
       end;
end;

Function FileCopy;
var sn,dn : pChar;
begin
 GetMem(sn, succ(length(srcName)));
 GetMem(dn, succ(length(dstName)));
 StrPCopy(sn, srcName);
 StrPCopy(dn, dstName);
 FileCopy := DosCopy(sn, dn, dcpy_Existing) = 0;
 FreeMem(sn, succ(length(srcName)));
 FreeMem(dn, succ(length(dstName)));
end;

Function SourcePath; assembler; {$USES esi,edi}
asm             mov     edi,CmdLine
                mov     al,0
                mov     ecx,-1
                repne   scasb
@@searchSlash:  dec     edi
                cmp     edi,CmdLine
                jbe     @@done
                cmp     byte ptr [edi],'\'
                jne     @@searchSlash
@@done:         mov     esi,CmdLine
                sub     edi,esi
                mov     eax,edi
                inc     eax
                mov     ecx,eax
                mov     edi,@result
                stosb
                rep     movsb
end; {$USES none}

Function ReadEAs(const fName : string; var EA : pDarray) : boolean;
label locEx;
const eaNameBfSz = 1024;
      secureSize = 256; {F$#%^k! Bug in DosEnumAttribute}
var   fN         : pChar;
      sV,oV,
      I,eaCn     : Longint;
      Buff       : pArrOfByte;
      eaN        : pDarray;
      pS         : pString;
      pEA,nEA    : pFea2;
      eaBuf      : EAop2;
      fStat      : FileStatus4;
begin
 ReadEAs := _OFF;
 GetMem(fN, succ(length(fName)));
 GetMem(Buff, eaNameBfSz + secureSize);
 New(eaN, Init(8));
 New(EA, Init(8));
 fillChar(fStat, sizeOf(fStat), 0);
 fillChar(eaBuf, sizeOf(eaBuf), 0);
 if (fN = nil) or (Buff = nil) or (eaN = nil) or (EA = nil) then goto locEx;
 StrPCopy(fN, fName);
 sV := 1;
 repeat
  eaCn := -1; FillChar(Buff^, eaNameBfSz, 0); {F&^#$@%&k! Really not needed}
  if DosEnumAttribute(EnumEA_RefType_Path, fN, sV, Buff^, eaNameBfSz, eaCn, EnumEA_Level_No_Value) <> 0
   then goto locEx;
  if eaCn = 0 then break;
  pEA := @Buff^;
  For I := 1 to eaCn do
   begin
    eaN^.AddItem(NewStr(StrPas(@pEA^.szName)));
    Inc(Longint(pEA), pEA^.oNextEntryOffset);
    Inc(sV);
   end;
 until _OFF;
 if DosQueryPathInfo(fN, Fil_QueryEAsize, fStat, sizeOf(fStat)) <> 0 then goto locEx;
 I := 1;
 GetMem(eaBuf.fpFEA2List, fStat.cbList);
 eaBuf.fpGEA2List := @Buff^;
 While I <= eaN^.numItems do
  begin
   sV := 4; oV := 4;
   repeat
    pS := eaN^.GetItem(I);
    if sV + 4 + succ(length(pS^)) > pred(eaNameBfSz) then break;
    pLong(@Buff^[oV])^ := sV - oV;
    pLong(@Buff^[sV])^ := 0; oV := sV;
    Move(pS^, Buff^[sV + 4], succ(length(pS^)));
    Inc(sV, 4 + succ(length(pS^)));
    Buff^[sV] := 0; sV := (sV + 4) and $FFFFFFFC;
    Inc(I);
   until I > eaN^.numItems;
   pLong(@Buff^[0])^ := sV;
   eaBuf.fpFEA2List^.cbList := fStat.cbList;
   if DosQueryPathInfo(fN, Fil_QueryEAsFromList, eaBuf, sizeOf(eaBuf)) = 0
    then begin
          pEA := @eaBuf.fpFEA2List^.list;
          While longint(pEA) - longint(@eaBuf.fpFEA2List^.list) <= eaBuf.fpFEA2List^.cbList do
           begin
            GetMem(nEA, sizeOf(Fea2) + pEA^.cbName + pEA^.cbValue);
            Move(pEA^, nEA^, sizeOf(Fea2) + pEA^.cbName + pEA^.cbValue);
            EA^.AddItem(nEA);
            if pEA^.oNextEntryOffset = 0 then break;
            Inc(longint(pEA), pEA^.oNextEntryOffset);
           end;
         end;
  end;
 ReadEAs := _ON;
locEx:
 if eaBuf.fpFEA2List <> nil
  then FreeMem(eaBuf.fpFEA2List, fStat.cbList);
 if eaN <> nil
  then begin
        For I := 1 to eaN^.numItems do DisposeStr(eaN^.GetItem(I));
        Dispose(eaN, done);
       end;
 if Buff <> nil then FreeMem(Buff, eaNameBfSz + secureSize);
 if fN <> nil then FreeMem(fN, succ(length(fName)));
end;

Function WriteEAs(const fName : string; EA : pDarray) : boolean;
label locEx;
const eaNameBfSz = 300;
var   fN         : pChar;
      I,maxEA    : Longint;
      eaBuf      : EAop2;
      Buff,OneEA : pArrOfByte;
begin
 WriteEAs := _OFF;
 GetMem(fN, succ(length(fName)));
 GetMem(Buff, eaNameBfSz);
 maxEA := 0;
 if (fN = nil) or (Buff = nil) then goto locEx;
 StrPCopy(fN, fName);
 For I := 1 to EA^.numItems do
  with pFea2(EA^.GetItem(I))^ do
   if sizeOf(Fea2) + cbName + cbValue > maxEA
    then maxEA := sizeOf(Fea2) + cbName + cbValue;
 Inc(maxEA, 4);
 GetMem(oneEA, maxEA);
 pLong(oneEA)^ := maxEA;
 eaBuf.fpGEA2List := @Buff^;
 eaBuf.fpFEA2list := @oneEA^;
 For I := 1 to EA^.numItems do
  with pFea2(EA^.GetItem(I))^ do
   begin
    oNextEntryOffset := 0;
    pLong(@Buff^[0])^ := 4 + 4 + 1 + 1 + cbName;
    pLong(@Buff^[4])^ := 0;
    Buff^[8] := cbName;
    Move(szName, Buff^[9], cbName);
    Buff^[9 + cbName] := 0;
    Move(oNextEntryOffset, oneEA^[4], sizeOf(Fea2) + cbName + cbValue);
    DosSetPathInfo(fN, Fil_QueryEAsize, eaBuf, sizeOf(eaBuf), 0);
   end;
 WriteEAs := _ON;
locEx:
 FreeMem(oneEA, maxEA);
 if Buff <> nil then FreeMem(Buff, eaNameBfSz);
 if fN <> nil then FreeMem(fN, succ(length(fName)));
end;

Procedure FreeEAs(var EA : pDarray);
var I : Longint;
begin
 if EA <> nil
  then begin
        For I := 1 to EA^.numItems do
         with pFea2(EA^.GetItem(I))^ do
          FreeMem(@oNextEntryOffset, sizeOf(Fea2) + cbName + cbValue);
        Dispose(EA, Done);
       end;
end;

Procedure fsInit; assembler;
{$frame-} {$uses none} {$saves ebx,ecx,edx,esi,edi}
asm             mov     eax,Sem
                mov     dword ptr [eax],0
end;

Procedure fsRelease; assembler;
{$frame-} {$uses none} {$saves ebx,edx,esi,edi}
asm             mov     eax,Sem
                movzx   ecx,semNo
                btr     dword ptr [eax],ecx
end;

Procedure fsRequest; assembler;
{$frame-} {$uses ebx,esi} {$saves ebx,esi,edi}
asm
@@semCheck:     mov     eax,Sem
                movzx   ecx,semNo
                bts     [eax],ecx
                jnc     @@semFree
                cmp     Sleep,0
                je      @@semCheck
                push    large 0
                call    DosSleep
                add     esp,4
                jmp     @@semCheck
@@semFree:
end;

Function fsCheck; assembler;
{$frame-} {$uses none} {$saves ebx,edx,esi,edi}
asm             mov     eax,Sem
                movzx   ecx,semNo
                bt      dword ptr [eax],ecx
                setc    al
end;

end.

