/* resource_struc.h
   Resource fork structures.
*/

#ifndef _RESOURCE_STRUC_H
#define _RESOURCE_STRUC_H

#include "MacFS/defs.h"

/* Resource types - first char in LSB */
#define RESTYPE_ICNLIST          0x234e4349    /* ICN# */
#define RESTYPE_ICL4             0x346c6369    /* icl4 */
#define RESTYPE_ICL8             0x386c6369    /* icl8 */

/* Resource ID for custom icon */
#define RESID_CUSTOMICON (-16455)

typedef short resid_t;

typedef struct ResourceHeader {
  LONGWORD res_data_ofs;           /* Offset to resource data */
  LONGWORD res_map_ofs;            /* Offset to resource map */
  LONGWORD res_data_len;           /* Length of resource data */
  LONGWORD res_map_len;            /* Length of resource map */
} RESOURCEHEADER, *PRESOURCEHEADER;

typedef struct ResMapHeader {
  char reserved1[16];
  LONGWORD reserved2;
  WORD reserved3;
  WORD attr;                       /* Resource file attributes */
  WORD type_list_ofs;              /* Offset from beginning of resource map to type list */
  WORD name_list_ofs;              /* Offset from beginning of resource map to name list */
} RESMAPHEADER, *PRESMAPHEADER;

/* Resouce type list:
   WORD n_types;                    /- Number of types in map minus 1 -/
   TYPELISTENTRY typelist[];
*/

typedef struct TypeListEntry {
  LONGWORD type;                   /* Resource type */
  WORD n_res;                      /* Number of resources of this type minus 1 */
  WORD ref_ofs;                    /* Offset from beginning of type list to
				      reference list for resources of this type */
} TYPELISTENTRY, *PTYPELISTENTRY;

typedef struct RefListEntry {
  resid_t res_id;                  /* Resource ID */
  WORD name_ofs;                   /* Offset from beginning of resource name list
				      to length byte of resource name, or -1. */
  BYTE attr;                       /* Resource attributes */
  BYTE data_ofs_hi;                /* MSB of the following */
  WORD data_ofs_lo;                /* Lower part of offset from beginning of
				      resource data to length of data for resource. */
  LONGWORD reserved;
} REFLISTENTRY, *PREFLISTENTRY;

#endif /* _RESOURCE_STRUC_H */
