#include "../defs.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "../errors.h"


int  BT_Search(MOUNT_RECORD* mnt, BT_HEADER* head, BT_KEY key, 
	       BYTE** p_rec, 
	       int *len_rec, 
	       SEARCH_STACK_ELEM *stack, 
	       BT_KEY found_key,
	       BYTE * buff)   {

  int node,i,out,nr_recs,is_leaf,err;
  BYTE *p_offset;
  int keylen, level, rec_len, free_space;
  int dummy_search;

  
  node = head->bth.bthRoot;		/* Start from the root */
  level = head->bth.bthDepth;
 
  if(node == 0)				/* The Btree is empty */
    return(BT_NOTFOUND);	

  dummy_search = 0;

 FollowPointer:
  if(node <= 0 || node >= head->bth.bthNNodes)
    return(BT_BADTREE);

  stack[level].Node = node;		/* Memorize the node in stack */


  CHKERR(BT_ReadNode(mnt, head, node, buff)); /* Read the node */
					
  nr_recs = GetWord(& buff[ND_NRECS]);

  if( nr_recs == 0)			/* It should not happen */
    return(BT_BADTREE);

			      /* Optimize for the dummy search */
  if(dummy_search)
    nr_recs = 1;
  
  is_leaf = ( GetByte(& buff[ND_TYPE]) == NODE_LEAF);	
					/* Pointer to offsets */
  p_offset = & buff[btnOffsetRec(nr_recs)];


					/* I must decide if need to alloc */
					/* in case of INSERT */
  if(is_leaf)				/* In the leaves we store key+rec */
    rec_len = KeyLength(key) + head->bth.RecLen ;
  else					/* In the index we store a maximum */
					/* key and a LONGWORD*/
    rec_len = head->bth.bthKeyLen + 1 + 4;

  free_space = btnOffsetRec(nr_recs) - GetWord(p_offset);

  stack[level].Alloc = ( free_space < rec_len + 2 );

					/* Stack.Record will always */
					/* memorize the record after the */
					/* last considered one*/

  stack[level].Record = nr_recs + 1;	/* After last record in node */

					/* For all records in this node */
  for(i = nr_recs -1; i >= 0; i--) {  

    stack[level].Record--;		/* Skip to next record */

					/* Step to next offset */
    p_offset += 2;
					/* Get record address */
    *p_rec = & buff[GetWord(p_offset)];


    out   = (* head->KeyCmp)(key, *p_rec); /* Compare the keys */
    
			      /* If the key is smaller than all the keys in 
                               * this node I must mark it in stack.Record and 
                               * if it happens to be at the root level we must 
                               * continue the search to build the stack */
    if(out == -1 && i == 0)  {
			      /* Follows a dummy search; I know that the key 
                               * will be smaller than any key in the node */
      dummy_search = 1;
			      /* Mark in stack as if we followed the first 
                               * record. But for leaf we must mark 0 and exit 
                               * with BT_NOTFOUND */
      if(is_leaf)   {
	stack[level].Record = 0;
	return(BT_NOTFOUND);
      }
      
      stack[level].Record = 1;
			      /* Continue as if the out was EQUAL */
      out = 0;
    }
      
    switch(out) {
    case 0:				/* Equal */
    case 1:				/* or Greater */
      keylen = KeyLength(*p_rec);
      if(is_leaf) {			/* Leaf */

	bcopy( *p_rec, found_key, keylen);
					/* The found key */
	*p_rec += keylen;		/* Skip the key */
        *len_rec = GetWord(p_offset-2) - GetWord(p_offset); 
	return (out == 0 ? 0 : BT_FOUNDLESS);
      }
					/* Get the pointer from this index */
                                        /* node; skip the key */
      node = GetLongWord(*p_rec + keylen);
					/* Follow this pointer */
      level--;
      goto FollowPointer;
  
    case -1:				/* Smaller */
      break;				/* Skip to next record in this node */
    }
  }
			      /* Here only if the key is smaller than all 
                               * records; this case should have been catched 
                               * */
  

  return(BT_BUG2);
  
}



